//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module FPGA_uart_apb
  import apb_pkg::*;
  import regmap_pkg::*;
#(
  parameter NUM_INST     = 1,
  parameter W_OFSET      = 8,
  parameter FIFO_DEPTH   = 16
)(
  input                         cmd_clk,
  input                         cmd_rst_n,
  // APB interface
  input  apb_m2s                i_apb_m2s,
  output apb_s2m                o_apb_s2m,
  // ptp time
  input   [47:0]                ptp_sec,
  input   [31:0]                ptp_nanosec,
  // UART
  output                        o_uart_tx,
  input                         i_uart_rx,
  output                        o_uart_busy,
  output [$clog2(NUM_INST)-1:0] o_uart_bus_en
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
H3Y3i897/ZBDjud+JDeK8B8KnX0cV08tWydURv+q9OVeDsMenFsomTdZqcshHytX
p0SScluu0G5xpR+8kt1FkozkRq8durneT65ImuOLXezVnP2nG0L/dqAAJ7Gho/G7
mdHbKzUSR1qdjUAcw0u/6GumWXi6QNJPBOhs5jhTb7YgKilk+lG5ox6yIYf0xC/W
EoZFmcUyNTfDnp8Gmzw5vcSFe5FAzVVUQqaZpfsgs6TJhBJWP+VwurrUnMohXnJB
ICXLWzB+fQt3Dkf8I7iqukohn/dR9Pb+Qv0V1kiq22mhHpJhiAKMXF6uIhTnS65D
thQ7LmtqDSyCa7x9S3hvFw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
fbWjTrdT0vbUgRt3oA3LC9LVc+rN+tsaYjjA5unIyUovni908g9CXApmQAgYZQBp
Bf020Cl5jjl/o/dePBZuUFKUImVnMg9TuUslvuJ9OzsJ56HxzrzLEhG6IKXI71mF
E2cwZUCg78IUKyHO8bs+BIp6SzLD2U3Pqf8xomC7raw=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
40XfRBRVXw7aHQ0rRw/s1xbMNlU56bbd8LEGxcfz75fFjR6bWthcMyse5GfvV08i
LjmjYRTvB721SnV5hANlT0YHi0KeyxD5rseL4mW3MZyi2wkrn5yTc12hDrvgRDqV
P1+WcLfp3dJj//KW8X28XYggTTBPAyvEwyXbAjEMCnRkUsAHXU0QjFN9hh83v61n
+A1flEaZ3+izNO6BkLUPWtZn+++Pp24WYzsMcKEmqM561ZNLvv11m++yRMe+D983
RfZDj196pxQxCoNZ7/NTAora9BgdMAEgOhUaDo0Bkt/eXVgn73HvsB/maCxGBB/O
PXDhjA9Q5yAQVtOyDituOA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
O9KPYXCfrHE5Xp1cqTu+GGbe4fpB73ZydobrS+2bryf4xxAZ+wZ/A2VFtZfvdU8s
kc4cWNHRuTrreBukm9l3Cu0Wam4aNJMFLFJxb6cvOFwaQV22MggaoW4JeVBbCGkc
5bf6aR3sirAYAMzO35P5FePT0Rx+0gmBuRNLzHZ6WQj88wzhjzpEp365D+g4MPV5
ZqWbQgJfe1Ijs1la/ntTlgHTnPhz846vvzFf/GRsZor4ySeHo0L8fo3mv3FUdjlY
A0D+Ln913lu8OxrClEwE4LTArDuDFecfa9xaDmxWkGhf7Xu2GATL7lD+lykY30eU
fecS5+M8VFgF5UyKofJwCA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
drBbeABtPp1IBrv5x5EBEqhM/KBYlNVTpdf0Jz3HlY18jAe+JaHK0QZbrtxh/zUl
htWis7QNU41pI6Ma0E3HMg6/bfTBtBhGcTg9NQj3n0m7dOC85F28zUSdZZ47d9D9
PhatoYflYXMP6XVMT8BSyBn3OWAh8I6/b3jNmHoflM1lhwg9ysf7LiQp8HfMv08C
qDXAiINkMkhJcxPpK9qDQk+nfK2HwhxmBaTdth5mBVrkG2GCWKP5OZCRLZKZw0Mk
GC0YuK97TZIsUCry5pOJGo3aDAxHBiuxZhX9HnDXFAM1yPpkJm0x7J7x3Z/q2gb2
/GuxatAxz8bru/pUxSwZyQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
KEhgpG54Fovd61lqYDzSg7F3nJLrlQenFzo7kzbOjMvDYWmC4WTFTdgDecG0fnVY
5UNgl3XZon2moyDkJVC+1M0K8fE5QRrnBeLcGZEU+xtgbgz7auy6PlC61/nZ0c8/
sVWUrTn/b5GCDoQpCWow1OGz9yvk3gmp0BtyYtW6Kg4a75a6XRSAB20SiMZuEQKx
4Q7u8fdhQY+X7BTMJD0g/RtY/2qG7oOZpis5ElGHTWJT/Us5XfEwT8BlB6oyr5vQ
7LlUScPVZrNZuu0H2ECfhMt6WNynot7BjNlMDGUmFiln/DJgMneItW2ODOia/cni
9WNIk+btKwsAGocew6NbDA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
WaGAd8MQGSE08ZudThXh9lkVUEZ6TOemOpsIBMBNTOs0aF4DOQl8CsKcgTPy2b9I
sVCOiCvQZ6ulil7U/LwWM6dajD6s+cVigAaydKnnXgDvqw5TOFYPH4OBq1rud3Oj
50BWEirsMqjcpOeZv++OBVi/MY/X047P/jzysC73Dr+N6PdspgmA1geD5svFni8R
YVRK/TzKDZp9C2SN/Cs5krBCUjCp0diEX1CAIItygdSXxsMay3LZd1+223u78nNi
kqsVlNmFJ7dBlW4URkowRM+R2BizRnv608LT9WMw4gBJDjFGT/VDy7eqs82UMKux
BLRKlE1R1fJfR55/26l2WNttGFCw1ynnObueTGW84umfjKTJPLakgCEJ7cG99RCV
3Kr4RbQDVNEhFB6p9YZUYaffDmrViNZeXbolFZIUT3CvcYsUML8nJ8/1JOiX/IFl
yV5gK9MCbTdoUOjNxKC2iCKc26lpqMD1nVTnqixHmU4Jh5HH3wZewyuQT2HH0Ozx
wvKpbc5S2KDF7A9JRC9/6q9n7VtS7qDxZ9rs3jquFAT9qifPSpkNHUIu6uv4pP+H
5L2hSnCDRr8pdDsZbBumJdbrPxoB5zzZIk37AhUeN2zcQxxPV0pWOeu09PAmJvYK
81KVx1LaDxCFl7TUy4CcxUvSdAxL2+nqA3tryluz4PaFrXwrz7DwTI9B/R+N6FBW
n6TQ9x5R5GVbtqmLhtSRJv5onKGepU3Qs90cBea1L++/yvnL1+DQEMzjfxZLi/qj
UzOMXZ+HMT2bYDM1G1gdvCxOU8BOn6UyEzEoI5qK2o0t5sErQKQEX/X3LdY8hAf/
NLRPfhlWLnEzpYdNKl9koqZpYL1/vZsmEd8EFgSy5X+gj19j/Q3XJQQl6UPoHU6t
i5QCYKduYZ3CP2Wm6FG2jW6dFbJ92v0gz9etbT7jkU22iuBFZzKuTj5Q5LXD2/bF
GEZT5zkn2oztD2QzK93iSFpxSO/YWPvpUQ6v7dh5NS10N5LG9SjXqWh3XuF14jIo
Ajk5iQwAV7sNLr1cHM6BRAFzhnVHwG9WaKrN6js0GJEAQ1/6Rki6EG8hU3kyVN9F
jm4Acgio+bKx6J5dljz5yAQah4avWj4C6/vTMWeYyycrLP7mOjayUwzBZlC+9qIx
sQuJKCnQxeBU77t45XYdJpkGaK2viKJOSvOzCTgvQ8eEYeDbS3iLk7Zht8AV4DMh
U6M3/n5wGA0SfOBNhH0AK1aq9BQV+Sf+j4BP4XqqeTr5QcokklxsCrjwnUkLx6JF

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
TkYmyQ08pCd1Xw8Ods1u1wMPbzUS1iJzLf/vXyUPhEfwpoOhC9EpmyWm7REZknMK
iHY/FOqyoyBjymeuFPjOcui4YJpq3xj6XsP87ncDM8v5SqaHPtjpo5T9y4srJLtJ
TqNMmUIODfU+BoVopW5tMR2pedhPox//HkwiNHLdi+g=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=4064)
`pragma protect data_block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`pragma protect end_protected

endmodule 