//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module FPGA_uart #(
    parameter OVERSAMPLE = 8,  // Changed from 16 to 8 for better baud rate accuracy
    parameter DATA_WIDTH = 8
)(
    // System
    input       clk,
    input       rst_n,
    
    // Configuration
    input [15:0] baud_div,        // Baud rate divisor for 16x oversampling
    input        tx_en,           // TX enable
    input        rx_en,           // RX enable
    input        loopback_en,     // Internal loopback enable
    
    // TX Interface
    input  [DATA_WIDTH-1:0] tx_data,
    input                   tx_valid,
    output                  tx_ready,
    
    // RX Interface
    output [DATA_WIDTH-1:0] rx_data,
    output                  rx_valid,
    input                   rx_ready,
    
    // UART Interface
    output                  uart_tx,
    input                   uart_rx
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
fAQrCrK8Zw0B/+QtOWWnrbW+ZElKH3TNj9r/mAY7tuHB7lSQky3ujR4aeWLJvvqf
60i2PIERbuPeYg0YWXJBgJXWq1irpmnl7aM4Qia61xEaOF/RjZKG9TCk5LQsf3RS
Drw3QzSN3iFN+gzKYtDILqVBbcW3Ds1YLQtwmsAM+nloyPgpSLnP+H2qtc8605aW
ukaxoLkge5HMdZcYEwEI+nKIHCD2oEGcCGqwLZdk5GI2Qd6Gtf6lJkO4Z7FXb/TT
GHosFQkCj7iy/1RaSv7pgWClCYcjSbmpHycf2HG2vxVCgsrUifb3KsOzqvnINCly
HBTyvMc3r8VRyEy6ntWBLQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
HJ/vlMZZB7fjeKx3BlF3PbG5yN9XsF+SYzyTLIfZQ4mv8q/ARbHflTrSlvUavRn3
Q8cU9vj6CnGSSD9wQ50BXPj/BmfmVAFeZ4L+TwuSJbHtvBwjJNwzdOYaeziOt5iD
SAqNgwNfO8gC9493f4SDpeCCsQkZUAspdEzsi0JsI64=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
NqpEMV0TcC7C4b4yycouYmOovsVzNsnQAsgJ1bKlJ12peIHm1rmeb6E0ZV7Kij0g
+sHQX8asKZdsBDZnI1a5fHOaxxIkJPmkCQQb2LXNmbg+ROTmHyeqEOykIqcTZ1Kx
y/I9FhCUX3avX0z6RSzNbpsMAv40LQpl+YNeXNGrlcaquA10Qc/AKoun6/0djJCh
lxx9+wIpl0MmoCSvji0XM/HeW6HaZbsiuAemIUCC2SLdb0ROUUDyONCDr1rrm8WN
46xemQMNCxM4uQipdHLybHMKSOx2gdwt+aePLKRiyGOP5SudXE/Zr+9rA1OyzXhn
NZZnG8dMoGSnMFp/CXsoKw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
hYL+gBLYjiAfB5pjrinEIZ64chiA1AmXGzAhfNBkWcNJzSBuDYBGlXuxHhyY3taV
Jc+Pf3/RpFLNJIRDLiyuXqrNoPF6OcnaDYMuJIoZT19kmO7+R3Y+2GHphTSHI4Lo
fVAMI86KWETQQvfiIy2W1GpCG8SshY4fKGXuRm4YVaZpdoQHX3mjFqnkfPR643jO
gbypoF+xtiY6dY+H3z+0+peHB6744nRARsnbWxWQgiiID6P/SXRcwZXx9JKzeaxS
TEBYgW9hrd4/VBp/N5+yPaDD6EplwrthOICqC9UkGU6SaFQPJ9JRnjiCCI3F51Nl
9R7J8iuCQL4BlAWX4noi5w==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
Gyyn/fRYmNxDvTxTwmOhm3rJOzVcmsGrW9LJZQORYEr+37tU5Md/G7iV6wm2oeyE
fnp1tI/xtdS1arbGceBnNmW8Drj3MBRdEJpia2nFYAL9HbJkW1DOyo3gamsb0Sdz
HA64pCyssSmchOsMymy17mKemwnsDK4urnLxtxyz0+fJld9YzpdFiu5wxSy6YKZh
vFCch6GuToR4bWwutK+OaQhIqGi79YDEghL/m5hZJqooPEg/F5OmPnKAFLMSHU6l
guTn3wtSuT4TtdXgqfIw+2Zu9IotucXgV/nHNvvO0dStg98gm143XW8t1Cer/SsO
OCDlpKKhtYa0xqZDNU7+xA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
BM8EMcCacvujDSZfBYcGVnX+oXJmXQpWlaxPE6Ld7QmROPf/TjJ86L+tyAVUYK5m
F+dFLHKQwABzfrtaIcXAjYhfWF3v8pqAEt+kU/iD8O5g6cnUhWez8gj7UYSM/6+u
VzkpSK4zoyDP+CTQIk/iZ2MMt+JPMG9rD08SbglrYat9fou4k7tyiW1NBWOhtvcj
XvFW3g90U5vK49l+iiWIwkOQkdvuDIqG69CSR+EAkHuvZ/egIwjsabwPEQUDrlP+
NYEaARqRBaoiqh2W+Wlse4JaT3XuZYKnQYn+jUcvyF5hbnEihMqeGlroyoHBL4xs
b6jXfjVvXRDfVRfot2efMg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
lsYhmBgn2nRCD4eo5zjIRUG3cKtIzQZZCSmNVHMU9WcjPhHCOknyUm/PiACCAwps
IPUgt5XqCge3U9ZLRG6OF2KlHl9leVWaPMeHifc2NU+8gG6ot0smYb9sBPSc1eoU
IVnKBIx+xNlwk3QSV7fXDqkr43Brun0EEtpZsw+XBN9//I88G+Mm55CYxZkL/Dae
8uY2UGLvvV4xYJKlQ0h3agpuDRxnOVShYgsjel9QIhVmvOtYVxF27Fz2InY8PVQN
wcvqkW6nAUQ2xAMlHpdzRSL58VU/28abY1ayUvOCGpSDWAjjmLNpX+3SItt+ErWE
bfhKQFJubarnX0ZTeqkdzw/feTJz1EhAyiU1sfHkb1D/fuaKeoJr3rAvpFuGZ/bk
B2sFZDRCz68js83gWhp2mTAZiYteH5Vo2hX0I9Ixl5EXSDwtI0EraRvVpCx+1DQF
XVAjpO/o2l8sigtD0WTsGtpwwe3gQbEzdjwTfVeBUH1Y4TNI8EJWopV/iw12Tipc
LEslBRgmvjRgrV86H1M5To0Sm/BM9DlzHo7ivbHw1uScX8SFAHdl53j24rLjvfxE
Ih0fxPOgWuK8Xo0x9jdkjNx1Oc+Ni9n7md1ODB/pHLTGWrNN0FX2KqFrBLG0lf++
/mMfpMbOmknAVG4+MsqkKaE/W+HeCehsMvh1fipRBeRQFFiQYPT1vvF1lOb2OGdJ
9L16mtdj/JksdBpA9XzutuZYTkkf6ZjpvGo23LpoT9G2tR/fE3ktVq1KTwhzFiNb
ao+NPcsI1pd+GVzipdfjChDprH309Jxnpavek5fhC57QX11pXleUV/Yit63OMnMY
z/ybUMKnmavmbEdpW+Fu97Nlb9sFb1EjO2HJ2le8CTp1aq/7R5R4z90C4KyWaBKA
SaU3fD5CBD7HNC/tu1NXgNYxHlPb2W8XB11s0e2htbJg4u5RXFuMnwmTq7YnSHgb
PkJZdzto0UfCSi5tP5PB1vrVlKr/g5qvuSy38c1YgEJvz1g8OlxBWs007rpY8NgK
eddi92UQs9i9ixLTMFxsn7CxgPEvJT9Jan/7xVvKE7uHrtvsgFVmlsuBCKxJQTAO
WerVtFqdWZwVDb2DDWn6W7OVaPndR5R7+5ROkHvj8H9ZEc1La4IbIAvlXJbNCZix
Cn8AJFWuPN7DXcmqTlf380Zm2XB0/rNHD+DKZTg5QkBsKlw1iajJJBNO1vd0JzJZ
hdlqtqYYlQiV11BC4cOiMG1iDtCCimC4lGIvbAdp/EMM7P0MfgLAk56BXqo06Pqr

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
Q9XQ1BuhUkyfPv9230wiZn8Wyao4z9UchvhqRK3ahG8mv7muRl6G5ab85uk+chJX
hhcsJYmmqpA+RmB2N0T9ThSsFYK1rNmUfaF9aOvk++UdeVF7z/t0VCCPXQQ6BA7p
k4c7EjZ/lVtpi9cPPJ6xqQYVAhkm1iUyKldDHCgEV0o=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=7360)
`pragma protect data_block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`pragma protect end_protected

endmodule 