//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module sys_init
  import apb_pkg::*;
  // import regmap_pkg::*;
#(
  parameter W_DATA = 32,
  parameter W_ADDR = 32,
  parameter N_REG  = 1,
  parameter W_INIT = W_DATA + W_ADDR
)(
  // clock and reset
  input               i_aclk,
  input               i_arst,
  // control
  input               i_init,
  input  [W_INIT-1:0] i_init_reg [N_REG],
  output              o_done,
  // APB Interface
  output apb_m2s      o_apb_m2s,
  input  apb_s2m      i_apb_s2m
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
wPFPJIhKkySVZPY2jPAShNYgRnGQQ1a66gtpqIDD0razKW/mUc6qBUcovfDwsHaB
KmLxk8lFxkd3GGqVbiQmAKazRNBpuudasmabF6WDe32jFV+VY1gaoU5i9Xfb+kS8
K7iTXcgltO7r8mJHJjIVSf50S+I9L6JJdKnYcav/Bd8fKeuXu0a6HiEUAiJ68ey1
oGOhf2dzOcRabwtGSdnkEJbBP3S9NujOPVKIFFDl39Jp5iw5p66KXJOpAvyUSJl8
gI9tA1pIjbdosgBNsE26vrBPZ7wex1BFqYiWAeMWZIKDtl0u9Rv2ajnNHWCYAO0L
mv06IV0rp7tAPfUiAgpF5w==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
iB9KlcQZO20SnBSgXDcO3wtwP6LKGzPa/+uCnyYjlfcVogybTlmYW0XdyL/DZNhu
piHz/2JK8ofw5/mQZdqaYW94RNJ/PorOkrE0q5gV83HdVMh+9Guc3O8lncIqUlAC
teThRXnZNCjkbT0ybfPgorjjbQa5IhbicLDiBpxOnpA=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
xDsB7/NAz08DH5XSAR0VP5UYPrxvyk/iRrcAcpzS99/PhR/5WgpEUuLv69fuqoh0
LO3gAg9EHeTZiFSFK9k+M2WaR2Pu57ZdoFBmr/WKD/J79eZ7cCA7UxGrbzZz9YCs
M5U0sVa7YS1GLG8fje4urvRlz/vxX5NCkvDnJRWluSe+pI6nikVnAN1PSpEk+HAF
x2NptcyWKHJE5LIhP1F9gYTgKUm9uR9V8g5Cz+flzYynqQcoI6liOjVx+HooJGhZ
0yE1JM1jWpDoeNsjy6cDzDAOT5uM9TF4Nzw9vpZ9KqXZc7uFegD7vAo1c8fXa3q2
2eVKCuRPGmu8xj2RMnOmEw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
BUDnfBcoMKHU2K1lsw8NA4mWDjZXytoIFLkh3rxgk/8DvpERrPIc23noXze6ODvx
Ai8W69RfEvY3z/48j+YKm6dl+i7d3UszllpsntHPB53Cfi+NqySURX+/DprAtyti
oASI0V4stYa4fN9zGaZV15PiWElkOpwk7I38HXZm8uO64eUeLdjBLkxoNOLolh6c
kgWM9X567tqrHfyIPhWWP8O/+TXU8IZq3yMgjcz7SO1TzlWYy2i8o2BJyFsnpq9L
wdqcpV3TqVGSFccO4epIwUJm3hWseCxYyWFtiBGyWKhQWZsuBdXIJ8Q3dF7PdviU
yqrc5CfuDi2DSQUzpYkCjg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
pkREktSfH1tBKyVcE6sTHpbx7mNw3m6Ws9XiQy31xGU9WgsvWPJwVnWCXCv73uaR
ZlzScwZVwOkKeGsMMIfbo/UrE6hBhgMeQShVNvcq/ydv1lqfjnPc0JMLRheUuvta
B9mWeZJGfq/2GCzplJhVBMNQUElDvRbalfdp+K7/0L+yM8PCakjF2BVpIUiZsmfB
4U1DKgua7PPN20Jabkq/Rzh37s+Hy+DEUVvUAV0ja+Pbm4qGIUDXftjk8QYRgyCG
GTq+gX4l8azzlNbglLsBgjL8Jx6Yubm5YQ53w0E1KTJwPHQGktMnhfADsLsnFcv4
dsw0PnmNH6j+XB5DV6LJ8w==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
xk2FjbgXqEEfSNYLH6O7eWyc5IjCIPF/a2IvMMJ2MJEjJ9J696J6TrlpTATxmR4A
nq3adZPqjJCYIwdpREcopD9jyj4WrilqOT/g5k8gbm/ydK4kWn+b78XXcKP9QOgx
up4fW4B7dNO1XEr69Vb5H4Z1SkApsmgY4R+OHCjnLLXXztZofOKlyHDG9RypNQsW
VRPbu49XgVrUR4r8duPOXd32YbYAeRJ74VspmTylYwbhgsnAv9jQj6HSBiDZvu1n
dvTvIIoO2crW4DCbR+SA8NUaLWoNu5U1slMEVPGj460Ew304gXM4wfn5XBZ0Qcqe
3IyR7GYOntaJx0fkR7BQ6A==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
T5BOt9VvndP/VU4GSxKZX4P4Aw0ayexRk7EJnZlz97DEXLNBZdrDkQcch2z0XtRh
vj/MPuxf92M9ZdeoHWbFOchSJrdm/4IxUiPWkGRxDTU22bG8nmDKSxR78/ehyzl4
86MUfnPzjXgJ9ETvO+/4yGCO5qqK2EQC7W0dzmqheOScaDp6ITW+4K1JC2GhmOkK
kHC+6vlSduXLDhxvJSiAidBAVNr0ENE2n3GKWZ+MjtDS75LsmV5t5NQTT27Iva/3
36h0AW4HiJ3nmrDG/Mfg57TeaVmX33q+Yi6FqY+sOSPzqwmKXDT6GlOPvBOS1leX
7AurMm+q2hl7uyvn+CVbECF2QbQssp1sakcftTkr9ndvXgHubA0IJse3PedeGcrD
u0wdI0ESgHYIEGHNl7kOPzCz76ghlFeIjstbQDKAL0AYMd35sTvEixO/NHcZn2XY
NctWwoY1DM4/noRYOKgvYacngl+CnskkmUvNAFHx82joDxDBT6ZusOvlFZV5xcff
dj55Ix1cwzjoRKyTNni+099DCQhbZuqKb7yv6HcH4ilPfPkTET4hEmClhSRUa40T
s8rdEmdogMN3a8E12dH7cHYoP6PoPvImGg2C84DGs/tfZS7Wv/5uAZztWw8ItR9r
FwZIE8/GDKxwgcTxhMtO/S/HjVi3gOJm4TLJCAhLwrhrAqpWU66OVAyr81EU2C3Q
HUZtTggezESBU0SOtn+9PBhWc2jRi1giKCxxNkvBNZ6hI3jl6gnIP9Uy2F5gjoUj
Fn+ETPKh8A+nzV5B2we18kSZYWmzNDtZEtZjiWaMReXot5XRxudxlge87IDhPutw
UHRyMnJVSC4mTFcdRfzpNHw5DwXPC7gvwGzJp6GB1OStd8a/JiFtmw1HCE88H9h+
IwhTETyulDuJZKYDrz8TuX9NU6gzM/XmuYxG5MWheRPvlsaJ8VONVUi5HeUJ8FA+
RWBnrS+rKhrs8OUsvRqNMcZmJPH8y9fTw/qMQu+oLbRuwTt41s9KtSG2q5BxzpYs
KnOXMqsVf2EWfk7ijZOGzr2dkbB1zWPjJ5t4Ibjngjb4H3lSfz6egIK8Jz5Wy1ZM
qXw6d/Ibk3dpGjh0nqcYExZhgzziqlIAMvfkct9zz1xzEMH9rppTX8irz9Ah7YZi
EV7IgFIy4nbwxnbfqubOxE+vNWgElonwOFCcP4FT1iH0OQ5B2D6K8+qeIzwsHcxD
pZDZEl8sgwbuwM8kEGEhpBg3/LJMi8c+4uwtYP2qOpOOIk3doplduFRX3ILFXy6J

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
a9L1YjiX5kSPKMKF5Vl5LiBEqN3/zIhtC86O4GbiAPBYtX36/xbmLzELfxzsuvgV
BpJu5Y66YmyEylmFaorHZuOVqE/10v6a9F6ACnWVxw8ubNPTh72uvCWzzBpsEdWr
Z7s7U0+7ZcW6nOr/xwzCHTH6GLp2555o/5WtCW4uHlM=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=1968)
`pragma protect data_block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`pragma protect end_protected

endmodule
