//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module FPGA_spi_apb
  import apb_pkg::*;
  import regmap_pkg::*;
#(
  parameter NUM_INST     = 1,
  parameter W_OFSET      = 8,
  parameter RAM_DEPTH    = 128
)(
  input                         cmd_clk,
  input                         cmd_rst_n,
  // APB interface
  input  apb_m2s                i_apb_m2s,
  output apb_s2m                o_apb_s2m,
  // ptp time
  input   [47:0]                ptp_sec,
  input   [31:0]                ptp_nanosec,
  // SPI
  output                        o_cs_n,
  output                        o_sck,
  output                        o_sdio_en,
  input  [3         :0]         i_sdio_in,
  output [3         :0]         o_sdio_out,
  output                        o_spi_busy,
  output [$clog2(NUM_INST)-1:0] o_spi_bus_en
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
afWiNgL/WOzP+K0oQwTIRt5COZ9AswingCwyQBtYNC5180vB011HrRUhLSVanYAI
HKQC0I/xx8SlprSEBdUCBdWZZA9e26g0tychSCDmGcRNmkCloV3/mKKM7hS4JPc0
5WYJNt0q86q4onHlvzB+lpXnW+vTGF+7t9JpC7c71lS5vgDqTeLviJJV8TrDMozv
ftNAFd9ZW/vm9Hxnfv8Kgf6F5d5KsVJv+6njlRPq2LCEJd6x6qMB3EH5FqZXPs0h
Lw7e7pgU91FxqFIc3nafGxyM6UJu72N5+yatFA9Z3r2lrR59NtMOTxhUy79jWMJe
fJvP6Y5NWtRzHkfaVC9CiQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
VUfzkSSAxI/Xm7RlFIZVkukcFLMkhzo5yhoHzLiNgTR5WYcj77q4omO4CoNaH9+W
dxIywMJR7PLSmJFM9WxYn1FgSmY6qZLNJJGLLlHAeH0V4/p7F2AdWzz8OsBgDyD/
2+6Kimvjv7wNXYAcQCkBHyYD2GSb6MTtnZl8PCB8DWc=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
KEoZlf3NzgzaguOuRhD94rAu5zSvZAlEdL77RRxa6b+rKyEDcJRSa/Wj9IV1hEtF
3jKy2vilTj3UtQNtiL31OGHKyVnGazifDlHLikvzFj/wlQNSBfWu2fnjZ4FQ9gvW
buWXB/tZgRlRI4XsM8cYBpotEpTnbeBWZOYRI02Ithw35gDNl28IKVMNemdNKajg
pIKs0XYDUKwuDY49ucrW7uCTKF8G132wgc5N66AlONP6JueA+DtOYOfDDgbd8sUl
qg8U2u1kA8DQymywNAHfW/jtENl+44Ujdu81BAICAMpWEETeALRcyOqBiuGB4ZTZ
opi4gXbIUwMsR0MPTy6CgQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
PgJvQmi66XhdOyxDQYS3OXOCybTkB/D19Hk4QL8NxFtpvU+Lpso8L7iqHFXHbeSi
BKgxx+C5nZSwDxFtaX/JLqD003qKbi3W6ej6bIW56wncFULRnBpVj6C6DVXhWUk9
vx/1enEV1spUbFoA03c7yFx206tlWM7rYP57DaMvZVdgLuo+WrIvVxOMJYEnzLwZ
R/r8ZA/bJw24MEndb094pxcfJa7DPIOcSddKqDieLcLqHC1oLr1GH3i3bRl4ApWG
kkYYbLwC6dyuzRNKI6iSmCzr9KrsTmYmMlF8VV3hXfCVTNj71HXltiRZq3amkIRV
ULrhAJK3K0O3foK/8AE8JA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
FVGtf3IZP3QO+aRo17hSY+IQNo+4eymLGE9RUTZDVpIGfgvO+U4mrG872WCFdLJn
0C870WfQwbUt0h0ZnPN3V8t3nRBhWIuxcX8G9DcST3o3dfZYzFMYscnI338MhUTu
c+DFVvPuKeKPwB7RvlKePlni+OETnvitOUStn+cCMiHVm7o2QCepmGNUSbijOykR
tdDdGDL55TqrNmOEmDkdkw9sglqZaBjx8J9ldRvnADE75phFE/zwJ3HLCaDQjTHX
vc1czkeX57DIeHy6fMEDYISiHPyD040/IUDI9fs9W2DFbqWVnYQ9pCUeoLaVR2hT
cIc5PA2a3k8kVaimYKsHQA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
kgPDEy31xSskEazSdZptZKsDjYiKl4ayfjx1KpYQh5YXGziqAQUdXzcDm8YcX+mI
I+ILpI2AhvVh6/IJlnT/z9p4/kf6ojPzim64bvqn5F4khELtLercFf/2FSqMTlaj
tCiGZp9Dw01OYVCyVCsfG52e/zDq/COpdHr02pbOXAaemsVIRnoFJrMKCJtWJmj6
FCKa9LA9kjuHo0bd85+eVsWqxozvSSSiXkhdVW/QHb+vpQ154WH4ezJirWiLQxUm
Kv0VXJugo22VKr0/hZ2G4qiqOmaW7oZDe0vVGft4QvzlqxwU+UUytwVSefb5rEXi
iNmUMWj8igXoX2U/KRnatw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
fjJERzFj8/lUpzDd5i8tYHOVbm9r/Xv1p/iPiLPpf8kY4JzzoEzOWiztgdQUjza2
Fty1ZNrkuidNtMpgTeZF2k8n2kIUsOGpVbuuUEgBH0F3Pe9k0YAKmn05lUizun+O
mn+2SG1vSijcEprV5UAMC3420z7oErVzcXFD3fh2669Gb6keZKK1IwF26z+MUTKz
TVQo5b85gquuL44eLldGJflJqqzOFx5koEOzOrIQpun6O79Ct6baX/ksIyZKHEnr
InahjpuatQi/Vsj/1Ml2xWte3n43rn/WAGpJ5XVbJIEcfENPqmCiXh1N39LjcA0D
cK3Ix7WqST+3zQYViwFsr9bN3+5KlJ5FH/2foLTu2SFPsannV+/OVj5kpHPxpnYo
rahtrdN+ryWwUojzUDvgGZApams3BG5bl3v1k2h0y9+V3RSUjSLK00EAN+Zqs1pW
n4P91kwYZUwMk6dO1J1cQ76KccDwDHZ4+cZ2JEPVx8sxhSUQUR7ZELknMlC5orlw
kTwHvN/7aXWOsBstGrecxOyeRGh6DImwrmULcspbheeLskFILfDKsJx23cjHFVB4
L3SyrNEG+sd5rPDqDKLi3p9ZeS5/9DQgRPjtDIX6CjmD3hgrafcJPpsEOo7KtgRP
yT60aoSBuidaDAW4xFvNnAj3EgOdSY101A7C/lcrtJijdjsC1g4EzmCz7H3VB0DD
qMAEbnIA/YmD9Iz32s9bgOX4EpVwVvlnJea5h05PhJsMYmOkRmOlsvLs8yJd0PsY
TmX3sWcltQLxAOwl8dvaQc3EK/fUD38Xt+pvEv5e4SmiFJkMSpcaZRE6Ft86cRSu
sUS9mO78XBhzuNJm/eqZDuYFbWt71CNnHmLJT8mUrArsyWvG+waJhekJX02BqhQ/
S+ylqpZsB7QT9A/WG76Q7+rOLAWKmMvf3Lgqi0b1zAf2hwPRMTaIuelvFeSGTWk4
i0llkMhRbTe2TRSEcoUoG2mBbLY1g30gaERJ9ikyVwQRt7gsMcjSTHT6inRggXTZ
MqjIXS7GCUBJ71Tj2SXkPHruzuTuhWQUdufFb+EiYwNuSRtsnGoX6XxsKQezzITZ
q5FGBvItk3SSh4jxVoPMJm9qiHpQMIz2vZPmwQUu+J9OevWypLcKBe6nCJEhRPg3
NsgoI2vlpgCRtdyTxF1ov5OZlRG//pnHjbuSHIZXvStTtI8V6mSrfNgZIv8Elzw9
iJerE5sjX8QAww7+PaJEGLgi0FJFjVxsWNMUmnX8+l2ejSScqFrEM9/oi52IN7am

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
lbV+PJnFApmo5wVr0hYIx5FCAojVHzKy5pv7Hw6JlN9diCzOytVZnULEU03PXSc6
0XOFmkdss5T8Lolxab8gsfibQe5dP3yLCLKTIosDMiOTVKfYhw9vZsYg+WAXAGLS
02BtACdgVnhjSbm5Oo/2hznUqtu/TmyumbscjWR8U2g=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=3952)
`pragma protect data_block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`pragma protect end_protected

endmodule
