//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


//Input is full AXIS packet. Module will swap header fields as applicable, calculate the ping packet
//checksum, and put the packet into a FIFO buffer for hookup to the datapath.
module ping_pkt_proc
  import rx_parser_pkg::*;
  import axis_pkg::*;
#(
  parameter   AXI_DWIDTH      = 8,
  parameter   KEEP_WIDTH      = (AXI_DWIDTH / 8)
)(
  input   logic                           i_pclk,
  input   logic                           i_prst,
  //AXIS input
  input   logic                           i_axis_tvalid,
  input   logic  [AXI_DWIDTH-1:0]         i_axis_tdata,
  input   logic                           i_axis_tlast,
  input   logic                           i_axis_tuser,
  input   logic  [KEEP_WIDTH-1:0]         i_axis_tkeep,
  output  logic                           o_axis_tready,
  //AXIS output    
  output  logic                           o_axis_tvalid,
  output  logic  [AXI_DWIDTH-1:0]         o_axis_tdata, 
  output  logic                           o_axis_tlast,
  output  logic                           o_axis_tuser,
  output  logic  [KEEP_WIDTH-1:0]         o_axis_tkeep,
  input   logic                           i_axis_tready
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
AnLBq7RK9QkevisWFQpSgbq9GWtORNu56ByDiZ8zFGtNIferMnidNwiFD/z5DEQK
0ZlQwHemQhIafkgtcszSW09f4jniQNURAE+MqxokIjeB6/bhRm9rNMAe+RL/BKo8
DkxKbmXNoLfDQNPlvR8Cbgo58Pa50xeMtBLmIQcfDrK1x774NkYFb7WVwCEPt8uf
tW1aI3FqOUKSGyL/cJVC/nLFdXh255T0EpZVqGRmkV/tpY+zwTCH6ZLmiMtDN2ru
J1U/9HtoA0lXNksvx46A7qXxWjbuCM/QsxmzAtKKNVzVHUPcIrSlTa86D62TD9Pu
+/hOI7svYjOUfHZk92dBUQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
mpg09gnj9+CEvwrZzsQYIFpqF+sJoKyocan8iLevrClrbMVmyzBrfEP0tBypXhEz
XmPcw3VQObHEQZFQHIhl03adiaUeOxKfqHU7gY4nCzjqCMp5XuKelguxfHe/6/y7
15bqVylePcfWVHI4EG8dute5W6J7rYttKMBAJepjK9s=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
X6VzsGlB5vqFrOtwIUpj1zVM/bPUdG2EwpOtfeEx99d2mayESZwM8YkVEt79wAe4
eAR2DuBxlGxIA3wmKAmQRioMYqRzXBUuiBlqamNVtQ56n6LmZRd6L1zhfh3sXMeN
kZdwzhIQptK/Sqpi5E6M4HNuMeanRV6op89Qyz8nKfKaEjMJwni1zdI+VSf+THFk
1Or3pr1CHjaYUhWB/nXH4M5Yvw55f898IBfwD8ueINSjq+2HnbL8MvudKCa3/yjN
kocZn0CgeRYF6NBi1g1dywb5tFAJqRwOMnGT4mAAYE9RAKlr1Vgg0gTtisU//mQ3
+ObPW0Lll4SaxT8qs2NeFQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
giN+mBe4ssktEtDzFeQpiMu7e//28M/RBaitG8MCC2USz+ld8mS+02iZ8LSFoT5+
nMMmiaTYetqUHu925l2rAJ6qAfx7ag3mgKAtQpn4B+5R71xka3hFZi+CZd0d7AWw
Xz8jGw26aIZsiYvNXu7UOnML6zyAF0i2hWO2hb8zW6wxbC4HcGUuBFJGDHYs6zdx
xPGVUq1OVNtsq2KEKC2eXxlVc4QeTX1gwbfZCq4ZvNGC7G5E/gMp8x47/lG9edT6
KJEkAQ0vMyrTd2TXCcyBbgR+0IlxB37wCkqvxtl3b8fGsTcxY8Mhw/d0O56Wdmrx
nqykojkeMlmQXDABgEobOQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
HdHWq1kYnFBq/o2r4cCgjEkzyJNJgRcQYX7LcYkL8Gf4uL8X40CAZxHKYdbsm4EC
1ByLSnBK7QpR2OulsYV1t/fGDwfn+6amG3qitrsJvPKVGuoviiwQtX643JjRoCPH
9LHhNl2T/8zavEIgolnXhKzFGKFNr7supCqTelToqY9cTWvhiRZHyaKDbMaapbNO
wtJzGLVuTsJtnYH/Mk0miBlOTdsMNnMMxp8WaU/VpCzUJNSBRbuUgC7aAPJQ6LUX
0E99CsveR2Jfdto+ruJCMwVIHnOe0y7oqZfx8saVmYYXY6DyfdirBhi0SgpBUwKD
a/VnI0OuALX7NDuORWxN9Q==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
KlomQo2Sbz7TG0XyRtPxDK97cvew3lpqoako8T5LbJlO0YiK/akE7k33bNaZjvcG
CHsvokOEZJfKH/FwzEry4xovXISQ53vgme8N1+GM0DYztNkpR5JukiiMszBCL/8Q
eMqinksgWY0vIL2+Cq4ZAJ/qI0H6HjMHrhBRZR5kE7Xvy1WMVBAuDAs0xvYIYD2M
At28iwMv6zim6Yezp2jXEL6e+MFy1e88Hh7HWsEs9IQ34tSDvx54eI2Dsu4Y9Tlh
tffGjH8pq676JEejdIUzObeD6j/YamsNwszLhBQka8WbhFu96RJGNSa9UFw7FlYb
FFhVkCQBxH6mafZevrUZBg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
o7DWyzeEBnJpPCNEEGNeqhvDPazVHjcfCzZvzMLzcZyCvhgQCZrZgnijIkoimsOk
u42v82w0M4EPBHPsuVSmyfrYtSE+9nOE5OFPywaurWQqsyy3CXQTHoOO7Zu385Ya
dnIMX1gIRkNXCSKpnW7+a4PbApxNhI4NX9As3rv04OsTv5VoDp1lS5WS97wtTOn5
LEPydMGM3QVcL/LVqQNbYQ+/WdcCAIXx1UnLdL++wsF7D51nWt6hoWXnI0XVdOlX
pXWprOSecDK/4DJQTri6drRt1G2m0dWyhigb1/PHeL4CY25+vQYkKXlsrFpJG+FT
BpgY7r5GcdDN5Hc4BotTBDRGitEy6MsQ80X4SPmmlAPXsDoGmPta6s6FIKZK1wY1
OkI5Y3bChmnqNvsJFA/J4eAHuOQgp2QxEgHVkg9xnwC5g8I0Xl7N/KkNHjSaEm5Z
i2QqwGTkaJ7jWxKMAm26eFvuMfkDIZ0G58YN51lmQLJvUhX4BUp/w3I88NIXSnKd
pILgKh7WeVKWGDDemqsznpoPihNZFoIHfCy5TEmx1i3kRFH5ZI2uY27GCUiLg10G
yRKwLQ0AMox+0cajVGUo+JBnWmtHBWjyZrr+NX6jVDB26RQbYo8rHpgxX9YhUFpl
Ad7kSmC1cHrgtCXGXnUutgJE0Ej8kUf3m8oem/JLKy5BwC0RMiUThtO9zPOR8lF+
2ozHUtL76+coKhqeed5DbgRmXb+jJer1VyitcjEd0l4A329YOKTISnq7MGUZORZg
ev7q+TmpHaFWGBVxnAjBSQzbLghmFbU7muQZrVlZIsUfF392Yplsr0CyuTDIyI7C
VKTwMH+y0HVgquxVuwJMk6Hd2A8DhBt9R+J4AYr4SrDxF6ybzQ3/3Dplm+HD+Vpp
sjaypvT//Mcqf7fnjhrhnPpsgBQVspzT3FwEtwSUOtaYrdnydjmPYdj5LTtxf5pF
iB7lBvWeimfLnuZuN1A0yCqpc3VU31R7K6nVgbyDCgfUIIT+hMoim50/g6bGQdpm
Mq1lK7U+ONoEJCKkzhf79dbelkqoh/kU+fWr+GePBUs3h2+oN5rkeVVOzU6PMzoY
+nnvbDlXFsJvJ7NFxQys9vQCVDWuifh7EQ3aZ3/SH0IcrwLd+S8OTsDfXsvJ94n+
m/TILUsiPT1VdJ5s/niHGwFviEN8k5FnBfgOc/uP+YTbt8TIChQXu2+WqIYLHdC2
nyjtHp9OYrZ29lasvItcbiTqb7s6yQ1095MU7Uhe1Jd9kLOQ2JcB7GQIUXyXtYMI

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
MGwDY4nOYrtBJTg8Nl+rdjSw8JRWs+KL4bkSYjNmON0THTP2NeAuaInrMi0JLYpW
de62uP+n/NILmSfDPF+vgkKcfheJJppZxVvclOVOg3atJO+W3LftYdK52hWVJHIy
FQuCDNsj7+RbnSWx+sglEKXsSQuG9mQfx/QwKAGAuAQ=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=6432)
`pragma protect data_block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`pragma protect end_protected

endmodule
