//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////



module roce_icrc #(
    parameter  W_DATA     = 64,
    parameter  W_KEEP     = W_DATA/8,
    parameter  W_USER     = 1
) (
    input                 pclk,
    input                 prst,
    
    input                 i_crc_en,

    input                 i_axis_rx_tvalid,
    input                 i_axis_rx_tlast, 
    input  [W_KEEP-1:0]   i_axis_rx_tkeep, 
    input  [W_DATA-1:0]   i_axis_rx_tdata, 
    input  [W_USER-1:0]   i_axis_rx_tuser, 
    output                o_axis_rx_tready,
    
    output                o_axis_tx_tvalid,
    output                o_axis_tx_tlast, 
    output [W_KEEP-1:0]   o_axis_tx_tkeep, 
    output [W_DATA-1:0]   o_axis_tx_tdata, 
    output [W_USER-1:0]   o_axis_tx_tuser, 
    input                 i_axis_tx_tready 
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
Hizy1mBdSddqb9bseacI5PegCq1jGsWrSC5sgEdZygLbVGda2Me12ZIYFQKeZX79
g3wj8XYOfCuWMQaerIVmUhk5jPECkFdOKho/4zTJxiZDJ2R/HnrTswLscohyWu5p
qS216HEor3bKT2YCh+HJZ415awEwqxxpfvoH9EG0CDsJAYBV+JN3W5dMPNIQhnxt
tVa0br44PhFTDiv9dV/N/Oa0QdU0FjOOs/0XjcR4V9cJf6FcTGOSJJhMcKSZt1gO
7dfbE7WWGPorE+FbOocfWZG1mZu5RidtET6RpJkb6zkcyfAmXFWgFZbjg5wjte1i
HU02GpIFw52MYAfPZiFpkQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
TI+WJB7UaJB2XLGbqrMTLe/2OZSzfhQZbpMOANhSRV1ib3dUOrAxYgzxiAJV/+o9
zj6m1rRskM/a8qBzBMWGCEu5ZvsssDrZavE7Bgdu5tFeSRS/L0ND50mJaNfUGRe+
MuahEH2+S+x6EWLVfWKbIzrIo9AJ8JQ8dlC0reN4FKw=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
DCrZBWjRtjoxCix2gUY1ZQ59HV7hKaaCDEiUXG+IrclYXMn4Mpd3CZJLEPPXDoev
Q4moMa7rm6ibiBwna1Dxv1hIv7QQrf0KGoTml8TmAnH9c03XLWhCLcO38eZmThqH
Ln/k+piL7u4Ir5fV2rDlSpNnadnqi/IyJAwW+3PdxnUp97bwMIybJnVD4ttPIb4j
RQLaXFnDjhTw6P73vDVfglTbzdlyKpYj20BKm5Iu6W36s2sgKX68sM7VX5HDyfNM
QEWpHkC0Pp8+AYGndMFWr/iUTgD7ZB2kxMJe1TaLuLDhyr55IFfcgZuDfpfBKitt
UmoKLaHC6HLkxoWZO/Klxw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
AHoF/RZ6m4qsOO0cQiO2am1Vejd1q+ZFefh1WTDI3/7fkz4zffeLiGxmM4YxjNnD
7M0LUNXdMSEM8ZWXLULdldKskS8/s3JUpGL29a3tE0PfOIAZJADqIdbcI9hsOZyx
vuAWJ6M0dlAM6Ly2P8OZrW5FRRaCxIrW7r99XchvOEIVwCyMccTnUMIf0bcq80B/
S4BGQgHrTQE50fQd+WKSQ0wSOTw+nMmh8ojFj4p8rcAPDmtPpFqY8O3n+6BLq+Rc
d5Lzjn4gCW9+OaRDObrkSj31S91bjrDh+uKjmGl9cyg0J6aAmhdTDSEIPf0/V7RZ
hxmii2UZ1T10v9mrvTnGUg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
QQ87fWbIjnIKWflVNgm0+WaVJp6vCgLbh29KEEjqSBskOW9HPoLZ/zJaYdz+9LSd
MOu0MtfL63CxKnQp5DRfLTSVKfIcw8xNvw0OhwkhdDzsWRdo9jC6vpvBkaJI87gS
VgtkFaRAqYbc053u/jfetcujnoK3b6SAt7yAZQHaQmBkUVPy0Y8ocNhL4Hyn+uU0
9sQI7wlE4KAg+ngb7zzT0Xj9K4CVEWHZuNxsJje9V/Wg50wTW4mPP9BurmPGuSVA
+EBqsQ4hfY7/O/bQoK6RKlTGHcfyddbdZrmZ7lK/+u4hdH7phWVZUdYauli1B6Y5
mnn5zi5e4ACPK81lPBrRXQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
yZNpIFSIsc3J7d9RjGUXkjOQZI+r9jA/LsP5OfjPK5CEJMFUKDWQcPskJ17weUnT
4yaKQL2vxzKTGFeUsGtaIXPnL+nHfiZ/MX5LaQ0GinbJJ1HVuKtm86bZDYq0L0xo
eWLqmED0ziNHo9+iwc7TJLjFFUH9afFiq8lz7SJV52n0hKXJBqCyejzqQRGrvAit
MNzG8d9zRB66Qook35yoKRbS2u4gwTa1flzA6FZD2hDR0WTeShRFzIQXEWza0v6C
hHDgYFPP6Z6S7uYS3CGLIRkkNcbfmCVapPoxiNECBpYveL8exqjoh1FrOQ7syxkg
DxvRqmX39bRnpGtt0F2rEA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
rzDrWSZj0YnVHfz3Of78uy30HyorJ2ZfrNgTwmNhF5CZPUUCqLiajuq3p2sja5Ge
eR9M6WgbLq2LxXhe3LL9P5PrZcrwyXdWr/82zjx+TpkyTSS1V6o6riKlaFVSK9xn
1/VVXqTS6yOCJ0Ma0d0ikOHZ8YosUS3Pf8M7oD92cc18mBMPm3XimT+1/zgxrXYi
jRDodke2vT6szFDgOX8zqOeTaRI7J64x3SoCoXVHKScaD0cGwXvHCDrtUJ6cGxAX
XTolWmseeCLdse9rb4HUw7NdIbFP9rSMd5hSNlVFVjUjhX/Bqdiz+tMhLbz9kPUK
Vd6ML3tp3fH2OEGVocIKej4yeEce0Jlk+h4LK3pNNMcm1ArVuNRIzSK4hjPZGwzz
qLXZGnutrNSKB9dKU/DIgAtXPs2gigTCjP8MZ9IryH71AkgQblVmBrin6eegobLA
fw5PSRL4HvzZIP8EGj0jcBr74QNXSNKm3wyMbmBLyQ0NrYeFWOjBHDR+E9AzAenx
+r11xFTKmkymg3bC72359ps90QHK4ZMqlxC++BP4vkzVKZDMy/AzwVsleDV07U7W
80BfutANMKIv2Hx9JPW4MJIEVuv7s9uJGiXnfS0Wf0pK2DmkIjyWjZX4tB4LNLmy
KieElQOZPfkYl0c5e12TOAgfQiOOjGQ6m8u/sa/X0g0Di+EBIfnmTnaZVc84zqer
OH4CW72uLlWFccMSW9d/UMF+u0XlMqJBDnhF0PQOmHaqpMnRZ0V2CELce+5kTm++
CJYhjfbuxuTLu8odCQJH9GQ9KcA3tfJb84lZhFAa+uFILaCGv8/27SzKBmbFZvZl
hmwnT2mzDyjsQxKdJlRgKbLajn1a2MQJIueKH1ovmTLWaAsFCGFdRUKtmA9bVXug
NOnP8wi5LZj0JnABkVkgquQzSOEmfj8maeQkv2mmxmN655Gsq+2kWSJyIYonOynQ
RAv0NnH4LHEF5t/gnu9i6xYrxECvQbnh23Bs3BrRSuFtsbmSrIPtRg8CgWMs0/ef
exMDi/t0GXP9W5MaPGP+4Gbe6iL5CTQuJ8czkTSZG1ovzo1fxHP6Ni+hFdtjYw8Y
/rMPZGXLQdnO16nya83kPcCOAc0EW4wtC3EszCXG4f05+wDNpgvC1MiBLMwDa1u3
Gzk8UPUpg6iQoPW+iOHolrsR66emiGnUZ7QukrCFHOsIK2YulnrkypjUGlnMl8Vu
vHa/tKmiTLC3NGoLnoDPqrzBVC9Bntf1aOTEsE9TKQwDYww0+UPVQzBs//AUhVFC

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
YmcXJ/mWZBH3cAvTyWcPTx/sXVmbFfiwiNfz8xuxxr6Yrbg4Pf7UXtzSNTMVpbQU
UvBz4c2Bpt8foqWMD8vkQnddW3Fh/qrNAxxH7RxfqJS3jXBf/4TMvqXKnPxp5hnc
+sc3S08H7DxcEQvoUyM1RLpppXnZWv+uuHE/qWBAcfg=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=11104)
`pragma protect data_block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`pragma protect end_protected

endmodule