//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module reset_gen #(
  parameter NUM_SENSOR_RX = 2,
  parameter NUM_SENSOR_TX = 1
)(
  input                       i_sys_rst,   // asynchronous active low pushbutton reset
  input                       i_cfg_rst,   // soft system active high reset

  input   [NUM_SENSOR_RX-1:0] i_sif_rx_clk,
  input   [NUM_SENSOR_TX-1:0] i_sif_tx_clk,
  input                       i_hif_clk,
  input                       i_apb_clk,
  input                       i_ptp_clk,

  output  [NUM_SENSOR_RX-1:0] o_sif_rx_rst,
  output  [NUM_SENSOR_TX-1:0] o_sif_tx_rst,
  output                      o_hif_rst,
  output                      o_apb_rst,
  output                      o_ptp_rst
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
CjzzGCNwOsRy75zdB8PPcXobvl453MkANaoy78T2m27iYMib9ElzJrBh5vnnFOkE
FvYutSQZopkOYyipM24lUtZ4gV/s7sqpuOOyBZ3S/ifF+m0V7BFsCP8KwbnoCe88
HQ9smuprf4Zg13JWLdzT5DE0Tw+1a40BmODPryirsxssoKCsDsnvQcFla/MieIjx
l3EUBo3Zcio9Mh+OEwc+WHNreDAA16G7HY7m87c9pqSImrdA3PU0X9Ny5SNjBxmg
G6s3olm/O306ohencB4ZFAFMTklMhN9E4ZSLLYoQZuuZrySnu4ZwxSAYsONqzlXq
AgpPyVffg75ivxFuI4/AsQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
puvPStqKFCOFNF30Ps1FLPN50mPFYHnBcrbUpa0GopJLzhcc99ZPb0D3tFw1g0yC
O/2wIGFk3YJ4ejKRB7MPWDaKPFcFA7zmh8c/hmdHXwTU+YQgkvnPYKecOulPn8Xi
+PGKAwpJ6tZ65SQYuy1CfTE0R2wkDBQFuPgjyzDJlU8=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
Rbc6RMYy8eQ9Z1nGN2iKNOD1rEKPTWRRNIgVucXWxeF5ZzkI8omMUcusQ0PgGPeD
CvlpmIV19x0cd8KKz4uc36ArdkxORXoXQh/Jui4Cn9d4IOATgmQxXp8M22YwtxJR
cDAowOKWeHnCzzA9SxgeZZJjn0ngjzYMfbycYFaoM5rWPhv6TWviT29tb8afC9gT
A9PzScsr7FpsjPTUrg8ae0uDBctXNC9vnVLvHcD7VEJqEurPs26Mj3tZ3sY5p3+E
IAKFOX9FWwjzAm5ED8XmBIaQk6KrMwk1Lu5PUw1B2TAquxrDJbW5mJxCO79GcDd8
iDsHKxQWNPeuEMuon7REYw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
CYdLzgokJRAjXLmYLJ90FtoSx5KtLhKRjxWB/3+7eYPS+hID+N5lqfF24a+P+58Q
RkAA8idw6h4Y/n/cI9xZyWVTsTcJAfyMknGGoff91YIH6p/b24AitJww+PPKxU7m
XcEXKUAF6K2DbouQ3nZsIKNAW+oHaQ7VoIDZflPf6y/XXEVGGw108Jh4VVBtiLRb
zPFwmosIh1zGeMlURFwAUBPybuhFsZeUnyNathgt8Qem7hljGdrcximxRWxLOju1
3jkneEjcRNTla2mT7+0c2lwfRYpdZzlEKAmELHfKqKMHL+9Qgt+CNQTafgH5qmfL
JqZ46lRJogAbsKO7GMj+xQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
TAEhjn40oT/Jvbuk870wSikF3QmYaqTOqo3A0fb7lw8TlC6yJ0wk0/vvMAK3HjaB
ZKbq7d6HwwVPrc1iaEIcvX75svBvr+EUGMuAj3j61VveIHVmY8ox5HkYwLZZFhd1
U3oSVu72pR9Vgyc3CqcdtDfEjUauxff2txKCTDJ4d/mYy6nuJ0o04g51BAgrEoxj
rzBiUVDgGjWYoX4fC1xhMhSGaaSCnMzsyL6Ly1KDhbfCYjwHuN26cyDhBLtGJtdF
uz78eGHX2WWvrvkYDznPVbyBofkKP9NKRPLsEyAV/xZtTklTiUCcFzPkUIFvRjBC
OPVjobg6KVPioDbPq67m4w==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
dvc55ZBWLk//j2RfijTd4znMnHNeW9xS3K8pwRiPjOTkGjIGbSxanm1/jRUGRCFw
hH9KO+18dznsUKZs1tLMtiRMl79yMUdOBLa0FVSDG6G3S0R+W4Y6TteswRKPu3gh
MI4k8JNYEYzJ06bZD3vaWTf2x4o5YkGabZtlj9jrAX0TQuH46+UdrGwwVIIDURNi
Tt/PExEjcCSn1aibq/4mwylYUrGQjXvxlcTF8jpSwp0NzxhrbPKzQC5EYEAx566T
0XPDUcFCD0FhKUWp7eloRD/LKRrNVkhXQ+NOdph5T4hRH6MVFvC6NWnDL70p8Fyt
JfEm6g7makyeUZ4o9GPPHA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
N9Ig1twYzGsB5dmZ7fGjxz5xMxF/qWCVplVI9sku5lGInnf/aw+rZeY0lLYpp8pY
uGGaFSvbQnuj5B13eoL/cKvXV02tRPqXRqYuV1fID4OpAQqFkUIk1rYDhnws3l9c
C9SRPk1t5EpVn3nm8ULe/0LLrRUMscquK6+RSAuXAHugEIRdquoWi+JekKQtHTyU
VJlAYaxQGlJRaxZr9o21UZiVdW3TuPji+2mKpjPkw/MCrD/NPzlgQeCaPraYYKb1
GMqhGAIuHAE5tbdsc/PaD2n9s5mIq1aig5SJJuSGV0Jji7hCWt3eFYDxnOUHiJyV
yo2NmhaihRU5A0UK68gXmL+OABN/TTsRN7poyNqC90M50JTLxJNd8b+R+JGvdDAn
1m8ik29zkbYGeKlzHSyT1pj0UJzFKgp1sGqf5KyTY1c4fgXNNMpYBiwAS2DB3isT
R7UaM0T2y3mqre1i84/TuivxBKBw7FYIF+hZ63vnzH7eom8dNoml/bkHYvQhpGim
TakIlfECgs1KnH18CU51Y2hqLJoComAGCOy772L9JJLmSB+gWExklRRDn5kKA3ru
FtqT7M2P+UaYKqbso7918mI4KcvfR1G6OMM7bslxAztGw7f2yex8/rPTbXjQb0Zu
hQSLqUrDpmCWQLdWs1ZFSSh9AFWnv3VQauLRQO2A/wql9Fnxo3VC0q58y6d0wqIj
S8mc/EFWF8dh6ZOuigCkDX2/sKajaqo9K+ReA3GInMuhrwoDQbmpTuq8Jr+Bte8N
joHHHjmlEnTMefBX0KokKyu1inGtENLx+y+shzHxMDJIQi7S8PMdB/ynJ3N3ZQhn
ytw6ChSYL9MH0SoXwyPndQs34kD4Z7P4153ANZ0RceBOnQj+fp/g3YNI1Ft9bpbA
bJ8v/mg0sermL9aH20fARCOwTDDz8S4Akjo+RRLGukaCSCDIPc88UgmvOcRalGR8
AxsBHrH3xZFA/CefzHcMrwVV8QaqZAGbTlE27rnQCjfvZvCrioazv2Y8OA2cPbhe
wpYolgI6XPULL7w81cN0NYTyRo7LL56hymVCg92Ss00V7WBeuDqd6iDECC/4O8t4
VK2qYQrvy9eXA16BDXilAgma6wXSNOdgE/hxzG4WZ0ouST/KdNEIo6uQEIfUenE6
7slbZj8QLCIs4Z1MvUhz+gBNj9vgF8TCNeCHHeVu68HVHNWPFcNyeWC4AyMhDb4t
DFhdLWxKhDGU1XbBgL3u5NiM1XpxxaWnM7yDrv7uYQZbEoWlVicgx+lfuUGFkilV

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
m7ckXaA619QK4REckzcMk67AXW/vM98n5AddOWSSZK8b3o5zUTRm/F9Ih0e6dkRT
haE/wYzaWFW20O3zMclTEdL1968Le6d6yHijtg/X8LeWCpZ2eGJPySqhzIFKQC3k
/p/5pbz8HMO03maCbrtVuCr1MzgUwoasQcceS6D1QXE=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=1808)
`pragma protect data_block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`pragma protect end_protected

endmodule
