//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module ptp_timer 
  import ptp_pkg::*;
#(
  parameter HIF_CLK_FREQ    = 156250000, // clock period in Hz
  parameter PTP_CLK_FREQ    = 10000000,
  parameter AXI_DWIDTH      = 64,
  parameter W_DLY           = 32,
  parameter W_FA            = 32
)(
  input                     i_pclk,
  input                     i_prst,
  input                     i_enable,

  input              [79:0] i_sync_ts,
  input                     i_sync_ts_vld,

  input   signed [W_FA-1:0] i_fa_adj,
  input                     i_fa_adj_vld,

  output                    o_pps,           // pulse per second
  output             [47:0] o_sec,           // v2 PTP seconds
  output             [31:0] o_nano_sec,      // v2 PTP nano seconds round to the nearest nano second
  output             [47:0] o_frac_nano_sec, // v2 PTP fraction nano seconds
  output             [47:0] o_inc,

  output        [W_DLY-1:0] o_dly_asymm_ns
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
QsZcrglJRJZx/rhhGthQmJjvis6eUahDjxuhtfxBbpaZHgWELRa/1z4FnvBznmb8
MwxCcZNe196V0rQbGSsHZjEn0c6LhbP2jym75NVZslD+LQJ3jMBGEiQ0EibPJccz
al/XWGvnB+uqaw3zo8wFw3sx9rVdb1f7f2UDeHHgg1hdOAqL4I3V6RTjZ4tw4kYX
3RdrHck1ymsTKW41W1RL+wabxLthpf9gXV22FBv2x646mSeTlunknDnAq22w7xYG
VGWPI29h0U6wlnTlo2e2sjpeuvoUc0fCCAU3VzwixMVcYKhb3NQemyINEW/yEn/w
MWjLD0klQo8ztHEHq7oqBg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
U/YBkstZR8An7GnpgB8JEFVt7/96oyoTtxPoraHenatTzCnnhkcVjrb7EJpXz0rU
PVVM3XAndMcRp5Dg8k62cwToNQQlyhbSAgT1tuaMpJS3MtmebcwcApbB4ZlRcNmw
ne2b4uVBSFNMPuidNGtDCb/BLoO5PsTsX37GWJYdn1s=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
TFLbO8K0/D71+ubZtD+3m+yYfC8LxSBEy5ivqDWi25OZvKYjU3AELmVqjWBUhZWF
erIjYoreXIMRfizkDrfMZWIM6bZwRCu8THDJuBPF5VF2M5+AO+zXIpnhLXOt9Jor
CgQRUCVg2S5D89Jcd/396AUUUOCS/G02IMQrVr5XwgHiN15jIx9nhrKGSjMER9ZY
6hIDm/x/scPjj+e8BtonTGIjcjvuvPp4uG/MrLZIwv9of+slEpJTN1mSIhNammg/
3pNssK8duuePsuGNZGRJUyh7YgDlVn3Qxm1diO0rTsnTKzHnMeOzsAOL0/61Z3Q0
1NYtDcVNHC8HB0wE9CTUug==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
Bj4n8ssfhe9lUW3uF0srkK8keT2PGGJiKmqLiMayT1tjHLNKGr0jkeI4LHrRdfZu
9WmM7p9sBGIe/lC33dC7zEpSJd6+jpkFXW6oH+eBI5POfGw7i2wK7Oui47a8nq+H
Kqy3ygaZDEosj/XClLMoN+QSQ+bnqhWUOBypXpkiHYt8ffG/h6apdLrrAVsFdQh5
Wavtfmcuj0mQKZofUnFUDxAz8lgNyrv+mG5n4xoFrPWb/NaG/em3WlDWxtGhuPP8
Vf5E8GYOm1GGK9dBe9jAKPrArXAx0Uw19C/PPXnTowYMvN02ho/Fv6+0RT3KomUv
EqsX9MEv2O/w/VgOTIeNFw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
EVieU30siwgSEXLZwNiCwExfaJJICEKIj6LWRLBgzta98vS+Ieknte3bXMu1fO9H
TOt1VYYX//ctkg4ah88nfqAjU9pAFDWIx09YIIAHA60HcODdm9a5JgVovsYJFAtL
/gKyii4q0bLqz6CKFL5Go0fUdErlxBoSgmniIIwX6c5joZYaKMH63Jeg6Ps0yT3X
ODNs8GELhZ1UZtavj+JGU2eKQa8t0FTcVkpni1MBddVtPsbjxcRuxsDGRFk4uCf8
kM46vvBxTg4/Z5UNCHwy9yIpg6qmTt833iGDdo5WXe+TPJIxTvvjl1fTQDMrggwC
WM0uXaNaRzlOb31LelWTug==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
kD3l9DJ402VUGAfKo2MMotmhB6GLJGsREiqsNbHgYwaDs0tNkOOHmr9r7aB+IpO2
ubZ7VxpJuoIPv44soiUFPAtqMD8FUzPKXoZniEFQEN5F7+oEa829e6K+Vn6YL829
VFS9LJ6ajWQQQygNSBVzgbFnlelIxqUsB/W36H03Qc2QKgmtQtR/+fttKGBk6ojU
UFA2YHvW/U7LxnKB5RID5AJhL6UABMv2GC1SW/J6jzMi6S3cqNtJzAVKXXeP8+Hg
+nWwyC5CquHFMe/7pzO4UxkHNl6Oa7ckxkfyzmSWTyWnpAMSCZHVl/hG/NH2NRgE
rLxBj2BXJDIBQ9SR6v5BPg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
LCtDFESzKhCD7sdQ9bslJiaqGle0EQ0Q8tYqmzV9rESM3BT72K0UlQDuXe/Nwr57
GM02NjzCmmTUbgfcn+QweKknQ1ef2DfuAWOBg71/p6w3S7FajOTsQDPG2EuZy2m/
xw5L4Sh14xXWWHhCg2N5Qpe+YJY3GaH0hWHz+q0ytK+mEFcU4ZdzsqZsbGw9gHIm
unZbzRMHjtOoiYMB1sdIdxxPKFwm5oXipdLzvoPb5yyfLDKvhq4Sn0w1gMNvtBXQ
KZ071GlrNwkhQF66i5/RoZSn1lFDDlrrloso5fcgZoXHipcQEHbqPLHUT8F1K0Oj
QRYLEX9YGV+gAfIpYB5rdTQ7bl2MC3sgqYs5lCCo8frJfh/V9Uwbsg3O3W51PXFO
ZftxI6In+Ld7diK549MWG6O/iK9eJmQLFjtsHtmfFRjXqpMQFAkAr3XLnF6LjI1Z
fJ9GbTw2fNaunVkWr6AaLjBJLqhm087llLh9I/kTn4VRYWRB3OnfgbbQIUc+Fk26
182TSpjHyP5yV9Numi6a1dCd430s+15C/U6o09c5imoduWbKuIcIGc0q2SZPPk5N
RcqDk3YGnOgOSuheHe25X65qurpI/IvOg4K9jbXoL6Qp7/fNnDa8+7lY6kVXBZaf
eub/lvz37uUtQRBUaxkO5mxsS/QIfGEZTEGuQKYISt6g/5rcsyglsZaapkMAyYj/
jpj8b6OYzaoa8QRAakg8V+F10XJGVIRVf/Dt0uLPPSxCjbJ1ZJ+Q9qzrODE5t99r
9pJIOXSmc7pirIdkhhUEsRlK5mQiuAPjZzNXYyR+kjxdB+Qp7Fe1gXlDoyJfQrZB
Z8cf+bh2ihmYGdOoZGFquWy3iX+5s+DfRSO2RKW+ZU1xVQwQZZ0Ds5qTeo78pPJN
1U2sdWzZcQ4mhIUDDfSK2d6jxWU6PC+P29U080pgkvzuyE5yQoKlMfBg6eApByla
NfZEPqyljE9ArnPLH3vA3LLIvfETxOM/CaGb+U7ynWEX7bu+8J83BzrIq5D86opi
EmCg1hEWpinHODjuP+CKCAzA8j609qXxCqC+g2vL1otAFZkr0RUhMsR4Aq1nN2aS
7NQHLARRnvbnid68SAHUmlxdHVfhJzgBN0E/OwltGgSnbPJYymAO/LK/r4fClsNq
/zCTTOEOQPZRU+uP8k7d0xiiRxgOKt4TWUMGDReAVIU6R+ftTTmdoHDzg0BvK4/2
acu8/roWRCSFFhWoqdxkLJUYvem6XxNOP9z2qX+fom8gjW7opBBg8fgmb6wGyiNc

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
FV0ld1qDYwaIx+9o69D4ZL7Pt8ucwxmlv6j3mekOd+iutZn28PbuZonk4hX8ZKPW
VQnWxClrPxwpSHFY2VcsM01KSQm1OjKejyTSYbgwTrOF3QjhmO/JwvqS4gN4VJGD
hO0QhZIlOjtQ5rhYNwQL9Nx4p/yF82AwDiSrE6MKwb4=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=7568)
`pragma protect data_block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`pragma protect end_protected

endmodule
    
