//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module ptp_sync (
  input           i_pclk,
  input           i_prst,
  
  input  [47:0]   i_sec,
  input  [31:0]   i_nano_sec,
  
  input           i_sync_msg_vld,
  input           i_follow_up_msg_vld,
  input  [15:0]   i_flag,
  input  [47:0]   i_cf_ns,
  input  [79:0]   i_timestamp,
  input  [15:0]   i_seq_id,
  input  [15:0]   i_src_portid,
  input  [63:0]   i_src_clkid,

  output          o_dly_req,
  output [79:0]   o_sync_t1_ts,
  output [79:0]   o_sync_t2_ts,
  output [47:0]   o_sync_cf_ns,
  output          o_sync_ld
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
QrWgrBgcvWBlSSBdHRaLdk4lvw55Yh2LtybkJ0Qk66CrA1iL9ZYCt5Sx4ra2tFpx
FF2gaAbfyRIjnabEIM0SgWu1FfGv4lB9gMYKlf9NXbhEM14V7mIrEAfCxPuDRkB0
0PaPOVwvIh8cQqXv4au1VsGHmv1ll3OT+c/3gLcbUogy/ODR02Ya0nbdn9ie7Lx6
HJDDHXtfIcvGeVfkPxNPE4VTLL1dsJaC/0ayWfN3v5B6hxh825ao/OfPpSXYZ/5B
ENTQjcLfOBqLfgyAnkwxmH/kVwUm7kZFM8aJJSSVwPiJBtXeJRLvdulDIzgfYpSl
W6AVtYc5Wk1GwaYv0X/g4Q==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
Y1auqC8BR/SvnwIyS2Lv+vAPPV8ac5Yn5wTbA6h/HrzW4BhE55zA+G5F++3IAdoE
+dEUjtGllHBXX36ZbkOPqOq+wa5FETW1FkA/QeWfP9DDCxIzfp3l25GKJP8aSryE
rJydTkr1OYeWEJLuiXcfU3/seuLKbfl4A3jSKEfUh1c=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
AkyPKo3IIxihkmvcQvFPz6XqayJybM+D90jYMUEXuGZcwN4SLvxQa3KpyNxTbBDl
ho7emD6B8Fo7780wnx28HSi44ztuEGvkKh67SKfTNYhKGdX1S8a+/H5l8ITh7yGQ
nOp2xznCqV/sbsP/UcbSgbxJ5uJOze7tybeqU3Z0KA2cbY9bxjpVB0TS1z5Gvu2o
ULMJ8qWE2IMOZWHZ5/E4yL1CDhlac5htjhivCSdkr1WbZsxnmH0kVOdd5uvQOntK
kHbl4PdeBxyTxurz+wyNe1FTO4CxGlWH5a/W96dCgsYU8AOGhwbrFyby2ZM/uLtJ
sRAfQpOCmz/tq71szHNHCw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
PesV0tbWnarFZKmpKFyllIrEkvDF3ANlln1H2Bd8xVLjsL9CQnzqArEM3VeRumW2
bJnkc1Gkm4OznEkEAKhj9tX4C3sbnyrJYlEwl862tpizKh2tiJws2QyAbUwnbXgQ
mpu0kXQRWJ1f9bXUgiOTwwdqJgDr3pHMxNpT22ycdL2dNhOffTDfijYHfJBguUoc
q0RLoLbIARvHfhrPWE8y3CBbY/GcNMaNNczQuejiQsnyQ047CHT/rzmfuGLstt++
AdjbYa9IaBzQ2Ias+vexka2qukLtxT+ELe3msBhvabbzOa20i9aewj5NysogeBis
h3pfg76YyhBtgZCiT+EkBQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
toBX6uqJ7MM6Yci2V3W5QDLNUTddGHQz98LjVNVf8Tw7dD2c5De5EXVkhP7Zxim3
zInJt0d9+JFqOD0YVhjDeURNXRgN6tw5hBir9p8SBDj2eU3G1b5VGZQ/9fOsYkqK
7hcm+WPD+KVmN52ZeFOXAZaI8F0Z+p9bD2J61Np3NvnSRNJl2zVWuGMr5tIEXBic
H/6MlUzqr/n2o3mziwNIyEotUyNXQeuzvWHY+kc2Bm2yTPSyhp+ygrR8WSLhYZLv
5o/bO8iCgLFBc9e96/RYSMPiaUzM50PIf5lNRgGHoGY3WBnL2FwfKr9mfzm6RJUy
luyp/7yJDJGr4kB1TgloXw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
U9WQLiRmxtOwhCdugtX/c5DwwHaVLObVCCGwOdf5mLu3eBJsv/i2usEvtuiyUahu
u5o1+NHT9jHhMUoA/N11yp3rwClPgdQ/3Sfc3cKDxjK5bg845gYRYc+po1Z+1ikg
k0Oa27uzVIvIr49SpxYn3yXEWML2V3GZznHVbMYzhxaxHuX1M9/sJWaxCREMXlal
rmpTYLhU2e1LTHci8y14aPIlqk5RoNetjW6vG3xNYoHqEf/OxvyVI2odFiOCIho8
uGXhZJmBk15U5H/+03p0AWgNU6E3NAJBB/cHPAG8be3TiQ8+zZJ/Dy3pO83kBZLU
uK5DM4u2nGRCrTCzbEkutA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
sNt8BxUk4apZoPgYJLiNQBeWr7+okApq34o9pekBVjOQ4by9H2evBBkH4eVSQ3D9
Ux2VDiLDeqSNfev0dxJC/TryYJ4DCBwaQ1bcEHrSqjyLuc/QnR/Yfw5Vd7prYQlc
tMm8oLEpsxlCCsoWUIQjeYuNwoKT41vUJZimaVk0K+3fFUTtAsg3+YbHaqRixHTG
BZdO2CY2ba7MQ9T18uxm1Es3MSWa9RbcJW6iKR1c5wV6pZZAiQwQ3YCNlpwjE00t
gvibtqqKUVfqmiHK5YM4kpuaCquHV+f35MtZXUxlHiQho6380Hh0BrbJ/Pwqh0Qh
8coJRNU3Ym1iVHlwNrGsHPKu/YogjAS40Ur6MMoFto4GoWrW+Mc5ZtEGKcTUh12t
AMjb/XBRyAec+PtGZXQEAxc5VPXsphD5r3fW9JI58VFpNdLaRAHn30K3fjEB7DpW
POvy2YlwWt0crygoXyu0rH/aZE/QEQNNk3jOmjD9uhuRr1n0Ut7S2s3tRQa6jv9T
wtwz/EBMW2C+glPaJUQ98p7MOEEIjOr+zRgEFyRo3Wj8Lh6Yd7caLMyQgrac1Ru5
duo/eamZfrasQpuXn5Fb6s+devwcTStgqLmhMojj7DcEd675BZIhSBpP0L4fz62b
9QCWmGwSQ7U2UdunLULm8pisttUgs5up8z+/S9er3SN4UkJPKsxr4o5FV89cvE13
icwwHuQAl8hSfz1l+oQyRSQLEfevbNUgshSHfDULuFoB8rE7tVIkq6Xn3mriAApZ
mN2Ay5pl+17jBK8b41oVjebIp0bdUEgO3SMP56zy6eYIwx6Yy381rNdizGCXq0GW
WzIivLA8bggnmnQnhjGVzaPcrMCKvCZJvwHetanHbMwdNfMGlqlz7bSryuzivYN2
AHUCsghnkm5kNuDAk6uTb9F2t3auMp6xtKbt/JM00Cg9RQG9mxTTjDHFfngdvSq/
pjJgZavqUQc5miucDZBV+uquu+Qm266BPxjWBd8s8AcXiFsDv1JOR/MRW+rTn+OH
UWnUaKtmkqLp1DvU7HdNl7h/sH8WMIqIFKrw0VTFZyxocetyXxrH2RI3MlhoQ9/L
LGU2g75l27VbhGTJKO/eSBr26/Mj9rZ4eenh0WAETdrcKdMNzNRoEBsh7lVg5KuU
2r4PUAH0mayV94Qj3DgDMwZBfI5LbkR9cTKPbiecjXaLRx16piAUMbyr9aantwSM
EIOZOpIbVUDbJHY0vEuyl9LItEBMBCKVoCJE/5X14gsE/CBFHMtRWtK5sy3LtTzz

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
iruOJ8C3CZ/tB1QLrsp5yNgRc2/gK+TM/RF4yDAyim6niBlvS6pxqHc8ErejCNpn
z/56kTkKqKWNIbG7oi8utjGU8hcL6Lf1gpGVharheWpvRh0aRVwrtg+PE/4eqDG2
VdyrwQvjMeo4/xaP13j0530Xqg9iA2ajsZie83JNm9Y=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=2688)
`pragma protect data_block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`pragma protect end_protected

endmodule
