//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module ptp_parser #(
  parameter PTP_INGRESS_WIDTH = 64*8
)(
  input           i_clk,
  input           i_rst,
  
  input           i_is_gPTP,
  input  [ 7:0]   i_ptp_rx_data [PTP_INGRESS_WIDTH/8],
  input           i_ptp_rx_vld,
  input [$clog2(PTP_INGRESS_WIDTH/8):0] i_ptp_rx_byte_cnt,

  output          o_sync_msg_vld,
  output          o_follow_up_msg_vld,
  output          o_dly_resp_msg_vld,
  output          o_pdly_req_msg_vld,
  output          o_pdly_resp_msg_vld,
  output          o_pdly_resp_follow_up_msg_vld,

  output [15:0]   o_flag,
  output [47:0]   o_cf_ns,
  output [63:0]   o_src_clkid,
  output [15:0]   o_src_portid,
  output [15:0]   o_seq_id,
  output [79:0]   o_timestamp,
  output [63:0]   o_req_src_portidentity,
  output [15:0]   o_req_src_portid

);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
W+3ZZnDcJb/0NXjgCrlx2Gh81abvt3LBg5Zu3QYD/TK5FOFQVx6Eo51kkNQF3CIp
0fsY1zoO+kGd3RkN7r8NktMx1cR1i+yMO6xXhM6uE4tmlb3adMsZnpH45AKCCf2e
/7zCV/cieKnl/O6ZXk9M7A4rPnmnD2itOA7bgTtr7pi3ccwugv6DSvZw0oB3Wn1I
xI0h7/RUVARa8yMByS4/cs8zFrQUorGUjYSDsIHBm9LWKtP7hvteOJxT4af4IBZH
zA/Ku9a1ftaUy6kYMnbpbcUjfyr4Nm5SKv85WBsstzrLA/6mVVN0CKPzN8rxwOmk
y1niQ8CXR/JVMIye2fRTyg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
1sUzfuEhif2T2lqN2iGjvbcGJY6wbX/g/UAjzq65GWj8m8KYfNhWZyQFwQ9uXWts
xDeIl/+BpXMAcfUQQvEBtHjVe+POcEc7Vi25F285JM7pfWKRRNzAfpU079a3KC6K
DJKai4T5n7NSfRxdl1XUKo6bC91elJCp6cFwLfhvnWs=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
5eAWlWzVn7wBaFPxwED9ZFoHvtlVQXZdT1mE7pqE4a5XdBq1WzjWFPUO2uQMH2EO
ehX79HkpQ/ZsKeA5nbfa31XOfVY+iVM9VhnRx8/KaN+NcJ5cI61vxBgDfMnkH6pK
xH4zNIvtg8LwoIXn3X/ndLsRM18NhgQdsHsakfbOSBlqovgOfgpsm2ePehFtpmDl
F+Cju6IQ7Kl8Q4O+N+PlYSKEuPwYhbYf0kgrgB2ITX8GKqpgPyB5BB6KQ3dUj6eE
IYRUUha2Ldrd0rkOqtFrLYyyRSrLgPcKrC8N3N4AxVZPixFZgNxMCvM6XaksnW3s
K0+VF5MG4Er7dgzm+2rNXg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
iRsA6UbioUCNOHhPJYkHkK4R2r9JXtPqzCLnp/tkUX7w+vqUm643t0e7RtvZIyxs
fSNAEKiyIYujCOy7/MKAGIScN/7pjwzj7IjcjttYe0OVZbud7jwN5ujYpr6i5qtt
4A7b6MLgTVlx5Mqs9SQGvAN2/1z382bz1020MwFtbuNHQsaZBsJCYYLgCULJaW2W
7rzV5GV3i5gnE9bYxPlYwJcW86KU2I9qAh6CjGxBFNr3E7YTZ4iMYgJh2iTaIjZZ
o5wJROGtUv7GiqCaPawKqHJ6ycCtsCas/3G3LUl6UD39WGw/uOeTMl+Sd4Jla5kt
p5xsJUFG+xOlMR261FsJhA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
tjV6euI+XEvQ8ABxLIjOcrIanNVqJNzfJovyK7WqVXC7ErQfE8+X7Xlj9+ZcjRUn
vu0j5JKrsBbtL5tfrWX/RTa1bymgc/nYasc5jUmPU2B03bHDkLmsRczpWJ8pNIM5
EdBI5NrMbSMeiQyM+UApKNGxkjL0WuwOV7TjyyDKNZWKiUseyQq8CT400fSuGmhv
cd27VlN9ezKyOnirnuf2MuEfzJMvogeA/mfFmUyyEi01Qn6RdWD/Jd4Miq3Hks0z
idO4xqG371phi87C3pug83e1xQoquZocvCKl/b3ZWWLSHQ2o2PCD3pR1nz3QUnrd
i/yn9f2HoDv39K/jrYnAjg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
wRBjk1/b6yN3ev3TT5LlAvB4h9u/fChLa4yFBrL+KWVhjgwA9rdinJ0rtPImHHq1
UYggX6jKw8Rkf6OifR3HoGTY6sukPdCISVbIYhSf4nfblwu3u4XVryW9SlZtGcbK
DsKPNbq0YFCrRpVlWq4+LqMpxgZlH2/uwTwoofcakfP3I1HpnaoxCOx7e5Q72JbI
c1HMXt8A75jes3weZekYhY7wmxhUp2VULpIokQt7HbWqMIEJH/BPe/NvX66ynkq3
Ro5WN3L4/VYY60TPQHqI30Ql9wLMVvYPcxNJZ+a2/tcRjlskjO9L6E7MrrUV4n3K
mdyffYuX53OgZuOiNtj1zw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
wBrEvu6xu7EL140grl5zfK3XTBHoC6NzUyru5TMtfrdrJUXmgELOFQTEu2Luyuul
Pe6v5LTdyuFMOhL3xGGrWJqFXTHw/Odyb1qFWnVOAUZCjiSF5IWW4dwuqOYwsY3N
U0jHv912wuAueoixZVOBSs35nM55l9PjKKfKW1JM3t6Ng9LE9MIlvqafTuBCRrRC
3N2ms/wnlymA1dezpPJcXM5TT0S2Ds+ktK2B8CKx5fB64GEy90UggiKC5aSaRFIM
gZskvdEgT+orpqkcGnzGtJRRbe88vmfKqEglt4pOy8PTQdlThzT5ChC2uFdUrVIg
p6xgvtxDruoTtvTUMOxsWVBrSj+wedis5WTL+PkzbslqQa1qkHqrmRlJ6fp/okNJ
Wzkyh2QW/C1RfIT4F4qe9ekrQCY+HyiTlIqDFsB0uYkAKhF/3BV9bLCLoTNOHw4W
x9AbFSANWAaosrOxuA1BWI0BxWOSsFHZLy6v0oCDGHSexRfcPH8rGZ50tPvSZulp
u+Aqqrcqz13/6wCp58tTkxYAfFPHHSovA7et83y4OiFUWGSd5pr4xhFOvEDVahHA
T4gapgb14mccPfDt7Jr563rUayfNygLTheUwc3DLJsaOyzvVfUKXyIUQezsVeOHq
vIOMSdNwuImc29MYN84mSsF9xyP5UZPxB1XaZ4SJZhs3HArr7Q1736va4YgkYgPt
0CAbogj7fM1Iub01Rbq1kZhmtTSXh/N9bWfRUNfm5NTViQRY4dbo9ICXlLIQhZjR
+TtSMOG4r/AQyN+meCoKIsOKtHqLAmCXOjbnZ8jorgfGqgXhLxybEn+B6NcL5l2A
eo2ZSagyFLNfrhyRYc1KuDP2V8lop066/Zuv6TO+rhnrx7jeR763uoYfbYpbwOUG
j9lmqSywz18V93lQMmQ+4UY3nTt6SYb5lwBlZvqLfNyxcUfV/WrMsYQoXW9gv3cV
GjI+DEhom4nqF3EQR8yHGuv15VwcP1IRbhocwQIH+z6VDlNsR78rNHtt4+UG8o7j
qMtF6caDaQVFv+mT0FJnqgi3ZLJahxcG6NJyP214QAtpp6OQvKwNmWGYcCHzYKBX
MNmCybtk7939Su/CK+pRg/ZMtNp3v4Lu2MQf5KrRWkCXb4vKgFAUQLbOjkMUI55S
erAD0oOrrxa56LF3Xa30C1OPlEqV2iVq0dBRPpNawqe3O3XqkwsKM0bAMPl0OaQQ
CMxYV2aR+aQn1KlFaM16L5wiFOtfa7epwvqrlcL5KA6Neh28clW5n5vIbzOmYSud

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
mmj6CmZnjkU+jGaqEEZ6XyTSPGOw7jwqNAMe6tU1TtYEkIT6N1JZllvI2rji6FJw
tWx8Lr8aA+XWtGBWTKYsG/ryBQS5hoG8iVSKFi00ZRDjfjbmMAGHw1t1xnWTHwpw
DAKz5wiBwXEWFRCd7byVnSHg5BgeJWH1fbj6N2NVHjc=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=3872)
`pragma protect data_block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`pragma protect end_protected

endmodule
