//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module ptp_ingress 
  import axis_pkg::*;
#(
  parameter AXI_DWIDTH = 64,
  parameter KEEP_WIDTH = AXI_DWIDTH/8,
  parameter HIF_CLK_FREQ = 156250000,
  parameter PTP_CLK_FREQ = 100000000,
  parameter PTP_INGRESS_WIDTH = 64*8
)(
  input                           i_pclk,
  input                           i_prst,

  input                           i_hif_clk,
  input                           i_hif_rst,
  ///////////////////////////////////////////////////////////
  // AXIS 
  ///////////////////////////////////////////////////////////
  input  [AXI_DWIDTH-1:0]         i_axis_tdata,
  input  [KEEP_WIDTH-1:0]         i_axis_tkeep,
  input                           i_axis_tvalid,
  input                           i_axis_tuser,
  input                           i_axis_tlast,
  output                          o_axis_tready,

  output [                   7:0] o_ptp_ingress_data   [PTP_INGRESS_WIDTH/8],
  output                          o_ptp_ingress_vld,
  output [$clog2(PTP_INGRESS_WIDTH/8):0] o_ptp_ingress_byte_cnt

);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
w2xQwS7VjHyM3L1yNVzJGde7JoS3VH0GH7dJAkb6yrt24WoRdVbkiWJVimq5ALH+
3sRTcbvUNkiScmeBkOv3GVxNirqOdPb+y/Fej+AWpNgbMtJd4UxgCIRIaVI/KoRm
AGpvLlzBzKVSOGi1bfGPdyjkBb8HhxKOd5ZlIsskK3gXwwHWLnioZY7S5WF1owLt
7TUzQVsw3VAAnslfXrhwxhwp5+VbVrwba1FgLq72zVnK73BaJRoRGWqiZnHZVjf3
gHs6NbxZkcb3d0/lT4FgwTyN8cqbfVKBnWZQiUoiqIXrT+1FJyIOiVsCq58qafkq
BCrO7nzf6wqWHuaRFKR3eQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
g2fO1zISn/B49c7Y39g60x2+60UgO1JTCEljZl8SE1QvP2ZyRtPL9l54L152zf+X
7rOp/w4qQhNoxIOD+05BQ2mIMiFMmLbewTmmFUh4YbmRA7HgCpOQjruDgpqRpTMg
75fVVw9ptMkUvM4tSHevn6o2DLrCtzbz4F45yGYU7fw=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
66xEJbW0rN+r+TFma3+9cLMXXUcRV2cJ2zz1dhYUNVp9lyigSF8i1sST9u1KahQx
q2U8KeuXZ0NiUuqTwhTcDyeCins+P3ThFbDRG6zSRqClG5OglGkAuPBAvwiMUDkh
o8c80ImziGMhnL1P+kDj/rnVZFvHzp9Y2AMuLHJEFCVJWq88RHknE/jBFWe3+Nq/
ilH0Kbhgx1UeDh3LeO2SBFfNtOuP6G9kqwp/XeIbmv4pajzBd3omxVmcwI+f8KFG
6W68HEPFXVVGZgWAOYbTMWE1wLJJGo4t5ra5LCWA3U/l1XXYmln25RPTMAy2L0qn
Hb1SfQw3XCbzPo1dOJGc6g==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
Cxgj9EymmZKNIy5NhUz0zmgt3E51krLjGSRzQ5dXh+BmAFwwaMc4/qi3GpYhv251
tpq0lS7UtZaGlEbwikwLDHlDBbqaoX+MiC5XAn4l8vvbfTjccqvDgArwmYN4K37x
MXk4kYIhiaAedQtCclFJGMwP+IRSR8+W3khup/zaBaYAL0WM5uc9y2blmqX+7Np1
QwG6unVvJOtzgDf9KuUllGhTKiqCJ6lmj6VVUQo9/dnIlkw9IyH+h62YenXMrp8k
nddHcuQXcQ6HaIl/pTFxfulhbO3UgnX8c2Tx+H6QM2hOIkJvMWR7vDLwBgBbnOm8
bLE+4txhnOtLblF2cQUQOg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
EShzkh/FGyrQM81odlXCxM8IGBNbhBTMWcS1+MSK9pRy+Me/jDXHol3OqrsXRdXe
+0rmeJMy/6LIgetK3glp0TlaFZXFNjcQmy/fDg3nB1dBXnTVeTK/84k1qPPhaVBd
KRP5rKbrEmo7S3c6WoiXXIKEJeOnTBXErG1zTjERs/74unyLxN4Zr2AHlSvBOAux
zihKftPj10ycGmcRVnf7Nh6JSanfEZ/tSz52fDwOk3IjVrc+2X89mY7TQnuyKdGV
pyjWxo54okS26e9X8Co/RnjQhyXl1soZ6YrNVeUkuKjHxtJGJxL6ECR/5EwHATHy
BvUqq/bI8JZRhvhStGnIkw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
Uk0bIWeWXLoPLVg7Yl8Cg7BvSRp1pdiHbVZvjBfdT1g6ahY+LB7OGH4VrDTWE2s9
uv4LuljZA0/GpNeM0+ZMJQI7Xv4mDGYopW4dcuiSiHgANAbbsTQ/hp1iTpofgvM4
8DfJ1S2k6fkKqiSUA/YbMiRVPxI3M2o/DOwq9oGE8lPusHij7KS9CIUSRaRuiIMl
CFWnJekKytebJ034clSi7BJE6vXZr8Vq6I7QB1FTiWGPiBCrG3CMqbPBTUKIxvse
O1jWiFNzV5j1AfFg5cuc7FkY6Yirs2YizqZxeqXx6X9aIbCpYxhkkV8CF2cHoRRp
RdXn1ZMdtwRrnywMdo1Rpg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
o97JteA1Sy/yXETnSPG+/u1m35+B1tlUFQCXlG18xDaGtAvaE9E8EmCWfHJCPchW
Su68NytmxyI/lQniysLZanUnIhWimRggkfyZcnwW/xPrBVM+Q6ICv7duqeEd0k80
4eLiEDKy81630xnT3ZS54MR7klpHc4zzXmg005GSf92PW1jLpHS042r3jHsKMMKt
RwHoG1mnlUuCEAwcijDKili1xl5z1hJ8dkg8VGYOB/hw2+l+JFScrWxBv3hY92Ie
SHdceS6KafOPuNx7ZhJPqjf7+y+aqosFP9os6oARgnD4EBodoYHEma4XHZv/Hgs+
6ILF8AA4w82+hhATyErofwYWprxYaCrIr6cLWADGVcfGNzelNGU94Cp+LXjyJ4L6
EnXxlCuasmSpazY0dfQc0Q3TK8QTINk6yGM7szfTmNsFCbVllwGBjf76+jyDksuC
hyifg5tPNnsakSHvENTpTI5AbRmewMRIB2ZrMF1kA6IIRa7grAShg+ESHGtJR71i
Q7stGNSuflYyYYKGaneuliKmMh9p8GKX6COwsBym4AeLwhrmCIqQnVqD0AWkORbZ
PEhRMROwKkstYzm7CF65rBH3F4cFNXneewsrWDVllZ6UCTTqHlz1iSAKpSNdfQv2
a8jTZQUOw3xPPHdsNwUS+NDn5OtiKfkgnq1O09YNoUycIp0kScJEhAt6I3RzOuCz
QWuae2X71f7q38IJJIoTfr2x7WuWay+Cv7YTPxcl9pl7lPU5Kp+lnstdExgvO6N0
SiCtURhdT9P5WVMMMeE8rd4GJSuHYAdjJqpaznM3ohncECBoET0TOJYP3sL/qai+
XeoIDq9boc1SZndjxVF/t9zDA7jNtudnh1/DGeXZGYHIXYE5oNHBZndcje0Onxfk
yE3TurCyfoL0BbIcNL9CCtsk7ZOrO5ANofrbU7IBYSn49EVaeDDuCqK2Dd1ND/ZS
ecrGDmrBLo4pm4O8Ml5/KEM2Qm4QQjxE/uu/WTNYmSTA7VVOV6dv/dqP3QGKKX+6
HoOpbgonQZUFrvRAz1VykGFt0wGU8KvQEzVO0tI5RWOkDTtTAVo3YiCX0pRjQERP
Vrax2qkzCDvn5tt6brTUG0YwOAXn7iVmKTgiGNpydax1dU0ybh1GYaQ+ePNxv+sv
RmsLm+HxNeFwYZrSEgyCLImnnDDdWsb1QRJ1nbstHR2bmSZeiiX4h7Glp8MG2M3r
sUTwnwlrsDlYQUR0v0QVrajpMXeUn98hb0KZTleen3HVQo51ULFMXP9ZktdILKF2

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
VH7PbwzJ1k+DQTL3OR45Qb1HFO2iahFTNdWn4bh8piZf5AqnUmlpOlhXIIdLji5S
GjcLH5TL0cTU+eAf3siqIuvSM0VIQw5lS40cOU4umEscfBJ4c58IQ7W3u5bawBLW
pMB9ySyjpoB1lTmKXrP1Qxt4+YXUc5qak53imuOFKB8=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=6784)
`pragma protect data_block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`pragma protect end_protected

endmodule
