//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module ptp_egress 
#(
  parameter AXI_DWIDTH = 64,
  parameter NUM_HOST   = 2,
  parameter W_NUM_HOST = NUM_HOST>1 ? $clog2(NUM_HOST) : 1,
  parameter KEEP_WIDTH = AXI_DWIDTH/8,
  parameter PTP_EGRESS_WIDTH = 64*8 
)(
  input                          i_pclk,
  input                          i_prst,

  input [PTP_EGRESS_WIDTH-1:0]   i_ptp_egress_data,
  input                          i_ptp_egress_vld,
  input [$clog2(PTP_EGRESS_WIDTH/8)-1:0] i_ptp_egress_len,
  output                         o_ptp_egress_busy,

  ///////////////////////////////////////////////////////////
  // AXIS 
  ///////////////////////////////////////////////////////////
  input                          i_hif_clk,
  input                          i_hif_rst,

  output [AXI_DWIDTH-1:0]        o_axis_tdata,
  output [KEEP_WIDTH-1:0]        o_axis_tkeep,
  output                         o_axis_tvalid,
  output                         o_axis_tuser,
  output                         o_axis_tlast,
  input                          i_axis_tready
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
zxFZblxNQfdVCzPVzIyvgu5mfFVYfvzyt9P9gY65LIMLFsZxn0kR87ksr+oBEedZ
VnjralY4hkVdQqVlz8HN92V/YzQAE1178xSfZ1SkJ2Rx8MUZc69Dkq9J4LVzuCX6
kvnQVVbgBBOfcluJRHPplwJOI7C75LXPatqxhOcIXknSE+tFwb7C4qmGtByXCL0k
SoDOlvV3ggbZkpH2tzwagihij5t9dg6iw2RhT6B5NCmHDJvtQzDIVH2uMxpahOvT
7qah5HpyVWDF6m09XIbPxGJsf9EkAWGeBDVvFh6EPeWSuPmc0GIYbn+4FivY7rD5
L0hIaNCyjdBIhItb1BDGoA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
36ATOwwCrNTRXyYgqBl7XIlRbvCPZWspCeSWQ1bgU0N3Rom+jWDO1vLMsTnqR26G
xQbXDkJiVjdZLZi41so4Q+vQiFPTHAQexHUUp57os1EfrFpA7GIkf5S2VVorulaO
fbqLE1binJOJEmEANyIH822aiVwjb3d3EDb9nV1iLlQ=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
IZO0KdFYHzqcC1BsrG1XVDFr/RqnorQTqdwN8ju4Nnyu1welDKwwuMosKJTKTI34
lS1etMyYAYPz+CUY54qSqwnGB/3wcsCE5VOgU81gGJ2oCCLxwmN3z5+MlSNbYT2W
zASFwDDKLAClr1wD5T+3Rn4kc0pJXIVnZyODn3aaifrfZ+0ATvI8oXjI0aVutu6I
Z4iWkNKOlokSRS7iGHEBVok5wOi21cf6RU48NzDwweopaDnADpxvuopUi6RUiahP
+ShCRo8z3H1/Ncp+SZebpx3kp48MpakOQwgCh7dFjmdT4vm+XXshZEU4JT/CLslv
Z4guJGjehf8qFQK4ajbDxw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
UrMQcmo2Itb21zkT6reFBgf6qJRbJkkqbbn7rYFbT+Wb4v4OvSzw0BqYNRtxbqYZ
4yARlVbqhPTBo9yP8cVcSxQU9zyUJ4VnY+sQKGqkFh4mBjczPX0JS7uzqmu5IArx
OPsr9p9kNdR55ICYKhAxBronXbxwHaE73FeeMuJic4vdqSpKu2eufBoRPd7OwmDt
qI8BqCprVwSEBGGg1TVVdYDncSOpDTEtk1g33aKAt2cFGQDZ+i8YKvh3vptumf29
JwveFNOXXiubaqsKSxe/WTe5iXTlGuyv8LRS2PbdEf0cNIXlVKol9DFdWMlgJs0M
JaqxuxPMJRhNPuLivZYqBw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
kx1G+o8E3cnzgQxJO0sQ2+PInR7nAYKsBfjn5XCKnKVL3wC9DeZotZ4exqIY5cYN
GkAX0wRtyuMyh5wmusCMz+YcMlSZIZAi+Z4Eyt2SKGtyj4/3rewy3gxzfW4Veam1
F4JfwjPqQbBfz58aog13kuy8lh6Y4dy4FIoacoUWzm/OpuRoLoYazpbgV5rvg0K4
CGLlD45/qlTuF1Jnse+v/o3oW55WrVFTHH6U4OscKOMFq/cHST3U0/C5LoQg3ZPb
UER2zvPfHiqfNmgopy5oNF6sw515RFmoSHLcPIVc00W28lAhFO/45frsExmCKuLY
bDzKlO5gnDFY2CaQ9utJNQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
GdBOD/8s96r739fvHUD6m1wX8QACDt8mpbO7b53CHoGg6yq8/jScRCeyRTUflLNP
BhJQS1h0l/3FXPwCoc66tGs0++86cVTXQbrzM7FPlQlanA0ebNYJGZUBCtSRY7wJ
n3dGlq5ynvaOIhhn5A5jEXvAt68nM1VcHaPKxYjVQw61QFzG+exy79nXTxp9nbfT
qFFx8bXx+rGjMA41R3VfYMgF80UgZtagO2RFM62lOL54gTI8P3nBZI6xjeVgoSGd
C/X8cNYJL2pBtwNl87hqlZDdZuNOkTk4UaRwQ2evYdDwY3Ncow1xT7Kq7YeVlw8v
AZO9HiIfZnpvOFHXTwuq5g==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
r2Xx6diaM9LcGPUlBht0OSgVel8mGEQ4U9wAjQVh1z6tYHND2STTdqy4LTvucPdz
99dVqLwGqCROKXlyy728/ArKhHnusqT5oj86rFHpjpTFwIDJ17HUKwl+hK6c+YTx
uztkAQRbQ7rY6OBUVXW68CQYAQ1RqnFcTsR9wGzoQXYNTROncUhw6vFe9mCkYtmo
M3cyoCpngtkKjlWedySYy8dyJfJKGfAbVuO+1X0zXOA0ZiEl5nsG0BSCqVIF70CW
+vKa4UOGS0nySWNkbcbI+ae8an2kL3fklTa631Ur58rmyI+jeN4EZnfbbTaIx+b9
EY4FEB1GDHH3fBi7V80Isq7nErMButsdk+YzQI2/MdcYpQZA6JZDuuf2IfWdWzf+
cmksIshrzl/xx8uHvM4R4uSY0j1wMbRpR+TT+WhK8ZK5nxptv8ycpRzpgwfuna6U
iKlW2fPrPsfJF9wSwKXCsEE7MMUfvbNc8GLy8jvpIn7YycMOcBK+joukP8Jd1aC6
ujtGwxArUGMtf6L2U2iPgITTf2NuK4aGmuvm3V6IYrTqCRa5D0RtLvubqLaZMJ12
5JtlnhorhAETyTtK1JQyeBkNgpuaGw8nbR4sDHIVsfxLpRutwEXtpff22Ns3AGbG
iPRxo/XyyQzOuzYz8aRQ94QrwCLsCgjvpYAptM7K4KaVfE/QqjUaRWW1I6hfCLuz
4FcpIz7DbcmIOBG5JTXuZlz23IxzfmhLfIkEPti3LxnIFqD38/iagrUepI6SSCNN
wK582H6H/Flq/6UbVkwlbS9jgb3CWL6nYa4Xgh572/9gLSWE0sXrrfOhJAq7R5ui
YV3XrWJdT2/IF5K9xO1qsTF+GXUnTRRzK2owYH7DEPnB75s2n/zRAEWgQ9KH9ltk
2emX6uv0fToEqV6ShrIU4JmWlb/61H/Yfv5nlwUgcThhPsSSl4wGO3pHk5kTbZI6
+wZ0epqt4LBmWZe0+LXgvqFb7V+qNEhuI0W03s7EohipIVwUNpUGdyFbQsQryd+n
IO100QxSi9thUIrEj5kfSrKMXUobkEfsue1tlptZW4dPpYj73ttS9Ogu+Xf4VSQD
zWxsgCuOWeu6IIlss5vf09AQs+8mmhkZ7JKP/XKbYAHtxqaBN/tsiNFQNqODbYT+
9nSbRhAkwWJnNOLl4Pwg6KSxTi1LAo92Rn3OWiRTkRPJbAjRTWOtPduAwLLL4abN
aekFAWjRxpnJTcNgBv8CWLFBq72F53bblWc3CunuaBv0zWMqqslHU7VvWsKtEgR3

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
XLwCCxu1lYVcB+6gpBFtMusi+t4j+kHuvC954bU1QFu0MeWUTVxuqz+z06JJNmlf
hieoHDbVhpEe7JvvaNakw5iUwo6YwrG1k6WvsqpIpZ+BFfPreTTIF4eYZSyTEhuU
LoSd4Ws6x+Zp9Fq5u6Mww6aVu9gfbBJpAhnm4OIo0xc=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=3888)
`pragma protect data_block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`pragma protect end_protected

endmodule
