//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module ptp_calc #(
  parameter W_DLY = 32,
  parameter W_OFM = 32
)(
  input                     i_pclk,
  input                     i_prst,

  //Config
  input         [1:0]       i_cfg_avg_fact,
  input         [31:0]      i_cfg_dly_asymm,
  input         [W_DLY-1:0] i_ip_dly_asymm,
  input                     i_P2P,

  //Sync Timestamps
  input         [79:0]      i_sync_t1_ts,
  input         [79:0]      i_sync_t2_ts,
  input         [47:0]      i_sync_cf_ns,
  input                     i_sync_ld,
  //Offset Measurement
  output signed [W_OFM-1:0] o_ofm,
  output                    o_ofm_vld,

  //Delay Timestamps
  input         [79:0]      i_dly_t1_ts,
  input         [79:0]      i_dly_t2_ts,
  input         [79:0]      i_dly_t3_ts,
  input         [79:0]      i_dly_t4_ts,
  input         [47:0]      i_dly_cf_ns,
  input                     i_dly_ld,
  output        [W_DLY-1:0] o_mean_dly,
  output                    o_mean_dly_vld

);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
XMa04x0wUBlkSn8W93U2NabDsBcj2ayfZdWeiwKIkaoV5JFze3GmlEwX85fV5Glw
uf0uKptrOo6nIEtimikCwn838SYyi9tlZxH04ih+nHnJcWlvPZMtSXGfCdeK9wmf
sQvaDN4g5bEJydUtGKSgqpgcAALpWpam7LLpg/PqHuRJbAfpBY5k8x/JJZ8MbJc6
FpfboaECutxKSzT/DNtteLgidHaFg/PEF1v4G4WoJikRfVVgx8ZEmymHWQY/dx07
fEuMNF2GGiqADv2TB1zhSvdz7h/qVb1n4WC9gPGAjhmYwqx9YPPdYqPiA12QlKNW
DhllrsSkBk6UIJqVUwVVug==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
zDO5v5Jd2qrV6gAiHgihm5ipNDEzKpDVUwB1Ko0B7jJrd91Jv4ig3vYqGGwJB14W
wWeYWB9xwy+KF6zLUMXIc8/QLcb/5HRWIryBTliPDqGjbDzzcWQtnGJ8LhfZddZ1
7C2pPxY5Ogyny5iNFs1v/pyLhurWFTYpWMVuKzcqDTQ=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
Enw7JkDtcMAA/+1y9kjTvCque1a4yMuv5pX4QgrxxvOZ5KpItwnWglRYDmdp+cCL
wenmzzHYIEGEcyuVHVMy5vvN8KGAwaZGH2+y6fIns/RE+LebdKewJQQ6V8Fz0iST
M4Jumy6LW/Oh1NJjoL06WI4gB6BFWlRjuGNN1oGO/AFJdTonDC+MxXgJiapdRhgu
yPDoPxEQK4eUO2OJ3L26j06XQT4LsL4kFE6o9o0jIBhXgAU0GDJS/Ed9St61jIuj
eZHYRQD/eZTxCSHabRGiSV8XPAI0SDQAcjlwer5bLnX9YSMtTcDOP9LWZWX8Isb8
xZqPl969wPb7aWj1ygQorA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
Zpg5jj1fWCV0bfkbG6BpsfrOEQWcZ25bSdHMQSoO7pFtA7MraMd6TCXBnV7iFmDX
M9Jmiz+mJ1K+S9UvDxDAP8pvRoHJtLLMbtGuohcGZpnqC01qvFIpzsljPC3jdMKX
1ga6jGK1gP3ejsivbuooH/bYGLdcJVi4olFggove9FjtmAyu8Z6iMJ02HiQyJjRo
vp9dVqrdWiwTx85rSrGSeBv9Jfv3rPMFA30PPvahYF5bq5IaKHruVRSAoCxBfkFv
rY9Tn2rDHjGjol8s810Phqbh6UkvIa7gWrW88gV2QMJITtobTwExrZ2dSUsmQE1X
/BaDiXey0AMfygdk8z943g==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
YL9x+Zq6XJqQ40NUDzHQuU0pea0bmzXgKeZaDE2dlndNux37YqhXHXHaVn/t67uy
z1tdsI06O++gWU1a+Ae1JdzTlFv0gbaQgewBuj4PsW7U+4/CBnx2Dg4SCK6+Yp4F
mjWMiFwM0HzSXcYO/3cfNeANqcy7ts9vImCGG9n76FEfnHnqB0QmgIbYQCbxzmY4
8HrFwKIpdFaWNxbvez2YGNeR//KPSDwh5EsSSH5sqx9xGACGxdP52ORxtTnrD8td
vA6iQd5ZZm6zSyepS82jXDFvvEZl6yfx1gzyzoPh26q/cLfT2h2Nl6NSwy8ZsgC6
t6IevQGaIwIvwxOO8xuM8w==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
RgpD+s6B4mBsI2OljQdY3/zuv6UEBn4ia0wfDmgHObRfq6rILvRq9jwi5Z0foCBh
bIMkADqS0XHsspmR2pN6m0eUJjbcPhyl5y+9h3pUUtcbSZfM8DkNC1xERU1I4hBb
cOa5k8Bm3weyeXQYIn86ji7EXZwds8mIn+ctv3dii43YdmcqaeyDcd+AeQw5YAGd
KwW7j+TehMIiZTlz4R4EVb2Pp6vTMwBLVK1sSVjLT31//TUrPiwIf5GsbuoWP+Q0
ggctvL8ZG48M/kdVcG+iGZ0RPSm2fxu3A2OCRDs8ZV72s5nRMc4vdpxH7Xwllnez
a15StRepKuLSPEeNhG11MQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
P6xACNrZ7VpVtRLtokd54NUx15hbRl9ULczaBHs5g3lwhPiY8WuaOn4cN5oaOLkZ
Cnn6vF73mh495vqBhFBj51b4COhcwHrrZgBpxjhzxkU+MxJYoWLvFRxOXfh/mihI
W0bQowfuWVelBt2kCfm3Td3BEviFVMtHbUaXYeK6X5nzzSvikCWVL0ztU+3vgGiI
LYDWWWstWwkTiLjfTnpa8KQg+BqbFxWZFp7nedeGl40ZQXDSOt9zFjFaniSfkeK7
IbVraSiR/ZtewVqyO0DabZFfhkoFKtV6ewQKBij6LpS6RzTplwtlSJseU80XLCdV
9sf7p+lmq1VxnuRQwB+QhN94D1DxMlw5dpZF6ONHFZAnSy0eRCyGVO4/5naGOPy6
6/E1PUq4VaHZbAOrrGd6URieYLStYNl6ET4ruWACUxSr9Ml85IRY+PFcMfD1dk8K
Y22pPvuQJ9n48tMS+H9dfy7jH5WfPCU1xe+RTfOYxvUdlQPET2JhGUUyaz6h+K/A
+SX/n+hNSGxJExrWu4qEOaSpwou0Zr4477ZOk0me/Vy8raXtztV/A5gXWiMc4FRl
MvKLwELXOsrN+DGTJ3TqqK2/oM/sEVG2B+JushNshWq6oVMZrmxbpl+hhpBLHyxw
2RWSuGXsx8m+gqdM83lMkRjl8QtlKd1lvwjJyV/cLjhzV4ZZFjx23rwIeMxoDyyH
urtm9REQztsbnmHlOdJgAu9l6eCFIi4uaybZAKLdsPtjD851xy+LbqD5X4QgICK8
9NoeNWran/5Wke6Nw9SH/aUEuU/c5VDsBNaaipZvc0hfgTXZ7yRyQc6I0DE7t91X
ZscAw8OQlZxaGWBUNSTpgKtvpuAoeeUPkQar1MURh4r28BrW1iB2QDi12jdhwNWv
3Vg2XBpEZ8XWzGc3yzUCuhSkgL/OzDVLCz3kXi+HB/t7MK5AcMsaFLtpXPpwYeF+
R76l7UqkX9UPeHIAR62zwzLtsAbfXHQYfm2zMEkAjVaTQCIQj+iCMufh2TlRDANp
9Ha1xFNm0njP48AUn+E2vqDe8VbsUbbwEquNkmUpV9DXM8wvTVygNEZ2W3KGX3le
GFqB48zzsAdm/LpMUgJJJf0QDeCQlDl0w0W56K+BLwo7q4Spg9BbQFDT4MXpFir4
esgJOCOni0feaG1mon885pGIRi0ISs91yKmrtM1vtZmN9oJvq+QO26IsxXFkXftB
Kc6crs+VMZbd2xHd+T8OaBk1fF27tPH5a3629p11Nnk+J2fKNB6P/cTila9JjvVx

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
J51qIcRALWYAXZYBeLraum4+S3ydXs8omLij0Z5yECty/QLdt4sdO1dwG2JmcYnr
PFV70uixWKkEgPNLzf2Uwz+8Ca6nHsP6MbNJtx4JF8mHmNlO7pQpQoKtZSxRzbMZ
9Ssk/WpmarcAFERh9Vy0G4os94g4RM6hmFuaFd6HRaQ=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=7888)
`pragma protect data_block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`pragma protect end_protected

endmodule
