//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module dpll #(
  parameter W_FA    = 32  // constraint to 36 for efficient dsp utilization, for 100ppm clock, need 18b for ns
)(
  input              i_clk,
  input              i_rst,
  // Gain Configuration
  input              cfg_gain_1_en,
  input              cfg_gain_2_en,
  input  [31     :0] cfg_gain_1,
  input  [31     :0] cfg_gain_2,
  // Phase Detector Input
  input              i_pd_vld,
  input  [W_FA-1:0]  i_pd,
  // Phase Adjustment Output
  output             o_fa_vld,
  output [W_FA-1:0]  o_fa
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
G/Fu9YS4HTqoIBIbpO4UTK3AWwKC/xwV/Qh4463P6dHEuAIGMxZLQttm+B9yaULk
qe2YMe2XVt3+uEKIO5eDtwuNsZJ9s41M7ZzCUOR1a8CW6QRBG/YMwVBrFnFCRo3A
a8RIIV5D59Cq0KvsuUxi+5veXyz/mh0SRit71zxHWUkqCT0CGJ1t/PQr0LMh7aSz
Wki2Ja9+CS/1GjaUT5DZSHPgDYhYRpuzyHmXM5t8kJyDZJvh7EFeqgrGOiOVpTBF
4kFB+/g5Br+Z+U0tldn2XH19evNJevqAALxDSJrhrKRm9RJGz1rnEQqEi8lpLlh9
fXkIy7wD/cSpU+zJfZaaEQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
x4/MJCoTJEre1NHUqo0F2gUfQQHm7hpNI8DjXJ4XKW8Oe5yo3WwmyftwoVzCPYkq
WKr4oU9lgST9rlwp0xsEexj/sK82AOqBZpCjOXy91DPAz/dkHm/riTMoxn1X5gwD
t7q9tJVi6GXKQWJ/GutUqkfAZa4Bdql4duqjTLwcAig=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
cyyFynn0Q044M/S8vXckeP6vsWWqrhQwMwWzAvuRvAmsE7zkgN+ImfH1UbEWRCkH
ORmEh/MPCyFucD02pNIGqeJ+A00JcqefGXzEcED7byVPNHIaDgo5J7ULOef/dEbY
3UQ8yEetgb3jJa1tdWUN5uk26quosBpIhRbUlVgevBrKwk2S/xlqfQXm4bjShoHk
2S49fg0W5d5NyU+hP2n8Z+oO+hqyyBuif5NM+w+19jhlSvv5dpGQRAsU6L4mBGMF
gFmvUZs0gPl19PCI91MWn+ogAcoX1sv3q3+aU0SbyXGqgRx02q/b4erKm/njtoFm
7GtkHsCJB5mydsdN0sJixw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
P4HBfAZdBxq75lKBoPAQmxZZUhCb/DpGqUXN+q4Ke6MlGFYxTsyrp03ksoxPlT+D
VGlSrgxZ87Or7ETj0iW2KubNn4uJ3lXCGsvBZco6JRhauya4lA4Mmlmw/Qk4iAl1
I18DPkfIKFdRBI+7ODfO39bCrT7Lf/VDmpzEz3DsxCtTXqUR8m88QIb7iHkMmXSd
vcgNnGMq+fYC5M/3f/jOcLYvR94fCaYznvgFTpMCp5uRLjQl+jKgr0EwzkPdNo7Q
5BySgNo6uvbTlMWLoKQC/B+TAvBWryb/Lm4wTmMPMuRV5wtRqNWcTXr9l1GVNBRH
hqjKJZDZNpir7bzr8Tc9yA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
dsRlQQAgGdSEyYe0UPO7IhKWSsMfNHh7nBVwuwciSaEAMp8MHO49AFyjL9za9SEb
cFhqnOlGSIGeQ6Mfwbggew59oHhieDpdTbye6Ej1nQsItnRsLey4OMIYBTmGiGdP
+ao2ekVvwihzX5WZeZgdAzFoYclBFGQCe2/0WV9liEREVAQEFwijfhF3td2qcWSY
Un/HFWgX0F8zWjWmkZtb15GN3d97BFVEtr1X8pZGeDXP7eXvbntgAPHYcD2fUE0R
l+9iwcIqY6oVau+U/fx45na/5hOWyb6a0FNT641ysahtcBlaHj0JtbsRqRCCTMNi
evqPw8Fo78rIpb7oSJGgww==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
Lk4FF0/mz+IAc9LBWHfkyfaIXjj9bfODn2dwUm0s2603knLgZ9AtRxpwCOEtsQv/
AHRVkjWLTQKBEU2Yxz4M+S3dkO1EynFjHGyOQE2//fubqYfYc8yDlwzXXnLy8Rv6
uu5yp94YpiL/6LTa7oGrTnmyQBjCRCSBwhN7B9OrEuZNCwq0dQ5qWv5zlhjvWQ8v
r815wOqxQmY2fQEZQ3X3mhC+VRroHPpzurvYc/N1Wsfu2bvhUMzJuHZSNsRrcTS8
D2uBgVriFiz3fwCDqvzDyxOkzH6Qb7JgogoT5uOj+Jq0cZXylFKMfW2r12tZf0pK
uxZzax+2DQMiYg9bKKIbeQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
AVr7sif8S/B9AOnZB6JqdcnbajTBRAHk2A/bS3/aYSL8Z5J1u0CuwpLwtkvQ5VgK
+ov/YXBzukFI/M/0kT4VFSoNhe2nIhWhhciXoTRzOVKVWWNOF2WqfhvMJq7oJXWY
6eRT0cE/q1kzfv6WrG3xnRyJ0OE2qWMoJJSIBqi4duP/594cGcpyQKd4zqf6tq+K
GDVl8woFXwJ6xs5i30P8FU/0JLyXy8V4pjbn/Rss+HIJk12ejXN+T7Rr+neb3rb5
uqZGXRuPpEHOJ1zL04nB/dXnTmB7f9Ay3/gBGOH5tPcGCkc+r4BA9NyUWB5g01/3
NJkATFGnYjRUskPAbwl2hMEYPa00W67GqISkEDAMZcqoxoj0kzBWvqpzK3jjhRoF
qvG1V2IxGfQlHSWnGTLyBvJyjEEqfh8pUIrJV+AoKI40UJpFdz7sA+dk6uAEe9OB
Y2vnu1Lnm1/pR7u60Y/JJQeMw9IVU5x/BZmFp2XHWjCWHvRe5k9UTgp1mluqPrm3
AU1aO8Sg0vik6x+wI5sdTBawkgOnaBK2JiMGEx2NnqoMsNNbRxV1eDL+aG2D8ciT
s9kmuYlicnelaFmthgd/WHq1o4KgO2ZOQYbVKsRw5UJ4KDPR3h7a5UKZqi0xlDuS
l6acgkwSO8vEPXljhGym3bhuHB0/1ApZe1l3uqTU71D37yuq6xhiMgO5lccMdtjc
OcnHLG/ZqNCTcmIAE/SVYBb++dBJbVc5PS/3bSAtho2Oy6e8Q/RtsbIXfqStl6Zi
CgiZGu1RTTgfJZtvfml4uRFUQJ8DVK/fDX9kqm1po71yusiGWq3xuXAZjcPLKawn
19DyBoOZBriUcp3voS1d0KPOxYWLChyRLRBSAZwOfX9K/+acldaVsUu8F6RSEI0G
6Pkwt7p98vqeJNMa9g/vHA5bJr0Q00i5HpvK6NT1O7f/y25+ZLLsX1QMeOchfv9N
TPirCif5cX7GLgJEEUVANv9BtVmWaFkD6xZCc2ySACZ0jDOwgMCACsxbO0+CIn7c
zGJyud/eq4wUqXveVMi9+CxBh3RcXWEbuLLnSUAFPOTdiWVuMG5VMGqfPGFp1zAT
k0dowpyn57gTnwntXDBLro6YQ1h5HYZOEVp2dffD76/rEfo6FBvehN72jSlpFZX0
nHhRlhytkvZBgb2OjKQBdgV7JR5+AeHIB1V1R7oQH8/T3THbsU/lWhaVOCHTUik7
/ZAjzj7Y2MbXy46ujASh8Ab4C0Lpv+F1/9eZKmCu1x2wk6NkCuInbnD2aE6h25CE

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
JQ6qjWon7zBL2gRYejUZKFT9WfK5+M8RMT4vQeT1SnniDRG+3FoJkhnCyarxn91i
RkXu6F4JH8UjN35e7Zhm8sqrqtv1YBuxkHUZw0cTk0LSjes+PToSqdXcxnjx3jyu
QjCn6oViVXdvWtDp+lLwmQ4GQ5k+UYHq49JH9lpB2RA=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=2240)
`pragma protect data_block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`pragma protect end_protected

endmodule
