//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////



module virtual_port # (

    parameter VP_SIZE = 64,
    parameter DIN_WIDTH = 64,
    parameter DOUT_WIDTH = 64,
    
    parameter DSP_SHIFT = 1,
    parameter RESOLUTION = 2,
    parameter DYNAMIC_VP = 0,
    parameter CTRL_WIDTH = 1,
    parameter MTU        = 1500,
    localparam integer AE_FLAG  = (((MTU-'d79) / (DOUT_WIDTH/8))+1),
    localparam integer WR_VP_DEPTH = AE_FLAG*2,
    localparam integer RD_VP_DEPTH = AE_FLAG*2,
    localparam DOUT_KWIDTH = DOUT_WIDTH/8,
    localparam integer AF_FLAG  = (((WR_VP_DEPTH+1) / 8) * 7)
) (
  // Sensor
    input                           i_sclk,
    input                           i_srst,
  // Ethernet
    input                           i_pclk,
    input                           i_prst,
  // Data Input
    input  [DIN_WIDTH-1:0]          din,
    input                           din_valid,
    input                           din_tlast,
  // Configuration
    input  [CTRL_WIDTH-1:0]         ctrl,
    output                          is_empty,
    output                          almost_full,
  // Data Output
    output                          o_axis_tvalid,
    output                          o_axis_tlast,
    output  [DOUT_WIDTH-1:0]        o_axis_tdata,
    output  [DOUT_KWIDTH-1:0]       o_axis_tkeep,
    output                          o_axis_tuser,
    input                           i_axis_tready
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
I0Dr72Q6JzWdjUfnmIRcNAKOY5pTG6RdCoAyv3+9WExW97el4TfgLTjcJz0w81KR
O13KhOx3tELncfoPbAe0WJZTQJeIsmhRfCLaCdG/thCcE76OV8RGCW+AvS1P02Jd
AsrwbNDkXHI3NtXxEGV6tqFoSAcqrcUQsXssnVsdGvkdDybp7lOCwqYjyo8tGL+m
dNG3SPEt88JAS4rLSdZHSKbDnk2hqMxJcCVB8G46NTiaiwgq0Z7yhAq668YWBYwQ
d6Xna9bha2QdbvMe4k4kjuo6m/7R95urSSHe57pk1Rbm9VlBakVTsr0hhFH+iFQ3
kQHvLEu0CMKqPi+EoD7hzg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
R/t5yHr9J4O3eyxTPmAhQcIHG59hurqqLRaIBWBhCTm89kg5awOjTiS4qcz0UDQ3
rrzIahQnkD3Zs8Ij/2MJ2RzQCstGYb3qAhihPYjw6GkTHYgfuqUS7WO9XdLvIJPA
qBEhVRqsNqN1ta+Pf4vOjAEpCXtL4ZROMGd2IKIKpNc=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
wKxME83emm6jaFatWaXTqv5lOoXNYw9Ia3umRqRH5ZpByVmwqDfK33Mt7+8B93nc
E05M72kZ71DO5kKgc470q4s9sr0/TvS2pMCiEDws3K7/f9liQ60gSbRD0Dh50ZOV
hgAiYY2jItyVS1NMeTZduu8Th50IwlItnbxcmNMViMclmUeerybz1basGOs7solL
rdKl6uy+DvNlwEpkzMmvOhFtWFkUXwQIX9pY9q2x5Gdr9eUkzlGZ5EtWx8T/HSc9
DPgtcIRESFnwgTtJkfqLprdTOTJzEsXR/UikNnZ3pw7MowkMwddK5bjSoAbNU1dt
zKn0Ic39aPsCeNJPJPRtog==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
XstwKxsJ5rOjV8dnAc3GP6kaF2cNR2h+HZAF46BFZcxPFYctovfH11NjAEjMqIGg
Zw2TWiCcBqDpF2qZtYVP93NaX2dck/YjMAgtl9mohTVqa2n7xaIPqhH8l5pHYruI
Uey++nOKcUZdBdQs4jxdWFNzocPxOuRD7vTX1iECSoxWNbuBcuuMP0FTNadE61Vp
38fwEk4McotNooeSA7TQVQ8TbZTXPe3IYVFg6KJt2iLnbQpUSxsgEqQP6aOdegf3
fTdCswqSJviVtXPYEszWcaXgNfkuAKSPis/JTEZBxeJi4HDCrxkkvT/msKUb0f93
ib+ApQltR617Pbbg9+LQaA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
n40PUkjUk2Aw7YePdJ9UNlk1RrSoAdgpXZe90hCIK0UJSVGDnf0hyAzeCExCcr9K
pFTHyb1OYAafZvKCLZbTocySNcd7il20WmGEgSjD/suVhXHM6om6DjdGG3bwOmVb
3KhwNqlz1//jl+4zKmQEqyUoOME/wKPf4FpxYxqRyb8Y3ry3TBSewtR4UGOt5ivU
oPAsrOw4zKAGChX0p0dLaasRmIVq8RTL9mZWS+gK3cIBb9pnvWxiilh5qme+esGc
yhuHxJMRMOIHO67Edlghh7zszdg3bBjTpod/XYA2edYk4IUO8ghr0o8D4y69wsYY
eGN9onRvdXVz10g/jmwn4A==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
iOjzJIBRbOjbmcSP3OBp4qEYtX4RnkByyY0v9v6fWt1pftk/UvI5HMaNqZP4lVTa
lATvbEcPbFfYndYWoYFc9iPfe0DMMHPz4rnY1BKGPDQexzub2EfOQ722iaHAtAf8
uZZ1js3WbQyPetw4PR49aGQNVaStV2tqPha50X7fBUTysfzXMy0yo1ohKncsMJF5
46TfBTMnPcugOYwH8kYGAqy3XsuC+flogW6+rJOi8ycOEuaB0/pEK9/A4yFe8DHb
Yl/LgRKUbn1X3BKc8rxt5hLSHdqlHUXQg2ktwRJ6aOqs0zSQUQIdFUIbpDiYutvI
k7zrGmZCE4SFU4ACb1/pNQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
EPsYLejU5HtsqudEJpN3doimR7FE86C38EvcDKq0E3cg8E4BETZR9U+vdlC5eJ4b
D6kVVG1S9Fhr0mf0H/TseuTlOeUNEbkm9va/jwTVzNyi1BiKJRl4Mu8pNu5Fy3k4
Baaeag2ARzXBPW1QMdJQLYRKOMZAX4saeixX2tqT6RGvR1Iw7oeIsfC85qUndyN8
o0Zk9kazzQtFTvCEkfLyqlO+UVqoQ4nWBAtQxKuLeh7woeuZ0swjwg5Bes6aK44F
aRWtc+x2qRJ4I4jvS42NapiQ16LpcD7SUwLhKA0sKbY2rVfI0ajjYEcrPmPM8EAQ
4FjsVvkr/DQXz8m+h2bsMitGi4PVbw/OekKvKyg8gN732X1wqbOSWjDNE22nowdz
VCmNX3wA5hHV3gpsyDk7Cyyywdhlclfx1IUYhCSJL1PDtmF8oosO+NonqNzflTEc
deuWK4hvuJaZUrXTwWxcWXYKypYd8TGn1AdSCCrJVfGhy90/UC6xalbnjeWT+PWG
m51GUdDpli4nY2vk1vxZcL5bP531kcvnqiEXzSr2isEwJBozUnWzXXRnzxa3Ib6j
rp0PKfDaG/QVoODVGLC4aV3PVv/AlyYg9fZQJcTMV2NlYndeNWdfw96oNLBvXDCl
51AAItOm6Rs203ehvAt3C8EPQA7e1Nkafps2vWEyq3IvzWq+jfGjb5UKXjnkJx81
cMmD7lkZJrfF//S5CerZnIEB1mjEOXqDOQB0MC+4+E4IKCcJ2W6Y1uGrj7/MaGOh
iAIa3fHgzpavIznHQ+lueoli7m6B6TMe/zA1FD2FC3AW8YzvzWbq/f7L5MMXJuij
i5aD8rPjLoAmQPHClm695uaORMTyM/Xs+nTxyCBEFCn8EXY3iw3eAHdRrsFn7Eha
N/XV58XEW/c0R4txcuUjbCENl0t5CH5mHQW2vd4AyqGjT+rOcfGNKa38p+1fLqEp
95XrUwGumFH0W5BMZcjs228J/MP+C5tg2A33HsSL+kndnGLmzPn7B4o+YEks2v00
8tPQXkAhgSCUYFm0goegRXWQgB+XrUH6fdUugWMPdub2XHfzvO7yQkPJx3rpwvAE
JR7Inqb+ilOdxexf03Tg4Q/Ikn37BR8VPQJ8zJ9SIEDxLJ9a4+thGnAg2MSPF6jk
M9foRhhwoEpPwpo5fboOdp3zav3OWqjtXv5F+tTznj/qIyYwOONxFtKNdgOE8xeo
P3gXVY/qAEJ+YJksSgU1t4tAbJ8XHP7zbhWR0jbbI5FDlGID2IwFoOKD03AOmkpE

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
X+UU1KOZMgksYC4EhsgRoyDGTQw1TD5vjiuP2XyUWGb9sMC44+gGbx0NYqVRYOJ6
1UuSnCpixpcNvt8ZkhssCDpnyQ7FtwgI2s6VtdiTEK4lIStMpm/R9HGa8hzFGRCM
DrQU/tMeIHpkwm+VZvUFnyxj7QKlW1rNC0etkvUwgqg=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=7136)
`pragma protect data_block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`pragma protect end_protected

endmodule