//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module streaming_cdc #(
    parameter DATA_WIDTH = 64,
    parameter SRC_FREQ = 100000000,
    parameter DST_FREQ = 100000000
)(
    input       i_src_clk,
    input       i_dst_clk,
    input       i_src_rst,
    input       i_dst_rst,
    input  [DATA_WIDTH-1:0]     i_src_data,
    output [DATA_WIDTH-1:0]     o_dst_data,
    output                      o_dst_valid
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
k/zRnOzIU+WSC1qT4sE5Q6LXx5QMJdVlUDE/5UOLnOkBCts7SpY8oQGgD2GV/LZq
vvDkCJEFZliCdh0LUZ2ZPZ7DrEL10duFutppjyiKEBTb2Fi3xDN3HuZ6xXt9iSmd
dg2XBpoPuDl1XOHGEPDoeXw1df20WYSKgc2bB/LJk7Qkvu3+djrI9mg1R+/vPmPS
Cb7raTV56aSLNRduZt7hVey+Q4HFtvtJomZfOlCBg83lX9FGPr+ka9UlRxBti16M
s5VBLdZkrx/0+2L1KGNzXFaRv+HZBc9LdmT+nFNqTOuAI96Ofjn0lrrPhhaVpgoS
mnWKGmE55xgUvgnXYc8F+Q==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
qYheIFKDHTE+jJn+9ZW3hnMovhag/0iQOFT6L0faaqX4fiMmOUDoEvLjDXTkobRT
+G5ZrsElxVRmDivpFdL/Fvf01egDORh0qJ5isDnRB/Dcs15rcSA8LcEsHOxd7eBu
N888P5qBbrOTYuCxoRqOEI4zUWRmpJSj4njINPnEUSw=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
2MxmL1LNv46gO4/gu5gCaZ6vIkSSorg2NfeT1d+GbNUo0tApRxm5uyUhTlIKd6u3
BI/xEY9YL8XZKWkeMnpOxWtEKb3N0ydHQKF8BLxSIwezF1xITUYQZ8muTuTe5xrP
fHnDKgunqVANiF+Tg81eJhP8wtU4k22tiTUZf8ToWlOo2quvbXvB5nmsNc42sGDA
lHQ8KAn9NQhqPzxVs1N3n3mx/BhtnEupLoSfgN5vEKCueyKrmBhVsdaMZ3yCklHM
xVPfYbiSAcBFG/HEYaY2CEdFOKcUvz2ajip4J9zD3JWfWK0qFOif5N2sH7xJfATI
ksA3VxG17XcQ1ZtjAhEUug==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
UEKebfnL8xiDj9ubT/N6sOpZutxQ592XzFIyhkOxTqvelZefiyMHFnBEmSNa9oGs
pbWT7ZJWtVocIVYHocNEcwLgVH7Fiekm/XRO+J4D/+JghNW6aslhW5iwehU0f+Uh
n9JrCgzDu/GAL/Fy7o5oncjL42RHiptljccWoMp5pr3AmHAUYOq1QDCzbUcNwEeT
J5DMLfiozuKv9305hydimyjy+605aanZF+i5Jve8BehNlrYb7gJDeNcozW+ShDLn
7oGmsqkkg9b/Ix8JbIh/uAEeeG+sZowb39N/dFwUhQdPbGSib3eSgUH4XG06g/n0
cDGOj+g3eUkw8r+X0E5M2w==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
MV5EDnA9RlkPXYnzB95uh7XXN/1hI1pG9/ChVAzSeIm1GAnNqVS4hXszKbWZVaVD
55Dw8nfXx7yKyhAw7Ey02gTTt/purkzyWKuJ5vJXwqiYc2YSuiefR8wKL3QeByGQ
Y+1uNR6RP0KGbEICMSbpk9tMCCxsPlBY/uJSf6uqpfbmtkVB5On13VZX1q30QWqq
syZy5WN4dKRfTXndiC8OX2tmpWQ5Wi9qistUL1mtg5lgLhShiOFuLyPmgJCh3zpT
KJ9jCD6umm23m4jGuIM9aY4Bkq7cZbFfKvptNUtFahc33fcXcqYCtOi9UcNkfC3v
TMy93FjWpik8oZ4Bc36iwA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
eTAcME+axNyVHFNNlceJuiZ5M0xZrgY4QOxrDY0Kw3AWNN3NnD3opPsDfKd3sm5B
BM/mQ/SCpr8Q4jHacGo6rDJ3YIrL+MwYdpzNPTvYV9u+1tgiYhdg2gJHjEbwFAci
utF0RFoI0TcP2Pa6/a0awV27h2JKqClOvq+hALl6roHIR5JVlIDqfa5Xhd/KsAHG
MVzQrNOtoTfN6GQoH3nGWrnsJKW/FOLLiJzgSMa5MCe6+KiaMwyIykOrtelvIbQl
Lsm/n1hcrIE7qgxpdkxl47C/yOt8hU+wov/m+NZ+5BzRXZUX4+EsU0pEzyin0tyl
lb4YhieRqt1UQBjjJDqWaA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
JN+TKP1s0gXX14jr4+uV/egVPvvtAcMYIavzT2uJCzMODdzWGmHAFMcoBoaVKJpM
RXRqlLiDISyLQTlZd6C52aAo6zlTYz/0cwvwxr/4TIPLessE9xeW8k1sft41fxMA
GcejoQSInABaR16wxUSm9f3uuYyMMk6cOS+nkvhzUmxO8mTzw84mKXzyn3k1FjaZ
Obeyh2rkQuLVYy7pJ2KOhVfZfhHZVE672j3td57HhUzKr7Qpc8BYCYFDKpeD/ORB
+SLd1A/i1eEyqLT3Xi9YpDylXAwJeF9HdaClJVa04McA+HLvo/n66HwcID0tsZ4H
22I73bQ9xPV84wfCtXM+92zrDz8LZZq1eOtjsU8ie2CF13bc//gwogD6Py/Mzw/9
gZ3yv3JAQ4ODRJPOfXh4em4OpCCvsQobVUDjR9OciBMZ2WPamNiYEKfkQz4B1RKm
XcFAbL/9GqkeGyWWjJ/Z11KftuPnBuUalmDa/pd0jh7Ez+ePhTUPH1bfGevRWqfM
SNHwN9nf+imnhYMSr96FOHVJNdxW0Y6wM7HZsQT2VZ/n+k0HBW9CvIlXopIU8Ccx
R+ltYrtM1hJXSyYNP49zt4/Nr4GOds21ttv+6hg+nuLl0jvGexTfhP0y+/ljr9Xt
f9WKWVNLwrGYM+nymUu3+oagHFfPbU4xgcf1MVutreNk/6v9P0r8O4mULJQIRo5i
2Lf5/6VP3yL79b4HBHesKDixS7uYCRgzwNCkwxer7oODBjVQt1EabA4J1UwgMZg2
gAV/H2LTG2iIDloIC8L6+/wzc9bHoui1g2jGySPIksqDkIskBdP8EpMPjOBGjacl
8Kzi5tFwXabwF9ff/OLbdCNKBg0WC/r4hI9dRJ2nIIB75ddkiyBVud28xvRaLfA0
lHXP2op7M+S+v+s6iXtD0Mb9jh0qJ9Di5ys8qzBCMHwObRJmWF0TSZ77hKHhpML6
yExbYTmXJJWwOntvNrU92mgPhEQxFmmTCE0FuhGWjv+qfQI7y46Q8Pwbrn0rwzTa
MMghyauyYoOo2mUSXBSeodx1GOvPyh5rNQoMdhC2S5cglTj9yaa13PRjpPYXjAZD
M2Od81/67150+ovMhrlHp9OitItGgM287CYlwlEzCR8+Tf3ZI9C2zQw3Rj+HJA2D
7UOOEAeJJ0JbRvpORZVV1lDz4QH+QVFypb7bWjDySNhL9T3g7irrJYxCsuKj/kxR
+mzy6Zhg4XFB0fI7c3pDfXx4oeJFy8VLFLoSI+Hg63IMnYqib3uws8nWqZsLg4vy

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
ofjfmXknXcT7mmBSxwefqtuqVBeqgkGpz3C1qowXOsJ6mVKyJ7DoPP1Kp1rDI96O
zvVNjXXXCY+6+84BjFwWs+wMra3+m5fJXqbkKBz1akrnTZMPnfmGK9gtzYJgC857
LJ31mR6W0AAxqDIqKpvPk3Jo8bdkKgOjAND/Z0ogfuw=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=3584)
`pragma protect data_block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`pragma protect end_protected

endmodule







