//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module str_fwd_fifo #(
    parameter           WIDTH   =   512         ,
    parameter           DEPTH   =  1024         ,
    parameter           AFULL   = DEPTH-4       ,
    localparam          MAX_BIT = WIDTH - 1     ,
    localparam          NBITS   = $clog2(DEPTH) ,
    localparam          MBIT    = NBITS -1
)(
    input               clk         ,
    input               rst         ,
    input  [MAX_BIT:0]  wr_data     ,
    input               wrreq       ,
    input               wr_commit   ,
    input               wr_reject   ,
    input               rdreq       ,
    output reg          afull       ,
    output              empty       ,
    output              full        ,
    output              rd_rdy      ,
    output [MAX_BIT:0]  rd_data     //,
  //output       [9:0]  usedw

);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
NQCeWCPLCJEpGnf3qrx6a4ElFAUdjA0NKFSdWf0uax9rZ3dDK1Azq2tPXd7jRWoc
wa+L7HQH6eTTErAZjMq3KHb63WHig8UyP/ixRd49MQAt3MdZUROKUsqfTj5pS2bY
jcnVQ3KC3CL2LwCh73yjUaKnJXTQTKzfP0MiJgmEJeRbw2B2RXfLnNRdX9HgYvUP
fq1nd6QYP/faejGRf0rs7XuxKqKEp+07D+J6VEwqsRFuxGOyhEvsflk7HpCAhOtd
peKJIOnAxW1ou3DfqiplR9+/BwNlSZgpVOwTqMS/IAPnxzAfpxxFnO5NM5vpeGaV
xMiHegJ2PS3iLqJikroQ8w==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
qnbUVhbATN74/s01ilPHTRbMS45AaP2PnWKmYUGyi+BEId70PO54FG3flBJvQWOR
q4KSQ6cynai6e49ZfZZYybvaZrCeiUP119WPt0UQvDGUra9GmqodoeczLz28YUrU
Enac9apiKQ2w4CM9AoN9nUh4RNk6/IWjXvmDtLLGh0o=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
SW6CWasU1jS6MwhSW7r11Hb8/jsO96Tj6MWK7JfFRpdk7y4N7tFIfCd8ADgbUDua
zDvzfr3NL4CMJXIWtAlauBvNsoYUOh4ptTgM2GHQQHgVJrPOPdZQALbYLdaR6Ltg
/f+t+J5X6+Uwn5easOaT+nJB8kIvcDvqzWpdsfWKBY2kd0XGLUvg6KuJJJljRG3X
ks1B2L9wS5uj/L3lR88jFDNXjUZCVM7iv2m0W2kWreFSpgBE3gsu4YXwxSzU+XIP
YD87RkZudm32KlO8LKiVbb44YwzANfMlU+c2Iu+pHQ+gpfsxGQD79uKwwitajLye
qHNWt3diyZLZXvmBXri6qw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
ZwW+DaUI3mNWXhmsuzFqOwIR5DHx6OrfrTWObDjLUqBX+/btyN29W3znfHHWRGB9
X9v5L5xpfWSSny6BMkd60X5GaH41hGCMJNnOlouTrN3yBt0EjoetK7Yr23fGLAua
y0WEacvHB2oAjYduhFq0zXNnmLBrcSy85VfHON7SgwRUWk91RhbhRK+4ixw1PdtL
m3ZN9TYAvrYhO16Wz8I4zLKnqc0oWsUbZm3g0dshM3becH7nXLj78NfOqtlCE5QY
jLGVcQvl7VnphzzK2FHFAMbcw8WWm6nnxlODTzJ7zejUUmjuGWpbdXuM0p//LENL
ya3+3HNxD4JPeNPz8OScRg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
23wBRly2YugGfUBx1GHOU/Cd3xcSOSIKner0Awx40lzBiLKy3rUb8g6WYM0uzspi
AYsidLZWJh507Tl3eBrIYphm75wgDLbpKLR80ex1mJihRSYsdM6c/2tKQtDlbzIR
bf5yyAkrn6BLiHaxSd77k8RUQ9bMe6FNS22LoYosf4wlfEqBRRYJjP6bavGLtX2d
Q0LZPfpsfOumRT3ivJ9nW4KlkjM9Ge71XHSUAluhVb0QtQP+AJA1q5xRBR/ruQjT
FUuHNtVNwilPxs7az2OIPR7+SIGEAixAHhmF5xXGO6t7FFJLa/TuDP9ycNkCYikQ
GuEIfZfT19SsUELroeupSw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
ki6iiHTNB2h8K+3qfeWbgnkdclTM+YK4/64axhZVQSEXBtdoPILLiUL7tTJVPQCD
r0YD7+RytJwi/M1up8qfoTy4Y0S2XpiXwCOVmMyFqx4cO3Fp4zHkIjECYF3waktP
YIs+rqOH1CKPoQH3K3ON2R4OpS3JSbOsJY/mAi1C+29bdKIQ5rhGSI7lBCC9jE4A
09x0qXVxxbfaEIxxhn61yGvPbjZhUvXpPCH1C8ZhFSeMahxKVDEybRkkOyeR/ESk
mI3sGEUpmkYMWkEo97MXAhoO+z+MB03RltU6FFgjlWeua/kcwwaghefxlKIClEuO
T63pwIy6Aadq6a9cZ+6HcQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
DT2X3WPS4GRdm+z8dpySE57TQi1sw0vPY429S886HPrk9OYa7DSnLOTAUK+Eg/rL
3CqTKW2G/lDrdRRVkNqdDPDVJ9erguV8RbhpoFH3A9tTh8WjkQnaYjuX++ku/IsF
ybPptXp0JXjf+xV//d4lyc7mnF3Y/S7gRPwkJ/iIwwnLCU6ltXtq1lelFBxwRGIl
e+f/0UVJHi8OwqoDeI95WqFvMUGjtfVBQ2bJNLyJNLoi4CozHye6ayASbQV+E5Np
vBdehcm1xt4TxBaTKT68gsU5rLtD/A6KMdXtxXJcv+gJp8t89YVewgZZqGRz1XE4
IkNIV/XXom4WrkUaBrCVw9AoIlJcGnxrnZwitOn28OytUEFFjI9TYzOsXJ9Y/3AR
obeK4GabNWIwSuxBugb3bvtVRie0AXY/fmFxWR+EEKLbjZRqMcuAAi9Ki53baRhQ
y0qBIOGGzixpOlJ9p01X2ODStCWJHVd1mUSUz7ClZaNDgsyKcuO6K+TlQItCJO/u
9rarjVALNJ3m6J0GfCtvCxMe7qoQlVxGLI9UlIxh19axg4pswaox+klu9YlvwlJx
aUTW/HLNMWqetgBTXX9z2B4XsPe4rAwUAuOCWNpZgIxCTAKEcu0D1pVBE69oEhKc
aGKNwmPEC5GZ/aMomIs3DCxOEIapk8sdZu4qMc6TaDt195TrQsnYd55cO/0IzydV
MJuKqHHus+hYdVOUZ+zTYyKVi/fL1PV78X0UkvCjCfWA6dz847abng69siTANazc
vdnys3rH08fMTKgXNX+yCVEFUk8MrllGAle771OgWAlJH48Ox38GWiES5O+Ok72A
GIxkJr5OnJcQ8SsBraJ+sfUQmvMbpNXJrAukhZBTgAn4j8icMDSQ+CYarE3CuboV
HfvKZ+uQSaTCFrGUzKaXuj7JxIQCkM4nCIhsfonZ1ZIbT7KFES7lZoW6TPT1CL/H
7Soz8sy0zQaQQbiipJcSULNefz5s+EXfV4oiyETvDgg4znNaDKbU4ntMppFovY+9
2I4vPzEGWJrPAqb/F3V8iaH5DbD0PhLn55D+rTBCdsltVyvWi+Mrz/3ajCPoXPMi
sW1S66lY3mqBLxVWHusANkMpeWrlRT/9EQKCueXe3b2QK5klhW8/yTCEOfhjZP0L
PjwVZzR+fsAgvJrw2Gxd1hCX15wI6HAs8RabRb0U+q3Kc3Xv6kjUu7RCeouhJFvy
Q6LOpznfEFNKe46t0MzucSsuF0CLO637O3H3UZqTDsQIaNBGyyEZlP+i1IDEeX1z

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
FIWfTysED6xU6SArxeG5Bj3xrMVHGXFyk0IAceSfj3r4esCH/dzFOp2uAHAc4UFH
fZNsoTFcN1/P4mEWlGXRRHUihNSVgZnI76s8xMlibG/G8px+iV4SU6LC2DNkyALt
Pj1pceY4VVq94srlG+ctPYshVPUp5tWOpkxH9fr2PMI=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=2080)
`pragma protect data_block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`pragma protect end_protected

endmodule


