//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////



module sc_fifo #(
  parameter DATA_WIDTH   = 16,
  parameter FIFO_DEPTH   = 512,
  localparam ADDR_WIDTH  = ($clog2(FIFO_DEPTH))+1,
  parameter ALMOST_FULL  = FIFO_DEPTH-4,
  parameter ALMOST_EMPTY = 4,
  parameter SYNC_DEPTH   = 2,
  parameter RST_SYNC     = "TRUE", // "TRUE"|"FALSE"
  parameter RAM_STYLE    = "BLOCK" // "LUT"|"BLOCK"
)(
  input                       clk,
  input                       rst,
  input                       wr,
  input      [DATA_WIDTH-1:0] din,
  output reg                  full,
  output reg                  afull,
  output                      over,
  input                       rd,
  output reg [DATA_WIDTH-1:0] dout,
  output reg                  dval,
  output reg                  empty,
  output reg                  aempty,
  output                      under,
  output reg [ADDR_WIDTH-1:0] count
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
BtclLg5qKA+jUxe0OhRz+LzRISBYtb+K08XhDaVOa5vGZfgn9962o6ydE8CLVTIr
0/y9AiKvKMYx+orNKOwmjW1N4uGqlf0saSyvzIa7GsFe9J3h3zyZxFXdh5nbSHgC
tjDIpmfLWxI93BjK9ttwSkEImPuWGqMDARUXv8VNMoRN0etnjw71xnP7/5fHSt23
bqCgE9M9VPLVCH6O0hqHMppj8FJ6/q3fe0LSAVmJztUSTyANGp33JHzFmnXYwb5v
iotLvIKMWYAXmDhIawqAV61Kgsc5RZA6NlFMQWno87bTrQKKKBZCREnXl9NsCi55
KIEK7JHbrGQ5mMEuTzdl7w==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
3L46sSSG3/bLyyevBYEUKH6G0b/BMtJCbralrfgGoqv/YQpA9jzgWD6oj9IAaI2+
Kw9i4iychZWw/VwVWGqJEHSkW3PM5tGs1U6Ao2DCbCnEagR/aT1YWMeGM6EJghxz
D7dZzQCfbrpKbD0+Uc3a3XpaK9FeB6TxHAjXMMBbWE0=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
A2JQRx/xwu1leIJ/eWSC61pjm/570Gd1jswgidNbxJnCvU+RRzBzmDS+K7/ElM8b
Lt2GGWAVepEyaX57nFhV89GlVtgHYrjjqHegzug4bXppTOTLzLTrqBw3NvFMtlMV
LmUlbkA0ZAMtlS/GHkoaCTzK27ix0/eA0n2HFvDUV4xt1tmqFbO08MdoicyTj5mL
NRo/cgVKcrC3HMPw/NPfX9ESuANdpM72yH5RflqqByytFikUQzM1DM3BGkysFj6w
I7cgbBuJhjerD/Vw56yGj5Eu4YSoHmWSNXR4pFCtdzKW3nJpOhkdjlIATkKBAztb
+xOpufsb7UpI4Nu17f6QOw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
VaRJtVHUcISwPGC8ivnUHEvEVzfB9TzL66P9DTaRXyyUY97rw5EyEoUf+tbH6Z/c
VFQH3LwXATQm/LxbO8u5OHHtLehUEFPVvQApwT2ZtXYa6mCFG7wrtjVnYT592L2E
4+KHacChkm5BZVJwPEueEiJIosCo6pf/d8adoJ6U+VjMemaITYgOrfJ0zWi8aCJv
+XLUsJlactLTkthcqYfKHAt3RWXMqPqpp8glBDRJWfEus+0oUZiNntSSV78VJHFO
PaIkgugg99vSZKLsR2/TT02VoMWzQrdW7Fgb+KfPBrst1czisNSPKKttdRc909BV
I3ndFoQZE6vvcE5El64zaw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
UDHz5Veho4uOoJo4ugieA92uUJXVme7Ye/HUm/JCnXu4D9vkD91cfdKEDUWYBVjQ
BboiR7MRmSxdeLFadl2V3NfmhyovJmjo+rrc9mOM36N6bfg7OFzC5vuIdHlOSB7O
JzHu8MVkEOlVQeylFe3gpdyjEh3AgPLfa6gTnnzUIsfKGA9KJtDNGOtbH524+rDS
WTONomzIfTxNUQJ7uwVMhm9qYNPK94ZZfBmrECxwL15ap3HC1jkL2fdToYVTNj12
ec7t9aJ0ZRjpwJOGLJsk40hygAqSL1D+MCU5BcxPm1fHnsGrbZvNoppsqvQFYorD
a87qh5W9z0bIk2ZWTsrxTg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
rKyRYDfQdaGpVbIrpyvMtPxEthN+XMCdG5uIb8cJgS/Mz5hyZG0Dm/B+q9e7fKAk
cwVJc4OLM3jS7I/NwM0BH4B2/Jw2VMimeT0lyBuVOnn0rSg6X8DGMMQ5fgowhv+C
6dT6SG2R7+uZWyZ1WQefIkud/7a5TxXkpy3n7lCqB7+CKjTNWmRAH7OQuxNE2RcL
nHnv1lLTxza4k5a8HM+FHO6B9WRmt12/8/TT8NpbW0VsVfevoqJre4NbIoEoz/P2
doHp0ce/43wdpiC/csBuaMoPSQda2E++jotZyhq2CDgAaN15W1BxQrf2dzDNnWvZ
mBDIi5ecc61mKWA5lQUlfw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
AFZHHE3b1pM+1g7MVxSkT2AVwwNVxC1Z3kSWNol398ETTm8qpCykYqllfQSCsUpr
km7BFNpwYtjcmJIw83aKgXd4w9Q9LBCGXwR6S6KK4ICdRJg6KVIrc2X3XduWU7g8
NFeL/VcfcjIYjLZLHeCa2IrooJwYkBsEkZzBmXu3bp3Awybu2zCyxB208ESNscg8
BoOfBY2+eBlOiufv7ZbvdrHdufiuqIWUy2MGUC8jeNRxClbuSYq94gdNI7eq/Rfj
g3aXEWuSKY4Mc1tXo/9HxKVW5jZZ3eUoqapEIs+TVswmTYG+jNMADG7i3YQ8HOKj
nR1QT18GC8FDQ4RV8qhEj5ULS+sKB3aPuAO4A7LxZPWiDgATYPTW7HDp0YYUgoLd
mXFwCAVJLo5ibduW1fjICRC9SWjQvfICJxUdufn2Zzc9janFYqaiUEJWagiQ3JEb
DQwKPusqzigV17k1iqpftd23klpMEIQLIMrMEeQc4XSesYIDpgsSVs+vmEYAfjVT
ZXzdAkjlgoueW9i4cofbFTfbONkldTjhrnvyLr3qYBA4rvg1mMJstbZ8C2AcK+W/
f7wzos8KecfjHBdXguLy1TpkuHNBw93zDKwhmJaUKeIRE8ucm+c5lc88/Jj4LV1w
H+qt2JoAMoQqHeIdHVeY8QTh9RRE5sw9mE3xWKVTJNhzuujf2pDCo+aiS4sJYRZk
lOoC/FZWPUcnQfY42b9QJo1o5g/Nzk2E7O0ey10YL01MIGki+V5+Q2As2NwyBLKr
3Ak/t9JR3vbd0mfnkc1h3BTSdkDgfCPdgemz5f4XVR/sGhtuMRDW04FtsMEcVNdR
TK7pzAQ+0QOYBOHaLZ9UKiMujvXsUiXSQgRVt/MH+9fTyVuwSv1PG0ecDm61boUX
yPX/7aIGUU5Pwca4KlxRTNqzdtUO3Gvxf6O0VaWQ0CGeBL8tyGBKFgmKwFBf1gON
ahu7fMTBCUdEha4KlE98KpoXnSVBVlxiZ3MtapSDV0tH8yr5zYFcG7FmGshCcMt1
zQ4BfBzpBJ8/CiHEoVs1/5SZJNiKzEYy+CDNNhuuiJ+6Gt8pAkwgsbbdpF5gkEbF
dYtlK98x61ojXIM5cmAXBbx+1a5m/XdhIpTrFXQzlfL/NfagfYxlkyElYpVBuqq9
Izs80n549/mQ22TwT3xiNwevOardk5KbDQjHXfqFLc5m5Cyl7MdaZwWEUnx5L7iL
fx1RD86IEu7SQnDTFmLR7CirVw3qG5G0Zy4CoSLKXak9qmKvO5BFtmI5Wpjxu/An

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
RhY6jb2CzL30x/qlZINoHNcnpQnRAk+FDISlIx51SQVW1X7kHKqHPrphUGgXK6zK
+CUJ59vQlg/JtCyklxibP8sUhItFaBS7Kexg27FqpDAq0EIg62l88NA+SCbYc71T
WJy8OBAwTiD/KWmfrdC1K/XQ+wog0okXYcvq8GVgFv8=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=4352)
`pragma protect data_block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`pragma protect end_protected

endmodule
