//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module rw_addr_checker #(
  parameter NUM_WRITE = 1,
  parameter NUM_READ = 1,
  parameter WIDTH_ADDR = 8
)
(
  input                    clk             ,
  input                    rst_n           ,
  input                    i_sel           ,
  input                    i_wr_en         ,
  input  [WIDTH_ADDR-1:0]  i_addr          ,
  input  [WIDTH_ADDR-1:0]  i_wr_start_addr[NUM_WRITE]  ,
  input  [WIDTH_ADDR-1:0]  i_wr_end_addr[NUM_WRITE]    ,
  input  [WIDTH_ADDR-1:0]  i_rd_start_addr[NUM_READ]   ,
  input  [WIDTH_ADDR-1:0]  i_rd_end_addr[NUM_READ]     ,
  output reg               o_addr_chk                  ,
  output reg               o_err  
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
qpArNEsDzlTPVXPF7jaCJnjcngWAPRdQ4OzBpTgzZVgcs15w46OBapDKGA5yLrDP
K97JsObgCy+a+2emSwudqYGlNUm0ZH+CM6oaiyNis3rU8zCdUH3TydoGNCM/8JZT
S/9sTm5yDMYdljQDi3I7Wvi9bvi+j9oiWiOS/JPmF+qo/D0z2QlQAF5FsHAProjN
wRlmhp9Hgmtl2GD4ZaLiOG5MkPAjx73/R43I5mca+O/riHaX7hH/LUokfe1PkUV/
CdUQnug/VNfZjlfwFsjwOK7nHOwb0T4Ig6C2NufAH9Ow1VSnTAWHEvpWepYl/BJ/
F785UzEcOUipJjJa7iv4ag==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
0Hr1ZO8jpmurhKLmtmoqZ0hsr2q8LGf+ouxUKJlBqzk8fNV4tIVVdP2c/WyUGhO1
gBkwCC2AS2L6ERI1UjELdj180rD5uGQK5kKakPQfo4W9bCIGEpjTIyrLFutNAW/7
Or+1zlc/teGL6E3ODoOpIVG9cPWMJLnQQpwEHZ9lNuQ=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
YG9LvQHVsNF+fyjDuvIVcgysYiN/II7l4rU5tTIc8tAaadlFK85abcjvw9OMpv3m
pW/KLrM06AlNd1UuDMkcacQpJpXlvzzj/en0TZreHrw/EhvgDeHuBdQ3EH2OU4YL
vMsM0FwAuXvaYzhX1gD9vFlmhabQdDkDtu3QxnZ7U9qqnOiuTCufjmKje5OypIkG
ed9uziAnuB+pwgyo94UXfnxttDLulrWZhmKFdIJjfs47N0O64dpOowDKr9vf9u1d
2Ejyn67Ew6uQkUxSMZe0c8XXOtV0W9bsA70ZuvcO3OGs/wtEmhPsiq6+hK+l2GKL
wo0Dx6esG2BB90SQXxvSCw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
GpGmHm36gvJjcXJU4PRf7rRKtbw1qzgD5ojQ0wpvrZvVn1QHR3yb1KHuqI5V3SYF
Jxi7tf/XN4NHzccjO9ln2hjjPhd8skcpFFwNeaMFnpEBG4PC+zz7lqQdIQsUSOBg
Wau8Q5+uS2wTHDAalS2WjAqBXAMKeOcqe3a+U2USAFqF+FkKCkUny406syzXluR/
yLRjiUCNxQnfexotg8UchrIdM9A2BLI5tBFBYZlULuYgOS9sCWQ7X727fft5WSHL
fz7ZkbRjPilnLyIxdBf82EI4MqvzCexivuOwgw+LJuC07OkRkhq2HWXwOwhGBAuc
BoLLkocFU3I71jPdrlzNGg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
SfHpiT0sVBQPhgvBFbB+WZg4ccsmx6cGBIpY5kRFw0dF58ebVRNSdwfE2dj4wOHu
KKmKTaSBklU3ofR46G1D36+FEzkXC4EKky6oFRAd/zL4+0lu/vFdTAZh+S86W8h6
+7AAaN44jXeNdgalXdePnQhhWNHmhzsGT4WzSiVLZKD/0cU1ufiIrWQChT2tI32A
pfztmmOyiAfkSVCullPqQagf3qVEBjiHw86ao4V0/6CSqbyglYlpinV00f252im4
NLrul4emiTlZlriUjSp2Hw//bALDM4F6H1j6t0zsALl7XphYjm8uX71fj5+LSI/2
w6owmb/Ct6wJD8DJ3QT3Qw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
NeB4Nb2BnTClOj5xjcJESWL353mOIOsyuCggAdcZWO+cT8qZcMdVFITGPhcy57Ra
xV4OEd8uEedf6eGEuxKVGzkSd5xilb5FpYsTn0atuLA0a2NkCiqmbBu81jiImp5h
V7ciKeccZf4/IRE6LWt5LS/3cKkUqro74etAgufFJRIi+hSttfN/N1Y0Z58PRmvH
tHMT7VRf575qGMm8TBtdg9u1h7QHIVDSMiE6ubo/V9BYYEtnzVjt4ksgzZX7yFiT
iCFuF7cvnEDkHyDzIJPS3uImOksPPRC9sxeCJ8JO4MktH2rv9x/JC/w1yLRxA/j9
SNR5t5sl5IDGBhd5ex/G6Q==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
IYqSKe5WuTd8f77rYfQjbz0cxQdCkl0JWT2gDZnBpZSne3zvH+1VijQKhLeyJEVZ
LQRnxKxf0Q9L8hKpnac4f7mbFXtMczFkuugN6aDy6oQXdvVxKDJXr89usTaCeCar
N68b67pGzHlX5QCb5SjtqRwTuOgAMxHZRJZzzCaub5EW+78tiqT2G5Ep91b45ZRn
Oig4UJdvGaR5ScBESy314VLxUJNePfrBjKfm0+W5jAzGcCbYVLxDdKTk4Nbg44hI
HACdYq2msyD+aTOHvX4F3KJJbRP8U9rw+p/X24c6B3uZ/cmN1RFJReV7fRE+c+2c
MPxe3MbJXPUvVfxxm7krzWN/cyWJCsADjaSf0Vp7/Z9f3aCpJ8QEGNCFgR/7u9lV
VCgBD/pe32l0WKg3cqy3X/KpO4xxMwTt0SSzVJpnS0kcUMSlnOR02ckTOI3X8GhN
GO8hECMzwfMmsTSpl7BVTa8/yulGiMrgQw+6ALTEC4SztSToU1WVCCn7Ujr+kFqY
/65ncGhvAYMqRC6izSe6m5my833Sp2/it97w2UgkrHj2GNcq+nXYe77mqbq4MzWV
7KfiZ3B4laUFdijGJh/Hzuv5J0+CM5aryX5kOAElbUIjS2ozTgi6NVCfwdoT20rN
JfnhVE0/1+wh38l145zeF0sp1evAyDvFxgV/d2TlADBZ05KyGPkzHC7yJwtbyC5z
zbyIBJqVl8/yJoWvBs75O4B4pQDii9SVQbf7pYSaLMBmt3AAyYee2pURe0auROSk
tS2wzGApI3sjeDxVT87B9Q/2FRHPKwZpwbBgKZVYXPEUo8JZBLlRN4P69Cm/GV8S
v25gM1tw9zwvz3rF3vocqm8v74QVhPrSozSD+M8i4AcEOVTWJab4awZcC7ibc6Cm
JtzTfAqZjlYRYmxEyCccO3OUblr2DK0RHzKSeNE0WdDrigCuAYRMr0b+Sioy6wjy
hUMMSgQcuSkqfPzFt9AY9gB95xX00dR2Ub2h4hwee573YKOfHP5/tAL0kF6ByF55
TBVKG24IYiu6eWNcPx2q4BAxkqxsRGkSPRCG317X4FnLop2UuKAPLuHLoA2Xcs0i
QZFl8D8H38yEyjhWjGJzMfhNb//akTjsyfb4JD1xWmMPFjkTRyu4XRcOojryqOEV
EmPVqaPcJjjv27AJw/TrW2iQ4/XJJLu7kH3ZIZVI+GSc4bZ4CD8FFWRh3dPNSDWy
lxDHKcU1s1v5mRak+JxEGxzDFH1Kx/CrvUkfi1T+GzHBOnyl2GiHuUHygdR60jaH

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
AQZ6KdJn8g4kW1DBhV37+fmc2VJz/AKXA63SbIzKD/EYgE8tgB+xIQuqt3UML4ZN
64ADhN0BEw+Em5cHKBy+xoX/YEUehZs28aTnGskExL3CBDFE54dmIaldPUsAj2nS
OJ5QQ3YikWWTJ9b2nl8GCqk6RjK6RwN2rZGttdP9G+0=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=1120)
`pragma protect data_block
3SIvrMvuWo41hM+3yZ849tHL6RB11syNs8JNVlwEn7tkqyT8lZ49rhVCdvToYCB3
vpRthHLKWsuPTPYNoXWl1otwd0Yb40cuVhWn6bNASWVYdZctxok4n33r1i0YXfVs
2E8GNH5lfVcZR5HJ77LSMBJFA/oUov98ZYZQk8gEq4p6ARJeCa2b8I3FFUhkmMmD
2xVSokqWaj8Bk9FeNS2e0mYADqfZYzliPxkLNcrVJ4rCgt9XAVxuPBw3KAHgIE2Z
TurUAef9fB4jZNFXBLdpzInO04OpOU7q9Qnre+braBq4XTpJV6PU3/CND4uqwK9f
sWbTFvkxyHkhDGfMtYLXrt8DfRDKj29P82hBl50Q3Fb9Q0kPxC6HwyoTS9YvMAO5
GQH8ucie21AWmpMVZRViLjDHJTICWUMMzpe9pWxSL69dTQqzeNjT2VvgRrNznZBM
zLhZ61pM8hIlMwUHYeFgZ1TNFB9rWQaO4b417vqGdVIxVrhh5/o5STQfY7nRigdP
hmAAsfPomi9nxqLn/qgGlOvQT7Gsx6YwPwa/PEH1amyIiKc1Kf/FVwPfb7ip2X+a
ayTNuZ7lMTl8xjatTovfPUY7365/nKiHrRxIuodXBTQAVYHBD9EvOZvKN411IzjY
2pvnmsbGq/HtZE+aEAq6AgoD0G4NDFXea6wqjERhJ5Mhazmx9pOnKyEBSls7wOy/
JjuDBSuk3x/df1wxNPxMAflXjbGwH+S9e0bECZ6sRpWj9JTpC2Szkhkuyth5+uis
ZfigVKp6xZStXlZ/2lBX3wksfgAffGlD/9amkLPHyi96UvPXjzA5bTHaZEjGnXij
6HwvYkD72WraZBGaTUca73cdnArZBEaK9jMTSRLQCTsxqZxT23dWQMttnYBICkVn
jzKac12c8AjHl5YxklWkqXIsbfG65wAhoRIrNKHxZKm+jErQcrbA1SRzNmgPSzDL
d0QvQStQL1kYACC7n+GGEeVwC1bATLwTWQ2ETZqFfM46jENRol1bGpqLmOgwj1xs
mJMxQ+7cjMDCOInXrs+g6BTRgHZ60HOwJJwi0SXoLDTuCWYeNA2d/tQLwfIUObq2
bxqgtmosY0vd06coqYfV1/3lsekzOrRERPJiO+4IAPSzk/SGg9SsJuZa46RBle0O
UwpWz7iSNcvBSqoUM+V7GPoF+LU9jWB5u9gukQWaVfaXzxeQALA9XOQEjXuREZpL
Ou4w0yAKztdNBtNth2MDg8bZvGdgiRPSwpjhsbs0sdv/mFZqVmdnvbXjqoLMJfAJ
QoFnZa//nE+VGPiKnqMY34W+g1BpbW63oRz/EwyjQ6mfbTnhnBSPHW2CTd5lIdPJ
bGvxg0HBrGYiRGBrose+/fbFbf/9fGdR3b38r83CVww96vL8FKnUjDo9cixvLzUv
T9fSVjjnNUtKy867YMTrjXm1FosCIWMB6MlNjFCtTxQj+UtrGLKTWiXyvGCjbYJr
m5qYwcY0bZdQD/E8eoT0Qg==

`pragma protect end_protected

endmodule