//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


// Combinational round-robin arbiter with sticky grant.  If a request was granted last cycle and request is still being
// held, that request is given priority, else there is round-robin priority. No new grant is sent if not idle. 

module rrarb
    #(
        parameter WIDTH     = 1             ,
        parameter PORT_EN   = {WIDTH{1'b1}} , 
        parameter STICKY_EN = 0               // Enable sticky grant, will only send new grant on idle cycle
    )
    (
        input  logic             clk,    // Clock
        input  logic             rst_n,  // Asynchronous reset active low
        input  logic             rst,    // Synchronous reset active high
        input  logic             idle,   // Only allow new grants when idle. Tie to 1 to grant new req at any time.
        input  logic [WIDTH-1:0] req,    // vector of requests
        output logic [WIDTH-1:0] gnt     // onehot0 vector of grants
    );





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
Gog9xm4MZLcdpLxKX46OuOfmcPeYny86ucw+z0mMmyINzPFm8o20iXlPMIvakxoh
Kp3CVVYfyePlQhQpXBrPl39NsLC7Dgjhz3RSOWjqHNMxb8D7J7U3LfcbpR3YoKv5
658NTZ9Tx+Of0auoOuvvGW3j9Qy7o/V3v3KgbGn8D6V5xJ3V6+cvbFbkraNNhbh7
DT9Y1Ybv7Q+zhFqsEsskTKFxvaWrSdFznjaWXPhgWOlXjOsOjls49sU/KqRaKcLb
A6yTn82PXl3hZBmTlOV5+jdQb17fwoVZbY7zBTZxmwwO5ldrvtYrQEY1BnlR8HQa
Px4CtP3lgkO9QGlKoot80A==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
NGAShTc+zUK4CA9097nWYaqtdqi7dW2Qzq88ymGx++RgEfHKmUBn5W58OiEM8gHj
6yAr6PvQxvVXdCEQzg7Vb949Kzmne8Mnnnlau8HV8lBMgs0x1WUtkLrfhEEo38jQ
9jgbfjkPHcXpAarAMIsG1hsiSE3EwqLo1KH/X254v2Y=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
phL19/hSvjn6F6om21qnDn1YpVeVtwqkNwDfyTS7/1rZ+U7JwrW0gw9R2tfqq5Vg
/nMWdLktNWYQdd1o6wAbgQaxjv3Pf1T4qJ7eI8V/rqXtrldygb9gHWZKo91gN7Ji
MV+s8eQ1TFT7f6iqRdaabhtCM8mTXRtiswjglnfiyUyF3ToA98DJP3z9yUogQfc8
ELDdBerPxOG7Pc0H/qVqQ7bNw3WbLLydVWMS7jEvBvZhy9ODIyZ1Eu8kTFmp6Yi/
JBbyg3c5FXOYI9hMpB6fsBsvYPUvN1Rfgo9RZJagvX0oHonm7CmmMX9UH12TqIl5
Gnxu/VJ1e6ztJg7SFDCYIg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
TYidy6mr7u8N6S2+khL7oziCZ5u68A1x6sVd2pcUWBALPt/o+GF+PzguQWQ74u1j
OwJtvrTu606LVH8lqiNiLwjPRnl0aay1OzuMyceQdJP5RLtEQB3sjqx9k9taFqH1
3vEWP5dkYwvl5q+47reAD8ycBcQ4VLTLgxpnPZiS4a7fDqn0NQUsjIWOzKJlJBHf
nFkDiNZBM1NBUJJDakc+rzJiigagDHZKvyAhLLasdhZSq63Vabjv2wgNiOpTzboi
TvUgJHBQ21h7INHNLkgrX0wkVaBHhn/JGu9Ts1WJYb4eFCbiWWn69ikJBYfID7OL
ieu8hatkF95gbUFHFSHPCQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
dgxUsqZJ40zezgcXupldoR1V49bGPfGtFjksDXfVn+C20scdzu3XRYPjyZrJpBFJ
JPY1y/4yfEMfdf8tl4ECbe3XUgzlUgfBYbFGNnJJh0A72xblOUHHsL48JEQZErs7
XI1lY/IScah+qH24ETS7AVIjDrIwimtYIC8mSlvymgFH7yGQgNn3mlIzN92BVyKo
iMh8hm+5fisyHlz63uh0xvI6R/XrHY4FdfpSxTHMiu5g0gJXn4vyuY82Ikz6hbbH
eSCLCNNU4rnecQZmbCam2G91DbIXEU9o7MvIYi5kq/da1GXqUr7VuXEDQxqYfCvJ
OggpAjDmyRffWEk/XDj9ig==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
D3zYXC6jWiarWk8b7yyRwY3W9l7UQywmdlHnEmxffX5UQafj4jk2SRBaE/gbdsNc
7pLOhBlEnmS7sdhdd4X95zAdid7RBVQ7toSKW4T+XcfXp/qtP9p1jT3W1w0vyfJj
nm7+CKAzoi3hmsoyNeVDyyK0SIwj7Jak9DY6zhfRLitTaRO7bfTKCil2KYyGBHow
LfTb8T3Q+Mp1ksSBjvL9LuXv0QRn/8s0GY/PUws7JM32OOXZfX72liJBz0L8cgkx
ijLbQzGBRgiSrqmJcz5O83vtKgd75CIXVnWc9ZkhkjqCxAep+pNd5fF03pQF2Jw8
kBvpWsQFVFEqPo15SwCJ5A==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
q5nD/RjPeaWjEW78DBoVIdQJ8QI4gX3w/nynCaknhJa6DBQIVTpYVp955fJnJORI
09hmwfzOmoQqywRXMLydALgpjfgEZVnBgPK4utPeymQxb2NkpQPUYav1rwDBnV6Q
QeYdbVfz0txom9zTtxRhBfzIq6ebdMMHWlVrxtW0PV/F01zYz8xSmZyPjMxqWJNZ
1T0J4pu2VFosC9OXBAXqrkYwZ6ZDk4n/IxA9I8oHl5YXkQ/gn4LZFrcMOWgulUcL
yNgit92Yr3s2meDDxsq4C3SH/QUGRRH8uFsvybQP27lf9Hglifu+k5Rb8WFT4tFf
khbo35fkwuUzh4+Ui4NIn+4fsnqWwUwBDcs2Y839TGBEBNQnJud0EOSC4qs1PszI
xMiprcJRu9nprgQvzJy+faSEgmBPuDLx/tmjTA9nM93n3cO2XjIKW/ML2GQtTeZJ
u+Qhpb/VinmSwTV50rRsn52e6t8U53D5AyawfUNkktpMqVVwVytoxcqNoyxXDLd/
FwwTWtJ1nlWrnpANvwExVkwIbYLBkZjwrOxUA5gTbt+7+Cv0vQ8poPyJ2rKAYZOI
ajpXO3KzMnwsfoW8CdE9EGcZFReEraNYKa8PKGaKN56k0Zy6CuAuU1+/L830mEd8
anAp3q3/mANSZvtD4zjk4StccWQBvVnVn5oAXxhw363ZYci345uM34V1F+k1M5pS
sLeaBnxh2cYRXexQXHjukKGZ+lHIMyV4kCaqb+rs2qL/UAvtm/YkLTe6w9iK5x6H
RKSM1qWO2dIBbS9GJluV7S7+E0AZKCps9wLkPPm/hzIYq/Qbv09/5FKligfh4kFX
Qi7+fTSGPjsp/VQpKYTK8/xm417e1V+EQENFFKxHYy0VKUvxjsVvyYt84yzkZwnH
9lAuWlLma47okk3cDBCiOUORKJHNPprlZzEsVEQfmSA9JdYtChdp9OyF+1fb+RIu
xS7qFAZ4X/KnuEXFEEVihVOefVTJim86OY0U3OHzKTqfYaKxD8TZy/d4Kj52K5zh
rimlXnJMe1tlbod1oH4Ks2EzA69z8WvIYz5/zhYjGOMxDlhYw1PLt5eX6PFDJxJJ
cKroh5GKQ78c2UMKvRBLpVflmXfq0X/dv1bbepQF+KCYlfQt1/MhBE69jkostKiQ
mPFOsP4jBpxPQgYhTMKvSFkwmqcCbFNQgSC7sOKTdC7NzevgVjepFS8CKnLOOtFI
aCFg4a5rtXQ9FcBBP6q3CT+EGWLlXdumQbv7bkz8uGYBwq+uBLcCYpUnugKEfsKe

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
cpdaEnRlGfPW0umSHT5W9A2U3Yr7E1WKEdj1Q+wpvIYP+7e0Zm0N2IbJjofXu6bZ
widnGu/oB8n86FqE5NpziwNiJ/hWs46c3hdEvrMcBhFyTW1kLEbxwaBniZ0vzm7E
WVwEmN3136G2zxL5/J400jdCeFjDoNnKdV/h0InHF8E=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=3680)
`pragma protect data_block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`pragma protect end_protected

endmodule
