//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module reg_fifo #(
  parameter DATA_WIDTH = 8,
  parameter DEPTH = 2
) (
  input                   clk,
  input                   rst,
  input                   wr,
  input  [DATA_WIDTH-1:0] din,
  output                  full,
  input                   rd,
  output                  dval,
  output [DATA_WIDTH-1:0] dout,
  output                  over,
  output                  under,
  output                  empty
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
l7kTMxZfzNrrdht+679Pdy0Dy5UpkUAxhR/7weZ74AOVPpaJ6omOrY5y2R3BXEM1
7IHt8JGRGIMfhHhPrlkZfyB/JI2O07U678pFVOTqr06Kp9JxciNHecLTQ4rP2mre
uOb1fTUffVldnhUQWp2zp6W8UkGN5A1raftoYe37yxRck2lIRztWh3zTTyqOrODg
AdZOXwwhlOxWQinz7mHSiVsWcEyAIDMtGVkQXjHC64giZjEDzSXtB8iKefoQCbbR
Qc6RORvERKiSBWGd0eWlxBRYVOPS+m8NBdGpQ3t7261Q9K1nPgJ46V5RJWIjnRLH
pa9K+lo7KmtCrlhaWY4FCA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
Gw9qFXBixRIagaq7aL/haakUojL2zOgQu0/uAHqOX2VxXSmjKPWFd2WDJ/qRDvBu
ELZnHUofhRJCDBrXQPTVb4sB6ao8oykPpFoxEc6Vk2qP4Bgp9p8do8uZgOb5Niq0
fOYr6k+oV3pT0Hwlcm9SRMU8oK8aXMDOtZcxtkI0GMk=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
UDgLlS3g5K/SGzSJqZYRSIranYK+dJ8WovQdn/AzkZgYhYGBsbBwdUyFv9aXK1bG
XcTWvGoF/gCe8cbUdXvarqbYSybF7YXG1qeBnGIb+X9bOW55YlM01V/CJaKWky6r
OAyC9HI30svEk/LyrNxTxID2Fdlsw1ryAPMAyFXB9Tivylw1ySP9K/f87lRKpYYF
SXsRnHqKPug56A/ruYr7ad8DaZrDF6jzD/3WBxwRbXoaVK3v32EwWyj8MXwEyE2R
sc8HerPvHsn+5FHKdoKoawvKuE2TxUMwjSoJm0PjrJbS6thPnBYSaNtqr86GNI9p
GNLCMnn6WsPZg3DfcLANvw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
X4vDEZPT+rdhJpGi52XoKsiFkejpaJ0mom4AWIV5jB0JqdX4ZUPW2UtAyv4WtTuk
97B725RKAXAW0uNF24zyrqC/tLv1FXL/serP1vgiBxNRcuW8S6rwIuEArxYQg0ik
sddtmS2z+qsPX8DXZl5WfNaWRCqq7QmlFa+0Z3e+p8z2Yc8mRq/azANdGfIoKxIE
rmnfvci5KD3/Ey/JI2pINbUGEgEsuxGcqY0qt2A2ufSPJICXa4LegqpEQryYMWv8
lA1XbOpkWtuE8OYUY/bh1hka8MkBCno4TVakGAT2BjRrUn0j2D8l6gbR1g5OdhlB
Uq+Or1B0GOkhjKhYT2v+UQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
vi6UOoE4qBmd1BZh6a7Ai/ibwJ5my4LSjG6ZMFgGvXOsgyjN50UGNLfEV7Avoomx
RCf8EVlBpyIB/0oHHL8CHhkWdjxpQ8mW2OHItx2kIsl53WwbupPR7gQqmRYuIKsE
RQ9uzpzCApC2jFx/dmZGhcovgRCwQ8LN/G7JjE5f99BeBt2BRze2zMkKg91odhTK
36B2YhSo5RtXxqkwKlcJVdPR75VP4+NRjkLFmICqyxZN9n5+6ijXyBNDpDdNeziN
LxajaSej+SfuybQl/D/uJVgzI449uWUm/zGVwm6Zm+b8H5IR4ovphECWMrAXNxMb
/eg0X7ZK8bfji2taceCI/Q==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
gVrjQNAlupUFl8hbMWT8HujSOwIGpKuD6fNrg1zmlr+YmZ/Q1c0MOujEr+pLZTOp
f9L9riW24eSfWEoMa87UOqKYCadLynx4d1wLZgL4mDLWOiiY8WG5rrt/50GrOzTQ
70ebCOT+x6d2LK1Sl3rVLSHrF+T5QuoKYVuY2sXNghpqW6CznijQNAQAHfz8AWo5
vlgyJuHr0rwQX/aUbNzs3wcEtMVGMXqj45+cPwpMut3j4JCxN2nau9CBE6hPcgVV
ugj8/Z5bdBrgjcj3GN/U7iljnV1D+HgBtW3Zp+cIKx9yuW4dhbJFw1sRKWKAhd4Q
JjP66lTtKMG2b07BOcO7Fg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
qZTBt6Qsg234QT5TexH1NhqRgNjH7sDF+jlTxFEY6mT4o6/2D8nLcp3fm3xK7Dj0
Y3HnZJH94JD1zzqTBF1KirHTwcKqJJYvPiUjqBQ2GB16eLHU+URWKw9zrZMBMisX
o8uvu4DRBP+tJhfOGKHwC1tejBHv6b7RBqKUbv62+O93Z+eVtMbThXOg90hGTR+R
5wsD5DfxPXmzUjTyTqzYP8KwFTUdXKlxgNz0RdbUGWBcFngMmz9lxSUJHVmpXMd6
JfY4/g/XTfIO74P4TQvG7Act5URLEqHQ6zCVi2HdK4QEAshqIQDFVuYx4FwRKU8K
tjHPIyzfD8axqgdGW18vs8HTMyWdvgRIJJ6jyF5KASoQ3GbpicFJY93wNglda79b
gqN59divrPdLyUAJNHJRohn7MM+Y2ztqwRlRJwJnUEXP3y1lTLtGKotNwnORJaia
FWCwoJVmNvQGph+5fjAEuRr/PAPAo5nshitXRU9hv+U8LhF4lZca6qVEho5jLE35
MUOAmv+zv7RrCrs4ATGZJyjlEA3yVJKqPAAlBG3h7QE8VhYAlz544wuDydAIAiVP
pzb5wKl895ufA0l/wF4iQVG1cAWw00ufnJB15fXQQvtuazR/ygR1a1izCAeyl6tN
Sdu2w5mVcJESszD+rb91T4sBq4Vk8wsVjU9qx4oGshoE1ehEECkaXN2ckCO1ACPt
by/5GJ9z1g66g0lp2eaV/wOgFb2W4jlRSys1MeHaCAJCJU6X8RwJyK5ctfhD6h8d
9ucePVXqZL56p8B4zS8HzNi3DwN8Qn5uznYeQ3An5E9XBsdyRiXTYIbAyOXjwcyG
cT9zVz5JrpHwcQWK6b2GNvNkvlN7FIuPbjxY/HuGBP6K+Q+zuljHQm+vxErixU1d
wUYxO0ZglpdPadQjhhnwoG8nJc1zXIv3hNIQS4ESczaZTeEd69D7qtuU9FqZI+FE
Ya+VEyaxrM1l4VRWDeizil7y2xYOk4jwAXFloJcfan5ffgwsYp4587g2SvLxhL6+
0CbmUAK1rlq/lBMd/6o+Jj7Kl8+/jTCqz19BNnACvh+L7RxYPSBOBPKC5YT4F1ek
KwH3jqoA03a90aFJcd3y9FbtRgzNXIhhNYd1t2UVtSEbLm0/aIuy22bWkJoW0TBl
9gKQtuB+K8yqsRMhErxCdTun5RsWs3PC0UYB9SOdzY2rP85JWogpTG0Cti8T2CRo
k3I3bp16q7ieGRTdmEna9oOavAHRuFUdEH5V7sSsfLwSiJQl/ajczp9cmBQ9dvsk

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
hV1vNTH2IV/kt7fjyNRL5s8YQLRvvLathJIFcc0OgZuAJQMBWiQCEWJ5csQTXEi0
c3D1ebxYi5iqsUjTjZZa9qrrYFEVKnB1tJQpEr+h04UkOdbgjQ++id0PVljMvLZJ
x+AZpk5h71TLNcHh+15uddwL3Qmq71j9MnZkSQmedEI=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=1696)
`pragma protect data_block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`pragma protect end_protected

endmodule
