//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module reg_cdc #(
  parameter             NBITS         = 32,
  parameter [NBITS-1:0] REG_RST_VALUE = '0
)(
  // Source Clock Domain
  input              i_a_clk,
  input              i_a_rst,
  input              i_a_val,
  input  [NBITS-1:0] i_a_reg,
  // Destination Clock Domain
  input              i_b_clk,
  input              i_b_rst,
  output             o_b_val,
  output [NBITS-1:0] o_b_reg
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
uDV3wkhN8TgMGy8XDbboqCsFyro5LrC1UbeiZDcLNFb6k7ypchvjHDKIrK6GNRVD
lk9ex5bknTNdKnrlHFZukz6MoyGGgEy0eKKGBpV+6sPuLaIQi6WyivAdnKyvXq/n
ZSTp6Zlf21E8xVxOalnwtmZ3CVDs0KwYZEG2XWrxURaYF1o4Cwta7B0FK1jFwni4
ph5/ESBIgkAe304iPgS4UWDpG+f4MNon+RtySBFQE8Ekz0gdwPG5Q+Wa+bDeKQXl
5L2xNAPMkGwQYfiGzRiI/wUKgAI6ZdpdQrAO95oZ1Ed78kP4pvxslX1+OvkADrK2
UxA7GKniUnEqjR+AP2LCgg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
dXn3u/dGNIWvveIFgFl/lCGH9bs3/VXIgqVhrrb/Lur9GTGHu2smTJeAh8IFo+fq
q7xhOiJtLaf+3axkBE3ciJu1VJAktabJMy7tOF6FqMWFScpaq+sR7RdL2/FO7qUf
/aRi/8q20Bge9MX4qznKxAcfmi66MTbdn/mhCVUOY4g=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
IZkRk0GHmEAxgSyYMcPq1qd16c6P+UaUXumIjswtusvFmbH+2b7h8q9lpEWZLmFq
iMfYiLeJIWQ90pM20jiUMIq6OZXGPZWMX7pRdhmqS3L/L87M0iq4II/HoKpQeIIh
JvWvn6depAXbWJkvgeLerI5crohGm7PPIyofyPAaGVjsfPdR/Fdp3DA2XqceUYil
hPtFY0RYfKa5UPWNXIWiJqqBdZrFSFj7vFjAPt93FlM1BXZh7hN59tq05AkE+r68
5CJPkJV4F31LTDNMITvEXUrXzUzhzf+5jm5OhjW4iGUbHMr0X5QEZwjDbU4KOIk0
rBEPXBCg6n+G6hpmsU5yhQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
hlMt19I2PNaGNb7WtTIm8+YGtcPqpdvbdZ9Q/3NGu/prGgzDRV2Kv7gyr6168oIM
WGW/gnh8QT8EXbFj3bcEr4WWD9jI5V1Y5s78U1XwA6zaXRfWt0bdQY4od9tsyTQj
oW+XSFF6xXO8lLMDHyoWBoaBU3yRv+DTqC2RiuLwrx82r+/9e4b8ROUpxJBPCoo9
kSiVs4vchkpe92AmGoLp+UKJF8Tz87/nlsSJsV9t0cLLL9j4sQ4JE2JlnOgCj2kL
UQOe6ulna35HRQ8dFtt8m3+AIMtMwQQt6i4jRYVV7mBjTRiD1OTl5UioasSe/Hta
mM524aLYKUu2X9tObNBCJg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
3res7aIGaK+kihalGjv+gLLSGsbZ6LB7HYCatb1QpuCOZFynzZsi6dthvX5tYSLq
6wFy5YtA4S5eiz7/Hp5O0fRaTiCgHyAWMtr5VyjnLStvQkTwGG9wxXapSwyF/k/U
x9FrNyI2UOkKcV4u0o98RlhLfZG/tk4BzEpbQ1oPuG+IOTxiOkYbMmqOWw7Xbjaq
ksAIVK8ymOecrS1QGyZ7Oi9fnm2zfsGDsliEJ8ntdXehTycV4n15V0QH5wj1y5OS
GrP8Wpsv70t3IofglNpf0Jas6pQU6xPjziAAHylyj/znRtIj/iD7nlJvyVN4lihQ
nCc7FgFj32Q4459ykFsqrA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
heoh8SCxwrEUzoaeAFnEUoaHKAA216+Qy8JpRDrvFs1/jqML7lfok5d+26aZFXAm
wm375YenpUQ94UxwGrhyUdZLa8HlKp8vTiZsaHEFy5fsbS7wjXgDtDccevb3wnyX
AdgGSXPY8w2qeZ3RcUGhwK+T9TNANJm6UVaz/BLFwQX0gU9oGdYKmX5gCIPqFj2L
jYJsfIfZCT9GDZoH1Tg3gOC0bJyARONtShtCwoIk9+pzjZM5bMTItTlSYxvMrJxY
0ABgZpOOW3Hsaqomc9AQtnJ5nKuld6SeK7xVR4pkhjryTPzaHIGq2ji93BbvfzMf
yQPhmB1pscmv/69bZLw2EQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
gFQjGX1mrXkVLjA1uwuFAgdI3vwzd0XkHxHtbN7/iD8DY28vKq85L1xAI3DwcTFf
W47K78CeNLlliU49LkVQhpZ2hnOx8d6NNgw0fX6ThT+LlMyXwPCNsqY+eyLfILH4
RMKJVtKQnzSkv2qfVhSmKQWy0EirWhmXilY//yMSadUpOoJTaHpoBwwG8etJ6iqL
INm/Md6/swd42gIjz1Ta0OvUZuqztZgH9WEtDYyWn5mE3QRJnGkeZ/c/ZC/N5FE7
kjlmq6pngWrCY+ZKSQOMa6psq51/5roKU+DegrP63qf/pVbfsb9XjXP7Qo3A5TPq
yv65vsFPL6HEQEVtogDs2KLGLtF8UNPI23UEy0LiczBsk1mYDQn/ULG7r1zmwZht
ANhTR4bew3YzbIdiuhQApYlUA2h1UGtTpc8qoNpXIfu21VqiraSUOJ4CTqcAbZAP
yokIRj6Vu/VUmeSPQe9G6re8FoANjFC8pX33St1azur+aGvrvzv8YYwUhkyaTAFc
QX70qPa8d2bctaVqBxfEo0DDuyfYaAsQ0ZkVjOUoH6svqk4RRLPecaTO3HDkgnOz
bhMQj5q3darsnkXK3US7/m/hM4IrrauqrRbrm9eeADtHtUHCLTgLw+d98RFIvooL
bLsOC03F4Ifc5QbgD8CY2qcLfHYaQU3SjUZl/nOh3ONVdVy1uC6jNw8gWp0brH86
3wp8fxUUaBuc88J2zzHQLLQFWl8+OM1EbwnAoLrB39BY+rFVkiEzhtBrLLJIpzXR
3rLzNepnj/zY0LIx7zl2rEPMoB+Yxq9iLJfa556SO9SbUknFwARIcKCYg0svF2je
1QwFAhS/ZOjgOrLc/mu0zlF9y6yHeWwtVBJgFSQIy+F+nTW8lRtS7zCndfnzRzz+
2GaKtDKu7t2N7G18Gqb+yZVgw4v6+VCNw+ji4quUPl04XaQUEv2/Iv3qUsYnoRRm
8+5inY99DVtKAzoRUaHW6adc1dWn8WvgyeshnF3T0e5RNb1rnO1OP7U31KcQKMex
rkY0QMwmjhta7VjWiTjl2F4KxHbqbwJtIaQ4aPg/qeF3k03P4qA1zNk4ggqKdDH8
Ovyo72eimViTq+HRQV1rnZc6RjlInEDlkNDX/02t9d6PCGqPrEr9S4O5sYJspOUD
UcHahcK88fccKCastY0kz1ZCb3kFmn4W/CkxHPdQzUnnXMDySCixr0OAghqXu1VP
GRCdSAeaStNLdwvct6HoTKq5KFL4tOyu7APP4XCYNdrfsf2qlL8SdZ8GOsYzbtZy

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
B4xpnE1K+A4kQHKND0cR/C8pnBp/Nkpy7paPf2iT28FFeZUUmtFiTRbalIaZAKpp
H1KDoZ9junXHNQlhBV3V3BhG+8WzZ3r77o3ylwlXYTSpua+ZuRh7RYbsuXEoCEy5
wz2LJHE3Emawxjmpe0RiqToqF8PMYHn6Rxlr0Uv/ND4=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=1632)
`pragma protect data_block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`pragma protect end_protected

endmodule