//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


//This module will synchronize a one-cycle pulse in the source clock domain and create a one cycle pulse
//in the destination clock domain. 
module pulse_sync (
  input logic             src_clk,
  input logic             src_rst,
  input logic             dst_clk,
  input logic             dst_rst,
  
  input logic             i_src_pulse,
  output logic            o_dst_pulse
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
Rxn9lQucVHpcSEUnRDZJjuFZS+uCu6Uoc9g9fsLVDrYSahdT+H2sqJA48MtJJrgS
s5Jh7XNAZBnHfQp4tj+ONl4ojVAAc+7vtEVKDoER6VMpLJr+0g9CHbgUi5moTvFa
U8qN0+SwHf6gyTpG3Dzp05gWrbsCh12khBxtrNpFWv7b2lf6nzYP+dFR4sJj4hnz
zQ9h1Gi1Xxd1luO4d31+UQg2mxZEqkuU1LvTF5XRW+MXGdKwuOXF2OA+aCfmZ67p
eOVN4fkWxahaSDQpjrMzsn9OYvwkdWH/CDxOpLozezE/WkKkqUbomxqdSxVe6fg2
q1n6pChCXm21ArKMq4u2GA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
2tSF9PDL7IK11cDNRF2Q+PCFN2V3g2OPuT45crUSEis5QdkviJmKtCxoju4nytQh
kUV5m7zBpewwm6rlsWEnbkMz3O/fHwy5ADpY4hgEObRMKzYMje1/Nn3wZdB94EwC
pJPd+YUF0KJl+zL1mOm4z8O1bVX/31nQx4FkpUnbuY4=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
diANJtVrAsFxA8lgA7c+I6B24aX1XYR4WWMlmEmJ+EkAlLPhMMLYvILfcKbnqvM0
ief63f6dFzD4EqgRt7+LuRM7zuVpe4JvSgE/EecudURUIbK5ytEUAJpA7nxSKokA
JeV7n2wkxK5oFOqHmBd4V+8+Z+PCrNHGDNMKwRDV31xvhwTOICyexsGDpn+mW46f
1I3OEb5+rxoBWBaW6flNAW79iNHlPzKYNSB7FubjJoksxjcGw2aCSvptyb08nlzK
OGivcVohZ0St0uKlID5IE4YAl8EGc6JBlscPIsoGM8T8O6svBOpPCWl5TNkJ8q1N
essFqJEZkLjecJyDiAFOgA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
odvbRMlzkTsvA9+810/UqQFvXAHU7WFuAZI5xFWQgwZuYCiWel1mEf02VMQYTcVN
Fkb0ul0PNZ5GfbDXtXOFU41NZ+BGaNNVOaTh/ivGS54TuMdvbYYS+qK+7v+oEEJL
LKFW9FOOPLuVhpwPUxF6dY7I7E3Q5oHFr8b9eSvnE5DPAAsdas43mOkpxHQVNbQu
76j89sLuaPbOFreeNWXU+ivGhS01+4VjQYjELmlo37sHa0lDW3qOoPrm/dvDQqot
YAZY0XS+xBvf408n1HmWYNpgLcK5jTZzgqgaLpbm3MFVx2qJd4/s2zzZ8klLoBOV
KoPuBqpoA8k0NB3zBZMRzQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
TejSWYeIkDz51NMQfxGNxfd+jni00zdOKEcv3iWv1+5Qzk2VG2s2I/Bre5OvvsaJ
06CJck2IGS5J3yuSlXO4DnU0iN48d5NTpd/qyhHmB2w+D+qzB7tFNG7TW1nHe2vF
qO+VlFZhzwpA2fRCCeKx8P2sDar9IdtZxFzmOs3FizIbqyHbSvEADGoswX4zZMK3
gwY2LJaa7WDEBTnxR+7w8/fD473DLuSq++Bcx7/PhEdLmyV4ysmVuk3ljjc+KKP8
anVKICkBcabmYxetiCCygRayipPsWebgN+BMix0wkuzxMNgux3dWPA9u+YTJlt4Z
fAgzUWghbrNworiBYPPK0Q==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
CsWpQuCl+Mm2xIa2FK6hmaYo8zenFPmgCZUj537HNYH8fV5Scfp3OJONZ1yJmAgr
wvLrn3GAtqcMSxNpTwE/JXG1uzaK4S0uJ9GTITeMdmXNWPxFURI0syIxpOC7K7d1
3Gbi2Wf/K+/4UsdWszufBtvGlYG+1YEwO4fTBVuGnGYGj9aK7hg6eZ2BCAcSlaju
9ib3gz3y6Pu5j9mthNPWOol9axfgBKFMIkUvZjdgeztkc4MbcmZQeYC30bN00bn/
QdEgYigTpb+L8qmq2sXc+qg9ofvJR1W9j9k6clmKFJTe0UaWyLOe5xmhXcjpsIB0
J20n9bwQWdQ/LgInnM/JBw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
Yktv09o6N2drFVo/21+8yhWmlaQJnhgE1ULUaWmRLiwthoCSVjwOLPp6Huvj77dS
MoUKPVj2I5bbXEk/HngT0dmXiB0a9bVQrkrB15+P18DWX9Ut0OFcsM3D97iDDgW1
trM5JOW/pvyglPV1J6EZsgHgI9jSokUu/AN+AJj41yQ1Yfyb5GHq75Cyo8ymHSzc
rjqlitkBuSDo2CUlCOlR8sl7qE64TS1DeELmxBESCrvR8dFm6ihtWRVCwR2x7UgN
feuUeXRFxEHK4QbmRzaO2o24SpfRxf+ieS7Cyu1EOOgeO1frD/epPO3C4yaEJqns
EH10u0VjhTMXQkCRf0HQ0sqZWi0il3yg+IpC+q5OvJ6s7pYQ2iT5NiKIaEgDbG47
O2gjoz53Em3IRxpQg8wny8gzWNBeDBzCxObvtq5tJICSOEpUlEwf+jp7V3+HrICp
w9hYMaiHgHlmrKENfSZtUMdymC/9KOloYUDPbZ7D9fctld8xjMUf7mz8F3UtaCaH
68Iv2jgu3/tDvlRdtTeeVQPIkgxE0tWLzEyTD+KrJpOmgLsqbplxJfy1VfxVW7c/
t0Dj5uzaSnoxPA3kzGyaH8su8rM419qkOTADQXV8nsyQfztxqJBAK78QU6jyCCET
UcradgUBYphVpOi9MaukmKHJOezghXBqx6etSoM4mO5qCcrgfR0oOA4U52RnsUo3
BYknDS0mwZl68FBhUUzttq7IuCBGXo9VCCl7CRAHJ6KbOUl3AqkBQLz6aL91Ast3
roL7E1DiFmFvbwDXyLiOZ0IowSvnqvJvXxFnk+LpjAEghS4ZVpgpSd9wWvbttV39
WHzpcYNHBexiXGFXbmncdeq7tcg/rs1Z0EhL23BfAGGrvvCW3UBG6DSWQoPt6KxD
gqTfqwrJN98rC9iyh0D+kMx2mBH9aS0ocxgb/efHFiGup8iQwEZWG5gmQFATqA1G
o+PUvgRVm3EvgKn5Bhe0btPNYQrv1U65tua4N96kynnJiJWv785r6QrK0yqI2uyN
uEu/FuLL658cbsBuB88rufEos0gkxeGpL7WIW8h09dgReD4NDEsy3CB1gsF5e+tC
LicIT4OguF0wMbXK2Sve8BkfzjOUTM2x5Vmtm/tBxncQFu1gkXoeLd7MZOCXuUXY
7uAGZhMov+aW54NwkKGtPVNi0/4/kANBcNXN8PWXRZ7RqbGwvw36XOfO+Q/cFRKU
gga0LLjV2YgLCGnW+fiCFUsoODtEJ2zbDhs+0/PG4imwwA7sQueH401+DgDqkGDv

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
GfZRyUWvhoYp9lthDjTOb3RlXXHGSqj78su99oCldkwLb2F9CkhIpe7sziOY27Dj
pvxedxrsXS+sXjrXXcmbHOas3k+ITamLl9JivtA/nOEeBS712bcSX+DI8lRRixh1
EElK/e2diWjO1swZ/KDktDjTR9Ree36rz0XB1gEmOyc=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=1184)
`pragma protect data_block
Aspx7m1qyh5WMewhKKkkYy5WrdHvNZ+0IUkY770s2aVjYRGAxm2vNOZaOEzwDing
m9hWpyXvATGrjHkt/2ndzc/EWODs1Ze8DW5Xyfpvcc3+eXj+Zi1Sl/MSOSdP4WjY
a21/4ivoVSaDouUzgCg4dRbU2ONl+w85P78CGG31E5C8WB9wqi/wdReOTXm6gGhw
mIoHqpOgEm7aCEXS8sFM5ziXSAc4f58iLVdJfJdxtiC/g5mcITrfCXg161uHONOQ
wihLykcSYk2HLcBJtN41yViEvdbmpF0gF+d+O8oRSQhhlHf18mn93x+g3fx8HX1c
W6ff1ZF3hsBw9jy2FznhTgIZuJ7VroA0Tjr+KqT4g+tfCPIhGNUB95lJDEIR/KHt
1DYgbW4IW5jZ4hq9vWFnA2f9ymCbQQJs/1icr/DiItw8xbBBT8SPh07XAlRF0EUc
JaHpNBW/ZCbtV65w5LKl1TsG48A63/bDb7Ejgk4MpS4q6dfkaSSs3xpyQHtLqw1S
d6MQFUjxNSZJ1gPtmSg/45Gm75t0wSFnmTDLGl9ZKZ1FpjRCG8Z+Bxja6DL79R1o
01HmSJ/BD73kVzAzi5GNKFHsLuYs3rrQ+s884cs+HPTKoQC8fogEy8Xsu/Pzu6AK
Ojjy/z4KJlQ/9rWUDXHrNd4DRTTSRyckYZPLvB3Wtw/sIsNskut6g6krxnJQxw0e
+PKu47JfLFluIM9+RyGIsbulFiOiRRp6HABY2JOLjHo3Mpc2w1DJ/67daqkKRzyG
/SJHp9aDtiiPxqZnkrs6tURHEEp3ViLiFPAUbtuW7vHQ/0h2zBPfrXb7+gAPz9MG
CW6uCdz5m0Ny8HWKbKRye8/W8hBz7fvgZ+KzuWvZP2AxUxH67oTo/9xtYQkP6s3y
Is+s/fSgp9q6OgqpwSQ2RtR0GUyiVv+WHXU2M7BpEzRFXhkW2xGZd/rnA3qXyuay
1Eja6/mmfmsJx1i5uedqd9Zyj+anJX7/hZ8m+Jan64OG8W8OOEnnCgZZnCDSWPN4
xy9G8LoWNpprxATRYVk0B5VpTBmeNbWL/d2MEo/2NXrxJ0XXSHCxIFnNzZepH+TU
N6nu4MkOiIQZF/nSx18h2zsfHMfWiaOGDxFPHZe0qE/0uarNE71HsgLcZmBUW/Kk
/5B7nATutLbljukanjG/+WYWhvIQmVMPg6RUAQbawgNmstcJ/0xlrE6zyB+dlbCW
R0o8TmVHF+VtsEjAQTtQqc8Tf4FabTjMp/yA/pKa38qoyR3byrthkbJJAYQdoTn+
qJ6uEJNTWB+KGZ1CSlsTAQ91ZecdrErs3pkHWQDveBNSnZArvm8nsrSkp5po+hKs
ldOA0ORBxAFGj2rtAO8b5QBVM1jOO0MXWIOOqIf5DFtrWq0+mgdGxVca3yEhHjs1
7frM8Nh4/y1wV9eEvlGRydDxjtOirUvlRcqHX675x9PYz/1r7zebBZH7LtU+WCPs
jjWuTrgqEVT0xnBJWpnNSmtVs9vOrnzaUKlrEwUkvGF1yrETAK4DSnZ71ODmuwF2
7z1GPHmuGTUPuVJKFIbh64Zi3ElTRTMMXd/9cLfTADg=

`pragma protect end_protected

endmodule
