//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


// Combinational round-robin arbiter with sticky grant.  If a request was granted last cycle and request is still being
// held, that request is given priority, else there is round-robin priority. No new grant is sent if not idle. 

module priority_arb
    #(
        parameter WIDTH     = 1             ,
        parameter PORT_EN   = {WIDTH{1'b1}}
    )
    (
        input  logic             clk,    // Clock
        input  logic             rst_n,  // Asynchronous reset active low
        input  logic             rst,    // Synchronous reset active high
        input  logic             idle,   // Only allow new grants when idle. Tie to 1 to grant new req at any time.
        input  logic [WIDTH-1:0] req,    // vector of requests
        output logic [WIDTH-1:0] gnt     // onehot0 vector of grants
    );





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
VOmHOEQIE7SwqXQYG57FPx5YI/Yxbh+K0c0q2t5XSHDWBcB0N7+1eY26Lt3cHFiR
9fYUJin4cjbdscn3IFtX9SDXTJ2neIkIoJY2KT9FpzRzSmy6fY++Hl/BlypGtD5i
u62RgIVszpjRy5LywfRwvnIBJmg0TYf4M10RAA7trl4ofWeOeU4En4x/28KNvuP4
8eqVEBxz/ZT6jsHHc7IlIid8JUSQZOnfrCp1aOZS83k+7edtXG/DPregKftfrj8j
l62Nz7Z0NgQqWIX0o3nZqSkJpsJ1xOWZwn7r8ZkINXi86kVfTib78dw7AHJ/eYmP
EzphP686XuIALmhztCiuUQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
SjavJE0yLrMxH8mfTDtcmnqY28BdqdvkStzA5W58RAWeriVQ8aKnHVZ+rLiIYPea
YIzs9oPtQ861YMVr9oBc0zF0dKHTVbY+unhFPNnbZ8YbzKFtkbrZ2bX8IGGkxwPT
KnbIVOPrGLOrKV2eDxFITNZrDTN6UsRPkDcUDKvB0bY=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
PyxlazKWSyCK7pq9JFq2pmFUAxwnlXW6AlT5wIZ24tOTmmyuBrUMsY9RbB6NSPDl
aKDvvKo53E+rhfrSFFxlZ+LJKUWUBNTbR9QVAcVT8pMZUx+IdlujiNP2/L9FbykN
JmZOLX7A6eb6SXscG4Is7fiYan1Hz+ZIYeJaVQe8ScAMo7YLNNFts9eQIFOZVIcv
wfWiaSceG0uo8K4OB03N/mj+PTxoW7xLGd+tmynpQjzajNwdApoLM7X0+EFogvTy
SX7k5bWD+YnpwKmUokG3Tub+Qb65UNNqiYw+NszXLfn1qwB0/WtmcqpLEXA2L9fU
LMQkaSsBS7bJoB0KdkcIOA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
isfxM8VepNsGRG5rVqmvjpBqwXlZcCI62B0Y6OXV8F7pnMPZFAxnpm349F9dqQCe
A2fY+rUBl1BCfPSTwaTW2EWXDOuMDLhcKwoh3u/+wsIe6OVA2ixQ3x50QQr1xiXl
yapmcY73/m7SHYazIQmfuVp18AQ4C3WkO3HW+c0K7X0lnGDOPGfgEOnjHpa07DCg
lYSLvExJbsk7R3k65FsiV1Yd5PioDo98269X8uamM15i4Wa8UzV52OGR52iQ6xfu
i5nbdZ67JmiJsc9Ehc5MY8cywU+YHH7n99qavTLUzj/GIIwhHnCynNo6LoSeK9KH
u0HWzmvuwcLEt3wDCP2O7w==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
HqsS340qJm58JsyU5vzyOKYlrJSbn/srvnfrrpGULf22FDpJASk7noYLRB0C4Tic
mO0cYstKAWz4xXcx0E67mS6nn4SAwBRtXo9iI0HdpjMG+UHiUkwabdqXbD+TXRji
4iuemhALxklvvrABYN5QMcjajTE0ynyFBmEhdD5ZOTCYcF+7xBtF9TTjVtN40yDV
fezDieCApfEB7jMZOXoixLdnItiOcoro8cC0PL1RmgcOpfC5qRHQMCp7KoQ1kohl
sUWzLHD0oHd5oYrOfrl7UTPdXSdNyAWXr03vVddY5spegd1ElMNhHJb3BC61qusi
0nqz05goJsAmU2kpYYi+qQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
SmzO6nRIUrYmKtEVeTGXL+0c5YCCjFe0he1PoupzJd45eWXFd1avJO02GT5p3v2F
MYaBgF9/zNKml/HbHgUf2LmQVqIrCrsE68Z1QpmhEIKvlP6bnbTbgCFj2CDURFJ5
cC1q/TjjUcxSPEuWb81V6QLa9X+y6R079mRdyr8HP1sTOGKwT1L+rswG/AI3dErn
RrI2i0FlxiEls+o+IionK5y7AsIXXNuE02wXbcwF4PKaUbEcz/k18cmF3p6TqQOW
N99Fd8oBG67O9J/sK6WU+lfIG9OgTBa5p81vH4eYdQdr/jLM6sdAJGeAERjiOkH1
eQ2ihz8/krF9Z/H3XzomKQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
SdeFuwuWaFX9bBqPhwudKxYZDVRnoBzZRyrMFe5BPRQqYkPxsbuXvYO0ff8mFTIF
/9ailmhvnScLgCMoBLG2g5Bgf7LkbEO9lwEcoAu5PHkLI1eql+8L63b1Z2lThAcb
s5sEVhsK2AZwCdKeX5aVBA3Gp2fzniuknncPQpDerMFpnNs7CY0PWSjhBVJPrGPU
e053bE1Vv1by8so6sa3nEEQtcUBLtXNSAI1etYd3cIMpFCTIBKAGOFtD5RHcpvEH
Nrqb/ORRNyYkTm2CLgOUiDhELK8Qf95wohUpAP8IMWwlMT61eoiBjlTPLcOOR7l3
aEqxCQ0gfcKhgf538wVjI24b8OqXeNELQYe+CQFaLJezsvP/lgJNOyfO4l0lvH5W
6AzYkLMaGsp3CSCpaxrpNCLz66VQpLqCa+HWKiSDFcOKTVE1ZYueHGvpdlVwrQg+
bCyqOwCtPfepOJUxNdkM0svyOMwBib8PlMFjq/X27/QkuWhajSpV2fFdjkZxCtHR
eu7kwkb3QvTEMTztycPWb6DgLjQoYg/V4w1FLiIIFWcYuWEUASUL+dRq7BxTfq1t
sO9zFqafGiKW2kOgqptElrfJcdezQ4hhu/FHcFuQwN+5EXcQaXsdZcY7MJUzd3Eq
z5iiE/MIWf5cRNMRzq3Pwt9FLNl5anfUX+gYOYS3mprjVgUjXaZ7N/lol913/dT4
SKuEV6XRQH6U9LpUUcUl3hzYf+GUr3UgdceS+6wUrmsVsEWLQaEOABtkJqL/BihB
viIrINFGn2YY+XfJcE6OJK3BOFhueINXcD9QQDTNKglOXnb048vCSgHYPBhwVrQc
70kmUdsBfwGGLPuDFZrrz0TxXaJpMwwr9flIJjVvxV7hmdtv4GNZEgC6nWJSM5Es
nm/UZQKQS0tsz1DTL8YRGEEkd2XjXXUeiq8YbT27ejY1hfrapHKLN6txJmluBHEf
rb9zxQ+YRthSZ4yJKWqcS6j0SKL2HrlOIyTtgPAmcRYiyKSvDQp5Blt2OdguYI16
GeH3cuHVgzGkkvEtGqw4wkWYPFI5jOalqQQmE4Sh6j3w+757JtGh+Ywk0q0kjTEm
De0ccjtI6z7G58hh+Kls2sFG3CwYKYUVQW0cOsebZCe6axhoJrQTA6rzkpoQ7K61
rVk3vixzm2Cp0Z1bAcVKsQ68tbTj5gGY9u6lL1TN1TEtYrOqv1XlGQFDf8Na4CgS
YjcHfkLvKCj3Smzj/yfyWZkCkyVapwpIKBcc90jJadgJMN8RT6Vz+0VffAgU5fyz

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
Kot0nu1LshTsbtYFWExKpu5ebxXtNkOIuLK2oVbaDFh/EWh6eKvDWCVg7myaG5Dr
BqTzdz1h5YkFl/FxnzN4R0NfLuY66SZ+DBwrSz5ebwOZktlK4f/RfxtgYxoDnC64
rg015I1ua+RfZUP62VQXBrC0eK6ewsYauy27cgq8mKY=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=2592)
`pragma protect data_block
z5w/qDIP4F1xNnMUYFLhChDp81Yr7cJfdtBBbIP8x9NVxu+fYIQZKINkUXEu9sxY
6Rdzr4KZ4sWo97aJ/ue9UrKG0hrgR6uuE6G3EQZ/u/W6V9TNb126XMO8Zys0O7yG
JD70eVnzpc75DWgWKJaXDiijdRcdq44mhVq0bmLNr4CWSnel8zXazgJ4/Cwfnbyx
hz25xIzYe25Tayx0+yeN04TxikPoXEWe/nhWglvuogweg6iXNNp3XHMPUupZx78U
GxPwpy+VzwL9mQ/4xMzO3I21zSwM3sn6nK0oW5aNzSvZ27qMFUH68NP3AKPi7xwQ
AFhBYIG/W2AVKaQff5D03c3X1hBTQue83Dfd2peMYoHnEUtCtD77rgZRCMLQZvoa
IwApsuD1tW/OX0moh8Y80CKpYbefpcQ0BUJ9hO6GGTkRHEUCrglUFhfJ8mSF6hE3
MZu6PP8rWOhzXX7BjCxYUXMF/P0zAQ4P5HBVgy150AyBt3eofusV9UYK0edOXjov
t2fdWnijFoqz5rA4BdKvCLxZOqC91Ulr6JmQcX79tE36TUMXcWs4vSDYn6BAVFOT
xYBhcAsW0I/1etMkWN6hL3mD511NRHMF/01+WhfxjQH/K3KACAGq5BG+n4hK912I
g+VBNPMBB7nxyPSXaRloixasoFynm2bcQTAdliLRJ3Mjc0WVcgxjUf4JgcIB1UeC
8jPXxGuoAl+FrOAw+ea/RwByc55k9rZ/F1+LwbZimce/ttdVWfQNVqlyJBTAn234
9V+fm3p1XzSZYiPXP5V5rM2B3mA3r2/JSzvLu+kQ2SmP7oC1ZxLfC/k9CjJ3LC4j
kQpqY2DIAdhtfZYB4BKcAkGoVAM3ME35aG5wRx+zr4yGss22zMqTeq/7C+ggK+V/
sGcKvPR5rwNJLy2OcoIuIvi6xiI2dMhr/cY7I1GuyOs2Rm+HD/vqwgCj87c7x9my
SwDj7FEFlz8afu3mMLyWR/mTfJTiXW5xX6++b5DGUW7o6BK1nGg7CbaiN+oCVhIR
CPI6XKzzKoJ5QYojQpfLNCMXwaq9848jMPzLiuQ67tRcATNYo2ELyflgLtRUqW8V
eGHqYjsMb5v/phjDsF2Q5TDrX6u0vK+Re0D0Xxxev2QlKvb427hvzRMR7eZ6CP4r
HGIuJpkNt43ij1ljMuI6h/PsEMEGoSTnLvquzChjl/DnYqtrRtbO7tG+0VxPngnG
7GJX2/uwJoN46G5x73SjeKcu7DUYE8Anm+tBTyO5/tDAk8E4QaluJKhYPq6P3C2s
lui7ATVz98vANAFSLTxk0HzfNEu/UM9kyQpSjvt3P8Jtj6ldS9KJH+4vGPob9iHg
AN1CHNIBZrlFv+ZC7jfI7GByLS2cJrH/5zJcSeHJj20nEcwKaLGsXOpN++gWFJYS
chV7HkHa38cNChn7ZY36BQit06pKtmhaTtDGWrqI392YDJBqQHEChDyseF2wr9pG
QRXGomZ4FreYtjOxKoBLROz7tNQDkERLsawXRji0wgvMfqSreT21IGmZ9gU9HL//
CQluK1+Ts6KqqSPxC2dQ2cZJds0N0Ukxx2Bjat+r9pXJUhl/82/YeMCO0plKYcr7
7HNxG2X6LCxkdHHk58mg77pV7AVzz2Z1o4v8LRftpyTBDAwYiHQX+FfgX62ad6jb
+mIdRnL2hnh7vsA0z9K9jcXKtKIGPWjaJuxwGxwYfH6d3JMpsp+EzgadwTWlc3Ig
88jL/l+ib5nYUqaKveqEdhcsJD06YLHw5nxd3AzkTuCiCio9gF6jr3HiYKjw1njV
SADsTeWHeFBQ0roIIqvwXW4UzTrlELs8clk9ObKH7w+/it2Acn5mHU6LXfStqfFU
7P/l4izCxeDSbWPxqXjEm3IqwcSw4ixKbRSPDXozAFBbaf9zL6lDQfiDYjz9m/12
0IjK7yn9m50Xg+PqxYwfdlLrp93vL4GXRxSIQ81c04E20fyNcM5N28fKEtKI17Z5
KXm8MhbLhP/f/bbgP2OAVv8ZLd0h5Z4DPYLCh00vPrvK9m/65xKPZaR9apGoP5cs
WKEDMBQqj2SMXpDDBxGyNizxc6zWNf5OtcMJNBCXiinZxAD9WfSu276ToMku5mwA
n2Rtn/qs0BzPPDf6RLxnckOJs8ESbGEpwuWpwRv3vqEoZR/dW6zuzGGdc7XqoEqW
sd1scrEP2hFEgHGjIb992JkQhqNwt2u19ADQt9n07fTK8i5tuzrywZO48QaCr6mm
bd3py9PQ9+mMTKjAy0+kHbopER1eeV3r5Knts86rQBdkey/4soV7dnfaj01libMi
SHrXp+Rx7gru79XERtKvDNYSITJcYNjmSGZlgFHdzE4GysD8tb+KKXwIkEeaCA7h
sPO44w4MG/6eXL512LOu3xOLIHe+KYAxVVnXVKYRJrWP5HTCx0/a24zCd4/RSoJc
akjNlh06UxlOQbY6+pNMdVY1Y+ll/J7dFvibQUzrRj33AfCFxZhrWJ2iEuDwbUnV
foLK0nziMoAEVX5Qb99uYpKSeSCP3PkMVIyy+94tLsTxoLC5PRimdcZMDQQryXDH
H6Xru+B87x42V7ccyYB8yqD2Mx5lOgUtl+A2DYtWPxzQuBjk22QJAnRJ+E7dsXAq
Iyk4hGMm8nUpU4V+DBBN+ziH/PaXzlwkITpXvBrXZBMkKYg6+agwxSgyC7qH2R/K
dYnLWlGLeUklZYqLYSKAcGkSfCq5Xluu8oXkbMzh3FJYGl/+ki69MNDBBECmhmsY
Pik+i4uRjqz9YZecjc6VhM9z0ssyNiKmS1YGS/Gd16wYXq90tJ67lIT9R+T4+3Nc
tXUH3eUsouDhLSblDwKHCUAhKLhxx6OBaKqjGDjS/ChP6e1HgtGYPCTBlX4if8d3
+fnPZghaXFU6VQzOZVELbbJKqKFdJgOkyvdnLjEvZCp6VDv6qsCi0sNJClU/yage
fmeY7iUkJoo5+ByZnQ5AkhU70m5mHj9ue1XCVNDxvYKsSegBc9ZmLgULMCoHalJm
O0dzEBJesBbNkK0YMPP5+zu3o4oXO4IkeFPrMP0pFqUAJ2bvZzILMF7/xpbbpOS2
Fs6rAXpXtrj+oUcB7hkfyKyAPTSvSy+wAJwWzrDN0NwJ9tgMZSbX0NJKvEp3ev+Q
tlNkUQeUg4ipDRggkh0/VdfaEhWrIKwMdijwmHLnzom+JbhMqC7vASFg3PdrLL2c
LICBtCYARszUJMWf1Bnu5QU6jaCdi+FypCbbdZTycENNzC3kYLC5dcpLjLxi3upE
0wu8GXgMDdOMJtY2EeeMEmYjf/eAbaHUs1wNhetBE0loM0aUAIb79/rYK98yUJXB
H05qNXcf4xNRX7fqEv52GAd+q/ZK1BfgEdZMbVkPNpeXuQknXPe3FhByp+2yGlu/
eOIppyFXIrAo1YEmcY0RIV+gkynZibHPW4k+hdjOIIDDk76Y4d6/mI05CudrK3cS

`pragma protect end_protected

endmodule
