//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module moving_avg #(
  parameter W_DATA         = 32,
  parameter MAX_AVG_FACTOR = 3
) (
  input               i_clk,
  input               i_rst,
  input  [       1:0] i_cfg_avg_fact,  

  input  [W_DATA-1:0] i_data,
  input               i_data_vld,

  output [W_DATA-1:0] o_data,
  output              o_data_vld
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
M/6HOMCV9uyF+fg3PdLIQfvMsWWJB64TGr5DgyLC9kA9ZUXbCk2WCCuGUEd65+Hq
O94XPm4YXYGjs/U6axX+MG4Vt7YygoOm24DxaPZxLEjzcp4ixdaJ/LXJ15gD7zQd
+brUgSdCuSWHv6vwgyTv3jvwI1czvWZoN/Cnto+O2D1J+NguwIXG3SxWzCF9hK1q
b8h8SWAruuzqt6YsGHKo2bNnUMukPbOpcMwuj6SV7DYh0R9WlfzbP2Z6cgiHbmle
6IhhgxA34OPjALxgxEUTZ0wKE+jMNnWxi5AgKhTXSPRwXL8yoFuKSYHGfgaOlxyK
wxSbC4Wq09RfDtaLR6Sy0w==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
rIkP0+ch0PSAkz6X6JBGf+cU0rGglr9gVjX99Ddnw/Pbo1LbwS8pq4kdJZmNI5WL
v3J8uIsxsAGol0W5mIzlBO1vjFT60Im3wm+RnsOtZJ/8MdzZwdJriSw2lAXpIJai
cOXIbwvYTtKnTxt1opLRBvLvKA8kobYmZQ3/AxA3ndA=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
Ag7+yBwVR8tekGA2Ifppr4cFKlBGSh3l4/6/otF0sc315suUHgxcnz01P0wLCGAP
zE3+X+T30XIfu+axa2ELzhz5cOK43uROD1LAQP/DoYjy2oQKuOBzK2UWbfv3gxi+
TrDhR+yH3/HAZzgCQHeUG0EvivNUvQYNLWki39btEiZoIwohkO5lXJ/Q2xuamHRo
PH9h6SVDt/8kM/ahmUTf4e3eyBVaGpmdYMnfK9iwH1DNdvCfxVhcSSBN+pwMb9dm
nphlU+0vVLfbKPv9W4SNM/wVn6qtkZKoIerEP7maiRIsvGk/EeJbrKcwn1VpmlgE
/yk4xXAafpw04Th88WSScA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
ZJ148eiY+07bE2gmn7b5rurtaxnc8/68ev/Fd7XAIwbRQW4FxuGLtUO1SmUgQfFe
L6kPk58pLuHUWdBA18UwdFO40RyC3x4IhjQqdGIEkp1o2JbFAHX+YFQt2VEqdK8p
XYrYyObESbwa7DAJpq1WVRQVyzOEMdlgvMCetElj49CzPsls9Z+WDggNPYwid0Ej
Q8ufmIoPC16E08y8tn9gCVTFKjLaV0+ekNS1hOfSEbXbNLjmEgLMWl3F9sxdT55T
g3o08mHhvS06tWsTLBlPetRysfsz2koZobUELp4FUlK/Vuo6dp6rqEBCL421v3cD
4ttH70/FdeMpay11ZunLRw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
goZKkBPXVAziohhN/N6plDUQdSlJptrl39Y7krx1JHyXu9l1xSX0gw8GmnfwsO1w
FLb/T5hjq8RDKFFPuJrQTPKuk2NQJQ2t9/3YWnebGyd7SFPc8Sy4361YtcrEBNof
LbF9KrjYuvH0X2hw5H0N9c7maA9IL3QGUqhn23uZi1JKDKxKkajfYZ1FZhEGXRde
Jfw1mHLB8wrIqA7veT3QFwzngpxSo5cy8c1WvP/3ejVsaKyDDwovwVsXSfkLX2pN
jvlvWKJegeTAjwGfc1cEtFuypdwL3Q8IP+aRC3XhRtWWjoLCF4SU5ij9PDNPUJmh
+cqoXsBbUNU0dxJNBYWUJw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
kSMomo+oMruH76TFsdNrFs4VC+WQ8o+ZoH/1kfl8/Fsm2x+fdTp/YJ3Gr+d/0FnP
n7eKts6oiS5eTbAxSo0tRcztca+BBKSmi23XnHPDVCAjk/xGdFUFZbwTPtfXU3tR
W7qekoLh4OpeKRVKD20Sdfn6UGStS648ys7s15/7rRCOnU8NrrV1Jq92fWB6N19K
bKWnU1NTfW0YgC7InyIbwpPS5ppLWUQh6miohiK3xtzAEA6IGwednRIPJQ2cEdHD
skxdWAaj6vEnHzsdJCw9dtNaC5fPdVjkBH19/ExT/HWeL2Sl2k4E/YfVWw6dPtxA
JRa0IxTQ1vqZfeby9jiLqQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
LzijpkFex01MvqlwK7JmUXsxcUWuoYi3OOTxX3PMkq+rQRZYCMoLRwDUgB5csUCO
QACaVpHfXO6vA+W9nfNhp4W2d7D7XXW5d8tvCB4jdZle/mqm7/2NA0X37a2IJBM4
Pu5UPBdDYyJIE3zOY93lRKJl9idZGL8F795XROALM33a5/6BU0W0eK3UidZR4K03
iAaGpMqdcWmKDznMh5f1FR0bgZj3Nu71ri0m8GYjDSvHfyxkA/I4em+KbzJURUyD
ikcJf5AtROQGdOs9bgP5izixClmy133Ouy+NSCCn66L5XQk1hZf/J93p7HEQ+boK
WNQo64tx5Ya5GIpP1SScG/2VMhOXW7FrKdWksyv2c1CzzBYfVLnrfSzTdWsGFI8C
wUK91asQX/e1+KD9/cJFuBVwZJ7/cYo2WahQngFar71bX0CvUoeYNDHUhggROfMD
tEDqDn/XjsCeXNPRwMu+a9uvOnTvItkYy32Jl4OlhSCWP1I6ovR4rncnhDjsz25z
5OJ8rgwaVrEAINfIBm4+3/PnvqvSPULa9o0mslR0Y55VNCS6FpaMmTub1CP/q9hk
J80N31UBsxLfzS8izqmZToyK76w0fHiJXhbXUkmZ8cIDj1bwqSfT3DqxvHABHO7p
rW7oIkcjQhocbdv+NmRolAsx/s4oSF6pucZYtC15oFwPpvolKMsAx6CJGfuHBMwQ
A8KR0Mrl+GlTUYkxN4qh/MD2ZpUrZJXXNymPSasNR7PeUrTL9jfiguFvAQAWZueb
oBN1IGCzaXqPJL/qmwbP4a2veWkJCeoYW1WIcnY13hmq2D/HV2win80y41dPVToF
6IB3FzSnxIUdDRmZuZPWcNNxrbwOeZWMPqYCaR1BH+Ai85dFqiKvlf6rUdpbOVpo
eSLHRhQPqQOWtXlgmk3B/Skx6GpP3/qwR8FedPd+wY8CdVt8gzgz3PKUeHV8qucP
rMKzlkrwNOPoaKTeC3gSr0jMldOfeC7cMLSzUH5UpqB2NSLGeiJ0MLpNm9lBphct
Mv2czc2nqtXtnJydmO8yDcpvaqU/aPlA13DokyM2DdpLYezN74NvetjrGqbE25eA
Yf6Gl+VIGcUw4oV6bji6VpnkaXERYn9LmZIZWJgQxes3AEr4tks0fK7cLG9GGJX4
9G7vuYMGr8i8Mo9FOONJJCEFwqSzDzPb9pQdZMh0axzZldlIsmoI8+h9LHxSJ/lo
KYbIfFsIxGLkEIMJP91FUucL1AH6obGO01UtlkXE42tbM0Q3z7V4JXn69sz6VaWT

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
pZZ40i7DXW0bUNtYfjYvrO2X+GTId9yHglJiHOteYuty/nKM+b5bbXqs4FbNLL17
vvjEggL6DZWvl0kYEQYVtTd7YYY0iCj9u/Q+dhQpoYd5fEBfhVMicEkMRwFYHjWT
5X9ebJBvSlbDJoS4nIbalGSxhSVLMuMO6i+6pHMyjOo=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=3760)
`pragma protect data_block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`pragma protect end_protected

endmodule
