//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


// MIXED WIDTH Buffer, DIN < DOUT and DOUT/DIN must be an integer
module mixed_width_buf #(
  parameter DIN_WIDTH   = 8,                // bit width of input data
  parameter DOUT_WIDTH  = 32               // bit width of output data
)(

  input  wire                  clk,
  input  wire                  rst,

  input  wire [DIN_WIDTH-1:0]  din,
  input  wire                  din_en,
  input  wire                  last,
  output      [DOUT_WIDTH-1:0] dout,
  output logic                 dout_valid   // Only valid for 1 cycle
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
X9DVY5foLzIn36AZICpJB9yg90gcA9+qeSfVlOV2sZhM6NViKeaXmQci0Zh7sdcT
hb+QnI825C1Dmm1374lLF9mD18Ep9yFcr5yahXWwTjE5tG+RuUDlAEpcPtS7Njdn
4Z5WDgguVzI4aOMo23FSa3brcabmoWsz3BAAyKxfVKXZ0r6UtmtIkydJVpLnuCF9
6oAefcO3MfJ6eFr/uvCbil0cacoD9SpLxw4O+caBhLwfzzcPp/TOemIvl2Bvo63a
lZvvb0LMG+sQsGAg1jvCIPQUhEdulH1KoekQuicw3AXvgpw+I1cv0Wp8oUN9/mkI
ROT8hkD5u7tI4XwUOqVvoQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
TlYVIzWlIhsLuiAiNaa7WzaYe6W/914keirTOk8FLD1Mfp+qaJWcmEnLcUDFwT0F
ocPy+8ZZPlqLktfLmdxWa2ysWJGx0cTLu6jPkTILvCeN3H38CRG4/OIldCVL68rm
AcAGQzVwlZ6ar3YR/OoYDHtXQR+AFZvES7wx5oJgJj8=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
ydYnE/4S/RHYQZtSOb9+tljxxXDOkCbkphLLtUsyz7ECnm2YRRZdLd7SS+h0sF1K
l/d1kLgfX5Ks+r01tdoxLN5MI8uwiGTe2spyLEZYa8MG4VarJC1P72evLgXem+B4
82u20+xkMngFHWS6CoCGJvIiYk3WPMWAeaAkAamWqwKoyXvy55HTsF1vyvHMYVcK
ncwJ2/kC0PEwJkzEGOQXMu3mtKWOjuwtj7phxIjByg5QpSYxrvrQAc2BPpYtBjVo
Baa2UPRdtZchASFOXAihccbc1okoYFJ1njDbpSXx8mbtgdGKLl/R/tD8eV3JF1rM
fUMN+6XSLnq2HVqBT4Qj9w==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
Q5Nrl82rqNTsScvKtOW1t2kL74INnnFp3hEHgEaQhpFfJ/ihMHJcoiRZKwmGirrV
lUj+jO7Sy7eKLSXDv7N2DE/BycMywUQQtcLcWS1UP0D3WtOWbu+7VoomFfD8SKrZ
MLXMh7uAfPMLWfTjTuuqVSE0GJA/MUB5xwLmqJ2WUbt8v20AMwHMrSO4qMveZCru
09Mjx810QW179Ng6E9D11BvY1bkM8pP+CY/NQmyfJcPVg27Jl/bRFs16sFsec3Ws
wS+gcleP49krpYRGfE7oMiGDNZaG3M+8dkwjXcR8Kb2BY2dNWEf4lUZAuLpxd94c
fe1WI679+JJ+MQGa8ZxtyQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
W8JgG3c4YBlffVbd+AW3IsnT2y6rcdvDPdRRUTCiuH7/Alip8C/zfK1iquPIiahj
+najW9UbXsFLOGd/OGVig7m/4dZkzUKoCBU5HbNPfrtcADhoeSv7jSSYbqSjlsz6
b9C1WhF8Lj0tG2DP2XjHsiabycLh4oXMB45ypzTziRedbguRAmdb3VIVn3qQ+bb3
RFam8PE9xBRKds/wFxy2TpyJprvv2jo26DqxpsxeciSm942gaAGhNW+CHkIZ0TJz
NGI57LysQ2L/B/rB9N4Rg/ygF7Xkj4hyYZnzgShNQSok9h4OHxauRLfOrDrtsW0c
pBkcX7ENDX8ioBaUNbuOpA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
qo/7s1u+gv/3NoxPWL16ZEW7llspXsSO6Qc5f8s7bONjBchRueQ6g9ngvfR3GWQp
hsOaUgNWiB0JczSIWFwtFx1kiqjhSzQx8nuWcrHbGwxWGdmeerRCOXhUR7joFcBz
2FvopEdIgTLqcZXzYTpBx8/N6GrqAWbdiVVGxO7OFVnSVw1ke/w9OSyJAOc5vHMg
9ln7XSjk8nunSzjI2KqdcDMGbkL5jgrgdSDPI39KfoY2GetvtSWv9bdLCoNkENjV
vWRY773DkNyl3NGNXdgjIrWTaCQb3Tr3GKlnCocDGVCjwkyvihjJm4WB1UKP54eV
n3QbVqBn1l8AGZBAX2Om9g==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
Jo2A2uF9hOQlhCjVcDdKSAfGkTr8N0gjfKL17iA5BtAu0d+Eqko/pGvIn77JmqSu
iRZHVjkzyQVJ0W8WJO3gFTu0fkJhuBgkfWt1EU8IvzmFDp09kX63YAwH2cmajlE7
OkSWfA0WI/LeXKx6Xb9j/JXVbER3jWmCMK4JpLzocyJxikMXO2RLLR3jAz2k+cFA
6CyypCP1VvRwbhICpDe/47UlDEk5ojokbykh9dRpCobBEn21YAEzwZTXcQ6TvcJ0
4SELjcXT+JS56ZeqPo/h820ZWmGPu32LJteJk+t3aba73SmKdx/+/l811n0DeAqi
UHmxJztWZ8Iyzv7leg8k6C0h8bU27PrDVBR4CXP4cMIE5g9FOQa3asx4a6sI2axh
ryuLXfKvN6JoHtJv9jy0u/57rOt92b86hhEUsCrpEJdd+WeMvZz39T0QS2KGxzvJ
kUaRbzDvuRM8toRjsq/9wyElal+rGkGqabHiA5ott4+2Bjr43fT0kGy/MTxc0Xs2
hOVV22Wuswn0NSH6158a1HuSprpdpIuWvgOUKhr6AEtxvtQYRg0AHKG9Yp/oF85t
J0zBh2gwO2OPQtVObLvyhWcmSQO8voqMjthUn831eysXnPSMfFgVNVZmZ3w3EZls
pI4m45ZIclUBqjZg+8OiaxVXJ7lT65Y0YK8OyzruHLF8SbPIxtka6Xc0ZdTH7CHq
mF9nAGn02j4tNJ7Geo7Ho9SM4RJ1pU24O9GZrnToXXk/N/6fWyCsKhtcAALwdqwn
DbkE0mwpDQ5Erc3CJElioTP6nBJ1RsO01j//UHL8HzGrrGnLw29ljXfOYBRuw9re
ij3X8V5Ir7pVzR5R2Nc/w6i73VnundD1ctrlKFnFPWlwdlsq7Dme1OhJR6fPGg4P
Ip0V5zkwJ7sEwBRNI6uazpznB7nLR2e5rgxx5nTM8HgtR87b/D9eDGNAtARbQ7wb
0r1N0N3xXfjCZN9KS2V/1kzLbhXOgkmAI/vOGNEEGJxkHpDAE0EwfEWe1XcQXlu0
BkOQmg8zw3XDsliLnfdPI3tDL8yG94si2rPRYp3fywltj5k4+OYFSvz6CT7LzjDA
Urm2yerDL3OCG3iV8zzy25QPihxqIBPw3GqBPRTnl12kD4nKeYf8tSNwtKxr2A3q
W32Yi8JVnZhGqCUWxRO5aKhjZ576AJn9i1VifHy4dtwQEiNTdaCqVZ7+r0ElM216
5sViWzMOdxqY/i8CFBCBt1MY6skPUObzwUF/1d7NFemgh2JKglRJY3/9K0JpsVFb

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
m1coao/szzVRlOO7urngTmgA4CUQAmJBDrzPSstHgf1tteddSTwGZvy9/i2LAFPC
Liw0v+ZJZvjftT06jCKxb9NuJ2p5iXSb8VysD1WoOwlSixW+8sWAA2SHGDfZPJ+L
AR6YgLkeHGPOyKlojXV8b7kEMsTfcmS8d986yPb/RWY=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=1024)
`pragma protect data_block
HG48v30rXqp89UqMDnMbpufBzSXWFN3P11jnmpzDA20k9B7ZP97sC7AccixMzQCj
6MzXOnWeTtE+PAOBpTgE+HdGlMe2ki4VAzJHxCa0u8EqWr4m3Pk/TK1ZbAFa+0fJ
3aXjfuKmTDpMAFtXzBFiZhqOTQ/t6wgJeJ5mE5j8xZ1XgolH3dwDCgII3yDdTP2F
9nINwMG9y/ogJPTpBXKWABdWqBfZYrh2Yj0avQyMuGz5lXy3mSjVG1dIL5mutW0s
BqG+sksdIlUxAaqOp4BlQ/dvStzwn/cRckQWIR/cRhSvRul7XPgdk8K+aNIHrdvG
fdQm88DfWRGajMqEarWJrJn7mY6KvxtG06btvIltIu20DyJ6GMq8FY7ogTwwxs9U
+Xc8dQG9epbrl8+zrIzPJ7ZADhIGbxQ0aBnfUQau+twbMmKgPv8D1mKLYmt1Rxs8
BunHyRzn5EMrkMhx63VCLWqe4KQWiqwbt1lniLe+yKeYro6ZB0uUtsJRS0qV3JpG
rj5h4S8LagPAviAYhs7tOQ+WeyvBX1d5wBEsJcyZFFm3yLvG+vVtp+w+qEWhpgoq
IjLWANchEAeSiKkyziTTEbTvv/7DHDks5FqRwNZuQ8PGV6ypC278EMjs7mgAwu0t
dZogmwVa0ScIVrE2qhs4e0tZJgSXLI4lSP5Fv8p7XWTNDnZl9UwS4Lv5kSHRTMcB
6rqdpPsDpDk7mu6Y+77OvXXDmWcD9IBmxP61qHaxQyAU/nvZaVMwhNOFdYvIv3u7
7aB0WzlX6rdTJAKXKgSulO/ZDK0Fc4UF/Btzhfjh02xeG9fSJcVQiErU0aP9bThd
Nw5LnHUJ6xiBu378Xw8Nb5RWAJXQka/cynnv6ySsNw9NLvEq+yMb4RkvljS2zAjz
kaQLkxNh6mWS4oN5/AJEVaFXsz4etZYCRKR4Q0h5OGyg/7BM6k8Uvvch4JEOwc+b
anBIsAlEL2x08TiFgd2Yz4E1EPPAGQkESETiChQssZYr28rOF5OGFdZUSJ/pyo41
wvVppQoBSDjXUqmR62x6iKR7qLvfgEjcgmEnJfZh/96YTVsCv0mbs6OQGEEwzRRt
SpR+7lvvSn+fdzaaTIp6+8+326F6aubDqg8azhfu6Ev031JPud5jOY3BO9i5ohhf
hZalRPbZHlJ753tY4iFjTNpPRpSv84n7F5V5FziaZXALFFtaRoj1rvhfv29BzLfP
HbQ2fcoHja4maJm9d8SkKvRVeLTh2x0CRdDBr51yrjIZ6/1vlpogCYUSQQrxUYRd
LVA06hCNTxP7zhQfvEalZKFMm1hmtJ2goV/xmaN66r062XlEF+k3Kmoz4J5DO5mv
o58LIMaIMZJjyAsQqxWhwA==

`pragma protect end_protected

endmodule
