//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


// synchronizer and configurable glitch filter

module glitch_filter #(
  parameter DATA_WIDTH    = 1, 
  parameter RESET_VALUE   = 1'b0, 
  parameter FILTER_DEPTH  = 4
) (
  input                         clk,
  input                         rst_n,
  input      [DATA_WIDTH-1:0]   sync_in,
  output reg [DATA_WIDTH-1:0]   sync_out
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
LE5Cjh6UburQh49UNYfgsYxXiVTr4tZUvz6DEXnWYXzq38jKuheRnPjftkyb0ucr
67pFhB3rXsdORMmBrLb5s/uGBHKIrKEHb7DHb6p3l3cT1a3OWPcNqDIASzOxpxDa
cfYmLolZ50KjDRam5+cqAMCgAiSsHbsMmflDtli+aG5QpaOMcVpw7PuFeVEtKPYs
iSturnv89i3mgmqWQKawzFKng/E7A9JgT7Un09+xDUdyHDij5zbfWNZc5ix19HgF
RNNPHiaI/x5AZfH0OCxgq/Wbg6nF03+xRcPF8sbC7KVEaKASCUr60wp5LUXLohrL
9b22xhQR/Foy1+hx5jhAoQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
yXwouT1/WQ1gOfqzPLRSHF4BakmrOFbPhs3d4Xhr/fCIv7uLX0pwuf5cqjwTP8y/
JCJ0xaJ1ZiyehYrW6pzp7osF/GNTDBEhP7ImuHVb2Fjt9Rg9a+SupFymICpGQUWL
vCZoP20UxDPD2Jzwewhoh8Xk0Pxs8xaigyhfjG4p8cE=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
DwK0OvG/9L9At3KYo9F368ee/I4ZsqZooZrBNFSKCQ31kLRB/zobgpb31+cNyuDY
S2cMveqhNhErbchh+FLS+w95ZRhG7+qjptcKTKGc+XEAYlI754oqAv2Copp6/W+Y
7YAxCR6X5DoJJ9k59wvp3BStW56Obcnr0atTfOCa1cUtWhc+rLKGLvJQYM5mTZdT
TaslhGaTdAbF7qsTEHSzB5aWfLUilyD21r+aSPSGf38SjFJFS6wQkWQNjS8oiCpv
+eZQ44ivPmFIWHkD2ys7s2I8fM0F6lCmKnIiYvQ3GhQiEN0kRu3Jj4qVUcJdk8n2
/mIYocSyZ8rfchgJ0fB9LQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
PmlvnnLvhMGET9WOlNgIUOYnewzpmWrqFJSEAxsvheEnvucQd6t/VPuOB0Z1CWFh
aY7zEqzGFCvG3dt+iYPLP6mAhF6xcFuH8WG09wP5fl/PcDrRL5H5EFqWXJGi3Z08
9yIRyLHKr/zSzBYo/pzKt3Eiq09QaOyG8vMFQncaXSdZYwkfYieza4AUHGTCh/KJ
gVIRtSXa4tQx3ui4/F0Y92Uw3saUUp5Qj8htGPMhqrECmTLnbLJsrvzkMzsmumrO
79Fh80P4F1nUiLvH/xLaGryJmNVUYcPT+mM8ztdxIqcOhqy8WgI/ITw3sQYLZKmW
HdYEckOXmXOaakDaVqYXnA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
XghfLHuDFyjp/jLuOmxmgvLOqW9M/908QTJOJcG9IiOK4+BlCho6g+w9O6DM6QqD
frp/HItu1ZMHma6Fr64KWnfhcEiW/QvJWXU1sYMVqIoy3Pit/LVVr4RVmzG1d+qK
mXNuJr9+1AykAcfIhQzZgga3gbeluF+U6FW9JcSNHG7NwOb5p2nv7q2oV2tiD8tX
hnAY5AfvH19x9xisSz2rYUy4FppGfiHQY9l2U8P+a981AADGG8Sn2SvIP2RxDqCh
OSJGyJFa3w+oobEhF0PpSrsa5duWspIwPOVWQq26GSmj/lO3Fzo6tbTjXgd/6+0C
moC4Dm/4jtjq4cZHkdHniA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
NSP4sE984KOwKubqa9ks65pglKzaegL7u1h7c3PC5/BTYxRshFGRGqil3JHqna+j
wzTZf+99TvnAicstHJPtGfWzn4hA+pJ1IxYr/mv0ZrSv6FMjOeG8Dzd2MR0q+1TX
REMNcRgEh+AABipi1wHUVtXcS5ajSGTyzR0AIMF/SoLZ45a74BwRw+VRimKxRn7b
p9tdh1ae1y7Jx9k5ViwXJe1Zs+/P+71enKUwviUiPsN4pJJFusVQQOaKFUCZ0kx0
mX79QrilEMIropQ1FGRyLLB3L2hlKRnjE+g5JTDy2MzuEUfRAOzJsd9xeIxWzjIG
8Yb8A4tnOpc4NALhKucOKA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
xDDUwVQrC21hE5d3bZrrFG9CrKW0+Fct4/W7boqxixP3SeyqugmNhaqUA6Q6y62X
kRHb1lDqtgIt3Vb0wAYavXcJtDFfDyOPUqlzIPz7KpeXZDSFjZLwBCZF1m7LAhNy
BxLKUnxXr5J69yp9ZCjvqqqx5S6HI4ZYZNZgA9N8XNUBSJSIXI/FVUc3a6WcnBfo
S5EVY00U2szj+nMfkpjzf/63CrSUSlKdpAVQoFWpk4Ybzy8GH6i1aj+5tB9GN7yI
v4iM4VfBXjClCCsEhzmrbo0JCN33MXsiN9kGzlCIscx9kxK3OKmj3Rv7DiqPKgkc
3W9ZEa4cKn8wqE/yEdxRxncG602jIj17OPafKP0Hr3HwzbN2V5tnmkAEcSNoF73N
qJpfWb7Y+FhsRGx10L2FsFY+N3KWzvSgeXWQkGIbGcynGY+oZ7q31GfTCUTD2h6m
F3rC2r0zG1O7VR5EoTEPNTWxB4hLdRXpksc8z9r2MTRtxlQLKyaHSt6GOXv6cLnn
ZOZ7LH9LSrJVzp4M0Sp+LGUOSVuiVnioc9xnPY/ic7n2NCAcjTyV0Qnj/NM8J+rj
OfKh3CXUBuIlUrs4eGt45aJXVEjc9S0hKIA7VRbF0TsjKkiyZxUWoU0td9JKA+Lj
FHdFS/B0/r9fTuAXwsjB6MfFzy2MmFVsIJvuakwxMQNvsLkLJmoY+HQDOcP72Xvh
fW7cN8cfP3GtsZb8qYAjaxeYqBXYuMlsFneCR+WLsAyx7oW589CUmdMi+6CeYK9X
ebkWrJG4S1Ob2AnkeIOxoU7mIY6XySHxt4S5gL0aE0B0geYzmS+kwDMB2fWCMZ9s
a1ZxbBfWULlBa6l/5cdnxzKt9NUq2XhTLxeuQSDOKaUeVLeE+nNreMMFR+UeOhUi
tnfhFAvm+RIxsByz04nWKg3SJ19OZHEC5bnd+h99Qq0ytSVg4Ta6Ey27T2A1gh6x
6TVPXpzMPchinC83tgghy/0Ja4OMzy1kzaKgEIRL9ULADSR/VFsPEPi5Nqh1TGOq
RLQunKCAGgYoe2tvfnIUXwcRhaw7jRKBxjVFJS34DufOtPLdzyyrhUFzNlGtfrbN
CNt47jpnXoAYu/OzgFVp9blI2CJDhw+739J58s/8ZlPDdSdSn75D848R9n/w81/I
ckqx3d93QVZccVCR4NQOsyCnZpPALo3aJz5g4rsJNjWItZkfXfPdEflsxBORtCoT
DQ9FUs2nF2fqsTGvga+GxLlBxdCxBT2pXJOHIeHJU2e2KBfZYQ7SoaZHbFx4Jbjv

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
B/cT+8RCSDxQoa6EbmxL2bKOKpULDfIsIFZ41uiTTXTFh6SKr/P6qpPg4dqqORBX
RryEkhgpnCUyd9XSFxNyvIZsUtO3mLelegY5rRYWxb4njgqyPfZei+Sdeo7rTRc3
p8hffXHNE6avv/0603ITKRarq2gCUrDRS/hTrjO7OWY=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=736)
`pragma protect data_block
FZH67UK10+ESapPeO5p1c+1lZDZ7OVd1UQXLWwxAOP40JFAWam7na+6Q3UIAipUe
S15smdUaBEGyRvst8HCVUFRY2GlkHOBTy3cgDXt2TR3YodOVhj8TkmfMp1DUc8vo
60nFrlFNuHvIvWzCO+cVzCKxB00HqDmgMRkXFIbWWLohMs4rROlb9nj8VZnEcRbG
LRIYBWL9jK4tEOEK75Y8WdkKqZoJd4G8MF2QVjSeeO/hXpCaX0zxfQslKkeyZC46
AhFH6ILxLCu8qO+beWBrW1a1je88yKpuC/enbkEWQOk3cWK2GGoMI/RqyYcQwuP1
hZeo6SNM87S2YyDrXhZmZ+Cf2T7uxvqgA/MEqM54xqJojOQGtzz0Hk6j52gACaSu
QXfVCQhtBauigrjPrr8htStD+E4u9S8QHhh7Eto5sM4eeZffuKKavhXr4HlPHEfH
BdHyWl9FM+kLvvnRGXX7oWg/n//9yQZrp1LGcynz2Yc0DA7Ed8Tu6dOCzYbO+mL4
bNh0IfCJOp1/M556h4nBjFmqM6zdovscwfMVDRXZHXjGKXut5kpdHZXHeem2w4+e
H4yQGdeJj0hXOu8D3EdYAliCvSEbcdIAoWLii9t8tPzBOJzrX9SINkBzzLpat0Pj
7mYnLppkB2J26avyKaM+8wDVWYMF36AsVVYnQKRZJjQf/K92/P1pekjAxSMPfdca
Jhpiv7JYhyAGFDdHrdmUE2NfvA6UeYE7FZP38uUCWFiL1LivJDVKuVa9ijH0ko/g
BIEBn6kXcF0ASfi1HGjQ29Q0qHNre4MhoAx/xhTsGi8kXTo+Ps4odX1N9epjNPdc
/wkH1hDpgI+JQ47SHwhMzZmYkZS56znvr4KJjrIi/T0wa2CccIcI9ev5uWVZjGr0
Lm2iY/iJoNzxst6jm2r9NcmttmgnWMX0uSKQF/riyBGqCmU41LeussEUntJV3RTe
GRdwMSpKZeEOqD6vEp5qEQ==

`pragma protect end_protected

endmodule
