//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module dp_ram #(
  parameter DATA_WIDTH = 32,                // bit width of data
  parameter RAM_DEPTH  = 256,               // bit width of internal ram addressing
  parameter ADDR_WIDTH = $clog2(RAM_DEPTH), // bit width of address
  parameter RAM_TYPE   = "SIMPLE",          // "SIMPLE" or "TRUE"
  parameter RAM_STYLE  = "AUTO"             // "LUT" / "BLOCK" / "AUTO"
)(
  // Port A
  input  wire                  clk_a,
  input  wire                  en_a,
  input  wire                  we_a,
  input  wire [DATA_WIDTH-1:0] din_a,
  input  wire [ADDR_WIDTH-1:0] addr_a,
  output      [DATA_WIDTH-1:0] dout_a,
  // Port B
  input  wire                  clk_b,
  input  wire                  en_b,
  input  wire                  we_b,
  input  wire [DATA_WIDTH-1:0] din_b,
  input  wire [ADDR_WIDTH-1:0] addr_b,
  output      [DATA_WIDTH-1:0] dout_b
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
RDjpC8C6YJP+R58G41zwFwNpDSaKtCccJZBzilUebjA+abfcauD2hf5zofoxM+1V
FXl9EKjrCyv9thOp6FtjAEkDA/BMsnuajI+NoRq6XcLE3efPl9PfPl/qiLHKMMIu
6ijQtMvjw7wv3ozLrDPb66y1zN8e3tEdG3F/koz7JK2PzF9xJgZUhghdfms/l5YI
FAV520K/b/qVhIwnTixAoSrvNTOkWP/c88c9O73panxkBwp9njk99ZBRJhFeC1ie
QYxoc0bdaohtguQHFKUufssO6mXBkXRJsRPbQvp86/b9DwODMYhWaVBRmW6g7FH1
6vSWz0tYW/04vwmMNTXnbw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
XRBG8K1eVm9zknpcxr2kGYKXY1nKKoERC6fD3/DFDDYhwV0lhEi9672Tq0gWmkkK
HQY3VAMQDJz1i3JqEY3WgkfpIsbvmj2HmU3km3udw/nJjehKYb90l6R3GZcsI4hG
WwWnh1i8dOqYxUpqGUJCpSzuuKrqkXUTpG/mXMurQVw=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
kDK7JorJmUzQaPdzi6PWgCPu5ktxbDik3G4u/BANi8wX4wprzYUcVZ9YgZ1zvR9w
AlzXLY++WK3SkTkzG/t9cKj3oPIs8WT8zOMLR6G/qKpvg3EvbpYOPm1Q+gDRVQIa
3HpfVHtZh923MZVJ/jQMNEYQj5nIiPbTobJK6EIBQlEZ1WaFf4sJu8rvPVGTysHO
a7SArw5nNMJKVE3zX1qaAFZ6+ZiSLiqnnn9y9DaqeA480IAzVsSC1IEDTJ+zysZy
x9iS9zx//vaFdZOc4qu8fIe7THxYO9eicEoZckAPU5CeZRoP+r2k947nMk2gbUC9
R55CY4Guv2rYGAdL+dvGBQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
Co4Vl7oIyeZWfh2e/pwjMhwYM1r4/wwxHxDuRDoyvAUsl518WB2LJNVLTzRvewCy
YhzDOQjFwwbBhR25S7M8Xomb+F63ql5JgwUDkyzfvgd29EEc0NfQYtwIULtXvM1s
QcW10/LLOQpYgZ8cle4Fem8XnxgAy+naKvdrhjlmNBTa24aKHpQHMDb2Qt051VsP
E9ZRXarGIbjFuN9QuxGO5/BGKgByNHMfhGITMvS3e2GDLrLHsUkD/ymUrrR8GmOM
DBvgDpYfV6LT/Zzd9k+OhL79I/Ztu1hmVdhHvGvh5favG6N8AIizJNJ9SVOwp40n
ax5KxnYEoyds/QgV6KZmFQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
HYpQcBj2ZuvUtNBvVpa+GT1qaeQHkeIeNIMyQoOEYTWU2zM0txfYA6SFDVOwQqXT
ZiYOwvSWkoaWf/STGWXh1504iOjjrl1v06liM1GESsDkzK28uq5HRhxdQH0o33a/
YMDBklI4XpUhSLq4jR5O8Ew/eFxTvt7ilb1eNKBl4tWJGO8wgjAr3xH8+37Zghq8
sYCjpDjAcSkJTGh04fus87JoVRdWCrMNgg8giRbCRgDeKV3UsLK/yutpGDlGaz0r
MH3BE+Et0m9rOVG/TsYzfAwBcInv97km2GFh1gPKk2CXEA0MTsSgZY0jg1nV4vMQ
0Acb0NVuWZPCiSBOTZVRAw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
IHCJF2hkHnq1YsdwGxUTRbJT0AnIB3ndcI3EiBKepQsUTSTfPRs0iv7aDH2SZ+Tf
enHTLD1DO69P4GheJgAuH/EOj0HSpqp2WKUPDQAk/Wfi/eyHalRE3knB8NTQtoJ8
48u/LEueT/CLDei231PMDdgmbRfunrS58PMi+zpiLrcn1IwN6zcD+KFobWh2PSgA
GXtY+bJb6W/ZrM+DZ0jeFg7iGBdO8ii1pjoZPO7YDaCNU4xPX7bpydKUcMtB6x7C
i4yxda1HRbazYQ/KHb1TXfKeoADvDOgJVGYskj7n50EUy12qS5m01hFWTwxsJAWg
RhwxD+QxTLXiyaw+WILAWA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
bVwy8Q7plRJjj3KtDbvkbgD7ZN6d92SJTT4XzMafMhZqb4ZoAEdvhQocwc8W+CyM
UNbgEbhyjk29ua6ZXQ/jS9iGI06Angk5HKpbc/Ebo5Owux5+18faLiQmVLH8YgRz
tU03xOpXdH5gzlSmS8Iyh/FcoGN4VUfySQL/JlC+nhV5xq6N5x/TKRpDIVtHrqns
NrkdfCJaY9nsL2tNWVrwFr/IbWAYAluKUWQDlRLlVlNeIS9ofGrhIeOgYFTE9ISz
LzbLSRowGjdTj/8iy+2lk8LdRV2t8MzTCncDrORIGbzXKL7ngj+yS8+ewqFItXx9
31JbIV+sam534IyKbOlnKygrq3SKQcSDPYV6NFH/uKHZj2qkrhham9GEPbW6/vIK
g94nzvxGoYZjchXhgXk6ckx2poTQkb9+WFCkgl842qQ2EgPpkOD2CGhmm9z+eFt6
vr7spmp6UwIiiu4FO6o/9n4kIoLyFpUrv5iolVBvEZwZKOIupr4cFsDZmh58Bgne
831Il/2pXvLL/NBQ4/jmwvoyDTjGC4XbOgj0JZAR9+aQmrweIZ1a6uTHkmJQ2L0H
aaU9WOX1p3URmkVfF82itu4UBhXNvUme5riiaBCsStQKx/oFLa1K3TXmDi9LSc1D
gw+VD4tW4vJOD2ewwciwIk0SeitX7JvnvfutLpyPitat/XOmPK8bmiHad47TA2c4
EOruRR3rb6g4g81UCFDBK8Gtoxu3QMbpEnS7v34d4zvv8O3uq2lwV7nw76fBSMoA
MWQMqqBTkizLy0ORCg0cYhYdNB0a9Bo6CaqgXGZzn1Bi9nF2bJ2TOfVa4/OKFiaz
cpdztFjHbl5fN3bQseon1OubW22NdKkMym9XYHSvzs2IR/tRjRU4RsIlljJPKoyi
Cu5jxe0UAiHcGf3ZmPZ58dsZVk/4duBfN/x38SyxTnteyXP7viO3q2HATWYjWkW8
ISpdjf/qpQm62jnvOkCTsgsIP2AJqGchUW/Xn7s3ZmbjmuaRfMxku3Y9R7ZFHQ6g
Lw6L8xtU7STfwr5mVvaPHA+SXnnvNjyMK2j4nr86ZvCqe7SAIwvOBfdoWObbmC9/
Q2Ldj6Ewi8Mn6Xa2kSkWe5abYe8HQ8sytScjG28cDvhMNQLYzljUBGKei12sCNzU
IqhmZwjyBWYAlvtyeNydQcK6DSsLcm/bDNs0n4kGNWF1nH5u2VVKLD1G4LvQshtk
KaBfKKpdMtUBgcB1YJrSUO4ctVGBG6+foE7X6DGpsVhbrfkpqarojn3y1TdvUDjX

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
j9Jlgf1x2r4pXEXwUHPEcbgcaCpXCxLLTK8tt6NGdd5HjAizXh1kIcmAts1VATxX
10lhHgb1LKjVStmBz+VUN0q2HruATvYYtt8xmTVNi+BeOw1llKKXVmiiILUdVFgq
lqJqAj8g18o0rqSdjrMQhr+M0gran5tHNC4mkVM+Ap0=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=3424)
`pragma protect data_block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`pragma protect end_protected

endmodule
