//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


`include "HOLOLINK_def.svh"
module dc_fifo_stub #(
  parameter DATA_WIDTH   = 8,
  parameter FIFO_DEPTH   = 512,
  localparam ADDR_WIDTH  = ($clog2(FIFO_DEPTH))+1,
  parameter ALMOST_FULL  = FIFO_DEPTH-4,
  parameter ALMOST_EMPTY = 4,
  parameter RAM_STYLE    = "LUT" // "LUT"|"BLOCK"
)(
  // asynchronous reset
  input                   rst,
  // wr domain signals
  input                   wrclk,
  input                   wren,
  input  [DATA_WIDTH-1:0] wrdin,
  output [ADDR_WIDTH-1:0] wrcount,
  output logic            full,
  output logic            afull,
  output                  over,
  // rd domain signals
  input                   rdclk,
  input                   rden,
  output [DATA_WIDTH-1:0] rddout,
  output logic            rdval,
  output [ADDR_WIDTH-1:0] rdcount,
  output                  empty,
  output logic            aempty,
  output                  under
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
uJCJy3LxGkoXuTjSbubBwp9tEYSsNVgeBj+6DmlfQlHluRNiDos96uuk+jOP569N
3c8YuPnKiHDBtAQWynHpeDaCI5UZHWvMSW6o4PdauxS+TgvibYFSfM5U/uKccIq4
XUIyNcnz4VY4S4H+UwqB8FyDKloGzYkTgvGf3wSRMDz3XjPBnlY9CC8YQyJLDMX4
T/4Y4wAcNy6M0je6Yv3VXfteXVw8m/npEomdcsqORXQzOGJkrgWgFo8cRnyCTbqz
Dk/gsa1zCvqy2s99gSpQlPYzAWVtlfTF8ifLlGa2p3rtOy0IF68gPiUSt1rSMOZP
cKayGAk8ju0+vvSrb0n52w==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
DnaLIEr7ND7VnCbKt9mSTlB6tlVij1f/+LikfiT6pupfITl/LbVYWi2ruUWyV5fV
dMWIxVr8K3KrieYTvi0Q3qVbgd72zwrMPaA4PkKdMGBrBsCZUl2eR9FdP+wPnStc
6CQC0voauvTw3dPFQ+VwNTc2kt8ZNz1B1Jw+V7eGd/c=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
cSuoU3UPhURRRNundVnpvtkUTmjy8KKAKgQXowgQuygd17GWiPmQj2pYzhfnCsRZ
9d6LtP4NISg10NjWwxcpseOrx6ErsJGFTPPgmLLCwTDfZTLQ7ZPPvAxg5Veq2MXo
1IJseX06SKVX8RQDmh6Nk3PLJGEhaaxKP4UXPqDK9v9clEbBUB55idUZaUMK4sXa
D2JKEi2KuczGIC5o2gj7RbwxarH+sr+tR0JynMTJRQ+Nqda1lCiN8VhBhtK9ulOF
6vr2o0LNi8JmXbdGACs7xhvUpHALuG0dNGrz9/8AZEZQfp3eh+60ArOTCL9CBYq8
W19YSkuowgi/jdzgQMdt9g==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
PgH5I8+ezdCIhqCdNE5VrqFgU3w4wX1fB16hJHb7YtbrbkPigRB0DNIXrRmZTvOZ
3zCh8htfAlDWuRdp+H8yBGTjdojJ6nzaU9zpULpMGVfYOyyx0A12JshvuCM00sda
ZwQ5jrRbxRmVAHj648yxGWqqmnm7rKaxekbEDbAA27ACQiVyhti8IN5Jg7W+OizY
5I4qyKeuGjI3elrFQ1vLrBtc6rnzTh7wZAsf38qx72hSbMkNQOWO35ArgJL77hPC
xYhqprmRPMFmLOMqG+pWlizIkYzkSLmTfeoSgMpz+FSmWnldz7KVsra5c8Bd7VOc
aKgsLUf/7451D97m6+GA4Q==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
jL2Vg5osMMsBJyEAMiG0aijUC2LkktK9AZc+gS5mlL45EzZLU1UHhE3IjeLeDG1z
+MHae3wsQ2QFYZF/x9Yv3wI2OOd0oTm/lPOUnkZwzxpJNkqbQ1XrJ93rcTgxmFge
bNT/1QvvVgJazoZAr5IYx17MwE/RPOBGMaR5lRAl5nxEUDhsXu8SlLR7+GFNVBkB
UiUxvihlgOX1Is3AhVIBvE1LrUUGdWYZd5Rvg4Cs1XOM+cC/XzR7NsbHbtchcK1i
sfRiXVwz1bCXz1j5UpU3xlYRpylkM6a1bN1L5O5ePxXs6S5qm1eiuMK1zLmM0YHM
Zoyz88G5LohD2kX9LCS5yg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
cRjjShfZ/VQHPmZpB/fN0a7Fg56Dp87jDDxuPS3bDLBKLSCkFGTexgSZ6WxKcZkZ
0OU39kWz0AqZqdhfxNVEBv2/O4rBVFnQTnasBGBAP6WItcMwj+5yQSMYVCr4UYIs
rpUBneYn9/cwECFMiA1sMqFQ8HJtiAyq0SGm2ePAEP0t130GDAd4poxkNCT+2muA
Pu6w6NTBtQBmAxNG2n7lofq9549SoVsj/Wvx3yxqm1y1N5llAHcvMdCxzvYB2WfU
K2FVY9V2HQ+CsZc6dR6ecmJ0YZ/R9QV0yJPCe0oXpNrFCRKHePQy1V4xGdwBZOnX
oUNAbI7J/hyFXIHtkShn/Q==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
pd6zo6OYryyUruXkFi1xr3AZ3bFGW9+h/3d3d2mZN1SIIlIsiHzght0jVsSCph5B
naSWghFNVc9M49HnlHBn6FRuEcAmUKAodOWNj17a7nh4lgbCC9C30SaSwmG6oDDj
fITD8EUztIey5Q8NEjMH4wVXiywLoGS4pyr11Otjw6ORxKotsU9UvbitRAKK2fRG
V2fuemvj9uNe169F0cJe+l5oVJYqrFFBAdli7/n+a8Fvr2pxANntoQUjJP+jhi63
EbMDTX+8f7jXxrj2kZ7bxtTvvgD6Wz/t2NYqUFXTlu70/vjU8mE9BuEwErNZjjuk
YpqzjzNvLBcyU0K5xgFuLgUwGkmCAw+gsjc4+obXomoAwJvFGgBfw3TVBVFI7Dj1
1AraVOB8+A3MWTp7KfShnGOxujDXexG7PdcbbxrJPHeEWokcv7+XEK+zrIgrUPmo
mZaFTD1eydOHjn2IXYC1WD+RlZS3dlvbXHzrBHrpBgszE91/dYGAuQQ3uIc9MPSg
m+St8vCEfimiyW9ZfMhYd6AO/zas8v4I9egXYG/nJO2/V4FSbVYktIpPBcyA/eoM
D/WcqCwRBiWbk7E57gbolmG5TQhj8zk5N9PGsLF/3UGA+Sf+nx8B5io51iZf/jE2
hJEf8Ujrytc2aqxRXWjVn59H5vUxCBpjP5e4eX1zfSu7xSwsCpVMx8kkqqBbvIlo
ZuoinD6SlIrEnS7CWx87s8T4adXR3Y8sABAVs3Hlw7N2qMT0zTTsbPDRmuGkAeys
le4jIvXHX/zwZUvel2i2UPhO775iVZn5Bz5QzQV+pTiOhOtPC7toSNXsWttTOyH/
DM87A0dIoFEFyApLaWHxi5tRiLf3zHSkJXSMHjZJyuIh24ZG3BOZoLhO/9zuroUK
cRHYaYTPxjyXqM98o1PDTCKFV/M18Pf9dWyS01n0SEP2jJ/OULXK2iiV/1BAB8va
5V6jLUpfyZUG94oMXm96ZOLPdjHCzhdgnQO7iMbtsuc5yzFG9JhiG/Xo4NU5JGqQ
XxiT3aZGCAgiPRUV+rxJFRJSiriitq8CFIosN3YeSrxmt1OTRoYWh9l7M8rzu34w
UK5gP6KrN4Ki8iWJ8bxRB1YwmBYbgDlLWH6CAIkCQ2If26rAjyWj0EEaGziE1340
YdxdP/SYbVbiaGhReHz0b6+Edt68+pViEDS2mF17WyV32rb1StVDMjUCW3Ds0HwN
jqMXdPLqBHRa3ytfqMmDmAy2j8eJ4EHjP/EnzoFC17n5kAIW8f5r7LeUfyXYxjBs

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
SlTMFRwDq/ElX6jIifZJ8qPlt7v5epRf5DVqjmy6FIL7rFG2xc0ZeX1kLJTJaBBh
ZVWJJrRTBtV1m5XucevBUVelsGtMyzbGXyQ1Obu/rRkvy5ZRI/+6r/V9wg2qKbhI
CrlnM4GJUZSxbtGh/+YAi1aW3gFhU7OyjgQxqb2q8x0=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=4976)
`pragma protect data_block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`pragma protect end_protected

endmodule
