//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////



module dc_fifo_nv #(
  parameter DATA_WIDTH   = 16,
  parameter FIFO_DEPTH   = 512,
  localparam ADDR_WIDTH  = ($clog2(FIFO_DEPTH))+1,
  parameter ALMOST_FULL  = FIFO_DEPTH-4,
  parameter ALMOST_EMPTY = 4,
  parameter SYNC_DEPTH   = 2,
  parameter RST_SYNC     = "TRUE", // "TRUE"|"FALSE"
  parameter RAM_STYLE    = "BLOCK" // "LUT"|"BLOCK"
)(
  // asynchronous reset
  input                         rst,
  // wr domain signals
  input                         wrclk,
  input                         wrrst,
  input                         wr,
  input        [DATA_WIDTH-1:0] din,
  output logic [ADDR_WIDTH-1:0] wrcount,
  output logic                  full,
  output logic                  afull,
  output                        over,
  // rd domain signals
  input                         rdclk,
  input                         rdrst,
  input                         rd,
  output logic [DATA_WIDTH-1:0] dout,
  output logic                  dval,
  output logic [ADDR_WIDTH-1:0] rdcount,
  output logic                  empty,
  output logic                  aempty,
  output                        under
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
P4ig1YwZajwGLnOFFS8FhEifyBz25xJ0jQr+GvRU0SpHjClY8zePI+s6icXdXMBM
1204Ly2QAmepvjUl1156hpYt7s9f1Wo2UBqyRTPYM7xMfQKlIn2ZZWE82NMpVEsM
aE4xLenXvrV86zJWff3M7niAr5m4Epm1pBuLn3xSdiXFdxkWlOaUjrb8fgSVPuoA
ix5OpB6wIhlgHFVO9u2OcWU03ztEamnYdziEWrtr1OWXUzEXT5kuGbRz97pYVUrs
TL/9qjdmjsyQ+qC8vgqNL8ABvT39imCWCEKypcho4C9S2bzn54ePfUq3jzTK8ec5
+yUtqJoP90FCIot9Ph/Pdw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
OTbPrOzIFNARKcLWSGB9NnmtbPW9d80D880r2B7zoFdyqnQh+YuaS9Pyf+6b+y7s
HaqKJcyc2gB6j0R0J2NtnS2/II8Z2kKLpN1wZs3Un6euyMKdmqAsYtcVcvUio4a3
WbkIFxum9DxkLwGjUK5aEzUUdI59/T9RUHFcDjCY23U=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
L+mFQxS98+86Jv/heLBLcL6WHaDmRQAJ7NETyNffYf1lfPP2f25TiCcwBdxs1wx7
cBXAZe2ObuRG/Xgs0A9Z9HGr1rWsK6+UJ+ercwqZeIl8UdJ5pN0jbZ/KwZsmsLE2
eThB/0Rq2YZHgNzxNZZlXsqfmbdpT23CS0uhlOdmid9QwoP84gQIoDhl28S/q5Oq
GNHyXnzRsghJLLsLMb5g3mkZ0kXeQ6r0Gvy3yNPVjlfW13pKx9KgCtS99FJYhEuG
vQ6aiihtgLF/JQn/sJWkMr8Qa4UX/17NwepdHJFJUtiZtDG69qZRusILL5mzNx56
X8gH/gfDxbuhUpAT7zO5zQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
JviKUp+BmjoIkuYulTS+5i+MYv6c/SljkoDZY6DpwENNr8EUEOkkRGM9TpFC1GaB
ygTT+1kbxC3Exbnq3qtPGg+mH3R3LjDQjy1pIYhnZrhomrNn7KAnv5080JzD33wh
zb2DY8UbuIcn/GxSk5gR+VxsRpzl9mOvnItko5OoOKsCwFl0+IAX6jdyor2C6f7/
UJ+yLSdMyF+TCIO176NdrqNtjj2rOpo3P9hPJ4hdlfRLPTBeMKiXglSJhUGE+3UD
0p+yqQdQKo8yxDuJnZX7ZW2cjoKzeT84sVWTPDdmEWsnGPMSX/qRkK0FwGhif0p3
zY+qs4sRJi9GYqvYUmYS/Q==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
e4UN5b4RWZKbv7kg9QwbQNyRzAvQUUxibQp+B1vK8+OX8kV5xR4N/ewGYSkiltt1
dNj/kFLcDwFd3cY6DuMQO+brKIPpH5Mvq1NF5vY/VI7bfQkiPXrjYtngsjdELDvw
eeUIJoJLkP+dnNt4PFKhmhfZoTwHAGXs20iNRQmCrC69ADFwp7uJwJHjc7SgNyQn
S7DYe8OtfnssBQiqCSARVOMjIjjX2MWovvYpX01NWOjLmntUCuWSl7XN35bRV3Ch
wElVHmBIh6NrG3O0MBCgmuGJvXaJM9RnPMNHKNuhWTl76VoNFx8jrhHKaXY4FHNC
RaDWaNiXNHfsOti/9I+1JA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
ShYor5fFUeDZ4bVKBGQ1Q80ScjWDSJ4Lc0VWkwdgitY+730vP05SMWtAaHFW8XCf
PDO9CRhuUn2IVJmVTO72tTU+ZFTmn+wxl9/Y31DHyJJHNapUqd62SfIphvBep8cO
L2+aWA6uQdg0YlC831bNkzlrx4/KElQPaUX+F+QzcJMgDPJgIDiZBkMXjn3+H4EV
tlUDYZH00KjJStAqxydwfeeROwZ9S3xlXGFWBQcDYlhyqsn3G5YtE9uMK/VnMXpx
9pLLAibtvF66sxHj9nUF/j2bu2tRmss/cHjhYxppP8Kl7d7mhdTIczuAElVO3PpO
mubh8vTC1NNO236r7T7cEA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
TCK2izKWTa4sGCfLi5sIeIp8CpAvRqXsbJhU9NF7qWYU8mnvL8vWSjyAt2ZNDLQX
cazLwD6EQ/BqwBK3+obIVynsTvz3FE1QJgH+v8wfNBlSeTqiiFLqG6hAxcnPMRP4
nM08GIAA1MN2UcUj9qg05BuapIipExLRSWR5MjqFar0YzwnLse3aPnN05q6l+yF2
f4LhSKI45xXVJrfjZjHw3BCGxnL5Glm3PuvrFXDM7uaTr/WtVhWrDlREim5ywOcU
AU+xcMeiad90GxZZXrb6d29XbQucQRkFnROk/Fst4vlmhMH7t11JVX/1Wwh3C982
uArUKXHWaLQnTqpXOtoURXSn9cTByTgymmOzBbaMlCyZ4WJpNRqBja0t7+kLcb7P
35F5hZICB8KDJno0jZS9cB/JFcTvGF3xrO/e96Gx0uG1f4Bz9afrM1gpHNbqXTGV
k4gghxgN9AL6KllHDjeVwqzDqjfcudhv9CNJO5KqSlOhjlon2z66etM/ziQJM2cC
2PDUX+FoUKOg8xMCfhfGwygv7ewy3McUTb7w56FDwedg2FiZp/xiw7MzAiXMz+dN
z3RvsEg5cZJtAx/ywTD5jtrJSYQDf5Gz5q4PO3gnms4BFfUGdxnyblMHA60XeE/t
+hSmwjjEGkdtKAlK3JCtAV7QlVu1e/lF7Yd1zTuBPYCGgUxuMntt0buatWX8OLPc
QIpL+viWBfSpFeGhqo0C/CxTLnegUmHJoUUbzskBR1YX+C6cs90bCN13mN3EGWdP
Uzr68YDozBbxC6+YqtcQ/z1y9niB15jR00zBYxEm7AsTQf8LjAkCTI3YO6X9vPl2
6TL+S0exhmhQRR0u4IEZ3iU6sZUHMVHZ1B3US+tKUDaPs2euy+XRilQ1WQFmzWIu
Ah1hGQ4+TzVVgM+8HylxZTy5wF66tPC7UJ1UJ2QeAjrsMf3DZC6uKRmJxVYq+Tqu
0nxLd9OszVxL4EKFVSw7wu3cWodtBr2gAowZmZ0D3PZ3dIBu3XRXRS+vxjHeK1+T
5o2wA89JPgyps+o2NAaeikDrEmBP501Q/DOd3zC2toqizDsV4uWl3FWI7emBK45d
OSgeYhZrG2CByByJhOyvrGRKxICgIw7QdDE9aNr4RIyq6gA9gRUHdFXLmg6LYDOE
o5MuZgDPcZxNm9aKn3iPZ5BIA8B2qZitCfe4WJ1d8ZlBKNecNgzXkeAh+w+xiEfz
PMUdaRaMnPDaCmOhLVyFz/PV2Bw1i005aE+lZ2W6vL0H2NWdWBvmrrdWeya1qHz9

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
YTtT6ZphatkarzxNlHkF2vngx4Tq1iMx/mSr0jScHwLgKD2RVHOhveAAwnBRIOZT
ja9sRtR5pnSb378lIMdtYCSDIxpe4yX67g5GYiGn+ZvThdiRE6w3fo+cNabSle7+
FL+OdsK8QTq+eO/RvCj/AWI4xbzk+xAmGM+TmTFAaHU=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=8224)
`pragma protect data_block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`pragma protect end_protected

endmodule
