//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


// synchronizer

module data_sync #(
  parameter DATA_WIDTH    = 1, 
  parameter RESET_VALUE   = 1'b0, 
  parameter SYNC_DEPTH    = 2,
  parameter RST_SYNC      = "FALSE" // "TRUE"|"FALSE"
) (
  input                         clk,
  input                         rst_n,
  input      [DATA_WIDTH-1:0]   sync_in,
  output     [DATA_WIDTH-1:0]   sync_out
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
uJiTivHG6bh899Rj48N3OGPbPnr3F2wrYoTGOV41tqIhGUGiexh2shiuVZCWkNLM
/nJOFfQpnlTYlcSAQHFjEAIbeX3CKHE35VRBtM1bHtv7LCxsZzD9RNDOqWhvhZqZ
MkuZ5tPlvI4cTDvssix12bI5Iab+l/uHe9yBpokgBU3KE1YAtenF0B5F28vEzLtS
By9Nd+bstSzEftrpwP9AUeAxnRkC3iJKuQac8tKdSH4JXnEu1t1Fah+0X3ZdXIb3
DGp0A9kFq0eLar5fepDwyTNe03hVQdbdqxTN/jG8erBU+tGCV53uA/JYXJqzlQhu
VmtXh1nG/H1coyVB7TzIcw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
Nb8gPQxZBX68Zb6jXVutgN4miUi+H0aDx4jFyt7wqmeAHd+90idJuXKTSAzTlU+q
gTVRfaSHY8OxljmfI+tLEwFSbfcetlzR3ypmlJatQ+8aIjpwzfEx1mkTr4+OvBWW
HAofBL8HTx2XDy/eyCNt/r+Sbw6uukyQj4h4Gmbvl4w=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
sH4mgYxF3qu+oAyu2PGC2m5MFFUY8JGTiyRhqirhGVjrGCoYOAHf88Pjwdaolos7
wZFllrWsxZo429qBwvWQEVO5+1KY37123c/3/jgzAyAiAejJD3Awy+bEy0ZeaNf9
0oGDBh+fiZuMIcsgH/QOdDUXlqo7ca9WvMfxE1HRb9uMGx+6eZQYCR9PIu589oaw
piddmCeEoqMHV1IcHDxEQMIRbyKdgkPbnl4v/1ykfuCldFoFUTK0O2I94zlQf/PC
/i/8xX1LZEd3V0icLrMHCnJBwFMTCXaaSf5EQ5FrCd0REKkLrQZBOd71F14+JdOB
fM0/HCnI157W8VHmaG4lcQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
eGg47nj9jg3Ixn3BYRY07yHkeTM0NF7+lqE90GX2QNXJaB7P8QDHttnpi5QXRxJ5
ugQBO2PXwPQ8mV4whACbtyc1IakngEZxO26PZVclL8Oae7+35emVZS6L8dj6edY5
mde3WaTlEMCN3TTp8AjfQw6+0kJQOZZM5ETFWgvSWBUTxYDgX3cA4bFv5MRIrEv1
9zjTPkJEvRFkbqQBI8gi6rxHzrhuf5nG7ziHOSSpjQ2jiGoddFcHpOJd81/rc9XD
rhu3tY97IdGJx//XM3vKGGgRExDB5n47T/M/Is616ZW2qy1jF9tBI6fHwkvtvw1n
FQ6uRrXCk2vrmMfPlp7coQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
6h0lOluudsYiNzD6G8WGdHaos/jsG/8jLvCmddgNiATC4Yu28XqYfQnlJNAvGcdV
a3OV0cS8tdwBbg12fjjvtUAv3mSuuP/oKSj/DODw0C9ieiI/Jj6KAha2kGKbCwt0
RgJhoukVK341/dZn570vQHDbh/NmCXUFs7n2dx6sKl7tw8Z9hTb3OqCbCjuYz4Wv
26AlNTItIK4kfS8dNPKZ/QGjrY9hV1Crw0RcOdTTQhf4ORPTbrsnLThjVM0UWH+e
+SoZxKmZEoeImIAaFz5lysoe9sJ5QLjPE52l8JV1Xtaalni66i2ZhrynwiX7ogYw
1ddSn7AfuZsEJXAqLppcjg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
Om7ITEUpZd96oZSCFgURgkrbRjpr7nCn8XN5Tpw05U9gCvxPcTP2TlYmN4WC3E+K
lVSy45ErtE6K0/2wh5Ouj+ln4Yxh0iBbOebKWSKSWvArVSw+yCYgccgo+apqDjsX
4kEMVaVYyFI99TUqZb+FUDHA9Jb9Ir1fjXT+9z4j0hjGfiFAniOmoDB3mA8exs+f
9nRRjg7nmmNuT9mLLcxMahJnFKKg/0Tpc1C6OnBpyfHNkLqiNs+MD0uYqnUqmHJq
1Pc5ANkipLdBrPt6nvcFEKivFuliGfoEsYULWHrDdfQKALSfzdby2VEjQz9L+Ca7
UL3HOnW2qoA+eoA+0i1Vpg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
EmP283LdEEu7axLzfjFf0EBNl1/zs//2xo1W68fBbcaD1T+vktyMAiaqxu9s20oi
PcrVo3UU9kAU7VOs65jJAZxv+qDYBXkdsWBV+TGM4zT3yBdCXSomgT4+05DH38Ca
4hVIIic29OZeuMPXjmKUilgyuQMtUqZnjNlUW3dSlVv/9rjSseGbjSrVtGlLxKok
oXQqTUFO4RWsZulNtMz0p64ZoflZxuTbpgOwqZntGQazwM5tm2/xOI9T34RLVsDU
57+pH6UR53B8v9IfzZsTGilWYKC0hSt1BNLyfdpkV6QJPqpMiDXQoJtF1oITB31b
leJIRbe/srMQtnTyov0FQnePGNQoOAlX8bIQf/WXfJ2NHxU0dvC7jUadiBOJ1YDo
Wa/bdCk5IWW7oqXGwM+DBJ+Dtl5wMUmjtoTl5glCTJzcCM3MCkNNMFp26T6BXhDV
cWOm9awW9S3acaPcavO6gaKkQSdtq7DwoKOrxd9aJk6YpZlB6qZGWw/KSkqEfzYl
c0G34rVgg5WF0bPK1z9W9/WC2v8BkM2INDbMAmhQNqrMRypX9gp5QdC+3EgFaIbl
mZT52idwGVrtNoBCKxYpmaPrLU3mDCQjNbxHWTQ/vhg5lV69/9ztPdxpUOtE6cmD
A+wMBUKN+lytbjGJE2rhdC/CPNC1J+cN2hiNi/AHu3z4bKZG7iYIeep1mBTjHopx
fKTU8UnRzXkyQXOe5/Ng2/nzMvi+WfQ9OtKezNk43DQoQyQBRbt7LezHhr1YRHuL
cmP0CNGK494buDbse3ERAoUeyFhw8fEPXnxIYwZp+yfRA4okmXSC2CHBQGH8QUi6
jr6Dh+Q2ehvKO1fJKK1tjlFLa1BHkZwrivJxfYEsR2S6+lGlA+g7VjkgjqIkw1TO
e/2Ds07RP0jIpjMzDDl/hHr/IAGvwShzxqJ4ah+QgRWxdTQlgtfIoFznz1pPgNDH
zaFQ79P5YBxeFu917QBy/RNs9NM8+0+xuIoBtFpF9SEoskHXi6b3ot/8sS5xULJb
aywiWmaMJ49czjOtOSBVKYZGX6MlxvLoH+/H7QZI+QAVub85PaurNtXaIkq3m+kf
8vQvZZJeDHTsWOToKXiLa7pdZVKItLvJTZ6KmV6eMkfSWAPtHVKO+DJ8k32WVsMJ
u5kDv0LMkF1nKYUOgjYIcFemibcDp12b29wWH0y33vZSuab1WYjTxj8YLH3aWTKh
QMtSlxSe1s0kcE1U62NaAdVNzhFW2vsglfLgPGOLLQVpTBO92COq//yhin9DWv0/

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
hzsC1y3qdDzdsy3A96V8KMzChCnXU6Z7TPZXIrSc3aHQbT6QhgQtkNqHD4378jQu
hn6x1z5b8KspNICc3b+x3f+bUOfiDGFm/CVbmeQsYjXk3Q5jvQcKUBZcSdFEqVGJ
usTlOeShxKdZXRF2PQVg1QhW9fJkAeWmo8JzgBPtcMc=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=1376)
`pragma protect data_block
3obz1VVk8ywLTZ621Ldi4+yNnAJdZr6kj3V6j2v7JtnPeUc3SGzmLt00EldlgObT
x2u53+M/D/+ceEUwGHyKY8DXUCZbNKCZ/GytE0mx8Ear8x9URLF9RTBj6UDlpVDg
GatAoPNdtieCtDoxnNLEGB3hZEP/gJPxQUzIE+xaLpgQXhMKFkVBwgOdEuyLkSHT
apfE1AYZZfSR0lMq0zLlgb5vch/86VPQPvKOCjnOl8UulBzm+vFJD0meBaJf4rji
HPhZNm/COZtYr2DDWpKz8UFIb+9sRmvxF6NSSAcKN+/3PK3hHl+4NcF3OXMwgpnE
Xpjy5p5QRqSIEPV8IfgBBvdsaC+ZlI07TDgZvjs5749rp+/RXQ+/fqtFvi8hz4ps
Z0JboKoFqMZUvMmVO8DwC89aI1U6H/twXlE2LTuxL3FpqS1QmkOV0cfg169/Z6Jp
Lxw9i0WA0Vi3kJRYqXn4PHt7MqqZ0hoTE/bga8AWOcs93B0jhR32Yzm6XC7uaV8l
ZMCVr5ba3wVzktOJMIpGEku+Hu5K7kVPHBwxgQ0O9yQAPR+YnPmdYvuojqtjM3LU
0u9RxpIhyWNODB7e7f67TF42EH/QQbbM1FRQcf6hc8xwid379o2mqG11DHo3YMCr
Nudg1reVMU74EG4IVtCexIz6fP8YGQqigeNJS1+TEXCP5wb2Xgefijs08RINjXGT
xx/lypYdBsZNXWzUhD+5M4uPOtb365C8AsOahGGXDf3AH1IIzaAe0mXzP0KUiMLb
ypEj3mo7Cq+4Xsc4EyRercgwakBZF8OiFkgLFO8Zv6QvoLGr7+72PyVU6e3pFZ6E
BreQxcxS/8fkWJIqbMcYCGSPfYsE40qZoh4L7KAIgMv9Ge3+5zOXVRAwCF5b/XCg
khCmeImiVFBSSgaVzTSOIpDYJviQeia+yed3irvfRjDJqUal1BJ1bZ3GBBgyC3Tg
9BYLXdfBR1GtTRRFXXU1BcySTlAUG3kU894q5TZOH6//YwDy4wLRU37hSUnrQF6z
+lgzEp4sNdy5X0XiVo3MZL561gWzwnDdh3AnQZ2T10wzgHiPjD2z0NvNddGlllqA
s+VNOFOCj6iV23GIDNLtgeTedcbR0CxZmi1OIMy2N1pzive4DuLoJ885jdzglgrb
H383ZlqKRcslZkuyexfcuu8qLdNFy22AXaMUJ9iakVIVeh9oRPWQM+g2rrIs6oug
yKTZHncEMaBC+Sys81ljVv1O+NwdiFn41Jopj6qP9e70kie/TkvEd7ivu1hs6qQK
Sbzmo9f3dul4W151onP5e8Q/0uImk9BVYC8UY+WlysomJj30ClzzIZikmLRcu0x5
FvbUtADTl+eUw0nrNxI96mO+e+CHokZCp8Op8G8lILkV9StNGZ8hxztye1b4fy/N
+ctikBkfh7U8qJicRntbWHZur8yTx2hQdZdA7KqI01iArvSN5zmD5P/5JxCpW/3C
xhpM3+jAbwVjF0GHEsiKIJBUU148xmeqp0EpxSXnWq2ExXwXWgTAO93mr1c+j2I2
NAWx7cZf5KHNwLgeOGQtLV+Cj7uyj8DQX/p+y3J1K2eAkZvtWJwQbyySKkv9phoV
WFU0Vu83sl8Fz3gBclMBT7mUEFH3aOcyrCLd6jq/nr1olgJg77cqsdcADtI4iL5o
W03roSVa3d/7YSfQz6LY5WP7M/096wnAxz1IUODhhIofYdcBkmhKgywGiwSbF+Tv
InVJu8pdswnubLH2gwRcUV134vz4G5VzH6cBuRz9KKVQwpT8mmptzeIaWUVL5ECq
jhT05eV4JPiiRBRNhb1rSnUnuzOkgUGSX4fIsjy/if4=

`pragma protect end_protected

endmodule