//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module comparator  #(
  parameter WIDTH    = 32
)
(
  input                 iClk     ,
  input                 iRstn    ,
  input                 en       ,
  input  [WIDTH-1:0]    iD1      ,
  input  [WIDTH-1:0]    iD2      ,
  output                oValid   ,
  output                oLess    , // iD1 < iD2
  output                oEqual   , // iD1 = iD2 
  output                oGreater   // iD1 > iD2
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
b4ADMetrcO6m6G8/WaLu8KuOsQQwNez0Gfcci4eHyTOWWF4MM8VsOCHDQMK1EhqY
zGWAXchgIvLxPgNQzwhX4NYFF5hjPjTh0pbcUl5/qkOxzP+U+Hi8n6KPJY4L+jqF
6Akc4IrgABtwEZDBMMoiOyCTfP0nl6IGIeecIkAexQwqKvnFnpVOWtLvENQ4juwh
/k1Vog9tB7BKx93PUy3bZHc0Gm5QXzV+EnBjdIBWcSzvlb0RDW7vC9+uQxve68Sv
jvqR3siphzIZLpO8V7WTkoORZNKKobf1dLq1ys5iFO4g70wHfGPthCGsh7YoYxeH
aX7cNhXh4uvppm00D8UxuQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
KNBgkNEE/RhjFBfr22dztBSZ6n9ZSI1M/PCfIHLHcrnfzAq3l/FY2d2esJRNCDYU
kz9ENf7YM9AdKMFyyozgEDhVsjbZcaD82y6dhW1c3pKQXspEm2vc4C1gErK+euQf
dOIdlpV+urLGQrL2Yp926AIhdbWV4a73o6aKpZBWO4g=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
I5zgFo1ib7FipKcGO+4EyfB93SC/bQL6QbrcyCgF4zuxJT6VfbZzI7MNrzl4VElg
u3/hvfgtepcm9GClw6cWI0YPCmAKs68ElPL3A+nslHwttvYqpvmP/ZKgCL469H9o
nSpIzdSFiges6/diq8C1g5uvu6ywoqYy8ZxvCCfKHXu1aVl1i0aomUcJ3u3wRwmm
ph6eJH1vhyZfvhi6T3tGd6mhm9vMEmbD86461TrCmFBa2MceO+k5eXyNqEVE9r/a
rE0GL9v05pR5TXTPvBEPPlx7L9/9oV/xC8H0tpEc1cGf67Ozk1S+5JableIMf/hm
OMJ8qU7FyA72uQHtyCHe3w==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
MQoKg2DPzLVmRmQJDojMfu9xeDcou25iuCUMPcjkV4qcRWJYQ6ynCm4iIR8n/B3E
wxecaGukzmQjOJDzJjBKo4j4KwHcCByfv33riGP+MMKPudLLJbJXnWav5mHGWQJs
hCI/pxC0FUMymHoIAS7sFTL3LueuUnP1JHtKgPGf/+NefVTCxcdJ8ERL73K7B9Br
F34rKQGLaZvTaWqMyl+VSwPb0miElxZKfPDMdfkCjO+OAAGoD1muVS4Xr7sgiHk7
TvEfDMf+4vdj1dyAO/hxMd1uOxR7fIDLGXs3CV7Qi4e9zdgdIJKMmQrZSOYPpO/0
+0MDDOK3J5SOLrW5JnWStQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
ZlyGAoHwQHB453rRFPAwP9RU+yymYVoJVA9ZzjaDV+QI3BZG/5xmBgDeGeF/rERy
IjsK1CDFi+tQDLKAaEr1pVn0ujgeWbOT6QJfW7tUJu1PfdEC+T6vGOvIsbcz8Shb
/hA43ku3ICqGHmPFx0TMPWM2mDFJ6PDbxGBpibZJINsgNCkqVtTSPILG8JaANGGC
RKJW2SYqI+jqEVXXJMs8JCNiCSz3sSJ6VWBh9HUhopQYmgejFWL5PN55LCUXpWb9
wX+givnu99gS6QA3gS75Z5dtx6HiPpS/UvzMYS+1Cm1f0MeXdAPcjowVUOmpFtSK
rb+Mm7hDgLBeEUkLBAmuig==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
XiBlUYfFf3fC3SFNv9H9eUhXSXNqabbdXAUEQf7jbImNPZam2ulZYYiBRNVy2fQh
+evhJvb8loXLb53lkjz2u7pBvIczL4DekJE3lk5cQOWHQT+r5YPuXZoAu1uP3lIm
KbgGT7Gs+e8he/OMVbjz/wf5sSwo3MfaujU5/8VIe/EE7wnNlkuvjlSq78Y9ZRc7
5DvfLkdovHxO8erUlKakT97XOIKI8fcO1PCKDEnKM79KiZj8KCGr+fKKGgOKJosQ
aMPNJBOqctyv3LYsWz+fMKW1A0AZnz+es+Ym/aFm7NJmt8DNRVif8WFMBleV4p/c
Ej7lmOdQvva8GtbwFRkwAQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
R+CoB1ZthRAO31mAHqPahd2gYzJw/TjWiiWosm0d0CV7fKXql7esTyrbrIj223v+
0jaeEqcvYItEOuWJFsDzujAEbvaZr5TElddLWxW3pweeuKaUmlAEYVG8SFr9lrXl
yui5sT+tAw0yAsae86ws/nX6AMx4zoC738toY5yhmJzVKgeLXuywiYYNC2ePygZN
vdNQxQF9fLz1bqKDJtox/6v8pvOzv3Y3LJq88MyMlySZIhCH1sB+PQAyfk/1iN2X
psM36aMq7IHvJG17rOo8Svb9doAYDWLK68zcXpuyXFcKE6hyvUZnYxjYvBBQEw9Q
kbncRFYjwhyWy9XQsC8yaZzK2j/nHn7cM94oLmSkU9Sl9XT32qpk4Yn3QstPXnVc
TMElKrjhYoctQ4yEozCoOtNKXMux4GhiwAvVp1tfNG4ETxfkUCNyzFIONI1jXId0
c4rGQDYVyrOQMVcD+h7HORu+Mu6M6enGPOIFNe+q2cgg1E+/rEiS5D+QmjtbcxEh
9A4mWv6bECebrKN+yv7u0k8MlGc28Y1/6k/t+sa3TDyHVMYyoND6qUjhZtrPQJzc
I1i7sP7c2Rxv0dg+cI6bDOvztX3SdJrJXPxjC8J1RQdn5Hzss8/C3tM2lb5pSE+n
3c3bt15YM1eep1ehb3obOfpYxnJYz2a6BqO02I3mpB9gIer87K+3YCYQE05DbxGA
4m1yxJnQzmci+qG3bKAsRxj3QoNjI+T8YnbUttktLm4N9YxszTCLveVNFoxUcZeF
W9z5pK8ap3Wh6CGThR7A05Jlatz6TF+jV6lpZVTai6jqzi6LFTFe+g8MhZ0Dhx4t
HW1VbOWQsJijxUMjlyw9QnufX+bSPZkYL5RRE2nj8Z1UWaBuNN37JhH89KrUzbsJ
DONh4qd6e8eEQRg6aIQtUs+SxZJIf0t3Ftpu0E0MuV8l+jBjfC6cG9w3ZqYmVM5A
wZup2bJRyfRWklwWqq1qGcnPLfIigYvIAvRUJ2ZPmS8FSZDQqS3348xCowEKbpR1
8M/9JRLJRMHfIUA5ItnP+LYLSCLlWr53zgmVScCR0ZUR0nxs47s3WOBcTJsi1OOs
gqJqVzwQwttkJk6Cr7lKPygc2sNK0babr/nnBZr+MTlMIgEt0pwjETgCCqVcX26f
EwUvQguW8tdhYiMY7nbSxH+dncvbHGSDt7bhLf5X3xti8763gUJNGrw/xQ+J7ud5
RNMp3ldvIhoA1zwHuQDrCVRWbxWYfCymRBXlf9X75P9Itai0fT3DXUX8nCoscApg

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
jTPlivhM33lPHAvc23tO/hAFHr9wVA7aqFWeyY2FN1VnDwVsSNqSwnI1sJhbBVEr
ctR2U9tjjYy53SYNurvJy7R5N3xyY0hfQvrxqKS918JQVSJ4EJJIaseC/Gy/57bx
R9mhIkurRQirhZVwhfA9F3cvrEn86KH58MpgS6KSUKM=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=4224)
`pragma protect data_block
PGm1/XkYzan3uW1bDYfmkiEV0HBW6h6pF3kapLHwXPvzvfiJBTqeTTm+GJDI5F95
9y6CpD7yqG7pM2l6DfPRQvvu7Tg4ZtrgttIbE9Y4rQWtwEId6E7fqkzMtZ0PMAMB
r/Uepl5Wxo908pD/jUB5Ds7UIJkkRg5E1zj1xpUZMctZeoINKS2XhtnvVPZjgc0U
Y392kHCt95NyJBkBpaHJ3BRxL1l2ObP/VD2lpUleCTFumDCx02P7rJCYvMtuqCj+
lwc3rwty5WJXUJ687zGBOmj7TeRx7lqarKoeoOJlmvxEBqUMS8pmegt4OH2CaWfQ
n1CmQv3DpSoXq75VSK8+62s7NgncGc91k+iGvY6Kej8V8Bkff41CVe8/WXBcgQWN
9WGtQMKb974xd70LB5IGWkOwRfvm81kU2U3bGVHhn1G5io5BHM4ktI28nSBk+12k
EscMIL6gbqo6caeRgKZZJ+UPniN01kzEBuUnbETCpbxyGpqCnS3bBwl4ppKcBntX
1ZL/dSfRdVzCBdJnyoCr8KvPmEG5Sfo8cAjEN9TadPXWS90azfYIMkHcf7g/tRb4
Il60y/7ve9lgl3JdD5PsPw6tFzvjJ6BnpVxBZ6RkS+fAKanAe4VCilCYzuAxqLo9
H3kDo38jcLLlKuc30khsXWOEe22tmcwfuk+cw4egxp2wfpyfTs/DJTUFLGWludCz
ef3hKUjW4KSDyrhBt6Lkh7yI1BT4jo2obKMg3TWBvtOlSGTqh3ZK5et6DLEwqGOq
YZ6gm2ZbRE+9mR5pCSgUvBNz6kThTDZfcMT8bL4c4apvcAnfTZ1mOuSCwZppLImz
NSDbpvi3+2UBQsOY34L6EO+wCspQxgVfJViUsfJAOy3I1/6pCuinjNmL9uoJiQgc
xCWYNFIZCLPxCAvT36vEC6y9qyrPTGvqcDDvB3jt11vRorr/cElmkTPg+CEA9zUM
xqOBLUk4q4bPhjzElAs8ZvEtbhPzzog8WK0JRHKREPsNQsLfFQ40RM6Rn72vezRw
zsY3BMSW93KRM4fgX42aXE4nD+Drtx4GVtfw5tbJbKPqOb7bCFRI3ACUID1r/fHz
c2jVQ5OK49sgFW/iIfufEIIsMjOvypzaBt7LwZJFiSnWbk6SyDDhsSQ29CKldAzG
KH5RE4ONaO0an/aeLBEeeFPEN/cUmLQ2TZUfhjZgtKNdI0KIG4mg5/lWI4ft7zWf
UBVpTGjZf52j52cDM+9+8KjWg8hyIICbFDs42f6I93lwGRkyivQPVJdTkuwmX4aj
9/eQdu/sa29BzSz53IcihK9nmr1226p2bQXmt7LOEk+JMAIpv8z52etrE3KhbDOI
wr9scpv4wr1fYePn22CTA/joFZXLP8R9bY0yAWeNzPqO4rT5KcrIF1eoHvgSpNIu
UXxkeKfh4RnGY6/DIiZLFpChwIr0v6l7+n+0QkZEsw+cvlb0wB7E1ugcqC9veScC
h8E8/43dZEQncVwA7L6mPWF0ySqrnFHb6s/w7wNE+qXAQmqJjeGUO836fubqZFze
pKcqJFhKcHDtgX5ZhZNk1ZdjaeWJqAfwNs9AhNI/Avpwv//lDHWuAfWWkcx2i3Rb
KgLyP9nIPXMkWFAwfgygKutHcgc0DRrG/ISV3sCVcBbYxiBya3mJGEOyRWLeis9E
eI9lseNgDVuRK1jjhjshSHQNWDZFNQBIL6NMHlrgvvjhLgqmiDgcpg0hU96xGB67
o3VxW0S6HOEOfPu92QE8xnMCDTsWl56rajqk5YJCo5diu8QPj30G5p8EnTFWCmRk
ejE0N/ZhC9I5QI0LhRW03zH+YKeoZl7O630w0QhIStfOEIebZOY8Or69kKY5Fumx
7HTmRajpSXpUyMZIuHndhWVlcbBB5PpxWZzWsJ/uGvp9oJhFwaez6KGnIxmk5W6A
UpJesDKT5CsV2omTHu+v4yJdo+2FbcKumFj8CzjJKbkkKTsvsIcbc0DcdwxD1nTC
nJ8xg97VDxhYBBDxlE3+rmtC1DI/EIVcMt0+e59FaoV8AT8/8C63+YNGCYnx8K7b
eySAD0b9gXMioEPpfzsG20atseYUh/5rbzO0XNOkypu/jSLC5XxyYmStDmCIGEiO
FMRP/7lKiJ/IIojm6QzLTcmV/mdt+LOzFgKjYsVsF9QQqsvHBteaaGnTWZlU/y1O
quDAZNBg3EcpctmHCecmJtcPDK5+WWa1oNWgjw81jkldYxwlDwmLelYNgccIRh2S
CGqA+4gcVHSdFtHY6BdSy9M5spOVs7oTbDiqE9os7KjTGO2HB2sfF4EQVY28xjPH
bd3gT6jBwy/ekWfci5F/YybPdgP3TZ+W9OoRVBcSp+dN2tMA5qAKLMpWRIi0gI1h
NV5R5+Vq9Ixijnu8pF4vFfVu+ATNY9SnGiCVmsvlZf2ER/Zhb26pIodRgxO5GTDh
Wid+l3iK6hxy/XHgyBm5AgTp6+himf5eOQEUhj/xzFoV62pf7iXJSNberj6kRhxN
TWTxWwg6j47ILPWm5koWTZ7Pp77+fMR+QEeRV0S6ALxTLGfyOvyY/+6LR/eUYpt8
ZZf/fv+GTrDezjqG2kv5SYCe5pskAehWz1RsjiypGl2pVcEFeivKDu9ah0mie7Eu
RoQnH51pPsA+GnQGMMjwpkVvJPybBOLQsnlZRRFwrjdQioOo8bSqAXptJ8QeWtY6
vCwok8JU5xHXHoqzPhngOLfcajDTh2ifP1jJnCN1y+QEmPk5tAMdlOjzq4tToSwa
Gp9PhjMFh3ECut2rGKxUgQm5Zs1RhTsKCib+Ba2+uU+fghFxiG2mwiC51p9mxcIN
I+ZECdm7O/LVd1p+/HUoCtEw8g/D8wLrrAHJt3hyp4COf0AoOIWGBzdqOhczOKpd
ktc4Vdz98AEDYcaJe3J1KJTNJdJqGLPK7rnkZzcwTLNYUKnn06Yqold1xqLUAKjf
CNPOafXl3YLeKtqZu3buwFqIVniLN+IpgL136T+4QGZORvEs3q8ZHgZPqrPL3EoJ
JqMFeb/9GDlnMCKl4UKx09e+NPZcZBXRnS7O3EWCc3rEJLTH+qGKsIvzSdaANQ6I
/ZhRb7kFrn1BqG8yMbM6H0ib+L3A2r7nFuss4sUMzj4eoRSnFVpyWpB4pvfedVnY
cgXGsMsUHl32A5D1nSlBWLprN/SnQgMdV0wvqbPqMDE2N0rD2bu2o3mPhJcsgdJX
gMWooSSG+RFw9oWySiLIkoz9Djukb3ZmnrdP1rSoNhIDSJRl4a4t4t1s7q+yoe25
lbg/rkCgwJ7q/ScxF9Lcig5lvmO2OUQCdRj1X7OcKwFQ2SLEUbxdmk0AU1Da6HC/
32J/0ScY51ZGadcvro2JX6qVekfKHIu472HJ/wBgrzoWjhzmo7Nz7fMpFO9Ox2EE
TFkn/OGmIDYEQWzCwT6vBa44/GSlKxy8r/Iri1gaKAqr+x+QQ3OigMlbDGnArE2s
Bc1FXPSVUizH16ERLU6I6xPWgnXaUqj+xNBOQVtY54MAdA2vHBx4vA8womi296lb
eyoOccMKxybXh4aUP5QocCRWFeYDdpXcMseWiw/m7YUjX7zHbqquYntOGAVgtaz/
TiG70bxzxolPLnIKGAa2Orh2Uf9q0XxVo8qCysHvmpJbwMPfpaYvD5yFzZ/mFMur
8vsQ/xjLZeaTEVj9nv94sld+dvNjdICEyQaDKGAER2v9MPvndt5ch/5Jh0QWgEaJ
d90sWJRAk53faLFj4T4ddkdkketVpzOioo8v8wmv8CvBY+DKD75GrApSwB+pJVCT
VUhMJLWba/Fvtmq3e03sKxlPzoxOJFAS0ORubnGQvpLJxEfWHLTCOH6BdVBtAfIv
KiUKOAclxjS7FdVpL9WufIaAZqyKe2l5FQhsMiTNmZYTZnnWGONdZXYPjCOONQAT
Y9sulJNAd4qZXp5dDFDRcC0DA1KGyencVNq1xLt/883ut1iGr3Nr9kLl2o86auou
mg6Rbr8GI54yXZDCkrLkCtk9gGWDLRf/r+Whb6HLrm1dJSgftgiWlSegW9n/wsNp
h2ORcTqjZL7/9J3nIHO2MigQBeiqz/+zIl0+dg7o1LJyGQNMUS1h2Y4wsJxEExVz
Oj8IemXNpU4lIWuGqr5HSnZVZP5qOKl+FVdWtMLBMxffFsDcYxld3q+1ndTrA8Mi
BubrknEs/13r+mHiXIw202RmsnHOX379meX/7fOldBYdLuseHtkPfVFRyGMCjLmz
IYYrzqu1lawmpydIzgA8MLhjF8zSzEy6x80Tc2k7IJJAGmEJW4taD/BzgvDX0AAG
gMsmt+cPkvwj1D4Ho5gphBdqkKorQw+1yu4LF5StFJ5PPIvR7ikez4+JioH8aNYJ
i6ws134kTwaM+BBIMj1SFS/Oawa28hSVbpbKJNfziS2F1+vAommOyn8jbAswxZEh
wctmrqM0tqs1hJWyHlEuyBBo1Hcll3Ng/BaIpmc1SjePapuxZ4Q+xHtGCD+2W40j
u5fb0suMOgL9r8Gkj+9Ldgje+qGrWot2CkyfIm0QZTVCEnpJc17qY8No68lZwfe7
0vI0IVmUyE0E+/idr9Kq/GaTMGUwaZijZ3QoJv6IbmouJKX2VC11TWMJxNZ551TY
aChY7zpzVm0UGP7+QmxsbWL47eE80wEznMxYYL36zoxvHo9Xkn9fE7EF/AkeMZSv
w3HwdkhsgIybf2ieTlKYToBAWjYJ9XQxvd+DVXqMJr9BPGFT8PFy94J09ThYb+FQ
pXbCXc8YW5JP0f8Fgsi8/ZzW5aMSMWLYTAvKalUcd4UN9Owmrt8P4627/1FEp1eM
cYY16I+SQQiXP27tXHuLN+9gBJHC1AH3xeB1d4AMxIkuMm9VY7lnoWGmxGped6/I
lNLkxBhDwzlaSu+hAU4/UxddVQNxcjzeiIeEghX3ykHUb5Dgvf5wrSQOnWoB7Ngv
CEBY7mCUJFTvApSQb0cw8Wzvyo9cSsZXoNulxcfAlGaLxZFV8kXmi++hIsfAAamS
vaswKgpR4wZ7FDfTr5fa7HUNXo/D/O/puQaNFRRm/Jrlb1ynjXTOV64+vwNZX5/6
neQv0oxVO50EkJjAEwSCWTuPjZyDuIfDe7QQ5nOUsHzND9UdaK7Y9zcLo/q1Bq5v
o5iFcZamC/6Ge8xneD+EfW2OGdNMyENh+4IUrQ3wsux8BAB4sr8hvkhqxpl/hASz
Gb9Z+ohHY8Sd7UivX61qD4VqGQyOVKVQCIPmdo+F3X0b02Eyb2UR9Yw3wgnmq3xS
1/yBjmh7JPotmll3sZTQcHkso3HORcMPZfdHkKK04/NFH+FJXmDykiC6fKjKhDt/
RYbz9WEnkYwmDQnm9MZLr8IYSzHV+utYpDfzhZOC8wUToDzYSKMVrYCkEO0xLhOQ
Ds6vlyycBLH+QWHfMhqLNeTc+e0KCyN5K9EGSuiwebPgQiL8HPF1OEpzwDKqn3H2
Vh1XdNeBW1+E+4NrxBNTQxO8oPXYV9jQQGeWdccv7qan0WGQ6K4yoDzTUP35vpp6
kca7PzVveRm4QrMr7rc/XCscZwMcns+JpuFzzWpaF8AZv0XUBppAhZU5GnkBeo3R
3IfyXsno6PgC2KjaZ9g7+/MSNivNUvWvmm6fqXNb7pXAolPljyZr6Uao9MGx23jW

`pragma protect end_protected

endmodule