//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////



module cam #( 
  parameter W_DATA  = 1,  // Width of Search Data
  parameter W_KEY  = 48,  // Width of Return Data
  parameter DEPTH   = 32, // Number of CAM Cells
  localparam W_ADDR = $clog2(DEPTH)
)(
  input                 i_clk,
  input                 i_rst,

  // Ctrl
  input                 i_wr,
  input                 i_del,
  input  [W_DATA-1:0]   i_data,
  input  [W_KEY-1:0]    i_key,
  output [W_DATA-1:0]   o_data,
  output                o_data_val
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
k01F3T4Ic61O/xRcpsMdM36Mr9z+YhVrNGe8k271c6KN6SCwrywi97iVGfrh52Dc
Zi+2rD3nkKB53n3yIbP+id17X1lXCF1zocSEApaPfam32TxPJFk5dKeUJ3d/bSGr
wYN7N/pLd3p4Z3hlLjWoj/8YrpcNor7BLLHXpzRRn7iyO68Jmf8huqut23jrJ/8U
r78BjkfaGTbWMtVNyI6uVlQhte+RK0JUBVgoVIEmEt6NaKNz0udDThd8tR/+lVy4
Ru5h8WBUMVcddP0YbGBgARC5IIDncoZbxT0i7/YMxgGqAJ1QUEQf3Y0BuRFDPl2/
Qm+YMVXTSMSJHu96lCdjEw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
YRtDIesmsazJiU1sH1kLBjGSjKK9GA8mq7VqFy2JaLj5MBfxbnMEP7Ggpx/pD30Z
CXj8QVbnpBI/O8d+MYJHCjPg2Sgeq4zYqrbeUuZUf5TUdZGQlmrRly1ZYqoHx5HS
EDAdF0a9tJ5Znr1ZGbTWz5+yHUyEfMNDwLaGt6WS/Y8=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
YaHJI9JwDZMzSJybmRkWe3AlZ5/BjvueqrkbEfwcGqWqSX8Fu44PNk6NFx8W9H6t
JKRBgUT6uNqy6t5GpLlDxMgnAf+dgi+LtwTQbMU2HfPP0h/BTeSKOyFdLIDBj47M
SzvTL0Nm7mvkfGrALvUd7o1om879SkW2esuaXGf8QWFf/g58mVab09PJInKvIwi5
rc7Z55upCtxDAiGg6jX/qSIQ/pnfLrv/EH6/GBvzU8jsq51oDo+M9BAvec2otJdk
yikP7b5MXoAXbq+ixRw3xginmqZM3kRriGhxAhAWe4JGpGVy5a4OJBxY4jI3tRUY
Et3byxZtTnTgrGh+cuGqFg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
apOsGljoirL/5Vkhg+qflB3POw453uJ5bbln+QsS/d2PY43eJ6UHnOh+VUMvO3+w
ZwJxCjfqsQukoe37beQEtqn8ZIYj7IW0JW7n4HnzNwa0CHiZl3ZUOOpM75OctOs5
uHFEyQ+Oxa7k5qoVdngxhpipzl6F6FSyBzgmJnzMXmoC2ol+Dvf/4v3S5wpMm+iT
Arey7DAoLmSKeA4p1knx2ngivHBlicAVj4ktFV4ITFK5nb3mvGZbb/moqtvp/RbN
Zatdylo/ltf5IEe3+hjEz1yx5wgk6XPnCrsYrBXOBEIKBS4/WAO6kNliaMqXivg3
PO52AuFU/uEhdiLdknyrTA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
ELh210zx+Tn+yCv7Nj4GdZqZXrDd2aHUJ2yT3tTotdSSYuQAnLSvylYKEJcB5KeL
PvV/02y6Rr3l7oZVbIy1hkqWOXM1QJZW547JAAHZfZOPGPQ3PAe26KFq/xhk65H6
2sU85SVG3DQgKE2eVc25zQqiFOHbNE4jPn+4MNmdvGdW9HERrprRy+ORL5J9UWAO
8YLWVUoncxGli9FIelf/j2dHrWDVTyaH2BUslgq0GmlY4tT1uMWsZNfvxVUxA3lb
AYyqnbOmdZAMeU7+vRGtGl1FdVzai3fnWHYigbrlvhvIGGFaJC+QwZTveDQeff3m
z+NsMtkH3gBgWb41H9wsXw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
GeCDgxBdgFvA73UhVKEGxkz13IwkEGmZI6Li3O+fhzj5Ric+22GqM6kfqK5E8opX
XGt0LoNj8H4rTpIWGUI/rYfi0EwmjbHcuWsOCYk4xlEmNVeXuq09SluRrH2wH14g
WyK13r/wBu2q48OkGohzqkcBtFzDggQdJQZOPVWILSgCLX0/2x+ixwmR4saoR2WS
7nxLGSqVExtQsS1Ypo1K7EBpD4DnzmHio0li+NkM60Ntf0M42PUjLmg0nl6xshYc
As5Ku3Z8g305QX+L/FQYl0FG7c46Tbm2iUNU/wH7kdXBJKb0IGV72EC/Yj2127p2
NoAjDVXuJx8XrDnKa5f0/g==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
e0IOGMwc0YqPO43GmT/1HqhgMKsfgj2oMDEIU713IG0Te8FpUZntvmFmrACpKijn
VysjRVh2Bo1E5hlQSS2AWq9poDmVFxqtTF3X/h2W8W0v5wkwT1eCeCPrmje5iR1j
Ab+Zv3DOvyEyzL01Q7SmAu7fY+w70xqceoZEX372Ct4IuMXC/gmViHl46M24ldIH
dxmNdWXC1JnGYzRt/PID+a+FhydMeWN4FPrEk0Sk8EmyN7O12mJneMDez9JqRcGd
FKwHJ2XbKcdP0arGlschC+xeSP2YsMVidkuo0l0OlQ1CKRYPTwrAcEu/RQR0pXp3
n02BAatqY/1DP/Z4DfUGyZ0KXJFJajnudRwDRE10kXz/C3HIgEF0mkMb8oMDZCNl
MC8sbWxb6zxirJ2x+7HtaqJ/zSAAQQpS20JQPhZpOn1jgesx9twAOSTSVg52KP1L
Y5Ima6nmQSKetLkIWH9ggkjTNWAWrvEO2Ovl7NNeh3/yXzJktFiiM/qNGPWcFHCE
kcMG2wrhg6I0hMUvgANKYZayQkO5QN5xX8QklLJ/vpMe4h79SKE6VtxhnKJtf/CT
dcJigtsHlqlvcb9sVjPW8qO2/2tnA7d0elyFzWtZR54jmViQv6NkFyDuYYmvHD2j
IuVrHIHCCwJWuMfWpj9vK/mskqzEM6qJeSn6ppkjIWWTZ31Xmhx6xMHYcmije5BS
L5vgbV8PeLqXPSimenbUlUBXNX8lG5lTFccNT5jHSmQBsqAqfP1h6mQuYZ/BU0aN
Him9v9WSOxdSGwSBXJXHfVIYpRYg8FZYVwy+hWK58ckGHpW0e05+5/jMO4Ajzr8P
Zgcvp7gyRW45gNLNAvUMJmS8aWu1kU1rILZFZk4iIv8VblFkAM+KhAVzqszbqOX5
XoKp7GNAi26xfHOLU79A3A013EJc91XiGsbrWWoIkT65jLKSmneOfTgFcsiLsFth
CeFHFin/v+DEMl2roaFmltn7CX6wnYgKPImtuOnWxKN1UoKwOA1aR42bvtLd7t/f
7i23QwccYZBer2BjQioJrL2yepaUSEvhyikgqFUF6F08uRJsZnyoUHPuFdsydbwM
kiGlMLjUVkyzCJf67Q65oC4TU6f+nbUUFCA4zvJQlV1dT9AMdQTjA+RLkYjKVzOp
9K0Y7/dCWegYXC+9WHR38JTJSEwPGm9BG8LRScjmsHiFc/aV4gT0L82r3+S4d6v6
zrdkjIP4zET8evCDIwHZHLxP2rX6pqlX8X8lTukqmv4U5ZVH2DIiL4Xp8DlqnANQ

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
F17V4dsZQg4llS8mPwLTg1ZB7LZIgfCwqclS16/xw1DpJjCPwQH03oEboyskFFdN
Hh8dkYNgsaLgpobxzLu9HktDi3X8lGkBKK027MjMPC0UFCvJwILmXYXDV9Qfi4Q+
NIbz74pCzfaYK4ATRtrzfqfbP9+sWQCD8CIs6uxAHNc=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=2176)
`pragma protect data_block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`pragma protect end_protected

endmodule