//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module vec_to_axis_dyn_len
#(
    parameter                               AXI_DWIDTH   = 64,
    parameter                               AXI_TKEEP    = AXI_DWIDTH/8,
    parameter                               DATA_WIDTH   = 288
)(
    input                                   clk,
    input                                   rst,

    input                                   trigger,
    input   [DATA_WIDTH-1:0]                data,
    input   [$clog2(DATA_WIDTH/8)-1:0]      byte_len,
    output                                  is_busy,
  //AXIS Interface        
    output  logic                           o_axis_tx_tvalid,                          
    output  logic   [AXI_DWIDTH-1:0]        o_axis_tx_tdata,
    output  logic                           o_axis_tx_tlast,                            
    output  logic                           o_axis_tx_tuser,                            
    output  logic   [(AXI_DWIDTH/8)-1:0]    o_axis_tx_tkeep,                            
    input                                   i_axis_tx_tready      
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
YANYuI0mHk/qxnoTFzvPs9+lJJZ3VMtFMDl6qNbuSAOac1juJ/b813FCvK7DK4DU
ADFw932RlA9YQus7u/HZg9qB/WkyPbNTvGwZuneVXQKDJfzI3bqJCuR9Djrt20FW
OVvLNZLZDZSzkEdmVh4cgGL95BOkPyGZVShwJUuGzoNeuuyCUmsrTOtxxrQGSCDr
qrTMitbRux0eDMSFASA1bO0dsNHUS8LVMO0y4aKlPr04Q40TAk1qlWqtzH4KTW5P
id0RylDF242lOfbjSKW8qw/47r2Z0VxpRgLxFgPF7WVvNefISBL22fAxzOTh05TK
ByhUruWgEA5ovQMRB3T2Tg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
3ppDNfhmP4JAezuLs+3oOH7nJXw2aNW925skOMNx5ucmSEdGqPRFpfAA7YFWfxtj
hU2Qv+iwUokcPKfPFloCHY5OCjSfi3RKdnMEgA1V3Sv/cjWVU8Tuc7ho8irJYiGN
9DnR7Fp0nk9Akj08v9zmUKv6iJ2wOo/VxPi26Ds+jH0=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
T4gg4xafnjp5OXv5GgOT0IE/PTvR7p029Vs5UNsWcL8+fyWGJauu1kU6HtmqG3Jl
Pl+nbp0JJd1U2K5Z9EZft0BgriXyZKbsR/dpSgOZB8zQLXMymvOkQ75+D6yDOcBC
+RJpF29ou2veleNtcOZy4ShnpSrIWkTtZz1ELlxs/6sCmarS082mXuhqppn8Ulg0
FnNPM5DF2RP6Z7YBKnDfj9MO59VWVxV6XaiqjclpfhCrQdOG0j5jfZnsqubkn12h
3lvCrOWPDiSfq644Si5P7RqfgyRlt1+DQhzy3e+ufr7axXvOSY0Qtglx/kFVJZbs
Lp1Omt+c3Wg+KWf7JLfXNA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
RQRdV8nZXP8sX9aKJX88DBaSuZzQ650kJ693IysQNs9x6dzAX4n1ZkUd6cK+BD3Q
ECNUNI0D4fV9zoh088GImrw5AEOQsmCua/tU3Fqjah2kVRcK23VlYhW65mgzHWh2
sapIsPH2vZZ6Vv4CF+qAOJvQ3GmDAHonj57yQdOOgFNgiKaM2nRBkXQVJ2+X3bIE
KxXyJkKMtFy+eb6zE86sNryWUDIQRtqSEhd7kegK7Tm3nBecNqsg1tmyEagXRAua
XVFPF725KAQVb/8PEUKVRbj6UIRhD+C+lLPCtvbKN223o0x8Vj3k59MzM61H4iAE
BLA2M18M731EPjbyRozfLw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
o9csBTNlCVS5p0sUBz9C1jO7ouTj7JLeI+QyPtM8mrOQp0joaWdhdOJFLe2ehGmn
lPRSymzHuwOccsjzMhOD24vCrYCpLNBKiy881gK2tOFx4KBc2VsOe140k5ZeyYoS
1+2JVDgUk+pSymuq1k3F3Nkc5SJ3AeqZnLVfRmpmbFhvykMzpWWcI6BqoH2cZLV/
cZoR8mxRfZpxxc2IIggnezg5yjaSgOuDC8Agv5FZl0wcBY0n4fdFs6jXk32MR5jf
ijyDsJVuHIxcztZ3FzYQYoY7Ul5/5+7c5owjK8gUP3UAVrCl9JNcdIQMFZginX7P
AoALj8TaCAyog8PqSA+QTQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
pKz3egAHHRVV8AluATp1k9mn0aXndf+C117KDNAVG9Q9PIhpeEFXVf9WAcekpViK
nATHAjZe8y4WUaeuulIFDfH+sRXdnjaeZnfTuOLA41iuauoA2dNAyQHHtFryIMux
YK1FZMFCBrn1erKd96h1Ep+Anx9XEehw/wCXw30lOHHpkJVPZCO9jUf3NF1V0VEY
3yDRnPFjNZMusSKhZfmYKrMjbBy4aSnv+YwwsaoBMuQMmQjvN2lltmM4XESCED3y
NZ+O/KMDu3Erxw38oFLuMRR+SlBRVcZhTqDaU5QHT/8dwfisRdr/KQ/m+5RE0yzf
BKVwq/NAscLJGzY0WJDe5w==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
wH2fzZVofObnVMdqoeS3CQQFlVS/jBwkJ66qh6Hgw6C8QZTndMKRpjUqVleAV+Iy
UDt6c8REz0wRede5pteDakLfpEf8cRjCvULU94jsIrk2zHINt1ue5T4SOd1f0+es
dlGJpWrKDzU0h5yYKk+xe8NvRPB0T8gJCKqlSZrYZPupzH67gvwtaonMr8cBkFVp
tlnwIy1W8ooAswje3fwHmpA0miyZuwcgzeumE+sbn914WWH8CQPIwNOsXeseRzr6
G7cJhDoDJyooEYOFSq8AhFasSJJBdC9wpeOay/cU9a+nB+d5q0VHcWlsv9wk/lZS
BxYfMA81VrLYvazCake5u9rg0TzGUSRgO2oi7Utlxbh7M+pXmvSetZCbnocxMnPf
OSaRIMTMhI3KgVUpTX47mod1OC12JmlMa/Qdi6VXhCkCQU6nD0GusIDk/YgKujY5
z0zqTLzNpKu38rMSQ08t3UhrIS32rGM2wuNjIXZ/DcMUSkNppjwGt5mxMlRYqa+t
8z+XB0uiUFuQuoKuQ8ro9XPUCYSKIGSeMTKJz4Obibv16l86Z8M99ZOsMoG6xZ+u
kKbxZBcQ7dsQzMv40VtDgOKOaaWVwsR8Sn3fvW0094nXN58cliME1r4Q/bBofXTq
4HcXNjOQfxyYQUboNqHqGZQyWITj6adQ9hefHPm/YcTtEZjOYMmVMl6ER5yIUQ7u
kqn4u+/yQ2tcSU2tcUKN5uR5kSz/kdBQ7neuw3nyphuo154eXK4ug3lp4PSopYk4
5LzVj1sx4N13Upq98W7bVki+LQeoUVTTUozPiMrsiPO2T7kZruQP9w11CfB1xkxh
/QCC1nRurAe/7inhguSbvUl/BuvDvwuOLjaVi10mwwQF1viTdO/wHUeD99f4+2/X
Xa2e8H2FUPH78EHbvE4+Qyk0eizqUMMfq1mm+LIMaEz12MwM3Eq51tzty+5X9+HF
bjL/J4SOdiHIDKdf74TUqh9wAqcwJug9DI8JmMv3DD277OzRSi6EsvD93W5EyAwj
LZJg3J/mdSKZLjhRTZeO60ZSrSnJSPa0VuxoDka51KValtVdlHSiKn6336QFUv+i
wOBiW/xjZozxf2b1WQRA+wbrBMywQzV9ehvPrGQebOPDiv5IDKRkvljcQeg7Gtzh
pvqtbG/VaB+qKZmF/L8rwKvkeF3oYmk3ZsGPZsPbY1VmZLK+81m0iUYYi+A0Tf5y
7vBUEEcYM7bl452JliAmOldwKEX10MWKOomgdWbEXqTHW7BmG4gULUQNR7+QuypV

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
dHsVMYSt1VB3XYOc1E8Uv+JL3HSG8CXopOdKyVyNBDe/KgIW8/6gAWcPIOSGbBua
0UQ/ASF0jTMTcnuzUKB9VHY2amogSTOsIVhTNKShJ/24CW8lBaycf9trbJePpoEC
zeg9AKEjEHMLM7c4v54v44yFicpjbiiCA7iKgdFwxT4=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=2816)
`pragma protect data_block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`pragma protect end_protected

endmodule
