//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module vec_to_axis
#(
    parameter                               AXI_DWIDTH   = 64,
    parameter                               DATA_WIDTH   = 288,
    parameter                               PADDED_WIDTH = DATA_WIDTH,
    parameter                               REG_DATA     = 1
)(
    input                                   clk,
    input                                   rst,

    input                                   trigger,
    input   [DATA_WIDTH-1:0]                data,
    output                                  is_busy,
  //AXIS Interface        
    output  logic                           o_axis_tx_tvalid,                          
    output  logic   [AXI_DWIDTH-1:0]        o_axis_tx_tdata,
    output  logic                           o_axis_tx_tlast,                            
    output  logic                           o_axis_tx_tuser,                            
    output  logic   [(AXI_DWIDTH/8)-1:0]    o_axis_tx_tkeep,                            
    input                                   i_axis_tx_tready      
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
MaB+OI/IsS3bpMfqFMjfIgBkgP5wFuAu7XpCaplwAVnbbtb/o7/y19b80Jpcl5wT
IqYBWyBfnwuKRXod5dNyXv+a0zrRJ1ekwgRXLzhT/ohVoG7z2UnCy0U0Zpq98E6l
w3roSez0xBtPOHF/XPpzLuIN6quBm37vKd33YadlYGsZ74WnvTj9HdqD3rNHfdQv
1dlRdfitr+1W/8/4hn2pdQVDYfzk5l8PuYVMwe9hVavX7wBPgFcvEGQonlaE8kqu
Pv8goLqQqEWN0nTCTuHYPSo8pKjZscw64hiid0gsWN1UIiHCYZhAuQFnUUq5jm5/
twwm+qnfTT0rKdVJ9qt5dw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
1zpUORHJYavqSBdhuwFRYjsfR4/wL6sRs9rRoIp4oX85wWjnPBSMJ1Jyj2dqnJJc
RmYVj47eki1i/KJdFQQht2ngrxsy8/foHF1fap4nbCXrZfRWicYIAqgOI345oP3k
j/AVTt5OJA/qMSLMiNBMbLGY0ImF/9pO/IAy3AJkH9E=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
qweMeccl2k6ead2LDLnlKAEn4YdDZDqvyS0Vl/vdwTiIc7BpboE2JD8fvlL3k4+m
FHziXbjZL4/f7a0AwQzWxZq3v3Fkd3K1EaIP5TIN3wVgpYd+v4NlfQxGV2XMYrbt
DDx6p3ZUswYezg0JvN3uYgxETRwELTKk4JOkI84QwxOeL+sCNX4EvItO+ltTCYTn
e8/5oUV3gUCHGIewiahc9Z2oWBuswxd3Crxe3xv5XmBpHeTe6wtJvGXdP71N8+Gj
/MmM5ZYd0eh+i6XfoaLJnmgvybi69tGebxH2dPXfrkj0Vdj/WC809/FzB56XVTvD
uiZa6Ax9wNka2K8UBqqjEg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
eVlrL0GL9yw+8YyVedC/hDdlVXnjSKIEcXoiN6YGHRlBaYjaq2YE7o327cY6gzHm
HabgS23DIW/Eyi8URppFzH5l0t3Jjo2IQ4zk9xx1hJ8/gUWv2UvmfBbw3rBsC6m9
YIh4r5/fGvZNzGKfE4S+JwHGcNtjhWgymF619Bcg72RRwfD2qNedlZsBFK4VE2RU
5RbKfx9KRbphfz0ojxYWRRu3JjdAIAMZOYl/ftTcCOmc7UyJQ9BGHNUbv7il8ibu
t21bXtn6VKsRUQM5TYo369XH2DuOXfX0nh/DCUmDStVANkl3o5uetsnQfLqxdJC4
H0kSE9fMNXBk+WZNJ/4atw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
4SLuZ/ft8xv8RhQvZpmIfY7aDUN7XREqu5R68lv6o4lB0elcr6hQthg8LCjnDGeP
h0d+V3Ij2AHL5U35DFleqNWHYq6Nt/9VpQuttDxF4M2etb3tsobJZhqN9MJ6yUtw
7xbxXOH3ISY9KUZNPD8oC9rEVPsldfEl56mdrDZQyQQH7ETU1lwJ467sj2CNM2sa
LXyNC7baU6XcfAX54knfHKioJtmJy9GfrAUSV7NdrAQ3+hpmeHKs3xGnnvMjrQ6H
H/xdHgaXX55UoE5C5f+jrEk3tCD2e1mLXOKCtiQsh5lfhse+AkIy0p8sXwXugren
Miw+XA6zfFKIG3qo2z8iwQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
J047MmsispZnTIpEbnKGnqwockGprriSjUNXUBWBaRKV+c07JoRonf60UzQ6kGNW
0bBhR2unmBVMkDqfrFeKuyOt0E+YUc0AyWXNjq5vqL6nN9AIvOmpspu6eydXf42h
1vq6VD1QfZxoYxQuPMoIw1iv9F58glYDOfCSBXywjuCM+VPFvhj3HsROM1qGYTRV
2yZyKdUDe/abDtqNngFCYpxve6p74bO0uSsXbSnyyNR+aiOhP5/XoX4QEgtl/ghW
q5fdkwg4BhsZbhA4wf3Q1AYxV6Ojapt3tqK3RURCbM9jbSQ5CZ8PoB6KGpyfXfUl
NjImeprFw63lxxGfKWkluA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
Jd/f0JYSUqEu3FPLMVN5nRYJ5xqd7mcwwxgt+HAI/P7fKhVrH9oK9hntMRtaCVft
KG1X+bWf1rMgiJ3A8b+nbnmDtLfReqpTIW4jJBg0xPeYKKz2vNf4zdgZGNEHHFI5
ev5l/EpXuKcKsqev6OzI6VgiXveqTr02pu97WVi3+8ULQ/DIdO+zCu8T0OjhUBWf
pB76TvZR58jHWdy4E2has2b+n2AzyXtqk2X/h15W9mV2WYk6qUtKh4O2OTx5eLrs
iN++B7H9UDgqowGOcosN5qKrVpoJGLX3VEOZ6h4k6BZsfllEU6tTYc7X4Dp+oTIL
4tZSZ28/uwZwwnhh/3uhgekEjVQO3dTCeWJuJGi0tl14FIhddriWkah1+cm9mrUN
Gj69sf9jOVN/HrPwhA4pN3h2cR/FksEjOf2TFFC0X4hHcAze8B+HAgaVP1yC4wtw
bt2tQrw8exHjP1Sa4I8vPWHNN8FA685gu+66T1MtrDfcGepbx6Ihb5p9Drb1DV6/
+6oTEKQUe8HeY+UzoP4Mbw+ugOBd0N/dYFa4oxKAnKoU76lFv8Am7o60PtV4ZAeK
6vSX1Unbi9+Mr6mMJTa7S8+vdSnCFJztVGlSq2nMdkhRM9QFgYvXKcveICCFl8mN
LPpDSphGNFNbSR0XBgI+qR3i1elGi30B00XwsJftDpGtpxUwUrBnVXyVQaWXA9KL
k+qGiPhnb+VYUEGPSlo/9GV2Er13vvWerWn6whTv+j3fXtagM63/QGIIouhzLAcK
gGbUGwB2k5pngc7vNDCKwH80RayiSRjKNcrPtZ4DrLYMP4o6NKdxxairBHZYM9CA
e53Hrlmk7CEXkcbX3UWk1AhVX6RzVm+5Hj2FBXcWOypu3kOAHrc9LeYkTHG+X3kk
p71cfuAW184ckTZaXMXA4WeXRJk/IFJ8/adMGYKP+MQ4QcY6ln5fwz1rWp/izEBH
ONtz4iK0jasw0+sa8gHmLKgX4N0d1mDTnxQYV/6YaOkNFrE/7E5RjmQiif0UCWMo
3uwvgmUbie55Tu8ztZxYiLMJrRO8kkRlNyDE7F9dAT8V3bVyns823wItwahi134/
nlMG/UZ/hFCNo+6p3SZ4Pwqd8AGoVZXYg7LprtB714K5lYFlZNEolgMQYC7xBzOi
Vj/LSwyf/6JJc4l+mnrTkpQsqOvSGPVVwhfdpp/JoADGVzO9H5x6NEbNe0bITal6
LXscab3cKMcbnRcKXZvrjLcesdASl95w+B8arbZVXoTVGkFZeGQpW6dg5RZvxbJh

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
CqRBDODmzReWFC1xdK+n7KCF82C7OxuLIRJN+dRUme+pkTfh3oxxu00vpmapotFi
/9DFqvN6CTxSLnhFFIg4WwyZtJhS3Kb3Qx6Eea4CmNmtlWBbKe5K5Gl6nXq9YFK0
9vg41iu8puei3+uUb+bIn1WCWdo0evBrIVLFpsH6yOg=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=3792)
`pragma protect data_block
Pm2Nu968VgkXbNhUw8FSWVV1EUh/kyVdHkG6Zl+MgzLIIzfBOGTjrS/JpQrnHY6h
cbt1x4KTzX9FqVeat8VUotwU4rJ/4LZf+WBihGEsY1YSYEbma1oyl3PV9A1Wb/J8
5g7eUxrLxPnfWxF2xVis3AQcp1quGt83rPFVDGa4OjcLFdNEalQUeSQwlcFRDcb8
NY97D7yH5kSGj/dmNptZioDEnEXx74Moa/jfLh1/nne7xzANw0owtbfB8a4gz6jr
M38BsVv1Z8mXjmHlGqkBXXkL6a3tsLjzYkwchxPxPppk43hNYgU24fdx/gTFVr7N
7+GFDU5OYO3hyExyqvRgUENWRrCO2BkT6l0IaUMnS7mcQSGoWuR+sNhLltJSnip5
PqJRj8hy9cIQDWKRYmvbvOHGzV3HQvXWmCEPxFjO7wzWxEMhHaVSOf9tnxXL0pJ6
V5yMUoCsVGdZJVz6HjO3VUwo44N6zRFI/iE/moIvuh2RHXKjcZtGiVDmRQRYb7tL
z8sDkEIFxMmpCbViyGm0mYiN5PnOCs3LsnSp0i+5UnCiSzJvXFIJFgYjFwOM9Se4
83B+m8T524f8iz+/f6N7jPbO6KfxmrKbAzjwUXm7aJ6yR7nGaQ1IKQvE4GW1VOaL
i+blsHXZYXtRUu4qux5um/nwYUApZny0/BUOTmWfP0V3FAbxU648bdAtHFJ+iF9N
tuhn8tGNf1dKS9op9df+IxhJReU1Eb+VpWzGzLv3SsbgGMfqS0l3gW/C21CIG2aS
CYs/q0xpSsJgXjVgdy9EuH8DONWLeKei9rlqGFZBsS3ov5LNt2IJsXA+6+3N8n2W
0SrUcejpXZvW+z8rT+f7kgh4fisy0+1zCFMNhNei4fzU667fmN0wUeBtYGOpSBOb
6CQmfxwQnSp/2WGELOp8n2TlhJuq13UPOe3i3jl38MZbVqq2sgldpnCmlKygBi7i
oBPbeC0W41/P2VCceaxsMz5WL9Btp7exfb2qm7zixd0YLWE2wBiAv2l0QAH5LCNx
F8v10ktHbgonMCmBCGjnvPEeYySir6XOMD9COSIVFq4df8kV8Fhre1G72dH+e2ij
CimrlH2H12VUV1qVHZIA9MadDIFa5it6Kni8uT2EcmN9Ge31IzQQJEBcbNIzrSkL
HOGbRNe0wXTQSXhpDYOe4d72oYAU0I7Y5pzccw/0FYERfKviLTlGPu0DN6fkY7d2
zeOUF+i6LstEORhp3tF0p50iv2rEJusXhpc/ljqsr8A2yvUMXVaURc+ZIzc8iZOW
IjVjC3xQlr85GzIuBxQFdpLqRbEkGcOhvx80tfb2yDdN8k0ZTKYPmqWnOVenkeXY
FLDRAGSnMcbe1nf91QxnbZZdMrs8UjT/97iX9SKEqTaj33EHbVhmwGFXiTZLLozg
iBYZ6CbEyBnwzVfxKhK9kLf3UO3afNqp2EIe0QjMsa319JsGN0/qSDr9EazZDQYq
UuqUnURWtLKJzKBBmbDP6cq90kAPiPQQStqfqlzuVpRTKH70NaYr4Fm22QdQt8Yr
T1bJC55M9rgkHgcBUazR6j/2hQXloMM8fGTFAHoZs6N7MmMa4v/3W9R2FP+viCEo
mEa/+jWa+UhREUhlwbfO96fJR90JcL9E5vIQZqbf6JB0C1TkA5G1Dp+o63HSf7x5
s4ubhan4Q/FYDEnUEDeAVTErs+/kWRqd6VT/iUU3fLvMBUNVPNxfvremMqaqvD/Q
oM0UXf+H7PcVqEj0yGQ7aVvM0iLU9DFGEeGHzwOOpld+yk09WjlPaXwyBbSW0i2i
iQ42HvtlNMFdblPE/tfzurLSKtFWc+GunVXlmQkiUB99S7vekU1NqdSE9AuM2FTf
5jkHlD3rnOLAfXWQBDVPNpMG+gJzyQstag7I1BI8gmryqmrJUAjfUIK2ZMD7bpZp
Obdd0FRlIARR6w8oSMzPgx4XAT/SaawiofhjgNhcl8eKFzci9PRfNvjNX7PPHg9L
3YvWBoFNLPZfPg/vDCJjnI5MCDw80IX22F/hTs4AFufcr2XyTSueSx1MroqpMomF
AZ8/iAi0/sKxd5bfKjBxVvfmsqFMA74m7QTur2agCxqsTThIFUAWvrlGTZUfnA8P
TbcceAhfChuFWwT9iQzTWqAzMUZNq9Eew7AmwfBLcP/etQniPw/LDcVL1Yg/MyTu
DAv7RUwRZrLMYM2fz4KDhrUP92+mFxge2AR3RlXjxq9/M3aFFYk0P+t1DZL6PbRL
dm+xB5vpMctUYtyVYKVVWH+pV6e8u0iyq4LrNFGmZG+ci4GvDZA6pCfvV8CoQdoj
LyV3wa8wrqTv3jYySLrdFjBP6GLAkoHJ/ZCkpXtVBfvguduXx1AcujRrcfFQ3dmS
GIrFbj1BRji54CRBHCPgnfxUyJeuC5BWlU+2BYzwjdP4A6oc/tOnAn1YcRr3O8B6
rtKv9tTsaArNKNWND3BQlZolKuqCDZQ5o8x1Cdlp3WTTXmz4nQsVYifHF0d8yLXG
H9y9Ip57MsDuSQpQQVWuUI2+jS8Dx2iayGpvbu+5ksPeBfNfTHL2eJ0zbXdq/3yB
OiJ4w0tYwTHod+C7/9K16ltLS3uyiYxnrt9sHBO4cRbq1GvED8LExAMobwq0Cml+
PPy7fquoD2GHvdVbQznsKVdG2qJOGYyxlKSXgowo04Xi8whqX8GfhJEz9XFXkUxF
NhzZL9FzZ82xAi6myK6hfrKfJ/+kreX9zvVYcJ0OyMadtaw5WqEyy48GJ77AxAn8
utW3DbqgFQJbaE0/vAiQkcCBE9+vV9mU6/btmZPEyqlA6/EhiBGlXDWZMopKKEfS
hNkQpEIGDFWctc+2kt/9W/uxdfp/0BxmBSt8h0j4E05inGjvLxDoifzglivfYBIv
q0HdkvQnTzPlI8pIUTpw31MTSE2hDuHooqiuXDYNkCbv6lY2TlsRYRZO1mQepvpJ
ierU2/MP67KLn6WS903aBzRZ+Jb6T1oww1W8/xMlq+hYXe24sG4vppoufIwzJA90
1ZbDEcW2IJOzyNmBYyQcnq/xEoIU+uvXwdNPKlPZCKtojQ6FdM9zaBd3kHxzP6Z3
FaRvztEkn5Rp4tb6PEWwCneish6ejyNTbK+Pmdvc80C9IGEG3k5ejs4mcyPZ6y1s
IGk/dMz//0mff2BxT3abaDzMf8DTVdxws4yNzJDZdAvJWfB/YG2648PdHTmPSnz5
FaHtWfCuloRkAq9sayrJsVz52XBOHtiIzARtRk5dcvqWcn84k7h/nxB3AwSUKK2x
UU0TyJ4GYiFTwfoqLK3sHb1Do+po1MySD7Ie7ZDvfq5R0LLZShFy9vPparoSp+vL
SkUSoDV7U6IRsE7s0FMRNt5/1gfgzXcCiD1iZHGuXolUQPHixRO+XLuCxKtzfwAf
VU7TwQsJHgjrarvK74zh4m9FXgPb0AjTbzcWjK1oWU+QWLi0jSAZ3R7vl2fvuOHe
sDTOEQtppH2kpoAnB7KewwqOVccgQ2aCuQtlk2RezFUfQC8t/2u3W8Ej5waGWfL4
iE4OsfdAIfE9de5XSKO/VGPPaCQz1g2kXXscLF5TBclq2gVXfQarJ7nqC5Ycn+zN
SApZGQDQDQ7vquAbCVRHhyf4vFM7f8TmB4CE1CUrpHziCxl8ldgTQ52pC1KRDHuk
CFuBaCdaCn+w6vbzsibPO2D6w8OXjByYd2kJ8m9A22+oJaZQgnqqTUv7bzu6HmCZ
/gihF+NrAbBtRcEUpLrFCEYax4xH1sXU2phbDUgdY04Np44OaPj6VGFXQLcv9dNY
FVCgtyYgAyWfmssT1Zfe0qe8qOWdx/+b7qrS5WWaEPZdIOY0sgS+oK7y1REJThDI
tzteSi2BHjvhvY9jkzlzW50Ruf29YCMa4CfcV10FPorZAtAxtpI+7NYMGL7CCuQV
Mq/rNJgMoq4r65miIA5SqdohXbaZzHWb2V2Y/bZ45s0fysJ0r/0cJcaPaMDYS/YT
+IwQc4asgMxqkPKMfZ2u0bWq+hbR5e4rP8FvBt22PUyIFHv4f+QEE5KGprqm4BXS
xhhJDQK13oaGWwt4YTBteMbOikQW5euHQGOwwShRwxCqE0AieZl5VJPIzwl1e+Dq
YEAwkxNzgpJmxZ8mQi/bPNO1RtTrXmgnmX6Y5MfxWmLdMZrkpJw50wK022KTWavy
7YJSg5NnVloTuSKoXKqrUn8e0SHCNB7K6mwK4M0UdsWKNzTshOh31LoeO2hNZNG7
Kni43u4LtDEjX2Sy3A070RLIPeoQLRdC6Qok8GSVvPWusTjFX3TXHXJuMVJiYbF+
85ePL5IvosaKlWCbCHIzODP/FOHmBsfmKXexprC40a/n3upZL57P0GEUrEGunbAU
L2rYAVIaYDPMMYzhI8owZqV90ipLYmfeS+FvZQ96miN6EIqmpV5adfCLieTv7vu0
OSZHCvbsZkWU8mYCvbR45GFasHPWyD2AlRX/zPQa9P9Rdohork9BrzBbrOgSdpkG
kZqv+6M8g6Vi7qyq4J04zjBW+vIXYlohdx5W9VlZbze+YVXeZfe+Uic0e8ufiStT
VTlGcU4a2dTSXdrXeP8lhXhje420e/I3d1A6ogFxZThjYQh5ZAF12MEcmH6W1eT7
KevaLZrzwQ5oxCKb8/G3wCk9n91ZjI6GV4RViXB8d4lpUfNG7NstcyIINWATSFlF
7OzChUMQR3ujJwZH0OWgY14bEq2pV+WWIOf/6YxzkAxbhsgFD0BE6C+xsLhvXZ6W
ph3c+Mf1TXVLQ0Z3TpufdWGH5Efq2Y0YEFJZ+cFc81fTSCpOe8p2dYv1oGF8dUBS
H+z3ZIIYHV8KfokN3SAKq5XqqQ1gJOGnO7XORO7X7dbiyfVhDKymzojk6hJQicDa
pH9cTXf+HcH+VPzcyK/Y7OgJkqQlLoZBbSpW2vircYFQc8PQe7hWO2yWpKbmET8/
718h/etW+8SE/kXYt4kA7xXZIHzAxgui/ugaUTd3SdqBojelyDgfZFXeCh5FnQtB
Haevw7itDL+cBt1WqrO8jNbWZT1XpBtDSXTRUs63RS/armcWGttrOA3YAjF0Sxdr

`pragma protect end_protected

endmodule
