//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module axis_to_vec
#(
    parameter                               AXI_DWIDTH   = 64,
    parameter                               DATA_WIDTH   = 288,
    localparam                              W_KEEP       = (AXI_DWIDTH/8),
    localparam                              CNT_WIDTH    = $clog2(DATA_WIDTH/8)
)(
    input                                   clk,
    input                                   rst,
  //AXIS Interface        
    input  logic                            i_axis_rx_tvalid,                          
    input  logic   [AXI_DWIDTH-1:0]         i_axis_rx_tdata,
    input  logic                            i_axis_rx_tlast,                            
    input  logic                            i_axis_rx_tuser,                            
    input  logic   [W_KEEP-1:0]             i_axis_rx_tkeep,                            
    output                                  o_axis_rx_tready,      
    //Control        
    input                                   i_done,
    output   [DATA_WIDTH-1:0]               o_data,
    output                                  o_valid,
    output                                  o_busy,
    output   [CNT_WIDTH-1:0]                o_byte_cnt
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
wzkHIjJwnlfT0DrRIqIC7AXsBXLQOrdX95cSroMdtgjke1nQeb1j6V7LflE5KHSf
0DNUOmAsWoxw2iV56u4wZk+e8Y5kWd79ykMyeVNMbjeIKhheyCYEN49ZnxoRGCtG
2xpwmod2P3th7N7NgXGp9y4lAvrcG1B54NVrm1AR9ZSLBptxpjhIYobIekulcw0N
Pp8GBf5EFNIbXtyO16HPPsNUkCjOA7rjXGyawuZr8ibg3ZSrw5OVSQvnqpqt0HUc
vjJ4BYjng0WKJJRcdtzI6FXnHLRv/1+Ys/3DBXUMpc0QaAz65FxKOH/u8n631n7e
QHeTCQSDH+ioc4a4Zi8CRA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
W1pB9xlT3sNPrxawfDedCNBmuqbjMj2C9j9zG4nh24bOlmI+x02hP+mQ5v82nv1F
JJytqdURO3L472MbicI/1JLDuEfBTJlTx7JrewsLMA3MUTvhP8PbJK7I1IcTDCM9
juK9jXnB4YW/yredPzhDr+5exy+cvqsAmw6MpO2S6Fg=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
gi5W+qlPPBek13BdaKR6zUQ9uBowmIONJUhH5NDyE4Ln2KEGQsQTOWc04J9cDQVN
N2R5PpZ5n8nmV7Se3CAvwFL69vxM5VrxVs9Cfp2y2ffD3biPqNnO337oLjmlyumJ
9E/JD5jHHGs6d/C+fDEPOjOqSdFAyV/f//lXBky75ubGnvbBhVqvuWwLdmrGDOpz
N2pR1tpfp4AHpk7d3Wpi0MXbmMv5+D28WWfUv7+JONSoXhRmovuUE6Dwx2Fze2OQ
QhNBe2dSevwszhuNfHaRcNFGZyWiF+1Ay/DmzIXMYP6IUX3ssIrlDXEV+N0k1/Vt
6qr+M8CAZ0PYiJPkbX3j2g==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
Imn7WIqrO0XQm0Nm7sm7sRJa8DOJhgJfpr1IMF9GiUGumIx3ICUETgrlRpfekFza
7fBGOgoOL0161KZ+F1y+5xgqjBgSz+0RCoT80A5ZWdb3kAHqNR4PDA2Cn/QbhQq8
SAi9ykygO7ryWuaLVqt4/XV24skGmyMVVEY2uyPkaffqgW/yoGgwDgAf6fWVf1Gt
1h7HmxFBlNH5WhpFjB7wstr34PrxhkFjL5nGaWBOx9RDS/myeuL5XtkdGy1qaO3W
FU9C1oljBl4zIkH1pPrjaJAsJyKQ895S0VB65BDKPNFlpWDuI8jtx3tFdxvvGfTR
Pr1ZgN4E21uthZTW7dW1Og==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
n41SvZ/g72hkXi0jPQraxsgpBnf7a+Z5v9bDsCZqZ5fn/4Vy/fL3nlVJ5RBDA1Ld
avGBp2CtWynJH8MFazFjZb1xg84RuGDsuSR/TQaZswc7BhILANoWXLkolLxtiyIC
R/Q+GK1TbTIpUO1JwYR3CIlPsmy9gT0jJJ5k05hlmSk+uSqIbDWhGDEh++1FTeL4
WFr3kJlVzeZl19Zf+Tcs2le6JRRgs0f/lRqoHOgLYZGt09UwTqdz9VX9KtZHSDnI
mmjjgCXnToroCZQ9o2JkCDvBY2QL0J1Dfw8A/plnRNrMTmOVFF/qMJ2UWmt9JBvI
5bwKroRKTp6arBgODgCPYg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
h2Nyc6ZPGxhLy2RKTYZYrpt5YnxpWTenpkWVx70I/vPI59ZwuO679HuLyfRczBQE
wBf2Ov8GodRTXuR/q9xDMJT8SKI3PIus4wBmVGlZhlalTrtx3oS1emhAMWKEsyyi
ysYEjcUd3+cWldJAn84wPBFm246iMqdh2XdWXcF3eL2uDmxqZLeuHiyL3TyWodC1
dq0zZnnH557P57gFSawSybCmaOGUyAiwHqzW5AKkaDRALDcBJv/NtJvxgPRl0MCw
o14yFkMTOAE98FvVLbdE32Q/XgIyiOgHw3KAazK1KAQeG5Pe1GCIvt+r+egCFGf+
d3FxgvXoIkNi+at+iczRyA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
Abu0qiGCNAYXTnCbw9DrbcNaPx3Bm8MRUifzkyA2bDc0oTYSb9+yJMNayA3bsXoS
M2pI87VZLg4P3tH2krx1R9ulxTBgNKXx39UoKjsvPbLRMjK5TZ5UVTomzDbZsooT
Pj+gUhIZqvpGVPtwNhB3d7hk8F33bjx+NpRVOjCVpd105XAjHTx/r7n56aJ3Kkdr
ZGdA4iUBp7Ne4RRMHcK/I2IUQIT5yHNcqg2SBXI14oesh7aVYiaomwZAuw5vrzH5
BP5ablWFQef67AcEZMVwGba/NwG1cQZVt39BAzlbOlJ6+v5H1acBeoGS0kihf54D
NDwedFj09oEyslmGqF+s+lJJZbaa/W8s7kYUcYSozDDvA6c09VK7sUUujdUtHryh
gDqn90HxPreZa3mHN1lzFltsUNWK7le1EoYPioxKFhjv4HTxLJQgcYHtRSTkjzkE
tfwJEsF0DkTaoVjpsGTbeYEIuRA9T73GGNDDtBRabcFeHOjBkWRlV+FZxBNPmScZ
6BQymk8aVjboFOJXvRR/lGizGY2fusBRpUUud226vW6w3V8tXEEtlbJP3g9oIOvS
oqJgyaZXtXUMY7gkIWld/185B1gKMbIUY4K1+bB7l8ZdNX+uBqamRf7qjLk5fMTc
v/0qD9anUwGHu28jPoVZ5n8w4ef2ABRL4GuFdlrGxEwBxGmMNQd9zrKFDE8UQq31
4XJl0n3t57menexRkUY1dzjzkDdXsaDYZW9scxSsPlHn3eKLpjRwMAWV4s/YRrBp
XOQN5v3qoT21aj5V/hgfTyXaMUCA5fbs/yAMFhw8enb8x28RqKXN+3JCWM8wwqzc
vWhySF4I6fy00rTuFsSwQOiQ5/Ff3v+d+xi7Kg9RLWxLurJgntI/l4wvZ88tFO6f
qRgv59TN/kGf5ttR3HRZuH1XqKuHp9WzDxPkGwMvoN+tCNldwY+vDUHNLjP8FhGZ
NOx+PtmNU/4rwVp5cci6O3Aqlt4gCr9AQ/ysORXgfbUz5sTV/RtODQjHzjSLmKAE
73g3qH0dAzDngKBSrXTkTqiSyiYnEe7xak/pLz+PLNTmGh5aH++hxJnUgfqr/8zy
tFevR9FXZN0re5kjjuRGkczk8SLXTT6swMsjQxZSeKzyaHjIW9kR207FOTSfBFJe
Pv5epmFeKMmA5cKUFhV/F2PzGQvCI0QKOtNI7ksOMs4G0/2BwmM2Cy54okRwemdy
OY5EW57BrN6hOzykBGcbAwuxn6f69BF6AkOVGLZMs4RmlFg2mOoW4MwsKO3ny00e

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
EWhfuu7rHBP2OR9TaX07XJ7pMqOhGy6gDBEavdjkTEiXaqYZrAr69+QmknIM5xkv
BHHQExw6NKTXBfebQ3gvuj/gR4xWlBwspk6ELLvorkXaN10InXAqQoZr+JCA9sp5
04XDiIyhynY1aNH61aItu+oLdXmbUMIGbTF3tnxaryE=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=4624)
`pragma protect data_block
YeLhQj3mTPKUvjlAZ2OxhHf8B6yrf8EY+ZbCNiSSDj98QXmUW0HF07O3XUluPcjT
Bfz+jVwlSNZPX3Mznx8dNaIBMdRxd365a5hehFmYvQ0bok9/coevSJwYTKjMS/rq
9Eitc8cjf0xAcOrkA+8eqJEKmfKuBuqftUZ6uMqtGupZQ2wRr+VFqL6svEMgyBb+
CzVjisdSSA1/DzBeSrCNYp6ELMGrWvVkBB6/UTROPrQKqyHeTkJOGNCZDIAjTQmf
7nxSa02uTLrNEwMZO3Cdw6fJdB95Z56J0p96ov5/SF3UG5Zx9YO3i1u6rxzeeKez
qCJ2woXeMQ/U6nA6wkNyXKYLUDLtpwzs95weeyM0cijGLOYLF6znOmZKHaYdkzsz
gysO6CJ32tBBcLH73AVN+jjzdMaMU9iQ3kLslIvFt6B+4gLcrnxqnyJFGph/pSY3
Mv59bEIPsCtB9wOYSAtgG/fF3uWMrNYHmmKbslgx+YxQLT+bSNcQlDPLv7FyjC+z
svNY0IJWrry/cLBkWupZMUDDsLqpyKvURTRFZg0ZB+zSp/5c2R+OVdfVm99d/mtT
C/8V7Wy6GmyDMp8FrR3B22iE7WtJbGQDLZ4zIRZ7fuMbH/6LKmyTmJD6CY5XILhm
x6sNinRYbvgoE+4josKme0+64GO6ALbJSJSG5ORw8Pypms0opm08E6o9aeC3FNsG
CBdQX/w4BBTrGwcZ85XlXotI2Y8hR/XfEmN2mjxy2481g+kZRfXkUObT4u8Ukl6e
Xt8ZpCCaDeE4IPOmx3RzsBtPrDUcL0poNobqrvyzUoClwbwi7E5TS4LbWkW+9pNc
OlyAHzTrQ8/zasGUbEsVrx7l4RseIQtqmCSQwwkSKjqjw0iyHMWOO8tlShJJjH8I
aGnI4HCOim3V/uEdxzJulm2jnL7h1men61iXdkDDTBDexKV7MjannrHCFyO91TIg
q4uteKhf0P7WH7Es18JH0iJF5riTKpMPRB6yCjgfJs/hrW8wRIPOdkCrIe/xIXFJ
0j/2LE8p5gtvVog36a10m8mfruMP2PNehuE2QfUIOgLszwvwXjt/LzXk3RFil7XA
6D7t9p9MHpehFxLVzuAG0yqIatZqmrzEBz5OOgrEpPFoTf20hEXrILkp+pUKCbIT
bys1n0SHeh7Tkr6L8Qaj/Ytns8pdj0ASnf+E/HLeds2n1wY+PHCG3BF0r1+PVYo1
VH9ByToJxQG8mtGy9EURKcXDCvMBaXcWlFi0087YUOYshgr942flzhGRlNJFMGRB
h73SnReo8xNyMUSV6wNCBBVhmLrIAtXxgu5hPf5nie0WqQzVgbu1eCsyXB0MdZId
yXX3iyOb3hZ6MLXNzQw4PbAu5aI9SRGp6KH/PeegZv6RAEnnrd1R+JdBY0yG7bBa
RzwWsp2PIr43Z4nXMsAm6pCNfl25pgj0fYe0P5976GdVQTCoGxmf/XUiMf83GCYS
gOBMvDyBNtc7JXxdtPWub8cgUOZwjwSe0YjF0ckpmQ7DfdvaoCWphPK2NGkkiIWe
SFdo++/gn4wygcpj192vWfxm1RBhYZttDFSWkefBq7tKH5Ffut2LFT5BjlYeG2TW
FYqBUZswTtw7rgqUB1h64ZuV0SeiJMyv7b4PJnPviH/tTLoEskXb4S6yLz7vcCrU
MecSsmCGkDCVXQkQkTjoNNmyjc7nZybWL3s/0eO815BrTAbIbxdkhoBHQd+FQuU/
8eQNF46oH0pNVkzuYdtOzM9Afmb0oNl6JXMP2A3Z0ec1WVDyUtCfIU6Z86EpNkdu
06cbwsDjCciLaz4iXgNE8ScNi3heY7tVvMitc/7DNMm5KTkttUcsgmcKI0JFcPG8
TZvS/Jh/U34Xv9aY9oMJv5fU5nbR8PgadZ3P378+mlT9tkmln1dQsr2srXrrfDUn
HnCwgZsYzgh+c/IKyWTG0C5/7/zTk6MjV+/bSPoGBrigY9WbFliLmBXOnhmyxU/d
gGcHm0KGekh9c4RtgeINwdHIS2Ed0bbeNZGgVgDU2IR979SRbAeYynh6+xxZUjn9
n7ASFxveuSUZBqZJDA5a0VafsSkgfImCjUEaFs3nXnruzr+iUGoW8eeMkiR32CDO
0fwka5T5ejr+mUndfcf1FQxJuxNdhMsCwoouLPprhlN1sbSs32QmpZQkvhp9nTvn
ngDwjZGwTzVOhRgMvJNOhDrF2AnAhCb4E2PwUDRWFlpMLfUWeSOpxegxRA5jnKRo
NOdKJUKgWKsnyihWGpMvzLEf1uCWTq7FFZRfEKq853dWlIK1D6EcxF0FF/Wj7H8w
KBtrHt0hTGSP7sqv286ojFZd2Njprz75bFqNjwiWGi0Kh5pwU+VWGM6TgN/selk5
0MnKsqgEZqpG7KCM+KXTnbUk+h7b7eE247+CMoFz9e8h+y3nHKi4hyN9jhqVZ58Y
gkV2iz8J+viRP0023m6xWMnQANMUfFZYKSopl8Rai/SYlSvIHcuxRFaCHt5Rsidf
pG1RmnnpJMYOYpAFF8w2+NfNxsTiZXHFzaxWKVfwveyaiLo9aTHnSK6IjOukcD8X
RuFTPpFd3b/gcqzo3gjZZsDVtfeoP48DopA0oVb9peqVN9KevIDVkUxE/lnCFOrX
k/BX7R1EUAhp+jv8fQzeAR762ioy8BS9HOdG6NZVvAkK3PUlN7H1ldktF/jOXfIq
D4U6UkZhBXV3OQIicHdZlve78P/nr5RtDbb5sPF5EMOknOBujfBvgGa3vAWzO4mN
71iqIhv0G5gB05RW26XLhPwrQpOBa15jZEtL0rhYCUQwH5GVfFjU812phLl0tKSR
snQYi3L3+Ltsc88v5bAXPjuzN3DjlIr34EDy6gTwaS9YwR1cm1ADZiceX7EsfZdS
zJla/0cfrHldHYIe5RuBlhzNIkmb58s0DgO+AhrXvwZJU6477SgcoZ+7TPBmYcd9
+1K62HAxnhddw5LZGeG3OrNO2nQTHj+N1F5P5nxXpkfIMqHBq5u39Gvub19x6bCf
WWCtA3Q5Tj07Gt3RbIX8qQpfvO3cpC0gQnYInXMnfKRkeWE8CODJo+ZHFEm2RJkC
Q/mE1Lh0h02b0koRmyi5jmo8d8ags5Pv6PGpVxBMb62r9uP1mVEcPGD16PYTebBm
tNM3nQCS2RWz+UXU6z7668ho9++YBRSOhECLmpOWaumobxtzwXbTsO8Al60uPWPS
lqk2I4yzVb5Scw1wyZVsM7i9CUyFbiWybC2tI3fHTPTy9mj9327qtxv+1Fr63Fas
suZR1PlUkif4+CUKLX8V9hZOo2epL6yIXrGJVDJpsDsLMRrnbHD0MMffH5TP2K+h
J+fn7ymDTY75lgEydMUY/eytBRGnoTIDyA06vJdoOQ2WzegesnkPAgFkcAUyXlM2
sro8Oj1xPoFDOo+7X0RZIKJt3HeAK/6VSEvmLbUaCF8e1rWt4LCxerspFDzLUcTm
Vf4IVT5LpHO8Jpgv2EhbK0rifnZsMeOUVE9tX/RUao8Uu5ADpnkU6eaiw/+1/IpW
QAfFyCqnCuuHhUqGv5QQxbtTtRc7ZhPEfiH6Z6dJTw/ZKPWmLRr3xViRNKKl55Aj
HfWp8CJzhxAXSxtgeZB2rYDoE6l9MMT30wCnhMUS8/I7wryHnXVnAWyo7XzanvCI
iY5MB4S9pQMsRVdoa9Wb6m9ONP5mJ9H+odmsATFDI+soLh7w9tgLp/c3SXU1i7HE
/AIzaQZ3lrXo87crD8Pq7SnRZVSda+nYF2N4E3+3AN6XGu2N/KdbB+h9ZUuSYNNs
3vXwjyodVNNFvc8cjusBC/KR0LUouj6ZFpStiP17gLTN0z815P5thH5Z4OKZSMpM
NnVPKRvxyLfVshdwVUEsHI3IPhWjPiaipNE4R9+F1fMN082WD7RQdlr/aUk1fjNP
cxhrcW3YNS56KVzpamwb0xrmSTd1gUd+kmRRmJiscHCqbzSo4nSViHuIlBU0hfQf
WRXCSdQcT1yTP1Uww88zBjKOZeoRVPlqkUuzidHoW2s4+c3h2m8Vh67j0p//Oww9
m5J4J4nLTme+vYR5/0xkUI8vK205QCdCNuyIpgRetkOgsM9hqWvxeHfqnNxF4DlC
ADq7pNFQbogz4aMepYA+NQ9Jx1Q64xA4qBIVkaV83Aa/r1cqUlKr/kbtdkiXrbF4
lxx7CmDlYam1TH76Vh+sebcc0tv9v+Obg0vnxMMV2Xt5N4b//n74HnpDe2t0j+Tx
eBP16x2i25HJwvkbesHgffN+3ChLUWWVtQYhmhnYcm4JB86FoiYIyCaMItx8Kh3h
2sQyt+xzmk8CfJLhatUUY4g4IOR/1K7k9Uq2TLhcuKEuhVoUMcSQa/d9v01IDwY7
Z2abQ0nU7iXsGrIWoin7nxVBxgo+NX7IBP53nVgDgH/fucqBBNBFpaHy/fp+bpQW
hXuBpzlXPBASA/l27UA16CVVc9PgTVDWy9vPPw/1wkpuGn50Kvh0UOHkhbdNLlHf
KRWZw/rWfMzfPFEL+p4Cl7aBzIFQIDvvyACauf7KwWqpNQgR7OzxLxGSjlb7gjAJ
B6aovbYlCPKdvh65P8RUNESgJeymWd5ff2RtkZuWyQ91dk6xUppkuMXHZWd1obu4
Dv/g0mMrlahG8UQ0YDly771nb6CGiR8GqA9TUaSJhbEYvNjJ6HcdYGjieOCHKzAI
2hgW2PVKgRFPH2v82g+9JjDs5o5c5XOg1aDbs+6Qf0s5v4OjgDvdE4pZ8gSo0aM/
3Ga/R72c5E3FRWA+HIIj9XE3AnqEb8GBkImhZOcRVmlzX3GnWpJgduXgAC2SDeZA
VXymm+66IKCXoKsiFyHvHYVk6pbua3/f6ZFCMD4FCo+YbPo9j+lXPR2bB0zacizU
Us6Iw8lL496+iggwl8iAeWfdYlJpl8uJlNPCOVGzJCeNoc01PtbZMoINxnXcaPEd
tFQsKX9hBQ58pdgtf/aiape5zXMGJZxbhPJ/XSgqaGETND77H6G4trBW/QReUt/y
pS/XB+qgVFPvIYlHidB1bj7uFC/ACBadjg76VLRbEFor2wALGQkCmTl908wqtW0y
dRsPO+2b3uyqMjt0z5wyxU28Ua0uVO+7/7iE1NRgIvbY11x58sY5HjcdnNxVtNxC
Rs8uk28pD8QHYml1zTZh0fPvUNt8tDNU0nOGRExJyK1n23Ja8T9iPEVgA3VQRv9O
hXPMiuA+CfciWK0F1/U9FY6++fCHbtkwLhPQombHz7oydBn//rRTCdGPFe0Zm7fy
aHbefBEAdRqEQQy3SBjIaM6+Zsk1cCkULqfROUfcPTKAWt9Rd02P/fJ/RJFCBgun
AZGKH5BsLyeSTh4C8NNYGicUUYCtSpPA50AKKTy/YBrt/iRgEks5WpPHOmtClamp
GpiLNE1gTas/TCjOv0uQ923YZdWaIEAFYjvvQZtdEuTab3Nzk1UVvajGSltl26Bf
DkIFDn8ab9h2eVgHGXyXw60GA1e3own9yKMDlSWnlOhkpDV4x4NOhLk2OIIh45qL
FLUnEKp/3i6owCCX8IjRnQNvSdc4JXFsKXIm9igcMhq5vxuI6f24n6Hc0/K4rpev
RilsCnwiI7dUTIKA2Ycc55R+PffnjK6wrcHHX+eSVi8KBb9aEQJGeflD5ZK2QI2q
jLIa++W/+e0dSNoOYRDLKtUtJ66dxjDXG/zg2PnG/15USxi3pZ1izyRYxKUG9xmn
ufseyWg84O27XayYeIvKJv2iy62cJgEm8Ffx015KO/ThZPNpxxpeRjDHZctIi+zs
sH90mebZUzAgJPpoKCIFykkgTHFQ1aFRmNadj08XiV6fpdsT/nSBMcWvt3LTBjBR
k+LZRUa88dKv5hjFs/Ozb70O02oCS05/Bhw3jtcmU76pg3HK3NAI6ciHdM9wyDZW
evIZySXpk5vIhdo7T63VmCx0g0/crzhqVj9G2gWr53aSnD1ZLYJgGmN5CsGDN/AU
M3tG7agGG/gtoA0d3rWP73s8E5Ouq4zg0HXvWI0aCkwfOhIaff8zcQblkCEGvtD2
iHbfPj436uqlCevI28PWeB6g61VinmJdvx6IXaq59sn1gsbbnDRpINuAB69y1YEA
yb9ZdOA2DjTM1Mf0ykbhWXSTqPufTJUi0ldnJ/HhCHfLI+pQ0lIUGwlPndhTqVvF
hfQvwCYJsE7yBLk7UKcUBA==

`pragma protect end_protected

endmodule
