//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module axis_reg #(
    parameter DWIDTH = 64,
    parameter SKID = 1
)
(
    input                                       clk,
    input                                       rst,
                                              
    input                                       i_axis_rx_tvalid,
    input            [DWIDTH-1:0]               i_axis_rx_tdata,
    output                                      o_axis_rx_tready,
  
    output                                      o_axis_tx_tvalid, 
    output          [DWIDTH-1:0]                o_axis_tx_tdata, 
    input                                       i_axis_tx_tready
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
ZfdYDf8kUooXEnDvdcY6IvxkBzdhhHs0tSDcGtvHnguZZVJp8OlBbeTsJWSmB8Tr
NBQr6QF4ByPjyeX8tGKap7aSmIaahLXyB2rz0K5cy4FL3fOhM+E+wQ+0SVSNYwjf
CTvYja+CLrwHnNwBd+JcwzZIRMBpYMRlpRP2oFiHUOXZUy/lt4W/b1KnVt6UdO/S
Rf9iKvey4qLR/JsjTMsRSLxBHEl4CYMYaNn/3BqgaS9GHqyIl4KcizstzoZNYdjE
Yfk+HeSJiehjGOH/iSxRyPEzQsFJJe4rGhdJICnAo+3c3KtKQGlRr0r0W1faCmdJ
6YFf8LHUWAewlQPdfNRseQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
j23YwsXQSuduyeFp53a1NSwCkyawzEF/+TkWCD6lEFFof1mWf+TUguIuUIwfrSX5
8Xy/LDcFZ1lQnUL63khnfLWO3YY5xWWFZZX+boKLDQAfAMcEX9IiM2dPlpPjmhlY
JVc4g+9y7qVOUUB1vv+bRVRPSh/x4s29X3Wra1JfqQs=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
Mtr6UeQZAZR4iZWWxJCl3UiKlc1rDR3kNb/jbno4ccJsUTZLYsUFJD4nuHiMb9Vc
8t2dEi7cnOa7v2FkW8cGiOdyki5tZr7Kr2xQhgC5WZmvjbtjM5U8zv1xT/94Tp4e
xzHHbkOK5/cUv4GQaeLPoGWcYkiXJ3XjWPmDbDnP5xKpqLM+NvfP4EMqK2pSNg6F
bf88CNfrSBIDUYevz+EJslLjv/6Y1GAy4eSGHaZXeSnwMkEnR765WGr61+Iy0HSR
uKCxRXhytENgVXFb8iGctXhsqA9c+9umh1h+bM9HRknEojBhCje9P9s5B14faePJ
y13zqywF9bLUgzQqLz6zag==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
LL/5UCcSfErEq6PpSRdKMX0IlQCBUQ90Emg0hax+9iBmIjexzQqQFueKsiL8nxAn
1WUQskNrqh3K46cwcaNA0XzGry7urSWZjPKYL/aYS88kcZOAQ/7XwTSDpNp0j2fG
uRpZQZuiOYCcbemD1SLonZGIAilOM5j1LuLfV0ZpUjFmdfE8u0px8DhZWRTIFl/R
bvz9kxuHmdyLnqwtbZ1H+FJ/9gQ3IQLHKko/I3fhE+6rveKZKeGWAYPiSAdMOC4C
Rrl5S0OLyKyT690ohf0/C3zs0ynmxANitFW1d5jNGRTQhlIEGVWz/eUNFEjY3wKz
C1Pct8LZRPxM0EOoQMvETg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
pcBwDgUCcYvwbiebQpUEdLG2p+MhMzGqlXF7ZRP1WBg8YIfbBuNx9UWxhzQNvp4m
CAfIWqLisBdDTlnUArDaCT8zCFVE8fE1eo8kAH6SH73ArCdRSGiqLp3KE8rch8Yo
dtXNQLMJ6mgeg8f3BYCxUDgVBIP/od/NcX2we19d4139yaC875tjIR9P/zWqqIil
dLrNMsIY26MwjhbkBjl1QBswn+DWUQxb5Bud+M8EWVPugPMNVH4KedWaqTTwK1OF
pgUeg2KDgaigB3bh4Skq8Xsu3+vYlvXB57q+EYPVARt7qifFCz/s6U76UELJ/6aC
u3/fMZ94QbV2v/vyWWwfBA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
FTBMkNgaGJTRAFx6jz5HdmgSQ7YpA1ADgbJNy4jcLj0uagET7XtqNdG8qUlpINHh
AWJAdMeO7yYBBMHKlE5RJoTWe75YI7MJgHJQ8Nu/yZPrBAfzAflnga8iLUD00Usf
XEIlZijAiQTfA+cL7VUaTkDm8McPY9ra7qtplmH3i60DYyJGw+Sgwm+EVq1rZFJw
RKSihCVK/J1JoHEkQyEZIjGKDMlY3g9hMYSF5L7LBSYCCPzYpKfh2C21KZsuKRRP
kx1tu29i8b5y1TDLmQrFCP5LizCWNAH15sZMFKV/mF60x705okRgOz/Ad15zN+W1
ViR/Q3mZW95SMNkfRHdLoA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
FSuWIvSPAM1fxLuWmXxqMLyLPaRuun2xQ5DFVo8n3//1WS9mmvj6Xqvn4nElRGV6
OVMY8E+6s2eGkq42znQ/sC0oKRngce2yFh4MbGvLvIpxvFWsmfpHTE41LUOQjnJm
8CfZJoiqH36CgsDLCItCTtdCpjQzEbHQCcIcXhLUAOgwDehTM7IzMSbM8gHj5Due
tI4xqwXn9P5KKM9Lc7oVX87uubyz3Woyoc9c/nFwoi78bt9MU5LwPbobTmG99c0H
8gdyKiMX9Pd7v2+H5HJZW9w9HOahKMn3OaXtszJG+1IiihIRs7Uqp4yy/dQjFBmd
i7CieLOWyQrr6Lsyoq7dVVB5glDjKYqBj5OY23EBJ0nEOOdzL+j+HEei9V0+vCm/
cMnXqJyzRUUip7tgWsVoD1ye5rY4Vp+CxjhEf6ncK82ir5xOIOYldJKKeqiAnBkC
HEaPw/5n19yrKs8Fh+Ro0/Syk5GVbWNJHsnLPOB86EfyLysxVbXUL1msmpeLL9t6
WybWOnFu+6owKSO/I/Ahfcjli20RxzadnPSj6VPazuxt4YYN+CsYEpalr8fAOIyy
ZxvbUJ+lK5HvApKdey1Wz4w65IB7kCaDyfdxZ8b+jKEUsLCbZNOGXaP9cogfdQSh
c1DhOftMSFK6gLtkJ9oqlLzZbc0K9gscrYhengq6754V/m6f+4oqcAruzcFg8Ijl
ocKqBY4O5zMOAxL2+IyrQt/s8/ezhU0qOLn00sX+3QBPTkH31o7shLynfUxtcOKp
2/WH9I0GPqiUb9+o+A3HRszX8x6IRvqhWAtR8KsKeuMJp90SpGQuW9/o6GPE5lLL
gU+pJOkmdzZLzdRhWPhjbjy+SY/PpUUbhXv0X6VMjPuOnY1WSBisu1BvPORer7to
g7vUzG5XTFI1rmLiCs6I0vdapZudLqt8HCSXEWSegbLoIs3t1FaPdDe+bOau9yMF
AHOO4f1H2oWAmob654N7RZpoEgQAa0YzTYktuRCpj0DWFsmxmitROnSDsr34+Oc0
za1JXKFA9HX9hQvwXzZahH58fo+fofMGkynlW5UNcm3Z4BmdzqyNLEVb38sOpSeo
JbD217WGT17BLiXNTCfD4D6Fv/c7gxoODZ0ux9lN/xne1xwCvYstARgXizVQc4/A
t8rrQo4Eu0Z7F37/1NyFU+1XGpQW6rg8CSBgsosjlZIVpQnwXo53E+lUuWT5HQRI
mPwRYl5xsGCb+V8uE3AuKErEIgWBWyjpH5/ph0EINeQZ5wABpmlIinLgtMQxcAMr

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
a7nivuApWbh4PyxcT0awBAdMvHoiHJK/9o3kHrU/JQBPJFyMyc2YtY6j6J/0nj0Z
avEVwmCz9d4vxucxFnhh/hokXRDUG+9oXlo9uNI5HhUoZapS0hd6MJLWX8E11i1p
NnhkAtmFRVUj9gEmbP6yqFLVRXMdWfrkYcmJ+T5XE4k=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=2208)
`pragma protect data_block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`pragma protect end_protected

endmodule