//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module axis_packer #(
    parameter DWIDTH = 64,
    parameter W_KEEP = DWIDTH/8,
    parameter W_USER = 1
)
(
  input   logic                               clk,
  input   logic                               rst,

  input   logic                               i_axis_tvalid,
  input   logic   [DWIDTH-1:0]                i_axis_tdata,
  input   logic                               i_axis_tlast,
  input   logic   [W_USER-1:0]                i_axis_tuser,
  input   logic   [W_KEEP-1:0]                i_axis_tkeep,
  output  logic                               o_axis_tready,
  
  output  logic                               o_axis_tvalid, 
  output  logic   [DWIDTH-1:0]                o_axis_tdata, 
  output  logic                               o_axis_tlast, 
  output  logic   [W_USER-1:0]                o_axis_tuser, 
  output  logic   [W_KEEP-1:0]                o_axis_tkeep, 
  input   logic                               i_axis_tready
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
tHf2sdNqUOgisCEYas5HPoaJyxObhSfaF9Wy+lNdK+UKRvLhMuILx+NnLwmpLJt/
+ewX1RfXuob5NYgibL+Z6ZcZAUhFmRFiliwN9jcWo1zZXWp+pep8YAlhbHNFMVJb
MVhtjDG4mdfOkX/emkCyXJEnkLY6y4GeUBr+ZII2T2nbnSLB3A0D/VGJWv/ZZnsx
+vfcqSQc+EpoSOl8hMo1HFJnnIe62Xrz5ehYQMHcIxrePgUf6Ha2EgWVtm7YbvvZ
tdIgftfmzz8ly7WZdzHokbs8Om2aXy9q+LM5RuyU+v7YO04q7Ir7tlxN4VSUucjO
AAidcbEALXDfqg3dse/4aw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
HRr56ciVrf0qZQ3R524nLP3YSloHV7sL2wXwCxr4gnLQurBHq/lycYPpwr+vNysf
8k+P/YVYFLPWukNcvyQ1upXx14NHHESM/DypfoGfCj5A9c7PR/H2OcWGhJZBVfHm
tLa0tVQvlWxfoJGaW72rx0HPmm1PPue4a4OlHSLSgtY=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
n0D2/M8YR5nbODIeT1spJRPMdZQXJpnY6nVhPiUR62msTA5d1oJ1gjA4b+a4u0cp
ENAH7e11NTr8Gd9WY6Bb8L+6SpbDgIAz89n/QLcftSbATrLeRd9G4iO3YAlqDQ/c
/ORM2AzQT2i6SOY4T8aKhNZxFE57JztDS6zjWjjytsBWsya51WrukT8qlR+IUC9a
lYTW/v65Wr+vZ16dUGwZNIwY/cGyxYyw3jRc/cBbMTiWBw89x35XLzLD38krmxk5
27XwK68UEPSn8sCo6h+vi2Kmx1K2Q7fuXEDJNG8t7PavOyN3p3FiwQ9EMN1w6C20
LmR5dkmYYXfjC9mzNxGFYQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
m/qKIeqAWYMBSwl4SoI4ox8a5r5MVVrtdDHfpUO+a1DnITDfRuP/CghYPnPNIBls
Sb7vRe+vhC/ZK4F3geMGQhtXSsfvrbO0AzK8Vj7RaOsxLyqPnVF6bFAW0bX/dMXU
KLV8kDBJ+fhnzljm4ss5v98m8yfl2ZdnlWNrsLD9j1j7vQUMbjNHNGmrcn6mK4+F
6Q2WkFeqXnfQp7GQq8kA5Kiifjlxa1R9QEwDjr4Jt9G0yNaSSAF6ZKvexXHn1D6c
XXIJg1F45L8a3Z/oIgYa+GQ7jKTMjsWaRFqO/zJiIWhTB5vgSs6doxtZ5+ih8AG4
KQ/Z50utZOcJnw64vqBKPQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
LoyD9dwkJy9WD7l84ECL8U8hcI3mLVsfNivjLssFZI6Zgi9MBrDDVvMEzsG8Y5iB
s4c5pzS6IHpV21BEVLulxErGF9MiVXlNHE7TUnK1PskneN3nZfIuToYVH8xLRfZm
nr+38qPNdWTlJQefmUVT703rU6aceeZyJJ9/KYCjifw5DfWbQqPBT3DznwKcd/df
L/Lyo+jTaBsbMpKHuQzzkJIMJgpGWKvcL9iqWF6SRgxehhF7iyfgxT64OymukHQ5
U/89/32m6ZimkcwnWTp+cS0UGoh13tJd8knApiS7y5KGhXs2px+imrv/WkvpAMlV
xeurwlS/Rk4MsHYVjyrCuQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
xISdxTPSucrnatJa0/H1WTklSxr4v35HYD2baI1EcthnGlInVGkzqgmTdtePQKFp
i0y67QKutlWgRsyzyMv/xmbU2m9Q8XULBRESIYWImxqnNwS45QoOjNGE1VsqO32e
AVhEUNFJj/rDmkRzL96NfXVKFFk6tebNYDHA2zTwhz8kesNOf0WOj9lPMK3GDHHJ
qVGfZBLPZAtxGeTuZ3IUTNm6P/FpgAEee3/Rd73n7GpS4zbwnb/FTOPbqpPKEgHT
qpVqgHLT1mEHnd5eClBAeVVhW06P8xD6I7mkbF7RUwKrx6bUjQIdssD1+4/E9wov
nqR0/tfdhyak8wdCuBHp+w==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
eG+hWU4D84Tcz230qu3uNV/BfKNop5ytmPQdlT/wmOrmQi1KbIvo1q9Z3FdF4qzc
0TR9dwrKuj/hNWHlfEpwdUGOxXeLb9MBS93CrzEmQpKndOfeu8BQz+PYL01f7YrA
WTrNJzJV17Rgl+SDem61gRNWc1NfYdfaCF7OFnhPOjMsLFc46iN6BBpzHVvDkhon
g3VT1c1nBV5Y7mModBGVvefqnkeokALpd17YHwDzl5cYHOk82TRTjHEwxWaMbOgz
X0XYuBfLQyo5+dKnojo8rZ3ccrxvU7qwcCiPhDP6Sr1og4qr83OPpQzIDoJOod0o
jIc9arCnjHULYErGfGSHoz86sTMGaGn7pK6yE1Ul8gkCKd0ZRv7bhK3RXiNzdWFf
E5re86+7MTWj8WltPne+f/oVCn72A94dsLHY5MZHxn17KScfkQ/RmWQ/HvCoSuLy
ADUiyJpUKJb9wg/+NdDywOlhdQ1O76EXmCkA45lpOWiD7gZ1bDwjlFadjVkGc5Lv
bc72k4IHrlhg9YfJYKTkGK1ezj+yWox/GZFW6j2E2AMaIwTNWJAEXHkbHAOOkQOA
4Qn2v1W64Tp7jAW84YVyCg1EEoS8vhcjaut+avY12BQaJs+5YROiibxSvt0P4btG
XL5ddiIo0WDT+KBNcm4ZTzQPfwlh7T75evYKK6AceMGc4+fi4zKPYNODNWnv8BV5
c4ppw9hprRP5qGq66K9axsGQttjRpuwfJ+mP7UVtJMQpfx97wZPqyp9zA/js8t1X
Y6bqyMU8ju6u2IRH1ako884B1W/iLFtCmUZndZmxmOkLsSjXrZB5OVWN+rqBu/BV
+YIaPMH1qgqW19/V7tvTlvjMiKAEWeEGXrcCdmKavBXbNpzDKK8UUd2BC0yNptlt
+QcvUWmhq5FHcbqxgJ8HS81AaMO95AgfozWtckYe0y4QujPgJsXSWRlI2laT4f0/
P5XlhnxPzgA1I5C2DCg+fUeMQC0nD9tNErOXqJQJ8sJvqlb54p7jed+HsngAcTdC
MkOItUx+2nsFdzqO/HvF7MEcDqaNvSJdV4BQqi575aFvV+4Jt6zUNXf/lJ8tddu6
FaTNkx0oMi4UnQzIsvy/EW2YNkkcui5l3n6FeCTiV9FexKUf1csXK9qYRxXDNuQw
V81nW8UixxO/nimjNq+PnPFJ+0jhegXdjy6P94o4WHRoq6yhVUXFfguAa4Utb92q
35LYIcDfxvZTlI9iWsM9I9rTM1c+i8Pk8BYT4JhxtkdEeFeTXZralEASLtcIsWkI

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
I3gRFPZs4xrUS4uheL3tp+iLotbtGnyicH90JyDSyZzAY7LRNUusv8OVoCD9Lmef
DM7l6uUIear0+wmgmImUMkqzy/tIDGqerW9VsaO2P/QZZp307Gr3TDj+t/gOAcke
ACXqdwiGGnu6xdQGIGBpxluQW5sTvdeVYTIz2OdwTMk=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=1792)
`pragma protect data_block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`pragma protect end_protected

endmodule