//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////



module axis_mask #(
    parameter MASK_WIDTH = 32,
    parameter DWIDTH = 64,
    parameter W_KEEP = DWIDTH/8,
    parameter OP = "OR"
)
(
  input   logic                               clk,
  input   logic                               rst,

  input   logic   [MASK_WIDTH-1:0]            i_mask,
  input   logic                               i_mask_en,

  input   logic                               i_axis_rx_tvalid,
  input   logic   [DWIDTH-1:0]                i_axis_rx_tdata,
  input   logic                               i_axis_rx_tlast,
  input   logic                               i_axis_rx_tuser,
  input   logic   [W_KEEP-1:0]                i_axis_rx_tkeep,
  output  logic                               o_axis_rx_tready,
  
  output  logic                               o_axis_tx_tvalid, 
  output  logic   [DWIDTH-1:0]                o_axis_tx_tdata, 
  output  logic                               o_axis_tx_tlast, 
  output  logic                               o_axis_tx_tuser, 
  output  logic   [W_KEEP-1:0]                o_axis_tx_tkeep, 
  input   logic                               i_axis_tx_tready
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
MkgLJUr/8aIw18aRUoj/D2kC41d2RGD08nwe5rmDZ6MTkjr7h7lyXoJSuvIGhaSo
+lyftUQpfcXwaraLs/a4zhMWqGDAvMZUxH+apTWbIfIXjqugSFETvXaDemQxL9id
ImpEUFIksv178zN2gYDl5LvlAdzQW6o+CQu8jHYQ9i1ygQCB6aEGD0+3dNmnyIUC
rxc/SRt0BD04ClE1VFULeaHYOXYSHnYaoXDrBvlt66z3WdnlGiu5DqrryBtoU/Y9
mEmxf6GyRCtoFZibwVTaHIWFsSMbxUo6zVq1fR91Ju5e7gec49J2nnjdOckIpdk8
cMhGrMh4493mGc1WdZaaKg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
fGUdD8Yq2jjx67tXlHc3bZFaFi9BHqX+kNiZ/qpN9bg+n7P21JG05ezfhb3jUcOO
brYS8NLjm6YJ2WouDgJNEhNhKgggpXeuDw+PWPS9p2/+PbnsyDO4XIHjsg8VPsgi
FznaOhwndW6c3CyDl0+XAwjLSk77lHzJvDKS+N34Aks=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
SIbiRZWU+NEITZnUBjg0jL03o2rWJP7ILovNYtveoB1iuHkO1WAGuzxqu+43fkGX
c0k2icIwfkYFvZJMAuiiweeNRtKQmjB3Mgeb3IVrPCh+F2L7Osm0e/k4ZENrJZRH
edtK+p4ZP/Bc9h72wiFsZFVnb1Ci/K/1W2+mFpvlG6lvy85ESNnjsmILyLRnvHg9
6ke3kF2gRmU1JcNCRH9OKRetSBBNvxpPQg33DD615GPdyDj/M1NiOveA/5CZvy+d
kipSoC+EiD+2mn22MspO+c2TA0XvEMywVVmId8NQTeK4tvoLydLSx3HxEsj4q7dw
boTiizF0WWEJcqXEOivxCA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
ewbq3BMmUQfFh8T3r8SL67HuJfuJoKjmL5FrsP39RT/BdcRIolIEEKcreZcWoTlU
7nc8p5mZg5xl77tpjuOL5c/RpnEyDeYnquX/bJUrfL0A1sqkUxANobaO83/KCIUS
CYNxC2Jz94OXZb+VmDSj4zq+EccLcini2vqpIrqep1rW939hZvByfeJycMleViRo
TRlElRawIi+pHRRvY2JZ9SHXNBd/etyEO5YLztASZG7/EQjgjY5rXCGxcINHMjGB
w2x1czRN0RDEjWd+50K03s5/01dIOSxvOsfG/x1/lcQEnVwqwbr1QveMPmIO2DQS
8809BUQdJQ/O6It+i/GnIw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
I7ACXoq5pmpF1IYIN5HQB8VXlVn2vmX+ntifKwu7uRbuNJ3HGe0X6nY14ZT/UOjd
wTpmWSI2lWjFqXUOMT1ECoKJn0W88FKnNLKa2V2gJCIqeCvXEw9r5DtlWkdhTIjL
luguOfjrPkt79yfgEupZVIo6a4qNTGYBPzSZwiQw8AQHSootjjQP7sY54Ylp9bqs
7bvpNPL3zGYZHpFIi8y0lhmpCo8orl8Es70HSoM4EPQySKXSDx/r//vYmDQ5cf34
9z4I8YpfbsRTa1z9ULSpbU4AyNicoCEzdJLe8x5IXPZF403k9B5b8PI9Q0//9zef
mGHVJbPeRKuIYoNAgGQSnw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
wdOT26RhAfrOGhtwIEl4pyFpu9fLh9EBVJWuCnw3xArH6RDCIQX6tbtxqWpnau0z
OBGmF1BLSnjgiJKPd6KZnf1nrB5fZwotcD561cY6WuqHTCDjwXwcj8crRunWWVxC
6dy2ZQRX2tfNREiocegkfN09lYkm8fjpk7yKlwObsjTNDdj2WXVjhY5uU4bHCHSN
07LLl2sqPAujSueILPKiteCkgdHUQxWfC3rfXJBSK91hI0LmhF+RbizTHRCqDrL3
6d1IKy1oFQSMslUC2Q4CNzcNcKsFoRCLJ+yTXTqOlghmFdMvOvYksdwAQQ2Oy7fT
QgwawiWquxcBBnR35N7diQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
nwxssFSRLhp8yeboov1B8lQiL5XZyo5hn5QaDPMB7NNgiJ8UrksOxCyjKlZZFPJE
6juh83f3T2xEDcDxaqec22cTzty0FGrE5kxmREQbgHuvf4x2+OoTZKSpvJw9j7Lx
DkJmrqCmcqMcUTpFtgfOrc8Harozv2fGzqPWZ37exIc0gJWhnn22irLEo0Ed2LPr
eXDb2pMsbfXHFsSe8l3BfsChZkQRRasigA+AXc5acDzT0aMKW3bjo6cLcZaM/2DF
AWIbVnkA16EKuprk8VyZF7EVo37f+LkuTrD3JUpIoZyu49T78YZcHgxdGNAq3Klq
FpDdTeex7CAaBVssEh4Bp1TluzMV7YzlYxUCUNkShVIk6PP03j8fiyvkjOCXJniJ
3w0wWFvyM/08U6OCoNGwjoKYcSl1VVr3iHMF81/blW+f6BvjJKsyPd8gECoKXuMq
oryZHEUyBVAKusxDzcDDVvwDM+m3rDBrvlOST5BAMWeLDRTZuM2f7IArXcrJ1zW0
NW8mQ/p6IvfxHPx57v5lYn4DsXWnOgx5zg1YWMFzaixOR09Y+u7f2wwKEhT4E0/S
NGbCUFotP1r3icOozDzmp6nUR+O8d1WWTH1XkSHKq2dEbRU1oRfS3vaj9L32kfpI
YdO3yJtJvWJXBBbSB1Jbhx3QDzp5dBQ7qklbTJw66+IETJcDh5dm/wNqqqDT27G7
GsiH6l9s9c3ttssV7KuE61Ap1DEUkT5C/cW7FONZx35b0kuQtGeFlbMwHZcoKk2d
h/Xq8lKEk7Sg0uiuxg4OmCmcZg38+omDVN/GMXSRgG6iRSWPrv47fWpDkqhnhmSM
Hl5A2eSxxqlBU5r7jajZjSIrmZnJ/dAcs/6lppRZ1T2kg9y50PYWOE6BTOmm3Mlx
Hx0u+JuD/DY9ymaXMmQQ6sH/H7LxjjhuchMLN67UxrQDAprJg7rFyl8D1Rnu3RkM
u29Q7wHjjPL40ZREd16FkvwkGXweDW0fLCff5x0opUeduHOjmHwChlV+xaxy9KUz
5dAe2YpXQqP+J3OMM/tpv1dJkf5lk9Fie7cQ7IixdVEHjPCQP3AEg3na6H150blG
ZPUHFVSoGSESmQBzGGRLRTQ+ELo6MVrt//5R4TXrkIeJaWr0TLIHGzrT1P96ZKZY
+1TetMDqyBLp55JcdSsdbAZLx1zldKL99nVLlSCF2lwh2YhQ+ZrYH3/GgkIKseWV
tx3jo+3C5wZByJgFRiRaEMoEH8B9fCR00clADLhmGxim4FHdYEWYeP3ThHT1PPVk

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
Os78zwjtN6/hc8+0yauIR7l3vIBZXdXyP7W2PeFBOKgPFl8KslMPqh4FhMYA4bD2
KotgFVS4kRBBmvdyFugvWpJ7UarzbHs3CNGGZVMiQ6lbPizRowmy6LrkcJhRirx4
h4eTVa+PVtOp0ZNDNWoez1azgUsBbBeyJZ/2DalBf1w=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=2208)
`pragma protect data_block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`pragma protect end_protected

endmodule
