//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module axis_hdr #(
    parameter HDR_WIDTH = 224,
    parameter DWIDTH = 64,
    parameter W_USER = 1,
    parameter W_KEEP = DWIDTH/8
)
(
  input   logic                               clk,
  input   logic                               rst,

  input   logic   [HDR_WIDTH-1:0]             i_hdr,
  input   logic                               i_hdr_en,

  input   logic                               i_axis_rx_tvalid,
  input   logic   [DWIDTH-1:0]                i_axis_rx_tdata,
  input   logic                               i_axis_rx_tlast,
  input   logic   [W_USER-1:0]                i_axis_rx_tuser,
  input   logic   [W_KEEP-1:0]                i_axis_rx_tkeep,
  output  logic                               o_axis_rx_tready,
  
  output  logic                               o_axis_tx_tvalid, 
  output  logic   [DWIDTH-1:0]                o_axis_tx_tdata, 
  output  logic                               o_axis_tx_tlast, 
  output  logic   [W_USER-1:0]                o_axis_tx_tuser, 
  output  logic   [W_KEEP-1:0]                o_axis_tx_tkeep, 
  input   logic                               i_axis_tx_tready
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
iLx4repYnaItpF+ADh8WZoIJrKJsiigQVqNBu+xSZ2XIBla0m88uPyho6Rduaqbq
rk8nGlFJXtY7NwFa7IAjPmt7VEBY3vxLHyJk3l6UOQD9GHMucA6CT5JnKHXxB37h
BOy8FEOJoTaJjo8SZrjJiSTGJmXNxAI5sXb6aCGnP2GQ7l70CwqSojAbubS1zL13
driCj2ucaDfiUxzjH0tDiGU8rewVWTT/4ev6cRA/kG/pV0Tw40foskT3TnI5YRmW
SPz9CjGGSE4EaUhSsjLf7pdcY07SCzqhsQY6zDghIDPajvHQqbi+rMGY4O0pXpLY
pAxLDb5Vk5Yk1mOhuK0OQQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
tcaf7Em2OXNG+dQp8DsW5/pmaRBQSScMSurS9yr8+MyDvZLzBgL9FelHMn2NA6kN
mUG9bOUq8u8LEwcSvubn/mrG+snZypCvEW+Mt84/ecbE5rFYoTFoN8WKjIlkuGV8
/IBbluFDobzVmCX2eVkOqSlkwKJH1j+oTtAuEOqXzo4=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
TW4sR/1atS3EGS2qtAYdb9Ehic5D2P0Y1i1/AFmisR31tYOQ212hxnUCpMhQmJJX
Qgpk9qcSdQydACfXXrwk0LSS8gjIjxIYMhNP/q1+fEdEXtShIVscNnVaeri+fnNW
xD980x+vluQaPTRjTh6v90CYTy4EwM/cgFc5g14ScKSatbn+QfW9/z6IknKep9tp
3LXQA+UnzOR/ZCth8K00omuD5BNGQxhuY96XVLgtzDaWx0YjDtF4ddL9W5BWKcWx
uyXJjCIauvLIl+oDqPXJI/x7jm6BuLLaz489YEVQ108Vu0KZ9vrjDD9SpOMujw/6
TFubBFtrLZyeWpBjzd6TZA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
NqAt38r1MiUNaT0kDui8QIBy9OlWt3l1HInz8XWyHXBhNLJ7X915/xn83oQ1l1V7
GcmUMR6tsIXsOzRH6Gacd+LUaMwbFqrCcotzGELWUP2WGoVHtAeBvYaEhm7V0izv
2Vmj9MrVg6QZFCZKaJV87VWEwgi0H4Nze1ByhnFkTxeBrBj7FkPqs8UGGVCj6wVU
F8zjcaYEC8k7NjchR2V6p5Ru/eeQlZIRUD8RwtfRKTBdsgrtWIpYXo7aZzP7TI/s
fqFhcYNc5jJVbOeCZ3++jLrdP9HwrIXPsr/6hHu3jK5uob3YhhFleJNbs/61FJGl
N0ni5KdrmsYA7ni/jflm6A==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
3ElzqVO0GMyxjM6ZwM0iPrWMO6OE3V0nSzVC/xM9/drMehcDwssgPn3kJHVz/ac+
3BADSnaOfLDR6cs6MOi8tZlbU/Mmi8S0LtQrB10A/TG8Ysba2zmOcuIwoU6HDDQY
1yWiO35XHimPmArJLs3bIZymep3/wRBSLFuHke5qoEgC7Ae39EOwGde6+iX4g2Xs
r5fYKTc0xTxZjzo8XhItk6HxVSgk1+w6M+MwkS4Z0XkV3U96BbKWEhozB0EcFpaE
kzmjCuP7IOsmjZireMajZ21phaYC5u9VzWIUhEL2CBZb0c71Rj4gAixvkxFLSLvx
sytADlZCmuoGTRRO0nW4Vw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
Btx9PnhhNPZijKWL1E9VNsXRY4ZzoIbEhbR1qrAEz1/VRoCd9aByL8MXfjd+wkZg
P4Y4RBwYbz2kGZCJT9i61FzoyaH22RJTjOnr8rfbvmuVdluTqAz/IL2Mq0VVaXLO
qIJMvNhSbfwlq58tlxTns3Nz57Xv8T7mOdnSq4NglILQx65U7hi6E1QanMrupjz2
SQ8/mieP4szsGwV32a1Jy8kSZ6arT3lrmvzLKqIk+O2WwSMIUCR8Udfwj07PDI08
NjLAC3wIm5/pDxvE84JcoL8u/oKMh4O6slcEBX/FpI2EfijxVD7HVy7sgYgBqRFy
m+2NMIJrSm/DQmaBA1owYw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
S3E51TILR0XqFrA+mF4DvBzLSfe7Cq6cnKbahQ23p9FZgfISJij0e1BP7skONbR8
ol4UWOtt+INIg85DOydas0IeYltumMGek2xDfZIRrMxqhyOmFz6vIyIqNk/Q2biL
nzRuBF6Wo8SOwN3w2ZJPVE7o1ZDNSPAmxO70v1QfweelN5O4hRHzmT37FJhYOp3f
erTy9Xn4h1tsbmtF8x4+rFPAXM4K6oSIqwvjfDl1aRdlfYaL4eAABfAAUAH3wYE/
LqerSh4/f7WAZLOJ9FDzo5dfJfrzL86ld9jIyWCXCrQWTL8Y9NE4u9HPN6M2I81l
cNG2ULyTEby/D8k4CYkutKVOWuhsOYm1k5LoZA+pxXejt7A56J3RKlZL/gaOTrqd
s0V9T17XQ66WUbMp3ch6NdIR0cWaRlWSOu5afzOmiMfGge8aMHLmTSFNJL2BkYdl
LGBogAFVJGhKVrecKHLihmymgJbai/Fc+fRmso5EyABYKgegXUqAMXfg8yMUldSv
fC1Z3S6aD0P5UnqUQ14JY1diZHGm47hIKNZIk+IwUqNnUhAf46VCTrMykuetJLsf
c+4mev1z9pYNW9F/7mgUJB9rPobmxrwG08GsXpGDMWx/gbpZVdao4Im2OLvOG/kN
0SPQlD+8F7qSbJA2SS6Lkxe26vkKXU/uCgzU7xp2Dyj/dJKYfPTQUmkvP8nTyeBL
fKTTJBCg06iQj2uchcWGU2hMPCR3fZW3rioxsWUIARS1PKBIutMD+Z3C/esOFyPE
dfyQ+whnWDQs6L8kksGa30FvVg3Cswoly6vZNDnkcL/MnooD79RUZP94MK5GJEoT
64xEtKboaCDxpqE5vetYBsoiQLD6EDexZRTCUKwXF72HeTWzJO+t6xS29zVGWgD0
TyGrE8G4hi84WMm2AhmnncCM683chs67tSR6yrFOf2yVJZw63pS6pcInbRcbEOK8
M8fW9QSt8198SyGEDeG8tgHZH8+KP4YYSxjY/KDV5oumFLaxfpmD0lGCQ/J703j5
WY03bJtUvcCWBXhH4+QfnykkXlSsnlku6D/EvTOlPlV/fz7omBObVFTUoTPtiH8n
NfPAuWt0JpegAW2AYEfk69AHQ/E9U+buyydZ/drp/5+22ATTriuQUJI3CL/3ALQq
SZu8IboU8311f34x/9+w45C4OK7ATdRyV+fwnDsNZfM7JT8uvE1sAJDsUavE4rcW
vJFpjs0BsaoMwW6QzogDMuV3d3+v+X2X72g6dr4w2t2bGMQVAp/igblfU0zOHYG0

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
GU3PRkANttTPMEkBhvGwi0DT5XTzwTnFI4g1UICny84RhnpH7fxZWpK0PvAcJwPF
t8QVhNYt6tNAUFA/zg318UirYkyfa7VGknKPh6hOhvCW3+ipZTFKMWmDf/sVbBJc
7/UBkWmA83cvI+pw554m3F89eC7cMWitzEVRJVodCc0=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=9952)
`pragma protect data_block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`pragma protect end_protected

endmodule
