//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////



module axis_ftr #(
    parameter FTR_WIDTH = 32,
    parameter DWIDTH = 64,
    parameter W_KEEP = DWIDTH/8,
    parameter W_USER = 1
)
(
  input                                       clk,
  input                                       rst,

  input           [FTR_WIDTH-1:0]             i_ftr,    // hold constant until tlast, FTR<=DWIDTH
  input                                       i_ftr_val,
  input                                       i_ftr_en,

  input                                       i_axis_rx_tvalid,
  input           [DWIDTH-1:0]                i_axis_rx_tdata,
  input                                       i_axis_rx_tlast,
  input           [W_USER-1:0]                i_axis_rx_tuser,
  input           [W_KEEP-1:0]                i_axis_rx_tkeep,
  output                                      o_axis_rx_tready,
  
  output                                      o_axis_tx_tvalid, 
  output          [DWIDTH-1:0]                o_axis_tx_tdata, 
  output                                      o_axis_tx_tlast, 
  output          [W_USER-1:0]                o_axis_tx_tuser, 
  output          [W_KEEP-1:0]                o_axis_tx_tkeep, 
  input                                       i_axis_tx_tready
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
vEbFVEG34aa02N+U3Xp38kXq86P2CGJN1C6ZvATrOFX+B00HhZFmfK9D67fl0CbP
Qz7mMmsQUVgrShZVgWqPRAnOkkp8ADV8kWkm356k6y6nkbJx7u+JPco+kaAJ7kP6
TiA6BwCbOzIXjOqnhUC6hVdc00w7EiGqsAFz06utWKFLaR4vfaw8lSCGo+svYv2Q
/R4hLpx3y23jlbusuzqpVuXyQIwWPdAwHCy6TOJs5IB7n2sd8N3aU3AJ6Gw5iX6/
/5Q8+sVXJm6LIMkl7sGuL65vKG3NtKMpDntDiUCJrFV1lBkvlyJi1yHu2Ahum2XM
wGOZszWuSiavrYgecW32YQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
X7h5TEB7DRM3OnFzy7IZu0HuYk/V/jv3nezTVvSEZJSi5zJlQotYdas3OAxx6QaT
vUVu8GqM+w9bw1xUvOIGsgI21QDg7+2umtKv0XJxJxK+IM4Yputf6++gUckOqgVB
0JYxLb74CpiN9buDgXXfmQmClNvnsXQGKnlnIGfmOAM=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
0cR0QRLvT0aDLqUCMrWpgtIqev/5EIjjL/U6Kx2YFbUduLCP2oP1rkciKzXD/ALc
/aONxkGV/huxSJaY5IJiNtHfx298+Arlo3l8JiGwDJAxwmNr4OOI8lsEbnNLqnhN
ZXBMquVJVdbMSJ6sg904Bg/oMcMK6T2Mc+2VqASm4sKIztF8JxKVGbbm9WICd+ut
8u+pGTWro4Mf9l0WQZg5TD4qNSoTwuItkCOwZR8fmk2oM4Ba4p3c+5oKGm/xwOqo
ffGTaxLXU/IOIcOeTtdEv6bMecQSHVp8k9TqNJTnF5hPCz333OnCbbukwUj78lfL
vA+m2k129qE9shQtjbVmIA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
PkRw6nGlI5PyXhrlB88eKsQd//fs+GDfCum9RZQecRdcV3Muc8W/VkIfn8/VRqKW
LH8VecTwkft3ffUGTXdvtqaA9LZeAXzzti5DquBv0SdFoinzGOhpwwvxgrtQba2q
jiPPEAH+oZDnJ6Ekec++qRdeMcIpThJ7ts95pjwFlr76JQ8iVNeVBG6Pr00Yx8gt
DRND7KIpCQ0zH3/uAYrV8cNxwPIe+xDy9pcVkoMS9q/CrmlzZnriJ0n5HJPQ/8iJ
7pxGcEWqvIs0GwEdpeuWsvYWDLByvEs7S7XQOM/8mHEn6+oopPqmzVzv92F8t3CR
pPUt/69oBJk2N64Xjem0Iw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
ahBLAcQoPOqQkL72d15YEiNSbKStEKkUHxMGm4ObkhSFQsUti3/tG+eJ6vv80/4B
bYrWVykY1IK6+SCbUaeNMNJnV+sLMob76Czyf2jOQP0Y8FafnCGmkTPqWFoyR2+a
YYwf7pI+uwkAitsB7tmac3jxPcUeQlgJAJXOf8OirhhrsH142Ofx713JzETxdbPR
p71smuD76pcwOXOS/rwn9LvSV1tiRs6tqImbdHqnx4qEtDY0OKyHhrsnoBr8iH5E
KSuGQIOVLdEKJzmi1S5wwucoL2f20kcPFgVKhSrwkMbq196r/EeanRipT001a6iY
KgwgqtnyEoYpybZhUpQPtA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
HT7BJ5RszPuO6NBOwPBdIl3lsNb8zFpLmrkh4hv0N/yTn685SQc5764Hn5tjtRzf
2DV1Lp6p8UQSXafjTDygwt9RrcgYZVBvepwB+yu3iscLszcxLh3GZLCUAnkW2zOZ
x597QS6wXlpQ5IGYC1ddYY6amaqN6XowOO0SSjpbGhfkff6pAnFhQqeCGfR6wyd2
WcSnvL8Mi8XnBh45mRoVkLZz6IiKEGTkO42vBhzsONkwkurlqu0BtfMRbgbbIl2+
kuBDHqZ1crJcKoqilKcwDSEyCGbwC72PhwgLFKlDugDB2M2R4WUfZaLzeuFAhh/M
9PKlYiKgBdUJEm8cjM/CaQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
AEGEwTK9tLAG2QXfSk8/OpgHxqPdRK8Rz3h07I6pccQiIjDxHOQOTy6CVFk9SJ3V
zn7YBrXn+MGFhXxJCqXf+311RMoRzzCzRpLoNwKMz6khQAke07dclMqCUAmBg8ib
WI4+2HOxRsmxwFMWmPF6U5p8LFNHRE8LHYDbY9r4pCjssPx3ObftemH2j36oPDlj
ZKpIL37fjRQIxdKWq14ZS9EI0tUiWrTQ04pGhmzA1SyoZfixmNvpRtPSpapBuGLP
I0w1vjmj9NO5YrKWXSmTT97Y/fCM6fykbtd7oysNLAz6mzTFkaHKkGtSz40EpMQU
vtZ8zdAFz4YuV7ukXq0fjdXZzvtp/y14BN1OReeou552+Os+zcAdi9Ft+lgSS7jD
/ajaUe5b2JX1ykNQP0cMbjp2vo5r9nOf+dAaQKK1KUp7zVokFtlxWKhvFCu+eWKj
JpEXZsXcY2wlOSCmo9Vq9vRaXEeCFKh+AMlJTRT9ZV8PSY5fF6DfIZxRdKTV6EjE
j3tteOutjPtjTH2BrWVoI+GjpSNKxV3i3ODxQaOamoPGl/Eh5wzgA0QGqh/+miuy
YsuV+p5LdftMk3WRVdZRPY6BROY/nVt6vjttqqD0UlSGTluH0hhWKeNp9HE5rQTL
THzTZsZknr9s+B87uAhceKRN083fDRbDMC0pgSXPx823F8FWkDcR5Cipro9MMoXU
1yptrfhlgs7cUjbZGptvyKWZmNnG8LGHQP7o7q8DVwFQFU8qPP7bsIR2S1+62Z0h
BFOtAnS6TCxNgQNK6QDLSiPALbRQyATSM5oNtcVz9L3e+zn1SAJTVNREBobDfDSn
23qfo6Qa6VuhWTI2T/LcXU7ebN2UgCmEdcNna5Z9h/eXLhssg3aWkmemZOKbJ1n3
/+umsTBMpeB2sLq6NxzjWjyChlsOZy1ZAPGmqCm1gvZPmfR6C8gjrRDcAvdjua8c
kqSexAxlK3TGNzeZFIUBTS9hOeCw5g08nwlPvoc47Enpb4MnotJg3uMa/2sTRBm0
EIHDPuhEU/gelDwdrMALoOgINN796R2JLQ69z4DkVwkHfdVM5HfsSPI41usFMzr6
0PpkcFHAcAkLLEDWQU79FivGhFUUi6Hh4UKal7DmIj4efL0c46cSJK0oa34ejz5z
7awKHmukWv5QCl4DnwZ8EKiNJqBg7jQzgpY4SUUykyfog1y11SwTLrSW5CxTGxq2
3yv8ISjAKWPIyUdRPnmb2rIu0U55/9HykJZ9TACmUk3mTOwEE9lsviGrX1/5Elp8

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
XpjHLZ1ebxyms9KgxI+GY/AlHWGYThK1rIhg1V9VT5jDhMoDKwIqSCQ8fhUIWQOb
+zh3xlFxo7ZlGEmzyH6L6WSvl9bKK8EH/hDWmsUAVCcAHqcoa/Zg9rpWvjUhSRbg
0Ewqo4U+4Gzbzlh8xV/hJOt4EwOXoNwR+tX3URRNSQw=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=5056)
`pragma protect data_block
vUw/CGg1qfbT37OA6XvqvunLgV1rCIwMeXmqYvBRbUKJe1neQ6/ezejoEzATPjSB
Q8pc/BvgJ+22+gNsuOOcRdKWuu+KARaITD54OFftjERH4hqJYsd6QVbYcPx/trxL
gLsSK3icuIG3sNuEqXTnyfllBgPPhA/e557d6TLlrV64JLlx6TIbkp3mRMspugKl
E7fVDd07uZFKiptM/e3aWkcyBL84LgMTEq5nbXbzB7t+szKh3NbSX55rcjQ7oWj7
JwNY/urR5pI7yqSRm2YOiBgz8+f/hnysXIPifblO11xWUS/3sDfvBNkAiVFxXR2p
lw1PB4B9N5KYH+ipNMXOQCvJyt+qpTTtqH3svJ17foQx6L/Q/4H9pKtIvv1zJqP0
1PiymkrJ43QF74AzhbCE/hUOz4yEE49t3k1j4OUHZBYkDLU9ZpMoXDA4LWn9WijZ
Oa8XAVUyjKp6LpmyMrFo4+sUfDWWhtXJEciby+79TAHkaxCxm/oO5658dp5fF1gY
hMFCyHtQ7UgVKkF+KWTDWiYKUz7cxc37Tvb40DocQR8TVM61559a5dxE0I7dnyIf
CIWf/IfhlouH8ZW0N9weffHDJDNM5yTY/voAL7LmSExHnx2U9tkxujeLMPvc6rLH
fwKDg1+32i+CuStPOoMEOdXn5iT+0J2srW53l9PBxTNhNyYVOEFDRAGjXA7oa8Mh
R4Lfht06v8+d33Kv3jicPT3JOlGunQaVuNE9zdGE7KVW8YbVfLYCMyNAUQYeXJYt
dYFWeQpp6W0Wl9VtKon3wecWmJyEn9UdCP4+cj7mrJrdzeTexsxeeHAj4EnHYYR4
YOo0j7AE/BZ2xtfJX0PimlKmSRXQm6fDi8oc6DUi8YVr67Ac/UTP3VKrout6wE4K
3lM+DqeYtFH8+ftMJJuxKwzDQiAkftI+mpPYeZZtWZgs4HDF3uMiQy8I3PlX3nbs
m3ssE7lucUdRX5rj+YT2uy2mcif6FUQP4ojgbHDcvVybcCxe7f32S8dOC3Vr7GJi
vGrs3bNgW1HvU6krY0BeKIAiiv7TEGOv4YYvdlggLf84apN/yomRPdCNlgPWC9bt
jcAfUHoJ+8Q2kSmbYadJSwm6Pv7LHLQd+DQh4IiMrwb3fR0YXUYJcP5poJudN8pT
57LWb+GpbwAKcf6Hqic6KvwbVDMdcw1SxTx+CxE0PkmO8vDPJQdGYyE43NGye9Wc
MWKbqPCBmI0pDJwQc5z2Ys3KOVwRJ0n3LJdJmPN0EAXNWQf9JoqR2VC089KrXxGX
b1EkTnon83vYPAmJ2xaW7ry/pPZugdBHEA96q7yrJTWThsIMzOugmlaS36vQA1Aw
GY8G9xVN9LnKFCKZuUNiRq9xKMNAPJSaKRL6lmGHkztvzreCDyL1fNlqxhZTKDEz
30qgkBx3Pt84AQa8QRm/xzGGQgPwJxMnvECtAeQZAN6+il5vPeWe8bc75zKFOcTg
32aPTSbL1O7jPBSOc30RULOwPQlrMrR/VtWw//kjA5zabmwzrzcHEtkM2KMVBQ4O
Tyzhq7QjMubG5i6ew+bwd9LmlCBBSloXGGbY6sXOvZFwgdVBiGkRZEe1LgV+3PDk
hGWISEmnRovuSCa8BakoJF+HFB6nOeafAt3kuJkc6ptgNK0ABwR0E9ihVZFJEOPi
knSRDftPDkQxXDECvHLM23ZZTzf2btR+UYbFUqcqnKJ5yzLwy1XycZQ9gxmBnFlj
ia1xc0BaWHoJoRySsI3zo/Lbq3NDlr5uDLA9G1C0EdroReExwev4qAS0GS3W4WyV
FOnsL1+tEmcTkRvA6GwCCQ7Ru/CMci+M48ycmy4uqdanIFKNP4BYQoVP8oIYOuh4
jSv4Mr0gzMN091snUM5wl4RCdH2GW5sCsb8hBFFYCll3mH8aRJsvkcK/0iKypbCH
zGhftm1DpOnXOJT3G4ev7bs5m53t4X8MQyni9qy8fAh2TWYPaihI5ArEC4qXn7cj
tQsAEgv8Xk93ZlVTtIfVw53Tx+EmR2R3bEz0PdLdbVLJ25PWWNj80rao1rPkRcS+
hE+XhmkBwJMnXXIIigWNYVwHfXvFzafgT/7M0mhe288/D+hOFmU3E44NBAGVBcPd
MOkP2qOCYSumYWxFGFvSp2dUBLR8bDuLvm2RGdzWp/Vm75JqXGAaUrjdvpo5l+HK
jhEO0UlVeU7J1YaRLvhjRWLUyvek8jzhu3gB9rwpgtcIJ/H9utS+wlZ6OLLG91dw
NIiE2Zsm9h5een1vFxDo4YqU2GQ+gCZG8m9Tk+K9LknvhvpI5MeE6AHrIVwAp2hr
m9nNoxskGmj7geQxY/RxcUFQsHJYfJLbOo2yPxRRqkLWV2oSwGaRZnw70JZ+3VeI
VHhDZw0nSI4b2ORZxg7lNUEoQUjZiBF7owAua/ywcF9RZDvvNJqbtOElr7ceWZeb
3sEI82G5N/O6zxeEpzctAnVHY7xKOJrJMd8M6wvPAhFnM6F2iR0KccwAibBOVUh1
GLjTW6gfST8osgxJhR+wlCicYJQFHC2ETmhkU8OBre0aStf7VvEcV1wBaP1BbFfq
S42cJvNbc2a3r5TN0kVw28NYO3+e58XpRVnZ3HUzNUcNlFJUp+Jo59va2gPTSswZ
QKzGe+ssCEmBGR/roosjXyvEG+5OP7eLUXf70HMfvl4dt/nnb7WM/j2Zg56zlWg1
kNip3KtdP9YCpQwZ1DVwNPyF5V5mSHMvOtsDgKrimh9n+m72Jb8iyOIUk8DZet+i
HAXwd/HkmmJr620cWGV640mieEkE7TBW3YSSWMY1BZKLCN8P0rAcl+zS6Kgg+nHw
hdZr143E29Zk9vrbUY6N5UBs8DwdYVqw63hjcPgZiHWshjN74vUaAjnegt4kqroE
WlGDJgKB6iPC8DyUijTP2W59F7ysc5SUddhk046ii9zplRNTDc+WpMq09dSN5cxQ
6o0RdaT6wC2i+NHIFhbyRVrI75/nU1etiMvvSZ/zMeaS3+TTX7UOpASA46RXKX/f
0eBDlrUb2gJwXTDbKKDTipqURmil5qLxXdA9trP7IhESaeK1dB7rT2pS6H3viL16
GyQWeNASISyRv7E3murnVF5kpvY22+ZJbQMVD5l9Ak054T6W4xOSpsf9XxKBuy00
3e009Fcgh4YJ+O53frW+3TTbmNq4HBAEY7a33QLQiqORfsLDwJoVLmbUiZruqvVX
lFRZujNtsBqGzx16hi6oiVGMhV9I4KjgMSPlsb28WNwXrgsUwlz2Nrr5pamQL4eO
yPQlaWRxYlH+vMxkBIwc8gA0+r6D1nQBwludsAi8gUXdN4W//9wM36gJvLI2dY8s
riPoQoXfIMXFcUc7CsykQ9dbbU8z7Gb+464KHKNy3bXlGeW2tkBi15ki4X3/BGhV
/vyhJYJZlpLxaCapYBcTpiqobzhLa/iEWOXjGV1+vjmbtnK4wgd25ai91HG48xmg
gozJmdkpueCjaLvgLBjAGcnP84OclFJUpX2AI5EXr1u8vGRBn0MhQB/6qJp3gjMv
hx2pK/PaQMZJaAjo5lvz9R1YlG3pTpGz3/G1nCL8nqzSFxWmGEFwa9oxN87ZSuvW
L8Niq0D6iQ9xzssakH1GMGUmWCFIXthDj3HFqVIAB7PQekZnJUHosCyKWc7xq5W7
ezjWmcqwRu3M813msqqaKBzhm/A4joVboHBLyfQSP6BTrIAhjnRelvy4/ftZ5pxr
ZoinpG0bI9dnAfjR7JqQxwu164jS3p4gDskXvHg3lB1LAEKr8nGxa8Ubq6420JhE
LlzFTUYQpp0dRLoNTNxI7ejnKSRgvP5Y1qHFA3Fr9vZiHweSQx8BaMwt3Ji/ckcC
dd7tWGjLOPTCejMKTsarJV8xpO4dljTqDFUSI2BjiA6d5kUyXPGRNlZIDIha2Zst
F37uimidyOxOPx2enywM5iKbn9255Gu0wci8iB6uEMJ/IuRiQaBidINNyPlF/UyU
WHeU0Vue3A1R5pVsA4gJwK7mgk15cGoawmQK9JQYOTi980m+g36wHgKriaYdEl2l
fw28DXR15F83Vr5xH3WKR22E4tjPGzIIPjGfutOzaiRDPgUy3LVn/Yw9GIjrzVlj
XjDrFak/RRn6qH6f3VBJZbnW7Rzfl9MlChNBPcA8uIpEZBH+p8Q+GOGM3aiTOonO
vpQEPG+Jmc1s1Wtbk6hmaVOappJXmrbhlOS2eFlfJZjOBPGRGiu5ybqLj/eNBWFj
uvm6Po1quFaRdLBObzylxZvq3u+5FnZeUtEIkpiy7/yGcgZhdM3ZokBbMRg0vn2S
0xdF5PvUkwjhJQ0c4CrdCEyZOJYgFJrBFN+9IWCwjb7fhl/LMgwMhWOgxsVk8BOR
h/QGtfBxiU+oLbGVf347QXc1HOMETkZlfPSUch78bLidqOMdRwqbo4zJp5ClIZNo
rYNYSw9prnFDe9oyRjJy/j/zvTych7Og7pOYZ2tMhcbpCMAdv6rqwQCuM4pjUn85
FZ+j2S12pld3mCHvjIX8j5I62HxjTMSCQqRXwgldTSvabqMBV86NOAR3uH66gPLE
jZWvl8XpyB9pHlu8jUvA4QFyxsUmx++QqTFW5F7h9IiCrxmVUWEdAEXOX3k5tdRp
lsf0eYE6xuUbjpbZ9OzY0kdEiMDsJtwa8zWmopiCao60W8IsMYhDgd6tZzOTAFRj
OJArHuH4thRwYtfZoJEIgWZT/sbF70mochR7iHcrd4PyqZntfy35kpoKsbT4pHnc
A9AeroW9KKgF/9+W5mLeR114cosDx2L49ksAXnJuL1PtrvdLp738c3hI/rrLdeaN
2hpZGaUKnf7NweJPXXQXt15hpIjH2tkuKcVhxnODgUHuVyGIu53AFpK4MZi14Et7
m4YWshlkeHy/BRGoHUd5gZvPHNKtE48XW+YwXdMtGO7UN5/o6+S9aEbr+PhdvInP
wNaf1aIkFYVwIi/R72d/Y2Ny6TU13wK5CRqvU8pY62MCuzmgIapGuwzf6p6RRCsn
rBBoyw6B6OqIhIxMCnW7zOpaQULVfiQPtsvolcXvspq+RQLPhYjoATJQjKQCvJCv
GoCZkdtT8Ivn0Dv/ZfXiefqqcwviNH4QIsZVYp4etp9rrVz+8YIEo9FLAsFmI4mq
Bdrdy08RVLT9BFWPvp4g3Zj4bM3wYhEXCZUxMDmzxgZqGpK8JvxDGTxVjsRlGtLR
E3gJC0POe0E5KUI70gHG/ER3qoasgxZ16ZKMcXIaSzZkpXYef/VJ7HCfFihEbDUl
5RQOJ+tsRqOKrTJOQINVnhAa9Nh1DxbGzhbbNqm6OdoIJpRm4BnP/rYJetO16phr
3yhnA9NJrsR5MWtiPwj75Pg8T0/DyBZ3gejTTlfDXtfBlIpl+k2eod8Cq/Fev/KT
T8O4ScPHTky4y2X9NP0kz990HxoNTs/DIg3GeA4PRmI/ZafikG8QaqEVwbA1m1bn
piqkQ567ibDFajDkvQ6GV705Wg1Z9HkKTlhMVwjy6Epka8Ti6IKvtBo9yjSxGlsG
Cfbe5NTEFpsUFlIFmo1uOQUZVFJkUscg2Ul2odND1LRJlbQ5jhzGedWudZkQsaa1
OdeZwROADVBXxk7j50w75zKQaIk/BPCEpfjMEwsYbYTazrxWphFofoHZNr0F/eZb
fJB//ltEKVri8MH7QiEJhmKJO+G0MSabf2aSdDceon/XigVqOLwkF8JtaldPe5iW
CZDru7CYOpqmn/uYuXOFfP+WvMiBvN5lr1svZERFEIzYhyQoQ5o9AJjo0LCg5qrI
eQAZHwlX42mWUiEEr6UuGSLLDA2WOHQ/pnLHSkfZ7SIOxLv35d80q5sIdH02YXO2
y/wsXDSr9EREySViOd/Ri5h26rxqIx0DadHNEZQ+JixF0G/gorP/a3QhoIFuSpa+
WyPdrSdm6V6ZqgaZPa5tIfMiEmHd4Ghhh6RZ/OwgzR1VGo9mX2CHvy+1BnaLPiOb
9TOeIPdnUYYmtKGXkvJfuOA7fckVsgcoKdykWs9/3tGaBwNWl3Jbt88bdpzCqr/i
+MmaeMRfqZshn69tlCXOgxtDVCEVD7ErXudTnOgCDGtENbfOmFAO2b4U017s2Xk7
/2Kb48q8TtT8yVcgrffAd1YIjl6Szecc1/g4YIhv62frluWHIh1sNbzwGnww5S/+
LobBN/u/paODTSEPDisuoDDmVVsUxKhS3aRIomleanUo2GotlN7LVCm9lVx2YPVj
RV3f/Rf3KS7rRQJXzL7s7xHPTZ0g1Q8UdhihHJBcITZ5Hpc/8vZNOc51VDXlZ1L+
oo+a5Vu3O9zOVu8WitWGWxP3Sp6GgRLw6rL6N1xiGDlqS8H8RNIETGumAY0YjFLW
112eXOHw7JPQx5gUITOyE/TXeIvhJfYsnsXOfLYc9ibroE4Zn7Tzv5wjb+Iob2oE
M5XBxmP5ZT9cjtVMwelBeG7k4MX963sZpi18Swi+GJ7wRRDPGeTxmuXYmd8AATJe
XNBUjZhZhRC5t+dScQkYZBaf3INfmUwVV/PkeCuXCOI7yjLWdhmbEHNVWegzyFV5
ZsJyYkLZnBH9+XUUGjHk9Edyiow9h6z04WNz1pj3tVYCxaRXSRaziCd+tW8LFaRx
Ho65XfJsTh54zyhWQQS6iDGchf+fygJ3g06Ue0lSjF9GQUwm8sp9OLcVkWwAlYao
T1Puu6cBlQxZwlKwFW8io6wYjNqmXsTUj7g5Rvjm9QC6MYk51VukxgVQNP2vvaog
E31JejAWNP4QtWBpwgmweg==

`pragma protect end_protected

endmodule
