//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module axis_drop #(
    parameter DROP_WIDTH = 32,
    parameter DWIDTH = 64,
    parameter W_KEEP = DWIDTH/8
)
(
  input   logic                               clk,
  input   logic                               rst,

  input   logic                               i_axis_rx_tvalid,
  input   logic   [DWIDTH-1:0]                i_axis_rx_tdata,
  input   logic                               i_axis_rx_tlast,
  input   logic                               i_axis_rx_tuser,
  input   logic   [W_KEEP-1:0]                i_axis_rx_tkeep,
  output  logic                               o_axis_rx_tready,
  
  output  logic                               o_axis_tx_tvalid, 
  output  logic   [DWIDTH-1:0]                o_axis_tx_tdata, 
  output  logic                               o_axis_tx_tlast, 
  output  logic                               o_axis_tx_tuser, 
  output  logic   [W_KEEP-1:0]                o_axis_tx_tkeep, 
  input   logic                               i_axis_tx_tready
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
cM8jr1igvtlGNSOMBpuQQNyrptcXVzGt+31TlBYO1V/n8dsBIFoH5IEO6QUBqfeB
UPefTqRa32Vz60DSQMpWUVM7JWQdjtoVQscNyZwpwkAPyOEfb8nHx5ztnKFSJgVS
fjT5bkMS7QIsuFH6NU20FEvHn9Fs25rQYkEyVpuZi1ypySHypehglQX+rCFtX8/u
GnmuFmYYB2ohzd9OSYC9IYyBPL30P1OX6e760ZYL0zv9YZ61QhRfg9qzMdDoQ68X
zsmyaA0LLrtcP9kqJv9t1VDXoxy7Sf1HYETXDGo8+UdSFRHbajGqzCEAOfsXrnyp
PTbJ/doz9PDIZ1SgxZboNw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
pLWzjjWk5rlKYWF5+P+zeB4y1n47pLMPrc9oBvqRZndI6BN089m3gqamyXPifYQ2
NCj0bmzGRyIy7AlMdgdAxi9w6IUFMx2U4yYUJvbp/tCHpBTYWbjfl/z7DtT2Y7Jl
5ResSCdwdP89TLGWEIcmqknF51zlQdahFeqVuumb7mU=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
7K0/9snswNuSvhmZUk5NaZMFHgZnORarkhER3b3pgkeY0Yf4h7tfkJtbZDKJBsgj
5KvkCS9wisaIcgV2gVNwEgcCjBd6ri/6gJabQObBd2/lRCoBAWBkuaslJaeNJysZ
QVrcccdxCToVHwPRiw2Boa9R6We7X7eCC4Vl7wDmr7EeJWkO79w+1+lDICJY6DZ2
IWX6OQEn5jVdIqmVxTpalVYXmFSjujzQWupauqQkbbHDhR8aw0/dcMWyDq8YyMas
J0FZ8vLydJTPliM7SNUwq0DvledA16e6iBuwcsY9dR+UNVHSo/p0kBplU8H0ARZw
II1WdCSxZ3qOhCvzEXd87Q==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
ogFkNuky8oqu5aBfPIl+COS6r2scStFgZglj1p8ftd4fWGGGNE3aVVdvjnKeTtUs
CzZ8l0kgDaWeAfne1xfu2vgxKMk87sszMwGWQZiiGw4FBK8AjHUkRjBkroV4uf2B
NhFRc2PZwDAe9xlh3OITJfJM0SWFzJXxY3W+BU6aZxOky7+DE+HGLed6h82pVns1
DOmmlxFmZ1dKkp7sr35mhG+JGgm/P5EoMQmu3ua9w5/hbKgQqzZsfWA1dHTKRCLz
u86HdSVj17B5eOQnh+QszW8t1mzrfLggbPz35N05jvWlVnOr3evOVk5rR0RWjYXZ
HDtgsAxsJxPDTupJHcDZGQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
YzUfb9Gm62fzwC64JLpL8eiZJclmNI4G4LSBDCC3CzPT6TZNhxl1Mpi5iQ11ZSTb
JhIVvJVAiScow0EH+bxQ2PGFvJ9WPB3vS8WUalDNTDEex1vrtd/J9P+nJQjs1k6m
dUH8XIHpDYagsMfTWq4VnVE/b4efN0BlndhGRbYn3pXcOKnLl2ZCw0Dr/eXINVEz
1N9WUyDlMpYjauhP3mQVka1RyGEtQx6r+Ug7Gk+iVi3WlAbZ3UEl0hfhCy7LffFa
CpkIEE+dqBda4On4wfXNBvIgvqh7RJGCCd61Cp/59Pu7DRj8joEi4/u1yZgUDDJv
WphX4QI4Hxm0py7oM8p+6g==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
D0+3BvynklztP6xC2LwyKopIw0cWSXWvlZQfNOYnMrmAQqdPwv200GE6pfNjevt4
kbFyqRf0yp7meGjuaW5Ptmy5Tqv9+AZmRecVq2PrZsfSWZV1kTOSwE2rxbAYXj7j
PLD3CgJTp8ttLQrC1eAFNlfv/zZjJ0ixJGR3xGa/ixuaY3VQNrgjSTqcFAD2kgdI
91ZSI3E9YDo5XCBwWJD92t2Li2RU8R9zxIQ1yrhuXgV+FnHm3MqoTrcKig1tvMEU
fnxp2DqdAlWTw+Gpsq6SvMFHburMtv8IyXU+H5UkkvJwC8UjnxOzMjxHSliHPbRS
/1tCTGt8yckKJ9aBUZ0lbQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
cfXXgfyFdut0GPkiJnn5lwKh3vRruLHqFnE4cSRZcNzaky16OV9XZ7HNMAzjJLag
1Ge4M0bilrANGhVuW54vHWW77MoRW2fn6CiduBMLK4A2Rwgf1BcLspLbk+UA0WIO
tnYF79/d9GrpcvU9bpaVVcHD8EHQZvqyqf6rxijfpyBCugQ17O0gNqrbpVupCm59
VRMzT3W7V2979QG10zFR6h0hLVTg1FQel0T+YZ2hOyKcKZ1hbzQ+4P5Rvg1/T/OD
Z0KrxjvBBCY8aMGjb7GHLeotTfsbf+G/Ah8MoCZIph9Oj+KNcOo/HqdwlymdOiw5
yyrVt1yvtoj/VciCHOy163aeGb5SJaCcMF4rnRkffh9RK9N8iMLgKm8TSXuO6RE2
Fo5EubXCrL+lnDRyRpCSJdXB420SRZ2cSPxlzCGrjkqGdNiPu0E2yZYd7uTuqP2J
2wsZaNWA2p5JE9PNz2996Xbr9gWPNSQVRefXxJnT7fSrQX8ozT26iDZTLHv0cpDZ
DkCCw0DZWje1h7iVQNmwBmRG5WxiEt+XRNQn27rQO6W2meC5DdyramdWAcdGvMNP
JQsNvNz6XPm+ZhoOjFX0dVy5jcWv0IDm5OUG6qFEVNjNsAegNwt7BuMnOA0o8bZV
rR7kWjUuHbGelKJhGZouWI14eF/ret9aG9WVLfbYvumIGzgAGAAFeWKQhqEohfZ+
IfFb0/o6X3PO9M1GNsfw4vn0IeUGWPH1APGH+IcDPuM8VhzJHLZGTLYdp34xFwTU
NN0tdg8mKH3EehkDK2rPcjEvLq3P4RX0+Srpm3gAsc6N/2/G7mdSu8wbCG+WqELm
xJZD0BESKKbSpJizQFEhojsRgPVcVR02BVjEMAAg98FLfnkRJPH2SRXByVj0FX7o
GPtIjFn19ci6dHX21LZykzfygRjehnS4cFydcWdznVUGnhk/WGMVRNkTIKCOWdV1
4LIfulEZAs7mNPk49xddKCoLilHX+fYmfNS/Xvr3e9K5PtWJuOsRKs3f2Zmfg2Qm
BA99LmkxPPpiHoH4E1tpSa6Ec4lRg0lMbOuZXkgf9EAXwKJsbCU6eGYMPBvRlulg
t19dGED0cnRtzL4ruon0AdslAhSbLa9oZvWimr3bln+41jLSfPUlJEE06IDwBPVg
XYF73QS76bvZivijLgxAE9jh56l06GSUTI7cKAznSTnLWmqZ03b7WhEq7D9069mD
/cXSA/QH/GrgogscskGcgjiE6kTnfIet1Imv1SOyCCD+ctm0CPrGlfnWthYy0H3E

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
Bkg95AdHTh3gssLcM70RrvCQG+/Bcw374GXX1JxE8pPHmQrIYT/kPr4GzI+q9KGc
BwGMf0ewri7KhVAZzMVO/t8CsJ4y13k6pBXZc9DWjXXZwwyDvo9lOakyuE3cLZdJ
waVO69CB2EM4Cwi41bBL5T52hkpodNqc/6ixGgZ9SSA=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=5920)
`pragma protect data_block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`pragma protect end_protected

endmodule
