//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module axis_arb #(         // Priority/RR arb 
  parameter  N_INPT  = 2,  // Number of AXI stream inputs
  parameter  W_DATA  = 64, // Width of AXI stream interfaces in bits, byte align
  parameter  W_USER  = 1,
  parameter  ARB_TYPE = "ROUND_ROBIN", //ROUND_ROBIN or PRIORITY 
  parameter [N_INPT-1:0] SKID = '1,
  parameter [N_INPT-1:0] REG  = '1,
  localparam W_KEEP  = W_DATA/8,
  localparam W_INDX  = (N_INPT==1) ? 1 : $clog2(N_INPT)
)(
  input                 i_clk,
  input                 i_rst,
  // AXI inputs
  input  [N_INPT-1:0]   i_axis_tvalid,
  input  [N_INPT-1:0]   i_axis_tlast,
  input  [W_DATA-1:0]   i_axis_tdata  [N_INPT],
  input  [W_KEEP-1:0]   i_axis_tkeep  [N_INPT],
  input  [W_USER-1:0]   i_axis_tuser  [N_INPT],
  output [N_INPT-1:0]   o_axis_tready,
  // Output Index
  output [W_INDX-1:0]   o_axis_idx,
  // AXI output
  output                o_axis_tvalid,
  output                o_axis_tlast,
  output [W_DATA-1:0]   o_axis_tdata,
  output [W_KEEP-1:0]   o_axis_tkeep,
  output [W_USER-1:0]   o_axis_tuser,
  input                 i_axis_tready
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
tKPPdIy1a86HNzKrQqG3inYKI8CtAMHpKKpY3iePEUu+ybLiuECTMXInR8dHxpfJ
2rG/65udEoX7WyfI2bG6rPPBDd9QdSbAM9FwsoPX6C9xfseKpvrlWJx/feGqFpCK
jZwT2ARf+rFwAOgpw9w6Y/OLYJx1F8WLLTzznG5zA6GWZdkosh6Xvjm08EI59UOr
MTsOWPZIKMkfBT9G5jR/QYPJY8kTV8hDnMjQ8F3HXWM7PSU+aZn8MXJ8gtqXTdav
ceWXRhm0a9bfy0BSEClTwG73t5WydJC286coh9z4xzJ3QS5BK73Vz0tEw8TM83zc
YfEiFPhn1tOECrVSYGFzyA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
zxs5EuOprNzSDcdVlH/4cA3R5ppFW8leQOYnNKdldbugJhW7/9YNnQoNq9h8xIzG
SKmjVeIN0k9y9dg/q50MU/X1bf5IT/oirkrWH5LFu4sSIB3sm9EGHzxiL/ruhpM7
1ZDFTg+25EsH6yi5tBkXAIgSqJIWb8gdnzFHqr82dU0=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
Jh+3TuhVF59zxfpWdYGeRUgoQ0DupuW2h+Ikw7HiDNg0riSpK9bRBC20XErvp9WK
gnWQui3TlIjHvFpWMqTzE+C6TqbPHFnIdscd0F1sue3JWsEUHbDmsIAMZN+7t0UM
6guc5DjhZW3UE1/4zcloH6yZ8YzRImpMUPmS9KtZidpLnS5TBRoE9+bgiaVXEHX5
Y8rX2YyfOIu11QXnnHcQNsZU8vOw6wcZoMZ29yX71xqzEFkhwG+2s+/KVU/LHoDg
MzqZGEp/wH3z9wi5LmiIjVpxrc2jDONuJ9JWlkjlgyHWaIPay8cWqVs65KdbCIjv
trfkbmpExgV7Sucra4ONvA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
iP2usWtsllBgyXiMyz1BhX8/DKNH7SsS9rmLwVPAEHofhJTahNYo9yqEidZDgkCI
AbRUGUoIbZX0WX+9PtUEgCCug0SDEHXLR5E6/C5M4fviE8OqzwZkNx+LUnAsB3+o
XMJCkRJxy/3B+xyFj+LVscgt0FFlxl+b3L9kis6x7OH2LyPTFhzSy5QpQIk1va7q
YRFDjZ1gKfB9hfGSEtlj5IDwjk8lzgMmtDU2FgVX6uH52/hZevJrVZB0Gn9BvkRi
8PT2ADweUaLxHUBPZNSbydNYdFr0IPzsph+ZZm53m2edfs6Df0c5k8IXpTbe6IQU
kvZVoMuWfG3mUkkNmGDZ+A==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
hrpcvwx1FPoyEUJjn8fyaoZnI4O89VJ6zZnLv+SZsq8W9BQ1x0yfq8+uF++rn44I
dwmG0MUIB8EFfiB4ks5sCBRldaRoXvqG1JDlsHENdZRSKMLh1AA5MeUT3AlaG6VK
knKJqJGTsSIBY86BvU2SBDAC9+LjFVHgs0ItJM/uDkGGltMXFcaMnViG/Dnczc83
jX6BGtey+bMDv6gNl249vkVsrZeL8fo24DZXHN8XmhKNA3TYbSaNtDu9t7tWPKfw
WkgtT8+2nMo35eFPOw1BUrQ8092Og9HFipUjfLPxoX4s4MPAMh3oJtWoVPp5gW7N
7qyx0U2yTJCrsXxi5H9hcg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
FjRk3nMCt2uLN2LAA3E5oCVUj+GDj/bPnY4ZYiqIuwEVu8gPUD3yJSKUkx27eOTw
TGfq1mNVlJ+ngr6chHFVWnSdCj9xkENcp3D/tAXseubzGBglM7eTknlOtkJUyO05
nl3bTq1hznCN+hBAn7YFZYJtfqXXzBtmFi5aOMTLg8r7KQEVNXV8G7fdDhHYQQfk
se7+WsF+JAOcb20lnebjLW1wqOrPdyaSq76irtFFsaKDJjpgvjW1aknb29oGmygN
iTQriUdmEWGGZM3eKK3BbnZnsGP/Nz3yzdv24esR3sZV0XhekckU3qK1K1TZoQlj
6OG5cNrLXtTVaF2rQJCD1A==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
LhyTLAfSPxoPVWaRDlf7D2fyP7sg/vt5y57sO/r+Ff8Zmz1oXs4cMDauBmddIc2O
hYD1jYcLKlxQucUsBxrR4p5GZI0y+XXneEGXo0VM3gvcbE6M34mptanYm/sRf2Kr
0q5zVYTE/HALG/NipSI/2RrTBUm01dT1jZUTuj3ekTyCHiamCRDXCHJsFZJTpaGS
Udg2JK6NEQdI3S8yTjrDbMvHJOQJqTiTj2OxkGV3TuMGC9cSXQqK5cHsiHZ4VM/m
5RRGJ2xFdKMh/v0GYuOvyayPWgM0dTsp49SNtxdYC97ac6VKBz/pP1+/DrJrKdqn
3LIQx6yt+KKQqgq3Uk9mOOoFXoLALpNv3TgTTCGYgNTR3kKbGQFNRD4hSga+K68b
WuQTWsX9kJoZTd0bPxqpIp79Dw3zujJZC5VMl1YogOfV0YmW3iwzjzzU555zC9OB
dfpdZPa9Ejbqbtvp5b3xw91U9cvmU8k8t2zF0SYuEyPlbterrxOLhSXfjQDZBd2S
A8I+m+IH+thq7vEhJcmNQ2T84wC6oPW2SXFPzXeq7yMTYHCQpdkC53MY/nKedgXJ
54hr76L56rmc1DFQGReLYVJ4y0HMA25wNTrrbSRv0nazFOmp3NITW/+fGvNNjkan
oelR21vcNt7grkTy8VUinP/c82Fuj2Y7bSdwm1A9B4jhSbxSZs3a3XhoswE6QpUd
Z/dtj6fQ9OCuwpz5njG4oM8ZF13ROquWrhgl+qYhURoeEGicy+fMEtz3e37qe3pC
uDajjhYW7dTRmUNor3q+p5KS9+wv7P/wsQYpCROspkrQ6UDitlvM+GdfyRqzGlWQ
dt5r/nfIOacAm90P+Ih9M1KA6YQzIqu2qtGW1bvtcolHREBEEOUojHh+M3DTwdHS
4uojomx65JF4dyA/Vdoh3CtPCUL7VMk1Q332Stg/ZQa0iSw96AtFKMP4POAldPEY
A4taLfCa7Fu+1sY01Y+TRX/UOssR977AqM+hnlJV0TjoXh6XV8EIadmhL9juC0ab
aPfY+MaZxwTkjoRklbPFkgFNiO4Cp35pO6dZSTsvMjt/uUBSwClIjxSEsCnjasm6
TwTarqQ5cstIQrkvJx2x/9zoFDImxFn2ud4L+rAqg3RWyREjQGWZssWF9fo6rEY9
ct0au5V7ef809SK1/HERMXvSanpqi3xbC4VZZ6vEBc139f59DQsIXQCbxRGBMOgJ
hpZ7qin9q1YaMRVys2+ypUnEkOeNQJRUo9B5ja6cxijKUNEfkvekr3+V8qVi04Go

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
LS6yxSDTRn+efVgPp9NIGEpHdw8tYltBAGNbmb5SRhMbAyRxEFuCsdsSf6wfWEl7
WFwWPZliHBkiLknWnejBc+G1FWKsz/oidUzwRaiJbYuPsVTMhMTAIBeirJPaLC9+
JTG5oTCqwNiYo3MGJizTv70vgdQwlBMu+x23LdYi9qQ=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=4128)
`pragma protect data_block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`pragma protect end_protected

endmodule
