//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module s_apb_reg
  import apb_pkg::*;
#(
  parameter                   N_CTRL  = 8,
  parameter                   N_STAT  = 4,
  parameter                   W_OFST  = 8,
  parameter                   R_TOTL  = (2**W_OFST)/4, // Total Reg Range
  parameter                   R_CTRL  = R_TOTL/2,
  parameter [(N_CTRL*32)-1:0] RST_VAL = '0
)(
  // APB Interface
  input               i_aclk, // Slow Clock
  input               i_arst,
  input  apb_m2s      i_apb_m2s,
  output apb_s2m      o_apb_s2m,
  // User Control Signals
  input               i_pclk, // Fast Clock
  input               i_prst,
  output [W_DATA-1:0] o_ctrl [N_CTRL],
  input  [W_DATA-1:0] i_stat [N_STAT]
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
h0uz9KOcbq49ZgpHYSRaKYlag3ia0hhYmzLyTNzwdt3xSkGYdsgcoccKQCO3uuaf
P1R0vt1835dVIYjj03pG2AEZqWDsUELC2qrHGSF0oZiRutN0cnJ+WSM/SGnbNUKI
IatjuOG1XnGlu9AXvG1Ko3iL5Vpl+SxWYODqT26nSi2g4h8PRS+Qu7CZNBUd7hHx
WkkvsNn9Of4nvkb9W5CmeDxFDUpDzgvDBJkv2OiVw8VMipEkWEYYsMFh+fv5EA8f
00K3O/SPeJKD4YVSE4Iog5oynJRnEUPKHPtBNoKlYsb93IBZv/SbLWAcNHert//I
hT/QdO7moVpgC1VqUn4FnQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
UY+IH9knj8O6J8AArACNPEy5JvufAxSDpIqqB4ibjwLWqd/8C2UA9Oduu7WVXuNi
b9SaIlqK/4H1RJtNwsjxxMZHIZeGbnVpXvosaK+XTXgs7C+7TkytwLQZqLmEG7Lt
+6llJsAX25Bmf0zKkPgUpdBeOsdTAZM5g20e2KLgSvo=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
SV+mnYXPj3ODfCTZGYXSJuygaBAQPtjhrQGQMTQqdhsP+SS8nJ1TmipLVD0UUWqQ
hUWHVrCmwOma4m5fBBqfpQWvfSkpSCuwnmbDe1W6T630qScRBJO5X8lir6iHu0Lo
hQqpiTPSQwBwAhj5KlY/9J+U9EaiCJ6V+xacpYcbTZyOAW67lnUQdYxW7RZeHTp5
0VxAOdmX+Qiql6FRTXVqFg5EOISUDPgc+9/VuuaG1YdnjZRrNrvi5rAxO3zxExRM
lEHUWH+uuqp1nNAiE56hnhIUxh38PDb8y+jj+BN+T7CwhJgZHth+SlPlZB7hG5c/
ic8Iy+wEnm+utU5sfqO/wg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
T2mmCFF0QBQ47f3lAAKR3RGZqlWVGURp4deWqLaUq60IeTRL3KBh9IYvwZi5CkAJ
jHQfh0maqIv2OJs8py+f5artBhzw/vDz7zLp2yriuYTWTY89RUg4PvbGyPdfg7Hf
ZC6yOMklsLVPnyI5Cvg8Beod5JFquiX1LgrMfhTPs3q+ylksEi1FRL+hzejBjXnB
UUWV3F5wrc10l2lnEGTS1R4lcvHlY/VfawrmDT3kYXgXVecWjxbZeTrWA5yGg9AH
ztJO2Sy7bExxNtJ9069d8+0oevRLERCjM8o8eN5wzHIisGdeGb1DHK+EXde99vgx
aVGBTqhfg/Zq7dN4oM6SrA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
w5+2DAEZbqadxc8A0cUgqK3xWZH2G6zGNQhOl5UW0yVG0u5By8k/JqHUo2FrF3JC
+nSLGCz+bcDVPjuA12upGy6QB6Xgt5E4UbHli7qYRU/yEofSmNVsxi9sU28rhqe/
K0rnL1rFwvRgN+IqMGM38Hgz29oQAisPD/Rkie0c2x0BIBujX4ZaKKPKJjt4myU4
57OufVPR6eOgNKmUMLavxzm/eOsSz8OEGF8J9Ma+8SP0ogo/dJl1jkezpEI2R0Bc
435+8vsfJuVEi7TUiUfXu6k2LuBMabDRID+nj1XyNiL3WTbIAiMzkBxY+Tw9j3WW
CGK5JDbVOBczoi5gj+nWqg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
mRp4wKWi44cCNEzr682jV1k7IgvjtSBGRWrqF8+h6OJwGhfD6uxziHYO4HMHzADW
H3Ajqa8CbEgxfMQpGW37kJdqTMcyqbJEf/j9w9h7fLu6XysVPcXUVArsplVpsmAd
FKLUHAPmcAURGYEhjlqb819j1YmGHdnJrKwNNUfFe79qp2e8ODO8lJPRSwE/aIqp
TiUiTdvYpMtzg7a6ujKNHoECiQ6QHATHAB2brBNSUkgCNZ6nZT54amuDWn746P4+
YEcTHJeV0cIGUCQvGXxnp6/j3yhIn62kkg1AOfNmyVe1xw08TOm2kFfY1rCXRNNf
45qe2ammY8qlkffpkijoDg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
TjEPqgkQIWcbHOyzYNc+31KcASBosH5kF4pdYf9ttr5lEC94tbvsualXF8SS7omi
ViRNuPuxcXVEV0i03WHeuuudbS+OSPLvvFDwBU4Dvse8mBRMTI1IGgyVppvzwJJ9
2Pv4Mbhr5UwUjqejH+bkySdIFtHdQeOKUivYqxRbtFy7T2Pt6RC9ng+UI1HcFldp
DjDQyunZIlDC1qk72S+ri65i5Nkb+ltL4Fn28QHi0yP2lU6NOKP3JfYjcgQ5Hi89
mOwdSRI+ewdcqnrm9ybYXYP60/a6uc/OgfLGIcRV8+RMj8RBCo19SZAhd5p+e9hP
Zno1THX0Z8S34YQMNWJI98sRFLqFq7dumqzp8sTH+ozpdVf34Mcc4OfN09zYLPAH
g1AbCVvyYx2woNwoJ3jHDcCdCgMrnB22nB4tGoU0qTDCUVdaPPT71HfZ6j9//xUV
PsTVHXd+IvS+x78MtpFw84OT7bG3qVo8BEZLqfZHWjrZscYMDqhOUOuAjQ49ogUF
WTeucYZ9ZuA1zUqfTpyozs3pAVmJUcupnmWqhf7pudQuJZG/3cdr6/+3eo9QnqVA
7frzOoiGJGD6ZFzLgPe+SKeR2a0Yqud9tP9uwCN6DOV/ZTrjkKIgvxiSUdt1jQzL
CEDbtt2XabXoC9UNHAICAK8qAOP67Kk3hHf843DUrb4r6boIqaLJ/P1xTLELdbFL
vReiQ+eB9feCfZnmdL7w2fbAy8Ff94/CLpahxFLurHl2cWzy9l+SsoOtrGnnJoHR
joH+Dz3fmGD/2XfmZzsbLtb+c3ry+7a870jAe0OUMCWixk3edn0b/8g74a8Y/oJo
uF5eO93HvLpozO6TcAVD/THTZwEzaOzLJ16bWw3wFoZr6fYqU88qk5nHvJAOhq7X
oMPFZKyiS/2FFFQuYfeQW220Co94ljydfswOv2yE+WNHZzJAoZW/fvr80uxS3lKN
AHDfi6dpvoESJTUWObduBXTaTCF3xRrA9GYfeEXv9teTtQw/VXykgg7wsaLD63IX
e6Z/J9gK3kpYfM1qd5UubTEeLn26gqog5IsLHQZ+qA+Nq7Qm5nYghF2vmdm619cK
qhv3egGkxkmxUjEhQrQGVgTzQ5URq0oYyyx6F5TccbUYz/3wQG9keIgol27Ebjrc
vCAseR7mIsPi53ReCKlvPuyCdQGikN7f5sM/WSPg9qvuhHeuxopQIdX0YK+O6cqm
LGTAW1TVj1AAD+bt920B8Dhc0/e6xcxJ3epVOXAJYscedLNpdFJB4/IY7250QOXo

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
LxUscUca1j6xvrFPPoouCxR7n7gFPsHriRq0LU4PdmCuyoR1iHLIaOIMJVvB0Grm
TXGIsbt/JNZjELWbkrEyZWu83pfMhtCo8rmdsZLwK1kNT1dSBw7Ta7yapfpf03bZ
WJRGEAcPeMcJ/mRYGSM7vYjbEdMF5NcsLJqQuc2X7Sw=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=4464)
`pragma protect data_block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`pragma protect end_protected

endmodule
