//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module s_apb_ram 
  import apb_pkg::*;
#(
  parameter R_CTRL    = 512,
  parameter R_TOTL    = 512,
  parameter R_WIDTH   = 32,
  localparam W_COFST  = $clog2(R_CTRL),
  localparam W_OFST   = $clog2(R_TOTL)
)(
  // APB Interface
  input                     i_aclk, // Slow Clock
  input                     i_arst,
  input  apb_m2s            i_apb_m2s,
  output apb_s2m            o_apb_s2m,
  // User Control Signals
  input                     i_pclk, // Fast Clock
  input                     i_prst,
  input  [W_COFST-1:0]      i_addr,   
  output [R_WIDTH-1:0]      o_rd_data,
  output                    o_rd_data_valid,
  input  [R_WIDTH-1:0]      i_wr_data,
  input                     i_wr_en 
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
VIYh5rhDnUQbgCwjbmXjYqtSW/xh9r/jKjjAYqA/P3cTjrmiI2QTZ+mpvJkV/Po6
qdwVIA6p0MftPeL4puo246tydrXVQsWGWzYeLU4sYaN0L8OtS6uZYSUGWbBEHVXP
HRofEG90AUblrj7uyEmRNFpShk2R2gyPwWJgcHl5U7QNLq/Gfqo01H2+q4q0S/10
9MlGaLK6/DwyJvEFhvQkk4V2lsnV23+5Kobwg6wyJ8qTk/ayqY8BiSuOo2/cirDf
alaiOVdZEuGo139YcOsdL6Bw736pvBpV1AS4r+k30n8ByGRNf93FS6a6cGx+mJrT
vGTapNarFafJJGJuVlI4Lg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
1ou4x7KLw2/uRzmDPsotDwoC7ncDNMueAoZx/M1ogiaBabKf95oWlPrSVFNc2HnO
VytzwLkKP6V5ZyCgi00biroux22DB8ai36k1zrGStjjwgpxZsD0bjCcImbvTYeo2
uNgfukNCYR5GcnBa/GMXcQstP6ah+YVKi0i26FwFO4s=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
6Qf2OMPPAzSJHEmOLdjo9zAUbSJ/MxLEapwUpBfWBNQsziu/MlNopkllo3JUthdY
rjp+L66dVJ4qpXJ1UmzhqwIoUFeWtJcLUD+Ct2FKPpjiw2uLs2RRWfclKctpYf3P
00/ECVbbiCYdf03lwskzMtuAihmgF4n2xIaGliuNLqX/Y1zpsVbrZXp0XDIxXelE
j2N3k/OdBiQ8FoZZFfmHK2OY2jU7NjaToWKJN3Zos6mw/uPTCH7lANaGrT4gtsCG
L+rE2Cwj9oYosIK49Er1EOextWRRRfb2KcMdpWPdtCY6tJgB8apfROmRqKHn5sNK
pX6+kvS94gkEz7gJHZyUZQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
GpgC/iv/C+jDbxZshijrU3/nBJYF/ogbume7J31cBxpHwJPvJmY+1yu8v/mDuVLx
ShSZHKpIWDkEGcqgagpxuH5lOUNQan5NvFEXkZH0tp5WQE0K1puDWiRuP8CldczM
unyV38fvL/wKM0O1Dxk5jVSsM8SKI7Ta7jlheuOiekf2/qaIay+xvc56AfEdIcqf
UIkT99Ii+UyaWX1MT6cti/K1zXLn2GDIfsL7ZlV2JAU6yFHhYmeJtM/xvKcLMxZl
56Pne9qAipAlOrWAxylk3FRGmrFRWECdam7Q8BgYBr69b6tQA/vwYmRKqaHr8EBb
fl8U5M/eBkTaIkFSvVYzGg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
PrvzrMLPXEG1+Ir5TRU6SFAPMtVLOwlTTPdCFtrC/bsifECDJ5gKruadW9YI0dHJ
c6E3rGDRF3ZoFM1R1A0ibJx1jkhg6sdf6UvgD2M90gvwC+i7Rp2gqfRtDWl5y/cs
f1gwqvdYmU0f+amIFKXHHpyjw4H/fsd+slzCHoOOTRD/ioOtz+iGzOAIZ4qQz5wK
kT0r54Gr5w3CIfMFYiI6g7lz20/CE2/+TM3LIMfjIhRSZIXouKuhoYJ4+fLN8jHR
f4aN+55rOK6oNQbpur/UeS0GB4v17z4B0Gq9xL0OYtvBR5Nvf5lO59zl58Uvlo86
hiTTXXYy8n6zv8+hh3bZdw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
SONFuf5ZkTGpgCTSQ4HENtt2WpX5VpnjY9jvfceulLqSvLAqwx3PQa5vfM9jCRSp
yvdXl4TCl4naV2Fa1AJkFTyIabpZvRQVxEsMYJ3z67sB22/pHFRvkNMfEpXv4Myb
ZxPAj93lOZgnLzgbpo8aYJzUITyPwOvwKcXWdVPA+Fd61GudnWhouSGCbgZQibss
MkIn+zWf7gcOI1jOpqvPbVxVUy8MmgxVpn/Kzaim4w2n9nT7r1o/2jeAjhxrIJtZ
88aqEGIwXdFoh54ayCGyA3DgX53BIHRXVMtsALa/0RSvGBNvVhQSTpWXJRQBSfAX
ZzxJrmyOXB8TicDop3SgCQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
bv+KtUZJsd1Mn09cPeGB2aFtEhp4J8ShZc41fChA4mBQq4xzOx6CFLwWwgz7wGnp
S6qWgunbblToG5LB9BGXk/nwzKPixQVjo/qGoKtvRLlR14MeXOnqRT3husGv3tZN
7UQrtGmwhRulsq6yV89XBnsDqmSaor16yJkcHa3amQSMQQPPCeW7prAtvJPxFSwc
/dl8OseQR298JITSpb9o/n6DKzsmXqhGckvxTX9zW0ZXukOtKCAGJWSlR+PxMAt3
hKE43Y0KFHqbZfmC6olfbQos8UFkP/CyoMYtdxwHyFA8smSaZKpoPqEIMPoPD66z
m4/zm6ZuIwBWqIeT2hx9DkA0K/EnKG45xklXAkvG2LfPc1Gk3WCgsmj373NjuEGr
M+ydq2j9dyv1QGYOe6mNlhhJsCGuNKMu+M8KijK65LQ6HUCewDtye+2fvjuuA9IU
b52sdBzPUGrZFlucw12f+MHCD3SWw7B9xU34dbCvoZBM7tNN9mj30bxZmwPiyexF
NFPk0+teY+ZSopb8BNXQxOCpQdCjcC0t9g2n6efUfS4Vo37OotaNSknuNauJEUPT
6gMkjL4oUD14xNUnhBw6N8Ytmr1FANm2kYtqfyFaFZc9BIQHSEPN3WfJdXGo72hd
kJKxk+ZOkPf5q7PPTrBhkr23fCUj4woB1p6+U42QCacSqtwBFBIx+XKIsJ10vidS
yz38TBDJAr3oZw/Hghuo1FtZyOrDUnlQc3BESKCjQ3FOMcVs424rkOnMtwwPiU/U
1zoJ90RcGi1hBslJje6tlT9ykuxAJFgCK3QHDM3wq9OkQ0Vn/rqdrqbLrV2Z2D/x
Z1HZ9urggsjCJHrINU1ThoDBxHSnM+rR5Bvz9B+85TnCfd7NXA+iXv4Pwj+gXsWR
JGhvNjB8jitnVhZ9bhwSLyuh1tYBhxrp8jZOfb/tboJxtYXWSSRtnLDN7P3odoVe
P74rI4LoE5ObukcVO1sbatR64DT8R6ojqJKATyN2GRf45hhiPREq4GM1kohjCmAr
FScyTzKzEAVzCNog4Qv+2W9m3Q3u356gyXshxowB+mtN2FxcY3mZ/VF9wpx1TMk1
FCnd8iNCmy6ZcMiDl5RZjAdPeT3djj90WwxL73PvrvV1jwBkKoHlW3B7tOYutTrD
yftW8+asJrHq3FKcjmVm6+HCaqgZ6o9274vtlRuJMAEDzVpjEQLWTjRwz0gWOBvz
pNPNFNEyvtxx3170XQOhXupBIdanbQbcdlG+BwzerJ7nj3l3lpEIgfPavYUcxRZL

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
Mh14vZQaZbc65jTDPSSEJ6/zkv19cU9JQ/T5CZZ039HWKnjYx/YCoG3V+o5HWbbz
IbEpPYhn8uZwpCWZDizcyH5TKifhcKvmOdddu1SRrGWStPuYjvzXTG4T8huLWRYS
BFyC1juxOurSO2i4gld4O0G2/rtp2vSORjgBMus10Ow=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=5120)
`pragma protect data_block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`pragma protect end_protected

endmodule
