//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module m_apb_reg 
  import apb_pkg::*;
#(
  parameter N_REG   = 1, // Number of registers in this sequence
  parameter N_DELAY = 0  // Number of clock cycle delay in between sequence, 1-255. 0: i_init triggered delay only
)(
  // Clock and Reset
  input               i_aclk,
  input               i_arst,
  // Register Sequence
  input  [W_DATA-1:0] i_data[N_REG],
  input  [W_ADDR-1:0] i_addr[N_REG],
  input  [ N_REG-1:0] i_wren,             
  input               i_init,
  input               i_init_en,
  output              o_done,
  output              o_ready,
  output [W_DATA-1:0] o_data[N_REG],
  output [W_ADDR-1:0] o_addr[N_REG],
  output [ N_REG-1:0] o_err,
  //
  output apb_m2s      o_apb_m2s,
  input  apb_s2m      i_apb_s2m
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
rw98exjz7L1kRFd69IbuEPpjm9/2Hzi4GtWoVDu+U4VjkJqqssBRRFHDceyPlDjL
uQrld9WH6X36VY3aIopfn9HsfomJr/SH8RjbMrbzxWnQtvx45Wn+ynxydxYTADV7
vFC4xhLMCog5QFyeMa63ek0D/ngo4mYoEEfIEO7HUx//VihCMz7xdmBNokFbEAQI
fZggMg+BndTzFe/VX+1xW/5V1ArgkLDSmT3ijpx7dwj93UA2rzy8cNsapzuUEQyy
wGiGCMTlLTMMRhZX+5L+9PmyyoPaBS4vVSPFpzWxhLm2XB5h5jgixdXAMz1LQhb5
ClTWQKayY807iVi2RiKlbQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
hwL9cF+/p2InVJQpFU+amiPFYqC3Aenl2ykLPYfyzx5sLs1sXaH/dRYagpDP08j4
j36GZSKFlvV9TfpG++JtoLls28k/kiQ0dHLfSjA/JAFZoyQ4Bb/6qNDtN+XiSL6E
6s0Uc+To7M0utuADMBOXDfDYByRviahidABHfckP8Vs=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
zGSRawd7uMPvu00SNzR2/fnkrQS/ZaE4ndASl0kz3crGM3CRsWgPsOn6xl6FNUwO
wiV4wfx6SAEUi9oWFthHNyhU99r/69D25bK/MxbTAMmG4JgzGv/rGtf2iYBmn09Z
CK8v1VaQc6LAWKXt1GgSFsjUxOtOAzQjuJDtXJg+mR4cIRWCGw4CpnLS6We8O5zD
GjsdFmpwNI94us8qIKvrtpD0XjetKYtQ1+AXbCDvjXZbmeOk9/2/SFbETpPp4jkh
N5UFlSxq5d0GdA37qkCYePJTaPQeAjJUWtq+iMA/kw8d0xwyh1uCc8cAR642RLNH
j/DDD/xJPjZDaqAPSVrYAw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
GFfd2Vw6gOMKuFGg79tR2gGrJKMinRUJLnMA+RL0nHzP/RyeFatZqQ7sgAVVeAfW
FQ1XUUtPIFpgDQ2Vb1OGGNdJvN5JH5xaBXhENXxvCzbAbWmV1jdE+EXudYLxJt7a
3hfePuZ9obIdTjYErFpDq+FNhO3/vD/tbxJ2E65GO9tuXprgCgaaSWZWUQYy1OKY
yMUt5G5oPP59VZoQxcAOAWYrJ1FpRK2EnKVw7hcpkyU0yiNUrn+071F+B9FglbsY
ntiymvF9ueBcrAFiHhl2H5FIOp3r7ap7fcV00iKIerroOZtNPXpATx68JJLmuIQK
16YqoAoiJpYMSF2jazPHiA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
17o4RU9OMb7R+jGOvzTDF4lliIj4W/XSShrzDNY5DoAJQqeZdxpXkhck4kGZAXlk
hNYER86fzbKKyp3dryjWHf77+4Bq+KeGJglNPrE5290QAY6gbRcfJH8ckgQtnzGv
iR1t7l9sKp3FXixB30oF190b5qg97+rLiXmKebvl39F/fDhlcQ3kFBAEB7O12GrZ
ClaP9VPkyZ7T/9S6J7lVEui2uQW/5489IgERYyOWZgGlYZsq8fL08DfVP/2fwQrX
9lUewIX/E/lQdvubmMHefER4YgL3F41NeTngtkOb7y9CluQPfosSIlpigbQ7zs6I
p1J2ocJ4o/cOt9RYB6e1oA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
VHDOf8G+zs7i+Kzl1ZSGwmjLLmi3hs2JLOhUTVKNzQ6xRQKCh+K45RN4PPJzgDvO
g0vwTsCe+a+9VTQtdRpKWnLln5c7dkfWTAtGEItnm0JxnGwBMpptAxdSDloVtM+N
nawQngbLVC5ZC6goWErYF9EZ2pxJSeIfTQLN507tA1UW8VMOA9MWzZsZE0NO7zQt
2MU9xY3jLb1kAZ0a0bGORrYKDWFdD4CS2+ShpNq2/UWFbxES2RZmIeZdC0OQf4Sb
9YxPkY/KzYGA9DlxMrbmvGDqRF+hPVI0F6We6aP4ckonm9QK8cWH0I+46Rai38CE
dQC0qE7YXftNa+Gbv0uSWA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
L1F10P2gGGxRuItLxu8Az6TC1RiVv0By71DhnY0u3poNW0iktbAE06AFeCxPUViK
GKMqHKPSC0nBTRxvjKuvN3KxmoY/mkbteCTvXOehmU0wCauSXx7kbBL27xYrRlvf
0dqH0Hlaq64PeX/pdFAQR5Ct7IdjT3c54OMbuK/JMNwPalgrntbtxxQ5inxzmRYS
K8oEzO9ujr1ReyKUaql95DVYL6O0zWdJqEyWEOyX1qZmmXuq4sSy4pIWxxeXIo1i
2xQ3zNUj2KprCDEKLXSvfEzUtpIrNKovIycGPFHmywLJHaOLaCp4YrD6C9LXbQU+
zzZTKEZxPB5kzGA5nzKYsbgNH2C0hTz+k+g6kETfX8BUCFpMR7T1iUkn7FvEr3f+
AvAI6hoCYC9A92mPHm4hJiMqZjwA0gCCugHtPLnGtXWitYJY4MUJ4eHDFkBGQDav
BtHpuL6LkQS6Q/30UcH2CgsrFP106TQLVQCQuVweQ6HHDYQj19qlDJtPJZWWmmhY
bpQTDVICUp+DxFg07mTOXl+XEvnVaTzAjhS+8dvyFnVwGeBue0I4mTUEKpczb4Mh
D1sbcO2kM/rHXEeH9WXEpON60sZQ8/2+Fft0EnTdvJDgESO6FUeOOJrc2RYX2nkg
+UBCPJPPGvav+/KNQEY0PijkfRoNt23j30+FMefVYNBITAtH6qeIJSq3xdcenjTp
kPvYsM+wXvhBoYbMoLjhZzNaUh+F00TsEJRoWRxpcx2G8oxDZoVzpmNuIPEZ6+/b
JZCc0E9j1dzJe6sl7Xq18pYMAm+tcA4sjrv7GRGfy9hG7r5Ww/Gz1GV62vCoHLoi
nF9dVz/54UMjuN0+V2NbYQ4Pmhjv82Efv8HE4aI04sbwtWIcVaFuk4SqACqvUAFc
er/ug5m7LNhOc0whuWaByhC8WtbQdYDum6nIrccE8MoP9vGrfOrVHJzr2cwCCOAl
jL9fAqICnGthP/6YAedaZ1wuk/9gnvoXXJGaTp3NTmBZLFVHi1bNYolJN3vKRR0Z
+pB6iX/wsu/XqSNr/oFuEGBVlXuZrb3pY9PlcpR4gbIKTive/vAdaj4slBJb8GNw
tZeSIojWLQ+vAapx3hiyIhmyXjLMEcUYWMdlpRvsEmB1BOG2kEF2364Z5CXvZgKl
S0A9mbqii4yCTQsQdCVxOWguviWt3ciXe5NDfVmOKP/DzwRmKEYXvtp5vkTHDEZF
b9ae5z+jYMgE8TcvcL1jp5AV6fiNjpyZ73qaSSS3uRkymnptPiDDL377+dpsBBQ/

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
Kmmxhq61HgbmSWRPs2Ut3AJsSbZSyHvZeHXT9J/4BGcEq1HQQ4oDaDkGeurTpaUS
OczX/ppDTnOfGL7Rg1w3Hb1eKDOFvF5q3MFVrmRrziyrBfwhVDGgibgwUxWaXFhm
PVY3IWUSWJX5VS/TRhv20O5h9Hs5yoLQ8yAAiZ3xiPY=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=3776)
`pragma protect data_block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`pragma protect end_protected

endmodule
