//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module apb_to_axi4l #(
  parameter AWIDTH = 32,
  parameter DWIDTH = 32
) (
  // Clock and Reset
  input  logic                       i_aclk,
  input  logic                       i_arst,

  // APB Interface
  input  logic                       i_apb_psel,
  input  logic                       i_apb_penable,
  input  logic  [AWIDTH-1:0]         i_apb_paddr,
  input  logic  [DWIDTH-1:0]         i_apb_pwdata,
  input  logic                       i_apb_pwrite,
  output logic                       o_apb_pready,
  output logic  [DWIDTH-1:0]         o_apb_prdata,
  output logic                       o_apb_pserr,

   //AXI4-Lite Interface
   output logic [AWIDTH-1:0]         o_axi4l_awaddr,
   output logic                      o_axi4l_awvalid,
   input  logic                      i_axi4l_awready,
   output logic [DWIDTH:0]           o_axi4l_wdata,
   output logic [DWIDTH/8-1:0]       o_axi4l_wstrb,
   output logic                      o_axi4l_wvalid,
   input  logic                      i_axi4l_wready,
   input  logic [1:0]                i_axi4l_bresp,
   input  logic                      i_axi4l_bvalid,
   output logic                      o_axi4l_bready,
   output logic [AWIDTH-1:0]         o_axi4l_araddr,
   output logic                      o_axi4l_arvalid,
   input  logic                      i_axi4l_arready,
   input  logic [DWIDTH-1:0]         i_axi4l_rdata,
   input  logic [1:0]                i_axi4l_rresp,
   input  logic                      i_axi4l_rvalid,
   output logic                      o_axi4l_rready
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
q00zDiDMW2RJsgIkDZQrQsvJyC7jt2Y5MzM2mFK2p4lwfzf57YKh0x52o/NO2vVm
lExV9OFGB+25ONB4a+Wn0twK6/mPwtX+59kJrcEPrPq7Iy4aWBcx0jbc4wjt55CP
17ua5hCPeuXu3W7c2ZLR5Pw6p81AlgVqIMPpXSqt0cqRC5vN7Hi2JYK+Ttonse5h
G98D09suCWPwl66oGp9X3HchUB5+mJjQSC0xFGiUHixgU6st90DXzeyZiBQbV7O3
n2xXYMhmLHIbaVb5fKouGfEz0PDiteaWXyicFXyNN5y57zuSnnnzuWhbHIVk1EEi
VZfpiEKdgldO3nt/ed4HZQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
e+mxrgzQQH5N+wLIbsaiBaCALo9eR8ujGoAfyfdeJ07+GR64H6KTNdLmuy2n4WIh
a6vhYoU0sd2n0Udd/g2p+GHT7kTdWuQTne/t24JCHM1uxMgoqKA4bUbg2ZOWNcz+
2TB1vtfcSuAkQ7F6OelmSwJL1m4I1Vy5wuuH9sycjlM=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
BWBVMh0uQvw8XI8d7vYuy+Z5YYFP58cufVH4TLyjx+5UBYU73iUwrigKRjmEZA19
0KNLlM2eMZsnLqOZ/Tgm4U3J8ktsJZY3M6TkoPi2z/gDPAoP0X10OaDnTc4FUH36
9iMSgvYYtS+qmcdvGtx3sGXL7ukJQ4nsYhXtPaRtSBs91M0DitbXi2foNIFqm6h4
ivr7sIz7DnAS7yToJkg+WoxfFTetwRJpxcC2kcWomrH7AYJxDQ6s7W3weOEODFLh
QOpnt2HqgQf6NZ4oARexZ51wLz2p9DiXi94Pl9rnT/qyl6ZOvQjrGO8Jxxa4R0ww
SJKHiRDLlUZKiC+EqShuzg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
AS+FuoU9KwLobEAmIUpZJbCRg+OG2inUSQgAdhmVHH/2ji2WQmv4G5Wxf9vu4DuB
VcvoZ7NjOZgAodwPgAjjScng94uqJXBjP6aR4Dx4MXWqCF2FguX+oFJG1oTzYLrC
sVOoSxsG+6JBxbQhxscZTcqLFdqzc3zKFlXV72DCRVYprxAViwEkPdP6slrXtbt5
GJBSDKs2R99Rt/q95GzaGtiJafWxKB2JLAHc08RRsgSQmPFJ8admPnTN64gEEmzw
qdTVBlIE+YoPUxS0Eaig6KNLFLwkNhSyLrJj1WabtE0+74Es8hceCLrp7h+tmYZC
D152H50JuqLl8Lt6qqPzmQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
TMUg3lYCWdtQv6RQiVISrA8cx5MK7Yzn7r54NbICj78VxmiwgBkd8i8+qlfB8MEo
PPuBI/msB83WAK+cYkICQAR+TY5hx9rinwpfeYACdSjNGZkygqJFc8uLqYPN6lBR
yepCp62SypHVv0fLhhVeMnPHPK0GjeJTKKGFQTCS6fubt67lcaF1egaHWkKK9eaD
erDwjFgH74dH8NKta3YUVTY+dGA3oc/T5mciM3TIxd2h5l6yryRuNAnz/DDc5J3V
JdHguw+JMnLm5bD8DXC36nFlJMSFi13no88FoBIjlJgOMau/IV2MdWfy6vQFhwjW
8wKkxhvXf5lj+/zW7U1ueA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
YzaW1JN1PXm7uxMD+mRJXBA8sYD8u9qs0rRUlvgKFi9Qu6KvfX7Tiyoz86SUQ79X
hOcVesQuQVKGLLFH0bt/0iSJZvyL9z4EWkKgBQvLos5XBZlL3cgM/FwtIhirJo2A
ujISR85T2/ztPMTpm9byVHLQfqOEGYBAhqUZjTqbsvOTTgNE/ZqUhYHgHxCvktbf
liN3C3RqTmYJeCTyj3snDo50avwHfZLjBrVXwV9afyDhhwqIIR6ELHXcch+eNvgX
Tyap8oQ2HnGg77zbBqtyiZMiivnXBVg9Ik7kEypjM/Vd5ro3HlHfR6Jc7piW+WWM
i1ayPEzsodWqVmVcqKTNSg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
eeSAi8fIWOzZyTrqoHzabqUIlyzi7K+JNP7cn576cPii38xfNJv8s+GgAq4XQTEs
mxira7FIg3eArjj7xmfHbFtN3qgec3HtOCo2XlsdUSKHpkqINa1vFSBv/9JIMmpO
c/ONKNDrcMeY3PCnJPcfE0L4L6BXrY+T0T/yGYd5pUX6TW/ZRSbz6ZsWGBir9E6Q
cn0kChhidp3u6fuPJfMIKWjWIJ+xupPHwag55fQt38MPr/LIv1L4mMKl6yVQggDp
N0YiknChdS03Y5mjOlC0cHfa9kym59U8DOP2+nfCfdv5g3yu21QkNKtTI3nyFyNZ
QELNpFQp3+xcK7T/Qdn3GvP3B6Bj/rQdY2pXThbgyhXyaz64/f71csuomjlHP5bs
anJqWc0cy8Ab0dv88j3We++Y8qwBsdGRM9uiAvncMiQ05LVr77ybXW/u4+4l9dma
7/EdzK+pGT5jlPo4yK8LxAmFoxfFDydlgfVUmaT97tQDxtwUDMg6O7fcS6tVi46X
Ta1sYJ8YDld+MV1f7hH2iMBtxleKgzPq4s7MxSBNp1HRbLooou+C3y1cIFVV0E4Q
2Lfn/a9U286L+Ygjrk++Sm+/R2uKyR92lLkEQv705jdEy50pP62qiWwJ+hJYwCbF
/4PRWBGjl+j35pnJLLbLJM+q0yB9FxlzNGiOssg3JF7hoiaLzugOVrdhm74uh/ma
cYLuh37RjrKctk48gc4D2XkGqMyzp3S0QFl1X3zgc/caWrzYuyox1sESuwzVda2C
QzIqhSBUz/UCzRsKFoo+mRxwY+HHCel5ljvXH7Dp13RpQqCrVnsytxQdg48VAqLQ
DCk8UTcY+RafbCc+VIRanlO8mn/X5+4CcyDz/RQ58WaWcgqgmkBLJ11+t1axb0ff
+nBabQXdBkxZ07m5b1z9LTsIt+FfsYs5xTR2YrgXV3jztNuE20i76xkP/1Er0vZH
MxvI8aSUHQjb7SHONDmdrB2RJgXs46Z22SxPyfEXeK/ph1tLorVM05J+TOxJwSLQ
G6TL7pecxAxmHY/LGbZ8Ohhgba5lRvHORqOCgRwSMdD0ZujJ3NgyvZ6V6GVtZKMo
tpaTi4ZD0zSLASrQdPLCoSCgnh6Sy0YRX5uSFytkKzEWtntH+kAaTMhY7tKCrYEP
QWRh5UuBYgNCfMi4C13ZgMVlrPqSAYsVXpI6pKkoDSZnF2TGz07FRtNii516YM9Y
BpgraEen7IgLEE1jfQiKOVtXQ1Zr9H6FzWD08dWyGXE34J1roRfzHK6JieFelaUV

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
gPcOoilUCiQ+flcQwJKSXXPQsbhY81FTCSV0dY4ydprevYcx+CetOE23ooin7/2i
wxag/eQT60eku7nhyRWy2m9kaTeLBrM1fP57z2JVU8pYtPeL9fFMGMhYsfPpnuhV
LWiUH67B6C9vG6U6Qcohif2VFMJ9PsRP4NTs7elo+RI=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=2560)
`pragma protect data_block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`pragma protect end_protected

endmodule