//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module apb_ff
  import apb_pkg::*;
(
  // APB Interface
  input               i_aclk,
  input               i_arst,
  input  apb_m2s      i_apb_m2s,
  output apb_m2s      o_apb_m2s,
  input  apb_s2m      i_apb_s2m,
  output apb_s2m      o_apb_s2m
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
oax7oJvJtgTQSJz/QmgLiwW2C9jWyKwBYGZ4+Mk1D9wxR3BW1QZNV9XOKVoO8aD8
dw5sHDnd2dzgcd9to3VLHEQnkZG1sDY0VifG6Att0H3epA3YvLRqlSoNJ0j76EhD
R5vBiaAlk824jxE3Jebg//1oUy3dukghysoxD4vlAYy3WVQPyfzH8hJ3z/6onSvx
6Zadc+8FGoOBEdD4VvqY+alUOFEX5u+KQ+iUbA/E4J03+V49V3hHa2fGkp9Vpx16
R50ab9UaIw9LqqGi6/ZcLgcDxVok6Lsdo95RBESQ8EOP7wKBEpXXFhExJKmDbpEz
TlTPy94Fh5YP5y8yGpcnrQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
Gzrnp8V6BK5xcz9bqVfTjxzasCCW7IYy16fTM8TEK5XZe4SOwWxECRFQxjJNdelR
F7u49kvST9veYfdQS5qET/uoUwrHohWad9Uoc4v183UkiYzoAyhG1RgpPlano2Ae
uA3+lZdpopA6ngIOGnY+V+YTWfWDeGasMoc0e9hLkdU=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
0mPRFASFsJr7Ifi499E2QeTQonVy4To5dbKhntUyJRqi01g6+nxbgQ6rOy+PO1ye
73UzA/j3ULGYhc7JygCimQx4yU6qWFIbFnO2JIQhm0ucqbLK9cXGFOtPh9QZwE4p
tO776zrVlJ6oqPiB+wFDyt2483VmRrSTGr3mwx1SeMgexUquQ8OAtKpu9YBzPk3M
wVycpFfkFtoeefTugwpUWS1JqVSr1sOj5xgT18gxTjVvApI4APbkdXR7aM+FEcwZ
atf+in+YTxFisF7i/9emcNbYBUl5JrKNi1f3lyNikxww0h62tNPJnDXRGTeubiM6
2I758rZWGkfuaipQUjkk6g==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
fwDRKpesXVWH+LCT5qy+jEe1rN04kupUX1WhfxfLCclhwrhaKiPCRmKDH7a5j93L
9LnT6I4MC2xhyVN0llJ/lQoe5CbTZRYMkEEc1o6ThUMh8Wlo92YyD9lmzh4/CpSJ
CjTLwP49wExi8sBy5ZFqpQOnWDxbWcRlsAp0lx+LYJe9Mp6DRvfFIEEbiHfLU8hU
y5vcxmrAVht+Uz3KIkiEL4iHFbp5MvFN5QCero1UkNFXLjke7KpuqEMDxhtuCx0D
Hd/QftLUZT56g9auEJdQ1/8U++dIei0A7IZOjSMRycKfA5HhVKD9Wn0FDsvY0UaU
IrjwFqDy+RLiefItKRzIoQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
2DgGeIN0kyjQq2Qp1d4RHvf7eYGOvOzbz4O2m+NOP/xW1NbeNVIGmdkraxQG2nue
2oDinUXEFejVa3cSx8PTzJEU7XhA/EqBX9SeIvYfzoqDkif+SBlsT4X3WBw5n/TK
f7AsD1b5clMOrZHNhPiWAl1zePxV258r7ef/GrjEetW8fu+isBY/Bf1iAWp2udUF
WlMuMP5TJmlxD1EzLVVk+qU8hK0HEQcTvNt/4pqEo1GsbAPgjGXL7ivg3iWRon3U
gZ8K9s4YuEBV91FzHDMEPrUTNq4I5+54TEGcc5nBsRDdgRGYfKsgj88Myhe5FfTd
4WB1wFDn9o71h5ybFn69xg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
Gx1W6ZYllZD8yvKDhPK+K7Nf4Vks9NjGKLiORWG24pnFE2LQUYuFXhxcjGeEhXPq
wONC4HBNilM6vyXcFQzn8rT4t5bgOKo8Eiw+4c1uK4/RNtLSKLBfVt8QU/HLQulS
PDa+74aicmvonF/h54VHYpCDBlBHruc8NMB4KoIk769QPTkpYr/NParZVswMJJzn
klj2ZvrNvIeS1H3UaZgzjM23byvCTBrIYSWU+ymh7xx/ZYO3XT7B6FJSHVLjKpdV
95tEDiR506ue/N2DFd3Vw1Gvh7b4Y6yKtKzI9Dgm2b8+b0vOX/g0neK7MPpg+7hv
6aadBVY/6SnjLHU05zae7Q==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
NL1Y3FcEZNF6kzpUf5k6Q8DK7htZTrzJiM5VWLv4xlABPQd5OmYW+co3qWns/X4Q
nPh5uD8px8ds8KjnLeIMZ4W/1CEBqQ0iEOV/U0sNj1wToxFlYiiSEEVYW0G+jMtH
IE3sukJ+qozRyUgkPOROLxVPZEGf1VU+FaAJS/QtAJd+Y1U4DaN0+rsgQhtmxsZC
wRgY6A72DRW4xkWNknHFuywTn1P/6NvDlevt++xdlb5b8npGKYeagXXFCAhcVfkl
0K34X3Oo3cxCgy9LUXggyNHRIrjXCn1EoyhpHBnzT6Bs4H/Rpe8MOrxr4ZkfLwT3
fzh5Jz013cHLytFvTYzT8D+btAyaYPRiSQMuulyFEC+GGLxxa6LQS+fowBQlpULD
heN0Zo+PaG440l6eCAA61KG+8Oki7OKR4wrdN6E8M1HzOxoM2p1+Yxb/xqUo9/1I
6TPykZhJl7xgd+H04Of728+3vYjdDtP+PfLBHjNh/SzfH3ZRaeDF81Z8cfq3cGMz
N64gR3UsRkrmdtCORrI1IlN1rMOBdoH9bvmbQYiG8V+99RQ/eOVyvu241KMrrdRu
E0ssvrE+7afq0GGatAH6ui2FgLPEoZxCqNWeRXtiwJucCuccPMuOQHO83vmVpt9d
IARfbCH8icyfoDjzqpp18zaPAKcumkLpUvoVrHSUq8u+aGTyZGaKR5ooCWev8eRc
VI9YD/AMSPc6so5CzQlG8tscrL55cCTGuiCtoSqVHIk9L6L0Ueaqoi60G3iFRbYH
AErjXxkpp12Y17DYsxDtzlEbQyvE5N9R+zXdUtbcSaDc7qEu9FNpPIG08iRizw8q
RaTpv2FjkBpHZ/SMDdfrK0yKjwS+b0B6mVlUHRM9aXa7LzE7mRDGItJMF95U1Ul8
Ktg0+RAAmT/dZWpY+d7hKcP09lffI+zCakQwM1W/H2bkgDFImagWuXNscy6IXYM3
PAJPNfkmJ8ZrJiPZFyQXtR2vg/h/dT/U4JtYn9t2/NMEXzaTdiDzJfnF2k0X0cpy
BCiE9VveCFSfv0NQtxgM9FghiFTn904pIbRsqyMSjsC0sqkVyO4qwR5ZRVRk0t4N
EDK2fsr3IKH7jhOLIkQfSySbaNaU8acHhKqzvaBnBT0i8VXYOs+FDOBgI9xfq5Zt
JHhblbOXomSuLwSnVqk2h/mhSWAAi7ky0l2LDDLYbUS7yjGywenLq9gnZ/fNUPb/
41WSAX4SWkbin2PWIdSbxs7ANOEPvzRFypkHjFn5PF8bWR7CPmFv5HDoqdGcDASU

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
mvUlsZVTYQ94FNroxL5Bz0YC1NlBj6HIyBibQqUDk75SvXZ4l/0fNHoIB6QOOSIC
GDeXrMYnRmNx72irU4FofUSMyAcz6Y+EyNHbqRXTivzjyWqSy4OU+GwM4gG/CnIH
lYlsH1VvT51acEILvO4/3G5S8pClsbkc3hv0mXgnW8s=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=736)
`pragma protect data_block
qNps1CYZIr/woKE1ZE7RMMpDJ4jjbY7gY0byxXqNWj3T4iMX34NfHi69ITRE43/Y
BPEu2sHi5RLM/qsRTS6tZypyqYQU4JzcZH9uAZfCreNfAWK3ehBoig4EImvrg3uU
tI3fX0aAXD75FV/cFgFm8JEpNedGKPOFu7phFmctMlMpFQEB1Bx+S/+V6ZVelZ+/
tijOkfJmplS0JsBNyCa8BfuVPNO1XtKTaqnKSjnKIajNipCPjrI4iup/ekivPqtb
TJdIp3NSkXonNrzWA3v7cBKo8+c3pLzMMMIaRasWWmdZDHW18v423cC8TF4Kn9cE
XqhgcRC6jVd+Bu823d6BzdHp1X8c3ysz+pDPSDGc9aE9OeMpYHpy+OpIY10l6EWv
FynGmkWps4ui7Vf5HUNPL6zq+Ak9VyvOi5Jpz+ApaqqmHVhVvpW2taDS55Jkarql
/rcMLeYlQLCzlHufktBeEo1egkREuyCZtS4ize2axazVAlDb1uWR1IOu+cZ9YBrh
0XOzWcbS8qk7QwJlTLSonl/6YbWzZgcum2CBuX9TGTkKN3wJQA9/MdzeKhMvl9hu
KX28HZ1RbGTpH6hzwPxhgRNUdEEtUhVN+SoypOBv+2YgxKUiky24HQbgox+N2k8r
H4JL57nsqdpre8W3HZnxIsidi9IB1piFQTMwmaMw9dcgoMgXHNTOGgR6torW+vab
D9HjfqNQpVH1PtPrz+EjzrSB+Pe6V5nnI2V1Sc/UqoctsxvymPlaIdPMtMVo/U5Q
efuKHeJqaQAFJrC4piJEFYiRDdSSI0ehLLHrcNzNVLWS2L1NloKlGgYR2osSOyp7
R8P4gx7hoe15+/luPOkZcfgh0VAsNPbRa075bjTO/5VXA6aBBKqCIu6z+xkv9WGh
HhdQ++tXjTPbzSxgMHMua/ovm5AlIAI6wCGsUZTUTPr7zziNrMptvbirjEdeMIOn
TMBKvvIM7BR2A7MZHPrBQA==

`pragma protect end_protected

endmodule
