//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module apb_adapter
  import apb_pkg::*;
#(
  parameter NUM_INST = 2,
  parameter W_OFSET  = 9
)(
  input                                               i_aclk  , 
  input                                               i_arst_n,
  
  //Peripheral Data Bus address interface
  output                                              o_wren      ,
  output  [31:0]                                      o_addr      ,
  output  [31:0]                                      o_dout      ,
  output                                              o_sel       ,
  input                                               i_rdval     ,
  input [31:0]                                        i_din       ,
  input                                               i_addr_chk  ,
  input                                               i_err       ,
  
  // APB interface
  input  apb_m2s                                      i_apb_m2s,
  output apb_s2m                                      o_apb_s2m
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
BkjtkgIkm7fcSqThDeJ4IXHqKPXS20QjCoHzNhdFarfVJI9ZWOwbbxZtCvcXDcOm
R6TaiFP1p07EbgDQWO4X+QuDOu3u/37JTqC3IVlrg0sGu7+cCKfEJW8yd1b9o7ss
nXIE0IM1aKip0SYtQPmWAp2wXRFuJbE35dG3ASrTCfzezbn2iJWSLhuFEj36XKOw
tXqX16qxZSdnj0rbFRz3lkeWkYShTCj5FlKtVcmgAaJJtNN/ovJejMO3AH2PQ3Zx
TB3bAJnDzb/o0de68I6ML2goPeN4lN9Zsx8V6r2cKjwXGbrJyJr+/U8tydDtWzHm
uqKTT5K3bj4x1xirQ6sd0Q==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
MKaJwnqI2AHvv5U2SVTw22X6cw/RmmV0EYoWW7CpQutmywPO4zf82NTWama6lHcx
QUW+5edb9MxwBZnh6csHA0uOKSqrHPn8sOAnLJOCMW8OCrEwXdUhpMJMFlNmMqS3
35dpyotm+S+WeXER+4VZohmEP8LwDmjo7mZ33WgOaaI=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
jiWqquxeb2nNaxEu3xb1nE+M5VErANFUlBJ9K0eJZ1XTsPhzskOtkVEmCgKZWkiT
jJASUVI2U2gsvOuu1Ux9xUYz2c4rNefVeVbLV+pe0aPvibxzuR0r/BoVZ1mw2Kke
7cr4sY4edFOIo35RX7yjG7GlIfQrujC/ILKluLx0EaEI+x7cEO9ARZcTVYysE3I0
m5T7dYwxfYCDgFNG5fZBDlQy6Y3ny/Vapa7+dLpfDYvkoLmdR+P1tH2kqXZoqHdx
9i1eghU+3YJxC/nZeiE/OthhHAhNwmmIfTQlwL4P7JTfl6Kn86YaCVExWlatdNkq
rlonDQT1Wammc+/qKzUJYA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
Bmt8k5KdnvPPJjqEffnIhzLKLzIrm03n84VAVOs2thnpfzuRfw4T9KlQHoJv683N
qIj2Urv3iOeSTywumc2x6UQbk0XAu1sTR8I3gQfuYkxm0VgxCrn1gNtoTREtVIcU
hZ0XjsOiUYu9lQu4HusxPdj7cMmlHcqoP5P6HUSKd9tJJ1ahDYKnGYHTZ1zzxzsv
ds86EgdWFgbD1M0hiV64lDVViVE5xro5DsnHsG7GDBHuLC4kiYNoi30EjDv9l9R4
s/rHKpK+MbFVCBhy+gbq7+oMHIuz/A9WCS6HGL+VoIC3+fCgXEbVyjL8AMylvmhH
9+ohDp07Bnj/lo3o3oyvuQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
TUj643bd5iKBlxp0hjSg1n+vxfIhEHh/Zuy5gfdioBnGnAf0xmSefYDzjwhR3v54
A57cdv3IAoCLPgCfFmP7puCtKeGpo0npQziqYxsUqnlqgpIWCg9fFCWTGhg0rZzH
EN+rHmG/MlJc0JP31hPgw1KdrYgJfD2Pyl8dxgOxsDCUr38mGwejuxJsktqz2kAF
MMWs/XglwuVNu5sJvrFroXDXgTQACvecwCWOdjfOhkADuj/06wUVyVZsHz0/BVdO
5qJ397aVgP+05z8Ns9/ypvuyFtIRcfOztnCptQD0bC+KocC/4n2QQpqVl8JUL8C0
VHg639JJn7znRV1lIoFxvw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
MuT06QOGkCGRXDKZfr4fdaMKdKWq4XtNu3tb+YBxHs3TbeoivE15CCBDTpxenqES
QRuVg56n6Ynt8pbFIrKltCC9l8e0F/JEcqncdrIdY4dKhhsG6Gb96hRG9gR5w4bo
qJyUjJ9f9C9yTvCGVtLd2hxECGach0O537ktUqcu7uT8ot+7qk+XaTIeOBg1tvz4
NBICq5s3rd+Ys09RoSbbAVfr0RKHRIr1RBkLx4gKn+7nJKreWKWiLi9d31/i2KpO
zFavZAyc1L1z/MFQ4WBSePZWBjqnkEJrOqWAiwExooQWK+1VjoXD9DxYHFMUiE5M
vOykgkgr/3gGzzG36h8afQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
pOMv1vRLyom74KufOFYALp3U5oLz9MZjxj4YpSq1R0fIPKmCT1E56wGzl8L0A4nS
C3hInrcad4+XvsUWz4UN2XCvhkMi2wmISJi+7xZ12hv3UAjH+QfbOwxmkqwVsIzx
vJiwUaW6HCFeTaIligvhMdGPlbrmsVpwCnrrzMaNfcpFin8pyMJHMxxLptwDBHXD
IO5+KoD2dNqDqDpSfeWif9+mneR0Akm9WmUGfnSwUs5+f+B8lickLIyUebBB7JsE
OlI2GrcuNUVpvvOAHisOknHU6y4B4pzKjEPEfIMS5jG/ZCbXi1E1h0SAZhw7kymv
oF5etDKiQDW71UHaMQb/ZL5UO9MNAGgFtWG1HJCp7q89yjxEGLpVAPPgJidbSM1K
GTf0VgtaM4iQ9Q8XvlZVxi+JEsFoFyiHacxiywfD/hbqaG1yLjT3an0Ss890M+Zu
mLoinon1zF+2IEau6x1DqY64WTrsJXA0PxKivzbAKasflzPZsuXUUK5lYaYWiFuK
h/paG5oGcV5sakeae20ymDgNz9V9UfGkss2rn9w4wsS5WgVX44vHSOHr38f618e5
VEpANZCbEUfuLbV/HXj/6gjs07ZdwUYWE7NYUJbbb1YDfIuxzC2vqzrw8vygr3v1
nL19scSfJ2ZnfSk0jgRkGbjZvPV4uTlEw5xhiJfhTV6kJotpbBpXk4PH8Z3d6/EN
+8w5WU4a67BaweQyHz/CHmkzCm61KqihiY+FPZgpKZDdYNWFkNSM9PprR9Tu3h7u
iRMhluh9eGm1KGLb1fmBpbraWiRmTbkE3ikLapJpSG8JlimnGj9r7ay3r4M5P6x8
0JvKbi5eQJC2ZN1XPacXvvh3VdfWF9hnPLPQAXCVsbFWOv3n5j6LdhTz58lLx4y4
MSOnYePUYe9ka3VoLbD2PC1An3sE+Rn/5OjWcSruas6P2zgDl2fnfDi1DLKijs3u
wQ3ywCWTngK/08SCN1PbJlNMjtG+8DP/FAVqYnFjSjKKt3HJYAkvRXNf+Yn1j1fG
TM4LnAiPCOfL965Q4WlL6yp95j5t6tLB8NaMAiAjQVjrfhY0z0EBrh0QvEXOjoHZ
eJB8yBLS7ay/PgVpAO9VrftNxLofVJyFqnlvZP0phbXMqd6TxVno/7AQmREOh3sF
M3vbvzbkI2oRgcRVrg3l1ES34XONlz4RA5th4eAECuk1dCuT5lRAZlaczOPPOrcg
xlmlg+f3OGT8fZdnaNT/uxscZERfQEfZrL2bXqAOhml+KjmmpGzAYLM1ATQzKh08

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
HqMNQu7HrDJcu89y5nixDY9aE0YNhzTyoucbXexF7jC8lqQgRTu44sSzxUa5sis4
L9LxWkpLVu7vGmu5mOCLlVcpdawKFlGpMaiDWT5HEMUn9bi0D/Awt2Fw6XqdjnNh
CErtFQ8xZ46JVpG3I/vzsUY68W6dXwSl1Wacfl5TBpg=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=1792)
`pragma protect data_block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`pragma protect end_protected

endmodule
