//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module FPGA_i2c_apb
  import apb_pkg::*;
  import regmap_pkg::*;
#(
  parameter NUM_INST  = 1,
  parameter W_OFSET   = 8,
  parameter RAM_DEPTH = 128
)(

  input                         cmd_clk,
  input                         cmd_rst_n,
  // I2C
  input                         i_scl,
  input                         i_sda,
  output                        o_scl,
  output                        o_sda,
  output                        o_i2c_busy,
  output [$clog2(NUM_INST)-1:0] o_i2c_bus_en,
  
  // ptp time
  input   [47:0]                ptp_sec,
  input   [31:0]                ptp_nanosec,

  // APB interface
  input  apb_m2s        i_apb_m2s,
  output apb_s2m        o_apb_s2m
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
dgsxFNhaOoEVe0MaFyzdp/FHw/ncyUk7a3QRT4zy7iJpf6sirf2ziphQlLfJ2o+8
mFTV6IyIHe3Hq0VjU4a1aKwN9hd3C/csdqexOuSlfcn217joOzIFy5+NXtRAj+y9
KxWANGbplVQPfSWPPEAIpcXpXnKQqAD/H3jSKESXtasLnLpn6GqqqVtIycm6l/5o
Uj3KUcL4ksfqxdKyDR557w7mQHaXwP4viOKHjChlxkgZ840NUYuDvmHC7fcuvK04
vV8SYlwo5M62M/X3103NcPByxbtzQ9wdY1IX2bH1ssWNpOCxsTvhKvHzQMbEiNN8
sSqCrt9YxQAhhGpIjJejTQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
urMDrQtDlSfJu8au20/+QXFGip0+gGddFqyTZpbfScA9z5/iGfR9Y+2qW4uW69Tl
CqkH8Kq2QoHchh2fWy1y7DVWwxy0ufEOrHGTvlYHu721WzVd0w2bG7lF1cyQQQmf
5YrhY7CbkOStqb4B0K5Gt4JZluvnCLjkT4F+JWW1/SE=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
vj9Hei9WTphbReJp0wU4BN93Bi6MsHHOP2jWMO2klPRIpuUhbfQXco3g336rfuK5
e/1P/9ZcWMErtP6jgsCX/AftxVyP1pYqNVN6sEHZPeX5alM4SPrcTF1UFCYwAT3L
RM5j01xlrCKKCtCLoes+tO2XjwJzRaYISzCLeOxPsnHz6rr/EjtNnpYqg2kmHpQ3
yNSUcGHAO6pmGt4Ee2VbEolMeTEbnswrz2l9OLTFZyhGXSy70WU75dANQo//4P3Q
VGQsyRpM0ILJqhwWpiPbmfk9Q/ZUyl1n80hooggsEZNOPKpx5/Z4XmXkk532QKfr
G4XIiDcr1XhaE4pFkVK/dw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
Pq+8ApiJo55DAT4TOnBuWQenfulPhbMZj0FqC+F2zCN6DvlXckCn+ANUstWMmg9m
87uD4hExOzdDHiP53Wiyur4LquZ7eTUBnRXq06The02Cqd7nxzUO2ZT8X8ZX6YTW
Dt1LCatQBNuczARfQsTM01Xau0iywwvJ9l8qqThu5+sju8pcTm/nX2euIM99WpHH
7mCPGsYqi2fUwLVL8SMF4sFcVqPMkCrinVGc8Y6JqS1BZBQyHoZTh0HOo6vVe4mJ
p1snuwhQXuOMzVB8Y95B3KpsDpk0gnlDkDcKYMyg9i8UbRUXihkpL3YymCrtcNAD
mr7WdxMUK9sv5xMdypC3yg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
f2fzzr68Ai9ta/gEBCptnbkRxW9Emgg/qtKco8dTaaQTp7DZJZCOnbWdZUv2jCFi
GV2pG9dL2AWrrNWhBysWwbuEU2tfdvkVsfESv7BX9NM05R0+wz/MRpoB/a4KfENe
kLbB7cES39l20K2RzJfaVMrOcYRUuX3Tj2FFAEcPFZ5YXfQ7YCLX10W+wbQLo0PA
b4dOBVi3rg7ocLxemAr31oghRqE+R8ppDOznwCglz4YVbCttR0om3egIoLcZ0K/M
ywjpuO3ys/bkfUwq8RMp4hlsOZZVXNP663YRLhc5hzVcYSg8SmFKZaO3mmHA2jhG
Iv46mg7SgGuA824uEw905g==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
f8rHMnVUH4mko/X5Kdq9tO6ewnr2vxHIJ0YaafxIMzKXzp8DNDJPBUVp2ES2w6Iw
Y367bp8yCIFWqj1Cez34f+BbcKap8aIO+h6Z8f9OCjd0DQUBogndhBQulPeM2Bo2
oeJ+MZddhBOyBlq2WKbRMU2QMcFgPmDWf694SHXLygWC6EiaQzC71Z+yK6EDls+W
6jNABYnp3c1aMRHuiFeBeMjM/5Z8tqSBW5pCBYDwFonYNNZpQrb7zEw1r3n7n07I
ZihgPUABGQZ1ptxKCjcD/vM7x0QmHRyJwB9+n9vB9Saxds7IA4ayGSsCLsjg0YpI
mmYr/ehZAABQOlvkz9C4yA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
WT6ou5rLr8b5XEw1vJVNiTV4VF+0rp7LbS/Jkbbjd8/4AYTDw+A3NefHV3x6uftV
MI9IDubLFae80vAzz5movCq8gDuexPUT1xl1NnzYPaSdFEXNgYVu6Lt/NywxcxNz
oCHy3yT/t+H3LMgHI4PCqVxO56wL5Y1anH2/Rj7HtUiHqs7+7iMIVaUwT0uyDqec
Xhegm0W5qFIe+bujK1hBaUvAqEWzRHi5XXD6EOuRFnW4o0JLJoyT6v1Hp2oUl0yi
mzUMamfj4m5lC48DocpIDvzeinyLxI9oneTbRd3wkpcSvj0prXuqLjWTDk0F4Jez
HejXAHAGN7oFDJ6DglhYCID1ML7xNcwprNA8aA856iMYJzP4we3eFVbjbREyHe5a
eEZS7PpQ4yJ7YAtO9H8qMnW//ERFJfA8cEnMgzBdrh5+w+pni6wVDAmib7Xigx3e
tNo78419Mc1xzRDeV17Yn4ZPAv05mjkhSj293raSqABZmKVa2dwhaOWlRhU7qdDs
gaYcg0tGBo9kLTYKMQ7QCTvyfKsVHupt4TSwBR+eDayxS65Gf/AFpTwXh4sSkL4C
RvUPnFvxUcKtGaYJ2oFsM7jBOy1+iAgR9QWiL71BOlrpcTLEAiYfDLhafe/KEoQt
2NT3PRatGqLk3tYKSxOY1vk5Xp+KXkDv+2S9LECu+3XSeRD8bw+oPyT09cljEx9n
L1RPEpDDJmua6ud7laNyimHe2Lft3ZldD7SyGRDBoEGw51gsGC0mUvnqQfjcv82O
4tyd4l1pBag56vxPUwJrPuYT0detvStoLeVLTo0U9WSGzWsomUFc3CL+XsJlMBow
A3UGl6GeIxBZZe7z1KSQLHCsN/U1IMXDUKPOiXX347UDjZMguDW8anvva5t/yQsX
yEyVU64k+rPY3Up+LdlY1OeuJd9KWkPTIS/Ns4OcQ6EhR4q4h0Lm5DrLFbxHzLxL
0fvwA9wEc4Rrt19x93NsEUg5eFXTe/rBW+XFO+KLjmBLkkJYwV7wnXCYC3UMXtWf
aw5IYl+irCtb0lP8vk2z0rQ8wy2frzSEYQKiVJ3rhkAdzzDrlip0JGPEhSDZN/2Q
7+uGMjx6TZdXZp9yAfHHLW5P7q5QBYJCfy4pIPs38xE+uds+tkWWJg2tQx2ml9Mp
K4t1lnyqLz0MLPIBmLhpw+sLMZGsSa94lW76UTQqLazvWsGA7jVh9PGiETrklQIu
MDDth12hmZymSi/ORVHa/hFkdLM90fiDKgWkedq77zmuAOG8O6G6/0Zh3X+DEiqp

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
NqErwGr7WIvmRv+Ski6sVZQeuQe/vptFE78OjKCl0MeD+jEi9QMhZFXssSCwsZdN
N7wEg6cbg0rp33fjsK5s2bEaB76PW+rOcrtqudade3A/kE4BMEOwr1HX0AtxgDzN
HzMCwl2YkYGYD6/0MUBdkJViQP7vkSmYm/v9l+MNMjg=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=4912)
`pragma protect data_block
5VbVIxhDqGbHOP23qZRi0ALkEVhnwQxZhFY0yaLRZhPqXljpUP0M9U54SXceaE8k
gmq6u9B+iqjqm0H+e+CWGLRJefHESmpNXWX9ph4C07y4ijJDznQwaeLACORj2bFB
HTu/QWJ4zYXtCF+YfU1CNkw1cxVMGLPsykkvvBRXeA2cq+la2ZtLd0LNpsG3UxP3
8sW7+sZ77f39lGA1ONW3bC3at5tr3TkIlEUxQ1XjtSd5ETZgq6G1D4hnFxuy2V+4
/Zf9dOS3dAwbIqSj3aSXnH50e5i3mpRqSxIPkK/wART7B56aL+1zJ+2nv5yGPRxg
Lp6InBVpYD4P1jDlC5x/REw52kXE2EHd6aRZ0OaoSNidLejpcHlYMpTjkCTtgfgi
p0ZDBT7b9GaHBeiM1klahd5lS+QiEI0l7YJnZ1YxSS0Mlgu1/bjQAShcXyi+6/2Y
qhup9Iopviag2PRt/H9wNLDAsorA5CuhOQiHjXmcMsoq1IeAuVeop5ugAoAWA21a
JQL+9Ays5HGre2XdjsWev/JiIc32feRDakcMUql103hqXktOJ0FWJ8OgUPrkUStm
kwbl5PRaq4QGra3i3yuSeluNfdOFeqTp17ZPqYqiQ0siWjDgQ5C/PFTBuEjotGKz
ywnWKLSeLOzmy8/Z4uvqESFkpHAvjGVOOKEoYdCOSwMeBicqM72TIdmox5eOiLpu
Q0Cd6CvZKuviyuDIbQIyGNpZABYlJtr6SpYNFrcRnVQzletlsxnE/Pf8uZJNG3lp
RUHwXUuIdw6ymtnOlCJXoJe9CR4KRGhkEYOUOaH0uoCPXkWJm2pSkxNu5W1ITp4+
qSAWwqE499Le/8VhetQamTvVB97L1ujO3QCVYvRI5NWSAVLHSUMF8po+vgD4XThH
wqvExF7lx44JeYRYYaz6YXcPE9f0TIe34GXyFy9nMm7BXU4c3zQLjya1PtlexY/p
FVcqe/4Dr9NdTUwza72oyOmqe2Fyzi3smTipt7TEu8eLPyBsmhl8lBw+HJhTMc9Z
v8MNx+U2YuMHyIOSPHd9mDIpS2IQ/8YJk/IgdXuRqfpVuXv5nW9VvFXKh7tu552Z
ZlIEzi7dmU+9xCw4LSd/m4vMHgBmRPSIgxZ3DPSmBLdb63BpOkgCi5SBcrFhgKFO
XFIPTcd3rJUBMpbEzf5xf1Mm1rtuy2HT952TuzKFQM5mnSUdcT+rRv3P4FeWDRIh
gOwaAYvMnI/YgDHilKk36d+RDnk0J5tzRUFOicbqSVMqCqpaBcxpGfom0zhPIlRB
jAkY5P628i72FhyJBCcCu5xBIWt58czvpklgKTmgKHibbFZ2ZZkumWYM+voioALs
xyPA2eAN6dETVVwbZVP6pu3DOKbWZSvz145TJXMe/44oqLiXrVoXS7cM1pNIzWTX
1SzdvG+UANkKIdVblyIdMS/fqt87nGgspA7Gn3xEQ3/satxDzQDuSRiNcQBJEyOq
6AqFPzvDsZ/wESU60FwwP34eH0Qd3+a2QjUII1QtO+hy4kMEvi+9wWT7UCDtNQCb
gzTT4cBV02XkWQvgxCbkUh9ect0ahY0HaBqemUOA+6G6NOnegXklX3JiqNbibHgu
X5yKXIVPuDaqQk4Wj1b9KQN8teYZ057hh07iuxWDZvcKr7l3sVmtNmnBlxfsYtkz
NEUUSjgu2FjtMbKOQ1sMRVHFgbfnf/M2MrkSC9aOO0DwffeG94HWTSQ5UZhnKZBB
TcWGe2aKY2PPmroKQ4hVqC3iyJ7JLuYkXz0kdVYsSaXoCpcOM2g+mnTs6tsHMJlE
W8FWgvpscpQwe7fRAvBaYYAg08ka3AI5iIBoUTPU+7ooAkV6cmPxm3k0asVghaDL
X5iiZLbLqGGGmBfgDB8uyxjLGMBUBwk4ckCdB6KOend1l8iFv92b9tv5TCxujeFJ
ISYvqchCccDI/37aNyJDy0jM205mCsCSEo4awNAr7rCmKCEPJPzZxqt+k5aADxyY
CmOV583WCdmXLo+Wxn+sQLTjRJhKHKg/HJVq/YykWiv7NrVCE5ndhH28x56k+z7J
WDEp2g+a3wgupvFi9JsLWu2gtaMnitxQ80dAAfdVCkyufq+iz23FTvYXaU7n3oqB
BaDZpFQc5wCNYxOT9i0au4QzGWULhCDhhcl/sQ1f7/em0TLW5Ia8k8ADK22iKIQ3
hZb3vE7qzh3eR7I+Fp8zaDwPBl5mMBE+OF3JmpxM4jB5NZ8eGzher7jQNMELFzVQ
inJNLvKSpNqwX88KHU56N5ou/76ZW+fOdL/KshyTKyXsgXy9V0IB2E0kNL0m9RdZ
4jG5jbkTj9J2hjpFJupWDHcq/NYP89hupPC8W7l5WROVw/O8nOZBMOnyrwFPYI08
laE8B5a9sulJNgqdM5SLOJTfXSpsB5/rjT+kssu3tiS3t1FAMzOPsFYeJ6d0tD2/
LQgeHVsdCZP863whj3GIumC2nPsGvT/CxRE/LbuyEBcivXdmENImVhlEE2RkreGq
H4CVECVDdvdw3QS7mzedLrBGwP/bdrnacdwv2lUtdLKVVzcdrEcD8l8h+ezdi8CU
CyX0UXbhljC9QXuxTHFtZfgLbJmymKFVro5ZkbBhy3nAW7lxAeul4EBZ6lyFUqP7
/NtzfHleTokXlwMfNFDuBgwJI3AyBtKWBHR4iOOQKxLADFo2eH3+2dbSVSKGNi66
dL0b9MG1tHj0Ove/j3Uty108C6G21159fIv2QIdSMACngLCZUVKT7Ix/MncYsudR
0EQ7rU1T7CWQUmYsV7vD+VUZy4GffGc8xFIaT76RSTipPUULUAKaI+eoruS9ZUie
rj8hyz2eXKvWZGOwSIS1H/ODWi92QWXx0FMq63U4suUni8PCxEZfctnkBBaLwEXI
teraMz7x2MGJC++JExQAPQ69gGL8IoXrVbfHur8ZCXymCzRKMKb10gzZNuLxD5pd
7RsaLUH+PPl1oHc2ZRxaM6JnTeL7hmYTEMkSHoCWymgqfYYQfrNMuyOYtAZoLV3O
X6fEUUT/fCYa1b0H0l8TmBQoB5+M1FBZM8qXM+DjKKIph9Xu2vPb7C+GGsvZOcSo
Jnp3gMFCjN0rFRrh01047sPXPnX2kwn9J4h763ENPGeupgIlYioGAMOs24nvbQIe
vh4gbyMnHf5IvzklgSrEetcCD8YEccwzDmH5zlRiA+Qdp7KlDMaY8KmkzKEo/5WQ
j+sLRD6aXZ0Yi0teEMu/tqFrm5iMVYaIEAsbwnbG+296G4iPVtiro0nIi8nMrvAV
4+ysVJC777yj4Yrvzhs5cY6WGAO5z9Q3YyG3RV1fVlwBC0RvWiZej7SdocjY7Zux
1CCk03BptI9N5lcU7ESM6YiA+H9Ie5EFvEMbKobE5Ahqw1A327m8Ljdjm/Q8UOSS
UrORSfPVUaIds6WyDqiQ7GxsEZLhCcRp8bI30fwXvcpZPjT83utZv3PR0iGXC0vN
IMFuE2cgc/NlSVr/HT55TNdvRvhY/3e07WDSiy4l4uCniOAP1TRstRKg/NGf6w0v
YhC141V6kVysiniOPc3P/LMp7YyZNP/8MJSmBU9uZ6s6hl8KFkn3v4QPrJ2O4qFo
FWX2z5D0NTloF8jRB9l94Sqbdemfel3Xa5tUCNSAGi6Ji7CwUVcPD79kpaQ0QhIB
E7WphbC9h9aH6jEDdiGp9pgSat4CwNG/SR+qTqWEozRoyR35Xdx3ght47nHKZcyT
4A6mJIj+prXoU5fex6uEapomcfv633RKDOwUMtUX2vEb9GBPJj6m0mtzm6a6GzC+
yvvxczkbULzq4z+z9BGhDPryIIVwSHvNjyfqwh/la1yUY45IeTPUoKZf51xGnvGB
Yy28qbRll/OE8DcPXCY0vyrYHaR9EnxAB97XrgVeOWFuFzD0shO65P9+3KCyduhb
B7H3emWmqbkLB2zR7SsP37dI33OQ2OE+aHU+Vc2YaCMDfQDA2FhqY1YsJyyzLgi/
ZXNXDToxfyn1GiN+BcgwFLJommybC4n23z07gcABN3ppfG//U6f6OGHDMx53f+Ya
p6fgsG4OxQheh84zt9J3X/F+kz6smPaFA0Sl8p+u0a0UMItstAI/nBw7IGxFACAK
wKRxs/K+0g6At0Rml+wszV6JBdQTFDDASsgTtekZgpZ4cz2Y5aLj2gEx3MpTD4zd
9t37gckhIN6vUBaGJLGA9iTz067F99OSDRciv808v1+sjq0vV1WkZcjZswLmLprX
fcymgt71GcTt9uMyM17XTasBNq+mSfvhF4IQ08IHIc2YDbraQIkcXo4+A++5cFt3
dZUYSJ6y6+DLfF/0w8efvQoUsv4yHhsOIbUYDhoIUBaGOvQ/Pz+wItXvGH6UY7MP
PaA9BnxtX7/K/7cP5/nxLJ7mfuSdCvmex7oK7LwU02dZ1eUncz3j+Rla+8tvdnzG
AxLo9n4GIcGzrSsbZ7M2MvJEZvQjO3xt/emMGHYIvc1J1mQUUjJfseDHFHe5gnxT
UDVmUp45ad8osupiWJ8v/kbYs9/l4W8jI2+UvoqFiEKtoGZTfzryPTFzW3tCHwFA
A1wK9PvsBvvVMhfaBSh2DcY7RezloWUfrqB1YcL8NCZpji94EMxpssUspFN+cKqk
ruirlka6wOGukuSEPC6TOY3HSK2VLFkjdLaL6xns7IsPgWAaAljMWG/+ZpWosAAX
LMzQFFnKMwoysarSSJFlGo3f0szvZztlSD4aNF4LoKVHODFTAZgv2vDXd9iY9Vw6
jOGeJ+0Ek2AVdwahnmmXbi0tp95VJ0KvHdXkGjr2p8WFiG73qzK5DnVwg1YP/6Ja
QI+qcXndz/4yalzFgPBvfx+0oBgPQDmSlsFcnULtjhPe7qEee6Ie3UqvL8tCyA9Z
XRSp8ZWgrd+hDPW1cMnfuQJDuS0Zd9KVPPzhfdXF51jEokroLVB06PVbu2Q+XTwC
O5m2afULSa+E6CdLRU/rIWbDCDm2sl7vtO/huJOP9eft9BGiPYyUHnrPANZ4/u+g
8z2g0uDUUHlf3V5bAJejA+yb81Qc1Qh/pcJT/u9IlT+xJM6e1KhToZ9FrwrAYzWq
MuWDdFnTwSaoGX3jZM0dCIZVhkatT5IycaCJtkBZi7wr+KNRVscyHhdwXBO1F8yX
PFyPotd7+I9Ehdk+z2Jb0xffuFXSYqQT12iBl4q4pM89JMFW+nJEj2sZHhGtUZcG
in2BmqY3yI33NM/XFu6BdFYUgA11D1uZmE+A3n+hGaKk4A2FyKUNSdrE6Ga2Ht6D
I46F6UF7FUj/BM4wCqlz041GquFSkmRzC3RO+/NruXQCc9tEeGFgWXhLJS3pVAjE
6MCzmWtqs9y/hsbUjan3Eo54TUiCztFObmxrjDWy3ZV2O90q5tGAOmvxO3Z+lO0y
7Lv1UZ/QzfRlz0zSRd9ZEuK1p+HVT8ZXUjL1iAO62puITpu4w4k2SegoPUapGiP0
Gq965QTi1uy0m6+5lbrFKQgKTAerIj4xqeW9dh82kKP/qOvS4bdzhaGWZxN9CrpY
bSrvzKnGL3KOFNckZWzpa8dCBVG/i+CEq2meyr/u11i+idxsn8C7HFvPUXyc6Vms
H0LddexqO+4a/xzuhNx7kpzXo6WtpqW4dJvCjk04qlkwsZLGtmcVUoelMVVadc1R
6Wx8C26CIyMAH9lAbSfZ7/3W9hEXYE65eytFqHL84NWBIEPrKPdYz5hTcwG05XAu
SX9FwwemUBzcIPPd3NVuYg4HtuwsP0GpjlTTuTuhXZXH8ok7ycHsg//C4msMHIUn
z8U4ECUCOUpfMPWf8TzfrIAvPbK+XAMdbjXmh3al8Cef156p7D9FRleWElD3cYD7
h1IVC3iVhWss8nIQehFTg7WYWXLxMBt66zcrua/ajgzP4drGZzmvqRtQas6MmL5G
9M8vVh0S/G+sQSw09jWPxu5EzMg8qKCgBE+i3lZMXcHqUxsOKt/S5F4Bq6LBsmxm
PKrVF9+CWbRV+v+jVuJt/Ll3iNOAnj6M15nmEXvwGOJQXwQC8CruFtTE4e/mwFM3
0eRj5ji3130cKa/k6DBf/wF/NWcvflJ3K9lk+TXjBnjZXvDfF17oDKszA076HTGY
kib6O6SKeHqJSkVpQVpG2NugQElsyvqOCE9X7Lth97aWwHzWq5awegVBbY38OSES
frQ1t2YZl7S2Ukd3elNNbFQX4Y6MPXQ12E6/iWTpF4xf9k3EAQjcqjAxaEEm0Axm
rkpSP0wpB4yr0LTR8hmQgN5CMzZEec50qyHlhfnlqSC7uoFpKCKtFs0tHCxKEUOF
Nf8e5T7uqh46QFHCoGpmk3DEX42avjX99I9V280WpLB1cmxUM2kAvg4q1+d4Ndb9
j7NO/tXkkJF2sRmU8/NVJHn/jfPogaMSD5v+KdtmYDGxttsb1oaePY0gcOaIcR0N
BsfjLkrcGpoThbfnac2sPRvUTLJGRE2Xp7fGFk54ImBf/AXIxy6Xja5zFXELfwsw
CmA9gF5An4H7Aylnb0o8QKSp6tvQZM9gdB+1srVS3zeHcS63DjuCGFLiBtLfbYQp
IV30Xv6JbecbTYbQjnfMnQ==

`pragma protect end_protected

endmodule
